# -*- coding: utf-8 -*-

import urllib
import urllib2
import hashlib
import json
import re
import datetime
from CommonFunctions import parseDOM

sslurl = 'https://ssl.filmweb.pl/api?';
hash = 'qjcGhW2JnvGT9dfCt3uT_jozR3s';
baseurl = 'http://www.filmweb.pl';
VERSION = '2.2';
syst = 'android';
liveurl = 'http://www.filmweb.pl/search/live?q=';
LIVE_SEARCH_FIELD_SPACER = '\\c';
LIVE_SEARCH_ROW_SPACER = '\\a';
imgurl = 'http://1.fwcdn.pl/po'
TIMEOUT=10

def PLchar(char):
	if type(char) is not str:
		char=char.encode('utf-8')
	s='JiNcZCs7'
	char = re.sub(s.decode('base64'),'',char)
	char = re.sub('<br\s*/>','',char)
	char = char.replace('&nbsp;','')
	char = char.replace('&lt;br/&gt;',' ')
	char = char.replace('&ndash;','-')
	char = char.replace('&quot;','"').replace('&amp;quot;','"')
	char = char.replace('&oacute;','ó').replace('&Oacute;','Ó')
	char = char.replace('&amp;oacute;','ó').replace('&amp;Oacute;','Ó')
	char = char.replace('&amp;','&')
	char = re.sub('&.+;','',char)
	char = char.replace('\u0105','ą').replace('\u0104','Ą')
	char = char.replace('\u0107','ć').replace('\u0106','Ć')
	char = char.replace('\u0119','ę').replace('\u0118','Ę')
	char = char.replace('\u0142','ł').replace('\u0141','Ł')
	char = char.replace('\u0144','ń').replace('\u0144','Ń')
	char = char.replace('\u00f3','ó').replace('\u00d3','Ó')
	char = char.replace('\u015b','ś').replace('\u015a','Ś')
	char = char.replace('\u017a','ź').replace('\u0179','Ź')
	char = char.replace('\u017c','ż').replace('\u017b','Ż')
	return char

def _getUrl(url,data=None):
	'Get Url contnetnt,return: string'

	headers = {'User-Agent': 'Mozilla/5.0 (Linux; Android 8.0.0; SM-G960F Build/R16NW) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/62.0.3202.84 Mobile Safari/537.36',}
	req = urllib2.Request(url, data, headers)
	response = urllib2.urlopen(req,timeout=TIMEOUT)
	linkFB = response.read()
	response.close()
	return linkFB

def getPersInfo(url='/person/Jack.Nicholson'):
	content = _getUrl('http://www.filmweb.pl'+url)
	out = []
	for item in re.findall('<li id="hit(.*?)</li>',content,re.DOTALL):
		one={}
		one['code']='[B]Znany z...[/B]'
		year = re.findall('((?:19|20)\d{2})',item)
		one['year']=year[0] if year else ''
		datafilm = re.findall('data-(?:film|id)="(.*?)"',item)
		one['data_film'] = datafilm[0] if datafilm else ''
		imag = re.findall('src="(http.*?)"',item)
		one['img'] = imag[0][:-5]+'3.jpg' if imag else ''
		hreftitle = re.findall('<a href="([^"]+)">(.*?)</a>',item)
		if hreftitle:
			one['href']  =hreftitle[0][0]
			one['title'] = PLchar(hreftitle[0][1].strip())
		if one['href'] and one['title']:
			out.append(one)
	dane = [('actors','Aktor'),('director','Reżyser'),('screenwriter','Scenarzysta')]
	for zawodEN,zawodPL in dane:
		profDate = re.findall('<tbody data-profession="%s"(.*?)</tbody>'%zawodEN,content,re.DOTALL)
		if profDate:
			items = re.findall('<tr(.*?)</tr>',profDate[0],re.DOTALL)
			for item in items:
				one={}
				one['code']=zawodPL
				year = re.findall('<span class="filmYear">(\d+)</span>',item)
				one['year']=year[0] if year else ''
				datafilm = re.findall('data-(?:film|id)="(.*?)"',item)
				one['data_film'] = datafilm[0] if datafilm else ''
				imag = re.findall('src="(http.*?)"',item)
				one['img'] = imag[0][:-5]+'3.jpg' if imag else ''
				hreftitle = re.findall('<a href="([^"]+)" class="link s-16">(.*?)</a>',item)
				if hreftitle:
					one['href']  =hreftitle[0][0]
					one['title'] =PLchar(hreftitle[0][1].strip())
				one['plot']=''
				jakarola = re.findall('<p class="roleText text">(.*?)</p>',item)
				one['plot'] += 'Rola: %s'%jakarola[0] if jakarola else ''
				if one['href'] and one['title']:
					out.append(one)
	return out
url='/ranking/person/director'
def getPersRank(url):
	
	content = _getUrl('http://m.filmweb.pl'+url)
	ids = [(a.start(), a.end()) for a in re.finditer('<div class="item place"', content)]
	if not ids:
		ids = [(a.start(), a.end()) for a in re.finditer('<li', content)]
	ids.append( (-1,-1) )
	out=[]
	for i in range(len(ids[:-1])):

		item = PLchar(content[ ids[i][1]:ids[i+1][0] ])
		one={}
		one['isFolder']=True
		rating= re.findall('<span class="rate__value">(.+?)</span>',item)
		one['rating'] = rating[0].replace(',','.') if rating else ''
		votes = re.findall('<span class="rate__count">(.*?)g.*</span>',item)
		one['votes'] = votes[0].replace(' ','') if votes else ''
		hreftitle = re.findall("""<a href=["'](/person[^"']+?)["'] class="(?:rate__role|film__link)">([^<]+)</a>""",item)
		if hreftitle:
			one['href']  =hreftitle[0][0]
			one['title'] =hreftitle[0][1].strip()
		imag = re.findall('<a href="/person/.+?".+?src="([^<]+)"',item)
		one['img'] = imag[0] if imag else ''
		if one.get('href',False):
			one['plot']=''
			one['plot'] +='Ocena: %s'%one['rating'] if one['rating'] else ''
			one['plot'] +='Głosy: %s'%one['votes'] if one['votes'] else ''
			out.append(one)
	next = re.findall('<li class="pagination__item pagination__item--next\s*"><a href="(/ranking/.*?)"',content,re.DOTALL)#pagination__item pagination__item--next "
	next = next[0] if next else False
	prev = re.findall('<li class="pagination__item pagination__item--prev\s*"><a href="(/ranking/.*?)"',content,re.DOTALL)
	prev = prev[0] if prev else False
	return out,(prev,next)
def getContAjax(url):
	content = _getUrl('http://www.filmweb.pl'+url)

	out=[]
	items = parseDOM(content,'div',attrs = {'class':"crs__item"})
	if not items:
		items = parseDOM(content,'div',attrs = {'class':"item place\s*"}) 
	for item in items:
		item=PLchar(item)
		one={}
		positionRank = re.findall('class="rankingPosition">(.*?)<',item,re.DOTALL)
		one['top250'] = positionRank[0].strip() if positionRank else ''
		hreftitle = re.findall('<a href="([^"]+)" class="film__link">(.*?)</a>',item)
		if hreftitle:
			one['href']  =hreftitle[0][0]
			one['title'] =hreftitle[0][1].strip()
		else:
		
			href = re.findall('href="(.*?)"',item)
			href=href[0] if href else ''
			if 'hit.gemius' in href:
				href=re.findall("href=\'(.*?)\'",item)
				href=href[0] if href else ''
			one['href'] = href
			title = re.findall('title="(.*?)"',item)
			one['title'] = title[-1].strip() if title else ''
		imag = re.findall('src="(http.*?)"',item)
		one['img'] = imag[0][:-5]+'3.jpg' if imag else ''
		year = re.findall('\((\d{4})\)',item)
		one['year'] = year[0] if year else ''
		if not one['year'] and one['href']:
			year = re.findall('-(\d{4})-',one.get('href',''))
			one['year'] = year[0] if year else ''
		orgtitle = re.findall('<div class="film__original">(.*?)</div>',item)
		one['originaltitle'] = orgtitle[0] if orgtitle else one.get('title')
		datafilm = re.findall('data-(?:film|id)="(.*?)"',item)
		one['data_film'] = datafilm[0] if datafilm else ''
		rating= re.findall('<span class="s-16 vertical-align">(.*?)</span>',item)
		rating= re.findall('<span class="rate__value">(.+?)</span>',item) if not rating else []
		one['rating'] = rating[0].replace(',','.') if rating else ''
		try:
			one['rating'] = float(one['rating'])
		except:
			pass
		votes = re.findall('<div class="nowrap top-3">(.*?)g.*</div',item)
		votes = re.findall('<span class="rate__count">(.*?)g.*</span>',item) if not votes else []
		one['votes'] = votes[0].replace(' ','') if votes else ''
		placenum = re.findall('<td class="place s-16">(.*?)</td>',item,re.DOTALL)
		placenum = placenum[0].strip().replace('&nbsp;',',') if placenum else ''
		liczbaosob = re.findall('<span class="s-16">(.*?)</span> os.+b[y]*</span>',item)
		liczbaosob = liczbaosob[0].replace(' ','.')+' osób' if liczbaosob else ''
		premierakied = re.findall('<span class="cap">premiera:</span>(.*?)</div>',item)
		premierakied = premierakied[0].strip() if premierakied else ''
		one['plot'] =''
		one['plot'] += '[B]'+one['originaltitle']+'[/B][CR]' if one['originaltitle'] else ''
		one['plot'] += 'Ocena: '+str(one['rating'])+'' if one['rating'] else ''
		one['plot'] += 'Głosy: '+str(one['votes'])+'' if one['votes'] else ''
		one['plot'] += 'Boxoffice: '+placenum+'' if placenum else ''
		one['plot'] += 'Chętnych: '+liczbaosob+'' if liczbaosob else ''
		one['plot'] += 'Premiera: '+premierakied+'' if premierakied else ''
		one['mediatype']='movie'
		if '/serial' in url or '/tvshow' in url or '=serial' in url:
			one['isFolder']=True
			one['mediatype']='episode'
		elif '/person/' in url:
			one['isFolder']=True
			one['mediatype']='person'
		if one['href'] and one['title']:
			out.append(one)
			
			
			
			
	next = re.findall('<li class="pagination__item pagination__item--next\s*"><a href="(/ranking/.*?)"',content,re.DOTALL)
	next = next[0] if next else False
	prev = re.findall('<li class="pagination__item pagination__item--prev\s*"><a href="(/ranking/.*?)"',content,re.DOTALL)
	prev = prev[0] if prev else False
	return out,(prev,next)
	#return out
	
def getSerMovInfo(url,out=[]):
	content = _getUrl('http://www.filmweb.pl'+url)
	items = parseDOM(content,'div',attrs = {'class':"crs__item"})
	for item in items:
		item=PLchar(item)
		one={}
		href = re.findall('href="(.*?)"',item)
		one['href'] = href[0] if href else ''
		imag = re.findall('src="(http.*?)"',item)
		one["img"] = imag[0][:-5]+'3.jpg'  if imag else ''
		title = re.findall('title="(.*?)"',item)		
		one["title"] = title[-1].strip() if title else ''	
		year = re.findall('\((\d{4})\)',item)
		one["year"] = year[0] if year else ''
		if not one["year"] and one['href']:
			year = re.findall('-(\d{4})-',one.get('href',''))
			one["year"] = year[0] if year else ''
	
		code = re.findall('<span class="posterInfoBox__channelName"> (.*?) </span> <span class="posterInfoBox__channelDate"> (.*?) </span>',item)
	
		one["code"] = ' '.join(code[0]) if code else ''
		datafilm = re.findall('data-(?:film|id)="(.*?)"',item)
		one["data_film"] = datafilm[0] if datafilm else ''
		if not one["year"] and one["data_film"]:
			dataFB = getFilmInfoFull(one["data_film"])
			one.update(dataFB)
		one["mediatype"]='movie'
		
		if '/serial' in url:
			one["isFolder"]=True
			one["mediatype"]='episode'
			one["type"]="SERIAL"
		one["plot"] = one['code'] +''+one.get("plot",'')
		one["type"]="FILM"
		if one['href'] and one['title']:
			out.append(one)
	
	return out
	
#def getSerMovInfo3(url,out=[]):
#	content = _getUrl('http://www.filmweb.pl'+url)
#	
#	
#	
#	
#	
#	ids = [(a.start(), a.end()) for a in re.finditer('<li', content)]
#	ids.append( (-1,-1) )
#	for i in range(len(ids[:-1])):
#	
#		item = PLchar(content[ ids[i][1]:ids[i+1][0] ])
#		one={}
#		href = re.findall('href="(.*?)"',item)
#		one['href'] = href[0] if href else ''
#		imag = re.findall('src="(http.*?)"',item)
#		one["img"] = imag[0][:-5]+'3.jpg'  if imag else ''
#	
#		title = re.findall('title="(.*?)"',item)
#	
#		one["title"] = title[-1].strip() if title else ''		
#		year = re.findall('\((\d{4})\)',item)
#		one["year"] = year[0] if year else ''
#		if not one["year"] and one['href']:
#			year = re.findall('-(\d{4})-',one.get('href',''))
#			one["year"] = year[0] if year else ''
#	
#		code = re.findall('<span class="posterInfoBox__channelName"> (.*?) </span> <span class="posterInfoBox__channelDate"> (.*?) </span>',item)
#	
#		one["code"] = ' '.join(code[0]) if code else ''
#		datafilm = re.findall('data-(?:film|id)="(.*?)"',item)
#		one["data_film"] = datafilm[0] if datafilm else ''
#		if not one["year"] and one["data_film"]:
#			dataFB = getFilmInfoFull(one["data_film"])
#			one.update(dataFB)
#		one["mediatype"]='movie'
#		
#		if '/serial' in url:
#			one["isFolder"]=True
#			one["mediatype"]='episode'
#			one["type"]="SERIAL"
#		one["plot"] = one['code'] +''+one.get("plot",'')
#		one["type"]="FILM"
#		if one['href'] and one['title']:
#			out.append(one)
#	
#	return out
from selectHelper import *
def getCoWybieramy(mymode_):
	d={}
	if   mymode_=='bazafilmow_sort': return getSortBy()
	elif mymode_=='bazafilmow_sortAscending': return getSortType()
	elif mymode_=='bazafilmow_dataProdukcji': return getYears()
	elif mymode_=='bazafilmow_Ocena': return getOceny()
	elif mymode_=='bazafilmow_genreIds':	  return getMovCat()
	elif mymode_=='bazafilmow_genreTVshows':	  return getProgCat()
	elif mymode_=='bazafilmow_countryIds':	return getCountry()
	elif mymode_=='rankingtop_kraje':	 return getSelectType('Kraje')
	elif mymode_=='rankingtop_gatunki':   return getSelectType('Gatunki')
	elif mymode_=='rankingtop_lata':	  return getSelectType('rok')
	elif mymode_=='boxoffice_kraje':	 return getSelectType('Kraje')
	elif mymode_=='boxoffice_gatunki':   return getSelectType('Gatunki')
	elif mymode_=='boxoffice_lata':	  return getSelectType('rok')
	elif mymode_=='Ludzie_Filmu':	  return getPersonRank()
	elif mymode_=='bazaOsob_country': return getCountryRank()
	elif mymode_=='bazaOsob_sort': return getPersonTyp()
	elif mymode_=='bazaOsob_sortAscending': return getSortType()
	elif mymode_=='bazaOsob_plec': return getPersonGender()
	elif mymode_=='bazaOsob_zawod': return getZawod()
	elif mymode_=='bazaOsob_dataUrodzenia': return getYearsProd()
	return (d.keys(),d.values())
url='http://www.filmweb.pl/search/tvshow'
url='http://www.filmweb.pl/persons/search'
#https://www.filmweb.pl/persons/search
def wyborSzukania(url):
	content = _getUrl(url)
	if '/persons' in url:
		return getPersonSearch(content)
	else:
		return getNormalSearch(content,url)
def getPersonSearch(content):
	items = parseDOM(content,'li',attrs = {'class':"hits__item"})
	isFolder = True
	out=[]
	for item in items:
		one={'isFolder':isFolder}
		href = re.findall('<a href="(/person/.+?)"',item)
		one['href'] = href[0].strip() if href else ''
		title = re.findall('>([^>]+)</a></h3>',item)
		one['title'] = title[0].strip() if title else ''
		imag = re.findall('src="(.*?)"',item)
		one['img'] = imag[0] if imag else ''
		rating = re.findall('class="hit__averageRating">(.+?)</span>',item)
		one['rating'] = rating[-1].replace(',','.').strip() if rating else ''
		votes = re.findall('"hit__votes">([^>]+)<',item)
		one['votes'] = votes[-1].strip() if votes else ''
		if one.get('href'):
			one['plot']=''
			one['plot'] +=u'Ocena: %s'%one['rating'] if one['rating'] else ''
			one['plot'] +=u'[CR]Głosy: %s'%one['votes'] if one['votes'] else ''
			one['title'] += ' (%s)'%(one['rating']) if one['rating'] else ''
			out.append(one)
	return out
def getNormalSearch(content,url):
	ids = [(a.start(), a.end()) for a in re.finditer('<li id="(?:hit|film)', content)]
	ids.append( (-1,-1) )
	out=[]
	if '/serials' in url or '/tvshows' in url:
		isFolder = True
	else:
		isFolder = False
	for i in range(len(ids[:-1])):

		item = PLchar(content[ ids[i][1]:ids[i+1][0] ])
		one={}
		matches = re.findall('<script data-type="setfilm">(.*?)</script>',item)

		if matches:
			matches = matches[0] if matches else ''
			href = re.findall('link:"(.*?)"',matches)
			one['href'] = 'http://www.filmweb.pl'+href[0] if href else ''
			year = re.findall('year:(\d+)',matches)
			one['year'] = year[0] if year else ''
			durat = re.findall('duration:"(.*?)"',matches)
			one['duration'] = int(durat[0])*60 if durat else ''
			premiered = re.findall('premiereCountry:"(.*?)"',matches)
			one['premiered'] = premiered[0] if premiered else ''
			rating = re.findall('rate:(.*?),',matches)
			one['rating'] = round(float(rating[-1]),1) if rating else ''
			votes = re.findall('ratingCount:(.*?),',matches)
			one['votes'] = int(votes[-1]) if votes else ''
			imag = re.findall('src="(.*?)"',item)
			one['img'] = imag[0][:-5]+'3.jpg' if imag else ''
			title = re.findall('title:"(.*?)"',item)
			one['title'] = title[0] if title else ''
			orgtitle = re.findall('originalTitle:"(.*?)"',item)
			one['originaltitle'] = orgtitle[0].strip() if orgtitle else title
			genre = re.findall('<a href="/search/film\?genreIds=\d+">(.*?)</a>',item)
			one['genre'] = ','.join([x.strip() for x in genre]) if genre else ''
			country = re.findall('<a href="/search/film\?countryIds=\d+">(.*?)</a>',item)
			one['country'] = ','.join([x.strip() for x in country]) if country else ''
			description = re.findall('<div class="filmPlot">\s*<p>(.*?)<',item,re.DOTALL)
			one['plot'] = description[0].strip() if description else ''
			director = re.findall('yser[ia]*\s*:\s*</dt>\s*<dd>(.*?)</dd>',item,re.DOTALL)
			one['director'] = ','.join([x for x in re.findall('title="(.*?)"',director[0])]) if director else ''
			cast = re.findall('obsada\s*:\s*</dt>\s*<dd>(.*?)</dd>',item,re.DOTALL)
			one['cast'] = [x for x in re.findall('title="(.*?)"',cast[0])] if cast else []
			datafilm = re.findall('data-(?:film|id)="(.*?)"',item)
			one['data_film'] = datafilm[0] if datafilm else ''
		else:
			href = re.findall('<a class="filmPreview__link" href="(.*?)"',item)
			one['href'] = href[0] if href else ''
			year = re.findall('class="filmPreview__year">\s*(\d+)\s*',item)
			one['year'] = year[0] if year else ''
			durat = re.findall('class="filmPreview__filmTime" data-duration="(\d+)"',item)
			one['duration'] = int(durat[0])*60 if durat else ''
			one['premiered'] = ''
			try:
				rating = re.findall('class="rateBox__rate">(.*?)<',item)
				one['rating'] = round(float(rating[-1].replace(',','.')),1) if rating else ''
				votes = re.findall('class="rateBox__votes">(.*?)g',item)
				one['votes'] = int(votes[-1].replace(' ','')) if votes else ''
			except:
				pass
			imag = re.findall('src="(.*?)"',item)
			one['img'] = imag[0][:-5]+'3.jpg' if imag else ''
			title = re.findall('class="filmPreview__title">(.*?)<',item)
			one['title'] = title[0] if title else ''
			orgtitle = re.findall('class="filmPreview__originalTitle">(.*?)<',item)
			one['originaltitle'] = orgtitle[0].strip() if orgtitle else title
			genre = re.findall('<a href="/search/film\?genreIds=\d+">(.*?)</a>',item)
			one['genre'] = ','.join([x.strip() for x in genre]) if genre else ''
			country = re.findall('<a href="/search/film\?countryIds=\d+">(.*?)</a>',item)
			one['country'] = ','.join([x.strip() for x in country]) if country else ''
			description = re.findall('class="filmPreview__description"><p>(.*?)<',item,re.DOTALL)
			one['plot'] = description[0].strip() if description else ''
			one['director'] = ''
			one['cast'] = []
			datafilm = re.findall('data-(?:film|id)="(.*?)"',item)
			one['data_film'] = datafilm[0] if datafilm else ''
		one['mediatype']='movie'
		if isFolder or '/serial/' in one.get('href',False):
			one['isFolder'] = True
			one['mediatype']='episode'
		if one['href']:
			one['next_url']=url
			out.append(one)
	return out
def getPremiereDate(p='06/07/2017'):
	if p=='':
		return ''
	datapremiery = datetime.datetime.strptime(p, '%d/%m/%Y')
	today = datetime.datetime.today()
	wynikDaty = today - datapremiery
	if abs(wynikDaty.days)>31:
		dzien='%d %s' %(datapremiery.day, months[datapremiery.month-1])
		if datapremiery.year != today.year:
			dzien += ' %d'%datapremiery.year
	elif wynikDaty.days>0:
		dzien='%d dni temu' %abs(wynikDaty.days)
	elif wynikDaty.days<0:
		dzien='za %d dni' %abs(wynikDaty.days)
	else:
		dzien='dziś'
	return dzien
months = ['Styczeń','Luty','Marzec','Kwiecień','Maj','Czerwiec','Lipiec','Sierpień','Wrzesień','Październik','Listopad','Grudzień']
def getNowTime(d='2017-06-15'):
	now = datetime.datetime.now()
	try:
		year,month,day = d.split('-/')
		dzien = months[int(month)-1]
		dzien = '[B](%s, %s)[/B]'%(dzien,year)
	except:
		dzien= months[now.month]
	return dzien
def getNowTime2(month='12'):
	try:
		dzien = '[B] %s[/B]'%(months[int(month)-1])
	except:
		now = datetime.datetime.now()
		dzien= months[now.month]
	return dzien
def scanMainPage(url):

	content = _getUrl(url)
	ids = [(a.start(), a.end()) for a in re.finditer('<li class="premieresList__box', content)]
	ids.append( (-1,-1) )
	match = re.findall('<ul class="list list__horizontal TabsNav subHeader__months">(.*?)</ul>',content,re.DOTALL)
	prev =False
	next=False
	if match:
		match=match[0].split('<li class="')
		current = [n for n, l in enumerate(match) if l.startswith('item item__is-active')]
		if current:
			prev = re.findall('item "><a href="(/dvd/premiere.*?)">.*?</a></li>',match[current[0]-1])
			next = re.findall('item "><a href="(/dvd/premiere.*?)">.*?</a></li>',match[current[0]+1])
			prev = 'http://www.filmweb.pl'+prev[0] if prev else False
			next = 'http://www.filmweb.pl'+next[0] if next else False
	out=[]
	for i in range(len(ids[:-1])):

		item = PLchar(content[ ids[i][1]:ids[i+1][0] ])
		one={}
		href = re.findall('<a class="filmPreview__link" href="(.*?)"',item)
		one['href'] = href[0] if href else ''
		year = re.findall('class="filmPreview__year">\s*(\d+)\s*',item)
		one['year'] = year[0] if year else ''
		durat = re.findall('class="filmPreview__filmTime" data-duration="(\d+)"',item)
		one['duration'] = int(durat[0])*60 if durat else ''
		one['premiered'] = ''
		try:
			rating = re.findall('class="rateBox__rate">(.*?)<',item)
			one['rating'] = round(float(rating[-1].replace(',','.')),1) if rating else ''
			votes = re.findall('class="rateBox__votes">(.*?)g',item)
			one['votes'] = int(votes[-1].replace(' ','')) if votes else ''
		except:
			pass
		imag = re.findall('src="(.*?)"',item)
		one['img'] = imag[0][:-5]+'3.jpg' if imag else ''
		title = re.findall('class="filmPreview__title">(.*?)<',item)
		one['title'] = title[0] if title else ''
		orgtitle = re.findall('class="filmPreview__originalTitle">(.*?)<',item)
		one['originaltitle'] = orgtitle[0].strip() if orgtitle else title
		genre = re.findall('<a href="/search/film\?genreIds=\d+">(.*?)</a>',item)
		one['genre'] = ','.join([x.strip() for x in genre]) if genre else ''
		country = re.findall('<a href="/search/film\?countryIds=\d+">(.*?)</a>',item)
		one['country'] = ','.join([x.strip() for x in country]) if country else ''
		description = re.findall('class="filmPreview__description"><p>(.*?)<',item,re.DOTALL)
		one['plot'] = description[0].strip() if description else ''
		datafilm = re.findall('data-(?:film|id)="(.*?)"',item)
		one['data_film'] = datafilm[0] if datafilm else ''
		one['mediatype']= 'movie'
		if one['href']:
			if '/serial/' in one['href']:
				one['isFolder'] = True
				one['mediatype']='episode'
			out.append(one)
	return out,(prev,next)
dekodowanie = lambda (t) : t.encode('utf-8') if isinstance(t,unicode) else t
def getWyszukanie(title='Dorwać',page=1,url='http://www.filmweb.pl/search?q='):
	extra ='&orderBy=_score&descending=true&page='+str(page)
	nxturl=url+urllib.quote_plus(dekodowanie(title))+extra
	content = _getUrl(nxturl)
	if '/persons' in url:
		out = getPersonSearch(content)
	else:
		out = getNormalSearch(content,url)
	if '.pl/search?q=' in url:
		extra = []
		item = re.findall('class="item__title">\s*filmy\s*</span>\s*<span class="TabsNav__hits">\s*(\d+)\s*</span>',content)
		if item:
			extra.append({'_title':'[B]Wiecej Filmy[/B]','code':item[0],'_href':title,'next_url':'http://www.filmweb.pl/films/search?q='})
		item2 = re.findall('class="item__title">\s*seriale\s*</span>\s*<span class="TabsNav__hits">\s*(\d+)\s*</span>',content)
		if item2:
			extra.append({'_title':'[B]Wiecej Seriale[/B]','code':item2[0], '_href':title,'next_url':'http://www.filmweb.pl/serials/search?q='})
		item3 = re.findall('class="item__title">\s*Programy TV\s*</span>\s*<span class="TabsNav__hits">\s*(\d+)\s*</span>',content)
		if item3 :
			extra.append({'_title':'[B]Wiecej ProgramyTV[/B]','code':item3[0], '_href':title,'next_url':'http://www.filmweb.pl/tvshows/search?q='})
		item4 = re.findall('class="item__title">\s*ludzie kina\s*</span>\s*<span class="TabsNav__hits">\s*(\d+)\s*</span>',content)
		if item4 :
			extra.append({'_title':'[B]Wiecej Ludzie[/B]','code':item4[0], '_href':title,'next_url':'http://www.filmweb.pl/persons/search?q='})
	else:
		extra=[]
	return out,extra
def getSeasons(url,sesOut={}):
	
	nxturl = 'https://m.filmweb.pl'+url  
	nxturl += '' if nxturl.endswith('/') else '/'
	nxturl += '' if '/episodes' in nxturl else 'episodes'

	try:
		content = _getUrl(nxturl)
	except:
		nxturl=re.sub('<[/\+]*\w>','',urllib.unquote(nxturl))
		nxturl=urllib.quote(nxturl).replace('%3A',':').replace('%2B','+')
		content = _getUrl(nxturl)
	year = re.findall('filmCoverSection__year">(\d{4})[\s-]*',content)
	year = year[0] if year else ''
	
	datafilm = re.findall('data-film-id="(.*?)"',content)
	datafilm = datafilm[0] if datafilm else ''
	href = nxturl.replace('episodes','')
	ids = [(a.start(), a.group(1)) for a in re.finditer('<dt data-filmid="\d+" id="(.*?)"', content)]
	hrefseas= re.findall('<a class="link.+?href="(.+?)"\s*data-number="(.+?)"',content)#[0]

	nowy='https://www.filmweb.pl'+url +'/episode/ranking'
	try:
		html = _getUrl(nowy)
	except:
		nowy=re.sub('<[/\+]*\w>','',urllib.unquote(nowy))
		nowy=urllib.quote(nowy).replace('%3A',':').replace('%2B','+')
		html = _getUrl(nowy)

	out={}

	for hrefz,seas in hrefseas:
		seasons = int(seas) if seas else ''
		if seasons:
			out['Sezon %02d'%seasons]=[]
			items = re.findall('div class="episodePreview EpisodePreview episodeSource.+?data-season-number="%s"(.+?)\/span><\/div><\/div><\/a>'%seas,html,re.DOTALL)
			for subset in items:
				one={}
				
				one.update(sesOut)
				one['tvshowtitle']=one.get('title')
				one['originaltitle']=one['tvshowtitle']
				one['season']=seasons
				one['year']=year if not sesOut.get('year') else sesOut.get('year',year)
				one['data_film']=datafilm  if not sesOut.get('data_film') else sesOut.get('data_film',datafilm)
				one['href']=href  if not sesOut.get('href') else sesOut.get('href',href)
				episodes=re.findall('data-episode-num="(\d+)"',subset)
				one['episode'] = int(episodes[0]) if episodes else 0
				premiered =re.findall('data-premiere="(.*?)"',subset) 

				one['premiered'] = premiered[0] if premiered else ''
				one['aired'] = premiered[0] if len(premiered)>1 else ''

				title= re.findall('title="(.+?)"',subset)
				one['title'] = title[0].strip() if title else ''
				one['title'] = 'S%02dE%02d '%(seasons,one['episode']) + one['title']
				if one['episode']:
					out['Sezon %02d'%seasons].append(one)
	return out
def _prepareSignature(method):
	signature = method + '' + syst + hash;
	signature = VERSION + ',' + hashlib.md5(signature).hexdigest();
	return signature;
def _prepareParams(method):
	signature = _prepareSignature(method);
	method += '';
	qs={	'methods':method,
			'signature':signature,
			'version':VERSION,
			'appId':syst}
	return urllib.urlencode(qs)
def _processResponse(response,_response_keys):
	_response = response.split(' t:')[0].split('')
	status = _response[0]
	data = _response[1]
	out={}
	if data=='null': pass
	else:
		j_data=json.loads(data)
		N=len(j_data)
		for k,v in _response_keys.iteritems():
			if j_data[k]==None:
				j_data[k]=''
			if N>= k: out[v]=j_data[k]
	return out
def getFilmInfoFull(filmID='233'):
	method = 'getFilmInfoFull [' + filmID + ']'
	_response_keys ={
		0 :  'title',
		1 :  'originaltitle',
		2 :  'rating',
		3 :  'votes',
		4 :  'genre',
		5 :  'year',
		6 :  'duration',
		7 :  'commentsCount',
		8 :  'forumUrl',
		9 :  'hasReview',
		10 :  'hasDescription',
		11 :  'img',
		12 :  'video',
		13 :  'premiereWorld',
		14 :  'date',
		15 :  'filmType',
		16 :  'seasonsCount',
		17 :  'episodesCount',
		18 :  'studio',
		19 :  'plot'
	}
	try:
		response = _getUrl( sslurl + _prepareParams(method))
		out = {}
		if response[:2]=='ok':
			out =_processResponse(response,_response_keys)
			out['filmweb']=filmID
			if out.get('video'):
				trailers = [ x for x in out.get('video') if 'mp4' in str(x) ]
				pattern = ['.360p.', '.480p.', '.720p.']
				trailer = trailers[0]
				for p in pattern:
					for t in trailers:
						if p in t: trailer = t
				out['trailer']=trailer
			if out.get('img'): out['img']=imgurl + out.get('img').replace('.2.','.3.')
			if out.get('duration'): out['duration'] = float(out.get('duration'))*60
	except:
		out = {}
	return out
def getFilmsInfoShort(filmID='220082'):
	method = 'getFilmsInfoShort [[' + filmID + ']]'
	_response_keys = {
		0 :  'title',
		1 :  'year',
		2 :  'rating',
		3 :  '_',
		4 :  'duration',
		5 :  'img',
		6 :  'id'}
	response = _getUrl( sslurl + _prepareParams(method))
	out = {}
	if response[:2]=='ok': out =_processResponse(response.replace('[[','[').replace(']]',']'),_response_keys)
	return out
def getFilmPersons(filmID='594357', t='actors'):
	array_type = { 'directors': '1', 'scenarists': '2', 'musics': '3', 'photos': '4', 'actors': '6', 'producers': '9' }
	tableNames = ['id', 'role', 'role_type', 'name', 'img']
	dictPers = {}
	if t in array_type.keys():
		method = 'getFilmPersons [' + str(filmID) + ', ' + array_type[t] + ', 0, 50]'
		response = _getUrl( sslurl + _prepareParams(method))
		matches = re.search('(\[.*\])', response)
		infoResponse = json.loads(matches.group(1))
		for data in infoResponse:
			dictPers[data[0]] = {}
			for i in range(0, len(tableNames)):
				if tableNames[i] == 'img': dictPers[data[0]][tableNames[i]] = '' if data[i] == None else 'http://1.fwcdn.pl/p' + data[i].encode('utf-8').replace('.1.jpg', '.3.jpg')
				else: dictPers[data[0]][tableNames[i]] = data[i].encode('utf-8') if type(data[i]) == unicode else data[i]
	return dictPers
def getAllChannels ():
	method = 'getAllChannels [""]'
	_response_keys = {0 :  'description'}
	response = _getUrl( sslurl + _prepareParams(method))
	out = {}
	if response[:2]=='ok': out =_processResponse(response,_response_keys)
	return out
def getPopularFilms(filmID='220082'):
	method = 'getPopularFilms [null,null]'
	_response_keys = {0 :  'description'}
	response = _getUrl( sslurl + _prepareParams(method))
	out = {}
	if response[:2]=='ok': out =_processResponse(response,_response_keys)
	return out
def getFilmVideos(filmID='182040'):
	method = 'getFilmVideos [568216,1,2]'
	_response_keys = {0 :  'description'}
	response = _getUrl( sslurl + _prepareParams(method))
	out = {}
	if response[:2]=='ok': out =_processResponse(response,_response_keys)
	return out
def getFilmDescription(filmID='1'):
	method = 'getFilmDescription [' + filmID + ']'
	_response_keys = {0 :  'description'}
	response = _getUrl( sslurl + _prepareParams(method))
	out = {}
	if response[:2]=='ok': out =_processResponse(response,_response_keys)
	return out
def _prepareResultList(result):
	elementData = result.split(LIVE_SEARCH_FIELD_SPACER);
	element=elementData[0]
	results=[]
	for element in elementData:
		one=_prepareResult(element)
		if one: results.append(one)
	return results
def _prepareResult(element):
	elementData = element.split(LIVE_SEARCH_FIELD_SPACER);
	type = elementData[0]
	if type == 'f' or type == 's':
		result = _FilmSearchResult(elementData);
	elif type == 'p':
		result=None
	else :
		result=None
	return result
def _FilmSearchResult(elementData):
	item={}
	if len(elementData):
		item['type'] = elementData[0]
		item['id'] = elementData[1]
		item['img'] = imgurl + elementData[2]
		item['title_f'] = elementData[3]
		item['title_p'] = elementData[4]
		item['title_e'] = elementData[5]
		item['year'] = elementData[6]
		item['cast'] = elementData[7]
	return item
def searchItem(param='310 do yumy 2007'):
	result = _getUrl( liveurl + urllib.quote_plus(param.encode('utf-8').lower()) )
	out = _prepareResultList(result) if result else []
	return out
def searchFilmweb(title='indiana jon',year='',itemType='f'):
	dataFB={}
	nxturl='http://www.filmweb.pl/search/film?q='+urllib.quote_plus(title)
	result = _getUrl(nxturl)
	data = re.compile('<li id="film_(.*?)">(.*?)</li>',re.DOTALL).findall(result)
	if len(data)==1:
		dataFB = getFilmInfoFull(data[0][0])
	if not dataFB:
		for id,char in data:
			rok = re.search('\((\d{4})\)',char)
			rok = rok.group(1) if rok else ''
			if rok == year:
				dataFB = getFilmInfoFull(id)
				break
	return dataFB
if __name__=='__main__':
	pass