# -*- coding: utf-8 -*-
import sys,re,os
import urllib,urllib2
import urlparse
import xbmc,xbmcgui,xbmcaddon
import xbmcplugin
import resolveurl as urlresolver
import json
import requests

try:
   import StorageServer
except:
   import storageserverdummy as StorageServer
   
cache = StorageServer.StorageServer('nktv')
base_url        = sys.argv[0]
addon_handle    = int(sys.argv[1])
args            = urlparse.parse_qs(sys.argv[2][1:])
my_addon        = xbmcaddon.Addon()
addonId     = my_addon.getAddonInfo('id')
addonName       = my_addon.getAddonInfo('name')
PATH        = my_addon.getAddonInfo('path')
DATAPATH    = xbmc.translatePath(my_addon.getAddonInfo('profile')).decode('utf-8')
RESOURCES   = PATH+'/resources/'
FANART=RESOURCES+'fanart.png'
ICONS = xbmc.translatePath(PATH + "/resources/media/icons/")

dialog = xbmcgui.Dialog()
import time,threading

sys.path.append(RESOURCES+'lib/')

import filmbooster as fbooster

def addLinkItem(name, url, mode, page=1, iconimage='DefaultFolder.png', infoLabels={}, IsPlayable=True, srt=False,fanart=FANART,itemcount=1):
	u = build_url({'mode': mode, 'foldername': name, 'ex_link' : url, 'page':page,'minfo':str(infoLabels)})
	isFolder = infoLabels.get('isFolder',False)
	if isFolder and infoLabels.get('year',False):
		name += ' (%s)'%infoLabels.get('year')
	list_item = xbmcgui.ListItem(name)
	art_keys=['thumb','poster','banner','fanart','clearart','clearlogo','landscape','icon']
	art = dict(zip(art_keys,[infoLabels.get(x,iconimage) for x in art_keys]))
	art['landscape'] = fanart if fanart else art['landscape']
	list_item.setArt(art)
	list_item.setInfo(type='video', infoLabels=infoLabels)
	if IsPlayable and not isFolder:
		list_item.setProperty('IsPlayable', 'true')
	if url:
		out = []
		nxtMenu=build_url({'mode': 'AddToLibrary', 'foldername': name, 'ex_link' : url, 'page':page,'minfo':str(infoLabels)})
		out.append(('Dodaj do Biblioteki', 'RunPlugin(%s)'%nxtMenu))
		if 'true' in my_addon.getSetting("FFaddon"):
			if '/serial' in url:
				newname = re.sub('\(\d+\)', '', name)
				out.append(('[COLOR lightblue]Szukaj w FanFilm[/COLOR]', 'XBMC.Container.Update(plugin://plugin.video.fanfilm/?name="%s"&action=tvSearchterm)'%newname))
			else:
				out.append(('[COLOR lightblue]Szukaj w FanFilm[/COLOR]', 'XBMC.Container.Update(plugin://plugin.video.fanfilm/?name="%s"&action=movieSearchterm)'%(name)))
		list_item.addContextMenuItems(out, replaceItems=False)
	ok = xbmcplugin.addDirectoryItem(handle=addon_handle, url=u, listitem=list_item,isFolder=isFolder,totalItems=itemcount)
	if srt:
		xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_TITLE, label2Mask = '%R, %Y, %P')
	else:
		xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = '%R, %Y, %P')
	
	return ok
def addDir(name,ex_link=None, page=1, mode='folder',iconImage='DefaultFolder.png', infoLabels={}, fanart=FANART,contextmenu=None):
    url = build_url({'mode': mode, 'foldername': name, 'ex_link' : ex_link, 'page' : page, 'minfo':str(infoLabels)})
    list_item = xbmcgui.ListItem(name)
    if infoLabels:
        list_item.setInfo(type='video', infoLabels=infoLabels)
    art_keys=['thumb','poster','banner','clearart','clearlogo','landscape','icon']
    art = dict(zip(art_keys,[infoLabels.get(x,iconImage) for x in art_keys]))
    art['landscape'] = fanart if fanart else art['landscape']
    list_item.setArt(art)
    if contextmenu:
        out=contextmenu
        list_item.addContextMenuItems(out, replaceItems=True)
    else:
        out = []
        out.append(('Informacja', 'XBMC.Action(Info)'),)
        list_item.addContextMenuItems(out, replaceItems=False)
    xbmcplugin.addDirectoryItem(handle=addon_handle, url=url,listitem=list_item, isFolder=True)
    xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = '%R, %Y, %P')
def AddLinkItem2(name, url='', mode='', iconimage=None, fanart=FANART):
    u = build_url({'mode': mode, 'foldername': name, 'ex_link' : url, 'page':1})
    list_item = xbmcgui.ListItem(name, iconImage=iconimage, thumbnailImage=iconimage)
    list_item.setProperty('IsPlayable', 'false')
    if fanart:
        list_item.setProperty('fanart_image',fanart)
    ok = xbmcplugin.addDirectoryItem(handle=addon_handle, url=u, listitem=list_item,isFolder=False)
    return ok
def encoded_dict(in_dict):
    out_dict = {}
    for k, v in in_dict.iteritems():
        if isinstance(v, unicode):
            v = v.encode('utf8')
        elif isinstance(v, str):
            v.decode('utf8')
        out_dict[k] = v
    return out_dict
def build_url(query):
    return base_url + '?' + urllib.urlencode(encoded_dict(query))
def LisMovies(ex_link,page):
    page = int(page) if page else 1
    group=''
    if '|'in ex_link:
        ex_link,group = ex_link.split('|')
    items,pagination = l1ll11l1l1ll1l1ll_fwb_.l1111ll11ll1l1ll_fwb_(ex_link,page,group)
    if pagination[0]:
        addLinkItem(name='[COLOR gold]<< poprzednia strona <<[/COLOR]', url=ex_link, mode='__page__M', page=pagination[0], IsPlayable=False)
    items=len(items)
    for f in items:
        addLinkItem(name=f.get('title'), url=f.get('href'), mode='getLinks', iconimage=f.get('img'), infoLabels=f, IsPlayable=True,itemcount=items)
    if pagination[1]:
        addLinkItem(name='[COLOR gold]>> następna strona >>[/COLOR]', url=ex_link, mode='__page__M', page=pagination[1], IsPlayable=False)
def ListSeriale(ex_link,page):
    page = int(page) if page else 1
    group=''
    if '|'in ex_link:
        ex_link,group = ex_link.split('|')
    if group:
        items,pagination = l1ll11l1l1ll1l1ll_fwb_.l1111ll11ll1l1ll_fwb_(ex_link,int(page),group)
    else:
        items,pagination = l1ll11l1l1ll1l1ll_fwb_.l11l1l11ll1l1ll_fwb_(ex_link)
    my_mode = 'getEpisodes'
    if 'true' in my_addon.getSetting('groupEpisodes'):
        my_mode = 'getSeasons'
    if pagination[0]:
        addLinkItem(name='[COLOR gold]<< poprzednia strona <<[/COLOR]', url=ex_link, mode='__page__S', page=pagination[0], IsPlayable=False)
    items=len(items)
    for f in items:
        addDir(name=f.get('title'), ex_link=f.get('href'), mode=my_mode, iconImage=f.get('img'), infoLabels=f)
    if pagination[1]:
        addLinkItem(name='[COLOR gold]>> następna strona >>[/COLOR]', url=ex_link, mode='__page__S', page=pagination[1], IsPlayable=False)
def getEpisodes(ex_link):
    items = l1ll11l1l1ll1l1ll_fwb_.l1l11l111ll1l1ll_fwb_(ex_link)
    for f in items:
        addLinkItem(name=f.get('title'), url=f.get('href'), mode='getLinks', iconimage=f.get('img'), infoLabels=f, IsPlayable=True)
def l1llllll1ll1l1ll_fwb_(ex_link):
    items,itemsSerial = l1ll11l1l1ll1l1ll_fwb_.search(ex_link)
    for f in items:
        addLinkItem(name=f.get('title'), url=f.get('href'), mode='getLinks', iconimage=f.get('img'), infoLabels=f, IsPlayable=True,itemcount=len(items))
    for f in itemsSerial:
        addDir(name=f.get('title'), ex_link=f.get('href'), mode='getEpisodes', iconImage=f.get('img'), infoLabels=f)
def getSeasons(ex_link,dataFB='{}'):
    dataFB=eval(dataFB)
    daneSerialu = {'title':dataFB.get('title'), 'year':dataFB.get('year'),'originaltitle':dataFB.get('originaltitle'),'img':dataFB.get('img'),'href':dataFB.get('href'),'data_film':dataFB.get('data_film'),'plot':dataFB.get('plot')}
    itemz =fbooster.getSeasons(ex_link,daneSerialu)

    for one in sorted(itemz.keys()):
        addDir(one,urllib.quote(str(itemz[one])),page=1, mode='getEpisodes2',iconImage=dataFB.get('img'),infoLabels=dataFB)
    xbmcplugin.setContent(addon_handle, 'season')
def getEpisodes2(ex_link):
    
    items = eval(urllib.unquote(ex_link))
    for f in items:
        f['isFolder']=False
        addLinkItem(name=f.get('title'), url=f.get('href'), mode='getLinks', iconimage=f.get('img'), infoLabels=f, IsPlayable=True,srt=True,fanart=f.get('img'))
	xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_TITLE, label2Mask = '%R, %Y, %P')
    xbmcplugin.setContent(addon_handle, 'episodes')
def getLinksFB(streams,hostFB):
    if len(streams)==0:
        return 'more'
    elif len(streams)==1:
        linkFB = streams[0]
    elif len(streams)>1:
        select = dialog.select('Źródła ', hostFB)
        linkFB = streams[select] if select>-1 else False
    if linkFB==False:
        return True
    elif linkFB=='':
        return 'more'
    else:
        try:
            stream_urlFB = urlresolver.resolve(linkFB)
        except Exception,e:
            if 'Cancelled' in str(e): return True
            stream_urlFB=''
        if stream_urlFB: xbmcplugin.setResolvedUrl(addon_handle, True, xbmcgui.ListItem(path=stream_urlFB))
        else: return 'more'
    return True
def getVideosFB(dataFB):

    daneVideoFB=eval(dataFB)
    stream_urlFB=''

    streams= getVideosFromFboost(daneVideoFB,1)	
	
    if not streams:
        dialog.notification('FilmwebBooster', '[COLOR red][B]Brak źródeł[/B][/COLOR]' , xbmc.translatePath(xbmcaddon.Addon().getAddonInfo('path'))+'/icon.png', 5000, False)

    if len(streams) > 0:

        t = [ x.get('title') for x in streams]
        u = [ x.get('url') for x in streams]
        h = [ x.get('host') for x in streams]
        al = "Tytul | [Host] | [Wersja]"
        select = xbmcgui.Dialog().select(al, t)
    else:
        select = -1
		
    if select > -1:
        link = u[select];
        if 'youtube' in h[select]: 
            link = link.replace('www.youtube.com/embed','youtu.be')



        if not stream_urlFB:
            try:
                stream_urlFB = urlresolver.resolve(link)
            except Exception,e:
                stream_urlFB=''
                s = xbmcgui.Dialog().ok('[COLOR red]Problem[/COLOR]','Może inny link będzie działał?','Urlresolver ERROR: [%s]'%str(e))
    else:
        quit()
    if stream_urlFB:
        xbmcplugin.setResolvedUrl(addon_handle, True, xbmcgui.ListItem(path=stream_urlFB))
    else:
        xbmcplugin.setResolvedUrl(addon_handle, False, xbmcgui.ListItem(path=''))

def getHistory():
    return cache.get('history').split(';')
def setHistory(entry):
    history = getHistory()
    if history == ['']:
        history = []
    history.insert(0, dekodowanie(entry))
    try:
        cache.set('history',';'.join(history[:50]))
    except:
        pass
def remCache(entry):
    history = getHistory()
    if history:
        try:
            cache.set('history',';'.join(history[:50]))
        except:
            pass
    else:
        delHistory()
def delHistory():
    cache.delete('history')
def setMymode(my_mode='',my_modex=''):
    v = my_addon.getSetting(my_mode+'V')
    n = my_addon.getSetting(my_mode+'N') if v else my_modex
    return {my_mode+'V': v, my_mode+'N' : n}
	
def checkFFaddon():
	wtyk="plugin.video.fanfilm"
	try:
		enabled_json = ('{"jsonrpc":"2.0","id":1,"method":'
						'"Addons.GetAddonDetails","params":'
						'{"addonid":"%s", '
						'"properties": ["enabled"]}}'%wtyk)
		result = json.loads(xbmc.executeJSONRPC(enabled_json))
	except RuntimeError:
		return False
	
	if 'error' in result:  # not installed
		my_addon.setSetting("FFaddon",'false')

	else:  
		my_addon.setSetting("FFaddon",'true')

	return
params = dict(urlparse.parse_qsl(sys.argv[2].replace('?','')))
class filmboost:
	def main(self):
		checkFFaddon()
		addDir(name='Baza Filmów/Seriali/Programów',ex_link='',page=1, mode='bazafilmow_navi',iconImage=ICONS+'all.png',fanart=FANART)
		addDir(name='Baza Osób',ex_link='',page=1, mode='bazaOsob_navi',iconImage=ICONS+'people.png',fanart=FANART)
		addDir(name='Ranking',ex_link='',page=1, mode='rankingtop_navi',iconImage=ICONS+'rank.png',fanart=FANART)
		addDir(name='Box Office',ex_link='',page=1, mode='boxoffice_navi',iconImage=ICONS+'box.png',fanart=FANART)
		addDir(name='Najbardziej chcecie obejrzeć',ex_link='',page=1, mode='checobejrzec_navi',iconImage=ICONS+'see.png',fanart=FANART)
		addDir(name='Premiery DVD/Blu-ray',ex_link='https://www.filmweb.pl/dvd/premiere',page=1, mode='dvdblueray_show',iconImage=ICONS+'dvd.png',fanart=FANART)
		addDir(name='Popularne Filmy',ex_link='/ajax/home/popular/film/%d',page=1, mode='popularnefilmy_show',iconImage=ICONS+'popmovie.png',fanart=FANART)
		addDir(name='Popularne Seriale',ex_link='/ajax/home/popular/serial/%d',page=1, mode='popularnefilmy_show',iconImage=ICONS+'poptv.png',fanart=FANART)
		addDir(name='Dziś w TV Film',ex_link='/ajax/common/tvRecommendations/film?page=%d',page=1, mode='dzisfilmywtv_show',iconImage=ICONS+'movietoday.png',fanart=FANART)
		addDir(name='Dziś w TV Serial',ex_link='/ajax/common/tvRecommendations/serial?page=%d',page=1, mode='dzisfilmywtv_show',iconImage=ICONS+'tvtoday.png',fanart=FANART)
		addDir(name='[COLOR lightblue]Szukaj[/COLOR]',ex_link='',mode='Szukaj',iconImage=ICONS+'search.png')
	def dzisFILMtv(self,ex_link,page):
		page = int(page)
		import thread_pool as trd_pool
		pool = trd_pool.ThreadPool(3)
		items=[]
		try:
			for i in range(3):
				time.sleep(0.1)
				pool.add_task(fbooster.getSerMovInfo, *(ex_link%(i+page),items))
			pool.wait_completion()
		except:
			pass
		if '/serial' in ex_link:
			my_modeFB = 'getSeasons'
			xbmcplugin.setContent(addon_handle, 'tvshows')
		else:
			my_modeFB = 'getLinks'
			xbmcplugin.setContent(addon_handle, 'movies')
		if page>1:
			addLinkItem(name='[COLOR gold]<< poprzednia strona <<[/COLOR]', url=ex_link, mode='__page__:dzisfilmywtv_show', page=page-3, IsPlayable=False)
		for f in items:
			addLinkItem(name=f.get('title'), url=f.get('href'), mode=my_modeFB, iconimage=f.get('img'), infoLabels=f, IsPlayable=True,itemcount=len(items))
		if page<10:
			addLinkItem(name='[COLOR gold]>> następna strona >>[/COLOR]', url=ex_link, mode='__page__:dzisfilmywtv_show', page=page+3, IsPlayable=False)
	def popFILMYseriale(self,ex_link,page):
		
		page = int(page)

		items,pagin= fbooster.getContAjax(ex_link%page)
		if '/serial' in ex_link:
			my_modeFB = 'getSeasons'
			xbmcplugin.setContent(addon_handle, 'tvshows')
		else:
			my_modeFB = 'getLinks'
			xbmcplugin.setContent(addon_handle, 'movies')
		if page>1:
			addLinkItem(name='[COLOR gold]<< poprzednia strona <<[/COLOR]', url=ex_link, mode='__page__:popularnefilmy_show', page=page-1, IsPlayable=False)
		for f in items:
			addLinkItem(name=f.get('title'), url=f.get('href'), mode=my_modeFB, iconimage=f.get('img'), infoLabels=f, IsPlayable=True,itemcount=len(items))
		if page<10:
	
			addLinkItem(name='[COLOR gold]>> następna strona >>[/COLOR]', url=ex_link, mode='__page__:popularnefilmy_show', page=page+1, IsPlayable=False)
	def Dvdblueray_show(self,ex_link):
		items,pagination = fbooster.scanMainPage(ex_link)
		if pagination[0]:
			addLinkItem(name='[COLOR gold]<< wcześniej %s <<[/COLOR]'%fbooster.getNowTime2(pagination[0].split('/')[-1]), url=pagination[0], mode='__page__:dvdblueray_show', page=0, IsPlayable=False)
		for f in items:
			my_modeFB = 'getSeasons' if '/serial' in f.get('href') else 'getLinks'
			addLinkItem(name=f.get('title'), url=f.get('href'), mode=my_modeFB, iconimage=f.get('img'), infoLabels=f, IsPlayable=True,itemcount=len(items))
		if pagination[1]:
			addLinkItem(name='[COLOR gold]>> później %s >>[/COLOR]'%fbooster.getNowTime2(pagination[1].split('/')[-1]), url=pagination[1], mode='__page__:dvdblueray_show', page=0, IsPlayable=False)
		xbmcplugin.setContent(addon_handle, 'movies')
	def Chceobejrzec_navi(self):
		addDir(name='Nowości w Polsce ostatniego miesiąca',ex_link='/ranking/wantToSee/last30daysPoland',page=1, mode='rankingtop_show',iconImage='DefaultFolder.png',fanart=FANART,infoLabels={'plot':'Filmy, które najchętniej obejrzeliby użytkownicy z ostatniego mieisiaca w polsce'})
		addDir(name='Nowości w Polsce ostatnich 90 dni',ex_link='/ranking/wantToSee/last90daysPoland',page=1, mode='rankingtop_show',iconImage='DefaultFolder.png',fanart=FANART,infoLabels={'plot':'Filmy, które najchętniej obejrzeliby użytkownicy z ostatnich 3 m-cy w polsce'})
		addDir(name='Najbardziej oczekiwane ostatnich 3 m-cy',ex_link='/ranking/wantToSee/last90daysWorld',page=1, mode='rankingtop_show',iconImage='DefaultFolder.png',fanart=FANART,infoLabels={'plot':'Filmy, które najchętniej obejrzeliby użytkownicy z ostatnich 3 m-cy na świecie'})
		addDir(name='Najbardziej oczekiwane ostatnich 6 m-cy',ex_link='/ranking/wantToSee/last6monthsWorld',page=1, mode='rankingtop_show',iconImage='DefaultFolder.png',fanart=FANART,infoLabels={'plot':'Filmy, które najchętniej obejrzeliby użytkownicy z ostatnich 6 m-cy na świecie'})
		addDir(name='Najbardziej oczekiwane ostatniego roku',ex_link='/ranking/wantToSee/last12monthsWorld',page=1, mode='rankingtop_show',iconImage='DefaultFolder.png',fanart=FANART,infoLabels={'plot':'Filmy, które najchętniej obejrzeliby użytkownicy z ostatnich 12 m-cy na świecie'})
		addDir(name='Top Ostatnie dekady',ex_link='/ranking/wantToSee/lastDecadeFilms',page=1, mode='rankingtop_show',iconImage='DefaultFolder.png',fanart=FANART,infoLabels={'plot':'Filmy ostatniej dekady, które użytkownicy chętnie by obejrzeli'})
		addDir(name='Top Klasyki',ex_link='/ranking/wantToSee/classicalFilms',page=1, mode='rankingtop_show',iconImage='DefaultFolder.png',fanart=FANART,infoLabels={'plot':'Filmy klasyczne, które użytkownicy chętnie by obejrzeli'})
		addDir(name='Top Nowości',ex_link='/ranking/premiere',page=1, mode='rankingtop_show',iconImage='DefaultFolder.png',fanart=FANART,infoLabels={'plot':'Top Nowości ze świata'})
		addDir(name='Top Świat',ex_link='/ranking/film',page=1, mode='rankingtop_show',iconImage='DefaultFolder.png',fanart=FANART,infoLabels={'plot':'Ranking Fimów ze świata'})
		addDir(name='Top Polska',ex_link='/ranking/film/Polska/42',page=1, mode='rankingtop_show',iconImage='DefaultFolder.png',fanart=FANART,infoLabels={'plot':'Ranking Fimów z polski'})
		addDir(name='Top BoxOffice',ex_link='/ranking/boxOffice',page=1, mode='rankingtop_show',iconImage='DefaultFolder.png',fanart=FANART,infoLabels={'plot':'Ranking box officeu.'})
	def rankingTop_selectFB(self):
		d = {}
		d.update(setMymode('rankingtop_kraje','Wszystkie'))
		d.update(setMymode('rankingtop_gatunki','Wszystkie'))
		d.update(setMymode('rankingtop_lata','Wszystkie'))
		d.update(setMymode('Ludzie_Filmu','aktorów'))
		return d
	def Rankingtop_navi(self):
		items = self.rankingTop_selectFB()
		addLinkItem('[COLOR lightblue]Kraje:[/COLOR] [B]'+items.get('rankingtop_krajeN','')+'[/B]','',mode='select:rankingtop_kraje',iconimage='DefaultCountry.png',IsPlayable=False)
		addLinkItem('[COLOR lightblue]Gatunki:[/COLOR] [B]'+items.get('rankingtop_gatunkiN','')+'[/B]','',mode='select:rankingtop_gatunki',iconimage='DefaultGenre.png',IsPlayable=False)
		addLinkItem('[COLOR lightblue]Lata:[/COLOR] [B]'+items.get('rankingtop_lataN','')+'[/B]','',mode='select:rankingtop_lata',iconimage='DefaultYear.png',IsPlayable=False)
		addDir(name='  [COLOR blue]Ranking filmów[/COLOR]',ex_link='',page=1, mode='rankingtop_show',iconImage='DefaultMovies.png',fanart=FANART)
		addDir(name='  [COLOR blue]Ranking filmów NETFLIX[/COLOR]',ex_link='/ranking/netflix?filmType=film',page=1, mode='rankingtop_show',iconImage='DefaultMovies.png',fanart=FANART)
		addDir(name='  [COLOR blue]Ranking filmów HBO[/COLOR]',ex_link='/ranking/hbo?filmType=film',page=1, mode='rankingtop_show',iconImage='DefaultMovies.png',fanart=FANART)
		addDir(name='  [COLOR blue]Ranking seriali[/COLOR]',ex_link='/rankings/serial/country?',page=1, mode='rankingseriali_show',iconImage='DefaultTVShows.png',fanart=FANART)
		addDir(name='  [COLOR blue]Ranking seriali NETFLIX[/COLOR]',ex_link='/ranking/netflix?filmType=serial',page=1, mode='rankingseriali_show',iconImage='DefaultTVShows.png',fanart=FANART)
		addDir(name='  [COLOR blue]Ranking seriali HBO[/COLOR]',ex_link='/ranking/hbo?filmType=serial',page=1, mode='rankingseriali_show',iconImage='DefaultTVShows.png',fanart=FANART)
		addLinkItem('[COLOR lightblue]Ludzie Filmu:[/COLOR] [B]'+items.get('Ludzie_FilmuN','')+'[/B]','',mode='select:Ludzie_Filmu',iconimage='DefaultActor.png',IsPlayable=False)
		addDir(name='  [COLOR blue]Ranking ludzi Filmu [/COLOR]',ex_link='/ranking/person/actors/male',page=1, mode='rankingperson_show',iconImage='DefaultDirector.png',fanart=FANART)

	def Rankingtop_show(self,ex_link):  

		if ex_link=='':
			gatunekFB_V = my_addon.getSetting('rankingtop_gatunkiV')
			krajFB_V = my_addon.getSetting('rankingtop_krajeV')
			rokFB = my_addon.getSetting('rankingtop_lataV')
			ex_link='/ranking/film'+krajFB_V+gatunekFB_V+rokFB
		items,pagination = fbooster.getContAjax(ex_link)
		if pagination[0]:
			addLinkItem(name='[COLOR gold]<< poprzednia strona <<[/COLOR]', url=pagination[0], mode='__page__:rankingtop_show', page='', IsPlayable=False)

		for f in items:
			addLinkItem(name=f.get('title'), url=f.get('href'), mode='getLinks', iconimage=f.get('img'), infoLabels=f, IsPlayable=True,itemcount=len(items))
		if pagination[1]:
			addLinkItem(name='[COLOR gold]>> następna strona >>[/COLOR]', url=pagination[1], mode='__page__:rankingtop_show', page='', IsPlayable=False)
	

		xbmcplugin.setContent(addon_handle, 'movies')
	def Rankingperson_show(self,ex_link):

		ludFilmu_V = my_addon.getSetting('Ludzie_FilmuV')
		if not ludFilmu_V: ludFilmu_V = ex_link
		items,pagination = fbooster.getPersRank(ludFilmu_V)
		if pagination[0]:
			addLinkItem(name='[COLOR gold]<< poprzednia strona <<[/COLOR]', url=pagination[0], mode='__page__:rankingperson_show', page='', IsPlayable=False)
		for f in items:
			addLinkItem(name=f.get('title'), url=f.get('href'), mode='showPeopleMovies', iconimage=f.get('img'), infoLabels=f, IsPlayable=False,itemcount=len(items))
		if pagination[1]:
			addLinkItem(name='[COLOR gold]>> następna strona >>[/COLOR]', url=pagination[1], mode='__page__:rankingperson_show', page='', IsPlayable=False)
		xbmcplugin.setContent(addon_handle, 'movies')
	def ShowPeopleMovies(self,ex_link):

		items = fbooster.getPersInfo(ex_link)
		for f in items:
			addLinkItem(name=f.get('title'), url=f.get('href'), mode='getLinks', iconimage=f.get('img'), infoLabels=f, IsPlayable=True,itemcount=len(items))
	def Rankingseriali_show(self,ex_link):
	
		gatunekFB_V = my_addon.getSetting('rankingtop_gatunkiV')
		krajFB_V = my_addon.getSetting('rankingtop_krajeV')
		rokFB = my_addon.getSetting('rankingtop_lataV')
		if '/hbo' or '/netflix' in ex_link:
			ex_link=ex_link
		else:
			ex_link='/ranking/serial'+krajFB_V+gatunekFB_V+rokFB
		items,pagination = fbooster.getContAjax(ex_link)
		for f in items:
			addLinkItem(name=f.get('title'), url=f.get('href'), mode='getSeasons', iconimage=f.get('img'), infoLabels=f, IsPlayable=True,itemcount=len(items))
		xbmcplugin.setContent(addon_handle, 'tvshows')
	def Boxoffice_navi(self):
		items = self.boxofiice_select()
		addLinkItem('[COLOR lightblue]Kraje:[/COLOR] [B]'+items.get('boxoffice_krajeN','')+'[/B]','',mode='select:boxoffice_kraje',iconimage='DefaultCountry.png',IsPlayable=False)
		addLinkItem('[COLOR lightblue]Gatunki:[/COLOR] [B]'+items.get('boxoffice_gatunkiN','')+'[/B]','',mode='select:boxoffice_gatunki',iconimage='DefaultGenre.png',IsPlayable=False)
		addLinkItem('[COLOR lightblue]Lata:[/COLOR] [B]'+items.get('boxoffice_lataN','')+'[/B]','',mode='select:boxoffice_lata',iconimage='DefaultYear.png',IsPlayable=False)
		addDir(name='  [COLOR blue]Box Office[/COLOR]',ex_link='',page=1, mode='boxoffice_show',iconImage='DefaultFolder.png',fanart=FANART)
	def boxofiice_select(self):
		d = {}
		d.update(setMymode('boxoffice_kraje','Wszystkie'))
		d.update(setMymode('boxoffice_gatunki','Wszystkie'))
		d.update(setMymode('boxoffice_lata','Wszystkie'))
		return d
	def Boxoffice_show(self,ex_link):

		gatunekFB_V = my_addon.getSetting('boxoffice_gatunkiV')
		krajFB_V = my_addon.getSetting('boxoffice_krajeV')
		rokFB = my_addon.getSetting('boxoffice_lataV')
		ex_link='/ranking/boxOffice'+krajFB_V+gatunekFB_V+rokFB
		items,pagini = fbooster.getContAjax(ex_link)
		for f in items:
			addLinkItem(name=f.get('title'), url=f.get('href'), mode='getLinks', iconimage=f.get('img'), infoLabels=f, IsPlayable=True,itemcount=len(items))
		xbmcplugin.setContent(addon_handle, 'movies')
	def jakieSortowanie(self):
		d = {}
		d.update(setMymode('bazafilmow_sort','liczby głosów'))
		d.update(setMymode('bazafilmow_sortAscending','od największej'))
		d.update(setMymode('bazafilmow_dataProdukcji','kiedykolwiek'))
		d.update(setMymode('bazafilmow_Ocena','brak'))
		d.update(setMymode('bazafilmow_genreIds','wszystkie'))
		d.update(setMymode('bazafilmow_genreTVshows','wszystkie'))
		d.update(setMymode('bazafilmow_countryIds','wszystkie'))
		return d
	def Bazafilmow_setting(self):
		d={'bazafilmow_genreTVshowsN':'wszystkie','bazafilmow_genreTVshowsV':'','bazafilmow_genreIdsN': 'wszystkie', 'bazafilmow_sortAscendingV': 'true', 'bazafilmow_OcenaN': 'brak', 'bazafilmow_countryIdsV': '', 'bazafilmow_sortV': 'count', 'bazafilmow_dataProdukcjiV': '', 'bazafilmow_genreIdsV': '', 'bazafilmow_sortAscendingN': 'od największej', 'bazafilmow_sortN': 'liczby głosów', 'bazafilmow_OcenaV': '', 'bazafilmow_countryIdsN': 'wszystkie', 'bazafilmow_dataProdukcjiN': 'kiedykolwiek'}
		for k,v in d.items(): my_addon.setSetting(k,v)
		xbmc.executebuiltin('XBMC.Container.Refresh')
	def Bazafilmow_navi(self):
		items = self.jakieSortowanie()
		addLinkItem('Domyślne Ustawienia','',mode='bazafilmow_settings_setdefault',iconimage='DefaultIconInfo.png',IsPlayable=False)
		addLinkItem('[COLOR lightblue]Sortowanie:[/COLOR] [B]'+items.get('bazafilmow_sortN','')+'[/B]','',mode='select:bazafilmow_sort',iconimage='DefaultTags.png',IsPlayable=False)
		addLinkItem('[COLOR lightblue]Kolejność:[/COLOR] [B]'+items.get('bazafilmow_sortAscendingN','')+'[/B]','',mode='select:bazafilmow_sortAscending',iconimage='DefaultTags.png',IsPlayable=False)
		addLinkItem('[COLOR lightblue]Data Produkcji:[/COLOR] [B]'+items.get('bazafilmow_dataProdukcjiN','')+'[/B]','',mode='select:bazafilmow_dataProdukcji',iconimage='DefaultYear.png',IsPlayable=False)
		addLinkItem('[COLOR lightblue]Minimalna Ocena:[/COLOR] [B]'+items.get('bazafilmow_OcenaN','')+'[/B]','',mode='select:bazafilmow_Ocena',iconimage='DefaultTags.png',IsPlayable=False)
		addLinkItem('[COLOR lightblue]Gatunek:[/COLOR] [B]'+items.get('bazafilmow_genreIdsN','')+'[/B]','',mode='multiselect:bazafilmow_genreIds',iconimage='DefaultGenre.png',IsPlayable=False)
		addLinkItem('[COLOR lightblue]Kraj:[/COLOR] [B]'+items.get('bazafilmow_countryIdsN','')+'[/B]','',mode='multiselect:bazafilmow_countryIds',iconimage='DefaultCountry.png',IsPlayable=False)
		addDir(name='  [COLOR blue]Filmy[/COLOR]',ex_link='http://www.filmweb.pl/films/search',page=1, mode='bazafilmow_show',iconImage='DefaultMovies.png',fanart=FANART)
		addDir(name='  [COLOR blue]Seriale[/COLOR]',ex_link='http://www.filmweb.pl/serials/search',page=1, mode='bazafilmow_show',iconImage='DefaultTVShows.png',fanart=FANART)
		addLinkItem('[COLOR lightblue]Gatunek TV:[/COLOR] [B]'+items.get('bazafilmow_genreTVshowsN','')+'[/B]','',mode='multiselect:bazafilmow_genreTVshows',iconimage='DefaultGenre.png',IsPlayable=False)
		addDir(name='  [COLOR blue]Programy TV[/COLOR]',ex_link='http://www.filmweb.pl/tvshows/search',page=1, mode='bazafilmow_show',iconImage='DefaultTVShows.png',fanart=FANART)

		
		
	def Bazafilmow_show(self,ex_link,page):
		page=int(page)

		prodData = my_addon.getSetting('bazafilmow_dataProdukcjiV')
		prodData = int(prodData) if prodData else ''
		endYear = prodData+9 if prodData else ''
		if 'tvshows' in ex_link:
			genreID = my_addon.getSetting('bazafilmow_genreTVshowsV')
			genresId='tvshowGenres'
		else:
			genreID = my_addon.getSetting('bazafilmow_genreIdsV')
			genresId='genres'
		daneProdukcji={
			'startYear':prodData,
			'endYear':endYear,
			'countries':my_addon.getSetting('bazafilmow_countryIdsV'),
			genresId:genreID,
			'orderBy':my_addon.getSetting('bazafilmow_sortV') ,
			'descending':my_addon.getSetting('bazafilmow_sortAscendingV'),
			'page':page
			}
	
		url = ex_link+'?'+urllib.urlencode(daneProdukcji)
		itemz = fbooster.wyborSzukania(url)
		my_mod='__page__:bazafilmow_show'
		my_modeFB ='getLinks'
		xbmcplugin.setContent(addon_handle, 'movies')
		if '/serials' in ex_link or '/tvshows' in ex_link:
			my_modeFB ='getSeasons'
			xbmcplugin.setContent(addon_handle, 'tvshows')
		if page>1:
			addLinkItem(name='[COLOR gold]<< poprzednia strona <<[/COLOR]', url=ex_link, mode=my_mod, page=page-1, IsPlayable=False)
		items=len(itemz)
		for f in itemz:
			addLinkItem(name=f.get('title'), url=f.get('href'), mode=my_modeFB, iconimage=f.get('img'), infoLabels=f, IsPlayable=True,itemcount=items)
		if len(itemz)>5:
			addLinkItem(name='[COLOR gold]>> następna strona >>[/COLOR]', url=ex_link, mode=my_mod, page=page+1, IsPlayable=False)
	def l11ll1l11ll1l1ll_fwb_(self):
		d = {}
		d.update(setMymode('bazaOsob_sort','popularność'))
		d.update(setMymode('bazaOsob_sortAscending','od największej'))
		d.update(setMymode('bazaOsob_plec','dowolna płeć'))
		d.update(setMymode('bazaOsob_zawod','dowolny'))
		d.update(setMymode('bazaOsob_country','wszystkie'))
		d.update(setMymode('bazaOsob_dataUrodzenia','wszystkie lata'))
		return d
	def BazaOsob_setting(self):
		d={'bazaOsob_dataUrodzeniaN':'wszystkie lata','bazaOsob_dataUrodzeniaV':'',
			'bazaOsob_zawodN':'dowolny','bazaOsob_zawodV':'',
			'bazaOsob_plecN':'dowolna płeć','bazaOsob_plecV':'',
			'bazaOsob_sortAscending':'od największej','bazaOsob_sortAscendingV': 'true',
			'bazaOsob_sortN': 'popularność','bazaOsob_sortV': 'popularity'
			}
		for k,v in d.items(): my_addon.setSetting(k,v)
		xbmc.executebuiltin('XBMC.Container.Refresh')
	def BazaOsob_navi(self):
		items = self.l11ll1l11ll1l1ll_fwb_()
		addLinkItem('Domyślne Ustawienia','',mode='bazaOsob_settings_setdefault',iconimage='DefaultIconInfo.png',IsPlayable=False)
		addLinkItem('[COLOR lightblue]Sortowanie:[/COLOR] [B]'+items.get('bazaOsob_sortN','')+'[/B]','',mode='select:bazaOsob_sort',iconimage='DefaultTags.png',IsPlayable=False)
		addLinkItem('[COLOR lightblue]Kolejność:[/COLOR] [B]'+items.get('bazaOsob_sortAscendingN','')+'[/B]','',mode='select:bazaOsob_sortAscending',iconimage='DefaultTags.png',IsPlayable=False)
		addLinkItem('[COLOR lightblue]Płeć:[/COLOR] [B]'+items.get('bazaOsob_plecN','')+'[/B]','',mode='select:bazaOsob_plec',iconimage='DefaultArtist.png',IsPlayable=False)
		addLinkItem('[COLOR lightblue]Zawód:[/COLOR] [B]'+items.get('bazaOsob_zawodN','')+'[/B]','',mode='select:bazaOsob_zawod',iconimage='DefaultDirector.png',IsPlayable=False)
		addLinkItem('[COLOR lightblue]Kraj urodzenia:[/COLOR] [B]'+items.get('bazaOsob_countryN','')+'[/B]','',mode='select:bazaOsob_country',iconimage='DefaultCountry.png',IsPlayable=False)
		addLinkItem('[COLOR lightblue]Data urodzenia:[/COLOR] [B]'+items.get('bazaOsob_dataUrodzeniaN','')+'[/B]','',mode='select:bazaOsob_dataUrodzenia',iconimage='DefaultYear.png',IsPlayable=False)
		addDir(name='  [COLOR blue]Osoby[/COLOR]',ex_link='http://www.filmweb.pl/persons/search',page=1, mode='bazaOsob_show',iconImage='DefaultFolder.png',fanart=FANART)
	def BazaOsob_show(self,ex_link,page):
		page=int(page)
		prodData = my_addon.getSetting('bazaOsob_dataUrodzeniaV')
		prodData = int(prodData) if prodData else ''
		endYear = prodData+9 if prodData else ''
		daneProdukcji={
			'orderBy':my_addon.getSetting('bazaOsob_sortV') ,
			'descending':my_addon.getSetting('bazaOsob_sortAscendingV'),
			'page':page}
		if my_addon.getSetting('bazaOsob_zawodV') : daneProdukcji['mainProfession'] = my_addon.getSetting('bazaOsob_zawodV')
		if my_addon.getSetting('bazaOsob_countryV'):daneProdukcji['country'] = my_addon.getSetting('bazaOsob_countryV')
		if my_addon.getSetting('bazaOsob_plecV'): daneProdukcji['sex']=my_addon.getSetting('bazaOsob_plecV')
		if prodData: daneProdukcji['startBirthYear']=prodData
		if endYear: daneProdukcji['endBirthYear']=endYear
		url = ex_link+'?'+urllib.urlencode(daneProdukcji)
		items = fbooster.wyborSzukania(url)
		my_mod='__page__:bazaOsob_show'
		my_modeFB ='showPeopleMovies'
		xbmcplugin.setContent(addon_handle, 'movies')
		if page>1: addLinkItem(name='[COLOR gold]<< poprzednia strona <<[/COLOR]', url=ex_link, mode=my_mod, page=page-1, IsPlayable=False)
		itemz=len(items)
		for f in items: addLinkItem(name=f.get('title'), url=f.get('href'), mode=my_modeFB, iconimage=f.get('img'), infoLabels=f, IsPlayable=True,itemcount=itemz)
		if len(items)>5: addLinkItem(name='[COLOR gold]>> następna strona >>[/COLOR]', url=ex_link, mode=my_mod, page=page+1, IsPlayable=False)

dekodowanie = lambda (t) : t.encode('utf-8') if isinstance(t,unicode) else t
def getVideosFromFboost(inDane,l111l1ll1ll1l1ll_fwb_=1):
    out=[]
    headers = {
                "User-Agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:60.0) Gecko/20100101 Firefox/60.0",
                "http.content_type": "application/x-www-form-urlencoded; charset=UTF-8"
                }

    outHR, outHOST = [],[]
    title=dekodowanie(inDane.get('title',''))

    orgtitleFB=dekodowanie(inDane.get('originaltitle',''))
    rokFB=inDane.get('year')
    if rokFB=='':
        rokFB=0
    else:
        rokFB=int(rokFB)
    tvshowtitleFB=dekodowanie(inDane.get('tvshowtitle'))
    sezonFB = inDane.get('season')
    episodeFB = inDane.get('episode')
    idFB=inDane.get("data_film")
    idfb=int(idFB)
    rodz = inDane.get('mediatype')
    czySERIAL = sezonFB and episodeFB and tvshowtitleFB
    if czySERIAL:
        rodz="SERIAL"       
        data = {"id": idfb,
                "type": rodz,
                "title": str(tvshowtitleFB),
                "year": rokFB,
                "sezon": str(sezonFB),
                "odcinek": str(episodeFB),
                "site": "filmdb",
                "browser": "chrome"
                }	

    else:
        rodz="FILM"
        data = {"id": idfb,
                "type": rodz,
                "title": str(title),
                "year": rokFB,
                "site": "filmdb",
                "browser": "chrome"
                }


    data = {"json" : json.dumps(data,ensure_ascii=False)}
    response = requests.post("http://fboost.pl/api/api.php", data=data, headers = headers)
    tst=response.text
    if not tst:
 
        return out
    content = json.loads(response.content)

    for code in zip(content[u'link'],content[u'wersja'],content[u'host']):
        wersja = str(code[1])
        lang, info = get_lang_by_type(wersja)
        outHOST=str(code[2])
        test = requests.post("http://fboost.pl/api/player.php?src=%s" % code[0]).content
        link = re.search("""iframe src="(.*)" style""",test)
        outHR = link.group(1)
        dlink = outHR
        if dlink:
            one = {
                'url' : dlink,
                'title': title+" | [COLOR blue][%s] [/COLOR]| [COLOR khaki][%s][/COLOR]" %(outHOST,wersja),
                'host': "|[COLOR blue][%s][/COLOR]" %(outHOST),
                }
            out.append(one)			
    return out

	
def get_lang_by_type(lang_type):
	if lang_type == 'Dubbing PL':
		return 'pl', 'Dubbing'
	elif lang_type == 'Dubbing':
		return 'pl', 'Dubbing'
	elif lang_type == 'Napisy PL':
		return 'pl', 'Napisy'
	elif lang_type == 'Napisy':
		return 'pl', 'Napisy'
	elif lang_type == 'Lektor PL':
		return 'pl', 'Lektor'
	elif lang_type == 'Lektor':
		return 'pl', 'Lektor'
	elif lang_type == 'LEKTOR_AMATOR':
		return 'pl', 'Lektor'
	elif lang_type == 'POLSKI':
		return 'pl', None
	return 'en', None
	

mode    = params.get('mode', None)
fname   = params.get('foldername','')
ex_link = params.get('ex_link','')
page    = params.get('page',1)
dataFB   = params.get('minfo',{})
if mode is None:

    filmboost().main()

elif mode=='bazafilmow_navi'    : filmboost().Bazafilmow_navi()
elif mode=='bazafilmow_show'    : filmboost().Bazafilmow_show(ex_link,page)
elif mode== 'bazafilmow_settings_setdefault': filmboost().Bazafilmow_setting()
elif mode=='rankingtop_navi'    : filmboost().Rankingtop_navi()
elif mode=='rankingtop_show'    : filmboost().Rankingtop_show(ex_link)
elif mode=='rankingseriali_show': filmboost().Rankingseriali_show(ex_link)
elif mode=='rankingperson_show' : filmboost().Rankingperson_show(ex_link)
elif mode=='showPeopleMovies'   : filmboost().ShowPeopleMovies(ex_link)
elif mode=='boxoffice_navi'     : filmboost().Boxoffice_navi()
elif mode=='boxoffice_show'     : filmboost().Boxoffice_show(ex_link)
elif mode=='checobejrzec_navi'  : filmboost().Chceobejrzec_navi()
elif mode=='dvdblueray_show'    : filmboost().Dvdblueray_show(ex_link)
elif mode=='popularnefilmy_show': filmboost().popFILMYseriale(ex_link,page)
elif mode=='dzisfilmywtv_show'  : filmboost().dzisFILMtv(ex_link,page)
elif mode=='bazaOsob_navi'    : filmboost().BazaOsob_navi()
elif mode=='bazaOsob_show'    : filmboost().BazaOsob_show(ex_link,page)
elif mode == 'bazaOsob_settings_setdefault': filmboost().BazaOsob_setting()
elif mode == 'AddToLibrary':

    import libtools #libtools

    dataFB = eval(dataFB)
    if dataFB.get('mediatype','')=='movie' or '/film/' in ex_link:
        daneSerialu = fbooster.getFilmInfoFull(dataFB.get('data_film',''))
        dataFB.update(daneSerialu)
        libtools.libmovies().add(dataFB)
    elif dataFB.get('mediatype','')=='episode' or '/serial/' in ex_link:
        daneSerialu = fbooster.getFilmInfoFull(dataFB.get('data_film',''))
        dataFB.update(daneSerialu)
        itemz =fbooster.getSeasons(ex_link,dataFB)
        tvshowtitleFB=dataFB.get('originaltitle')
        if not tvshowtitleFB:
            tvshowtitleFB=dataFB.get('title')
        year = dataFB.get('year')
        if not itemz:
            dialog.notification('FilmwebBooster', 'Brak epizodów' , xbmc.translatePath(xbmcaddon.Addon().getAddonInfo('path'))+'/icon.png', 5000, False)
        elif tvshowtitleFB and year:
            libtools.libtvshows().add(tvshowtitleFB, year, itemz)
        else:
            dialog.notification('FilmwebBooster', 'Jakiś problem!' , xbmc.translatePath(xbmcaddon.Addon().getAddonInfo('path'))+'/icon.png', 5000, False)
    else:
        dialog.notification('FilmwebBooster', 'Ta opcja nie jest (jeszcze) dostępna' , xbmc.translatePath(xbmcaddon.Addon().getAddonInfo('path'))+'/icon.png', 5000, False)
elif mode.startswith('__page__:'):
    _mode=mode.split(':')[-1]
    url = build_url({'mode': _mode, 'foldername': '', 'ex_link' : ex_link, 'page': page,'minfo':dataFB})
    xbmc.executebuiltin('XBMC.Container.Refresh(%s)'% url)
elif mode.startswith('__pageR__:'):
    _mode=mode.split(':')[-1]
    url = build_url({'mode': _mode, 'foldername': '', 'ex_link' : ex_link, 'page': page,'minfo':dataFB})
    xbmc.executebuiltin('XBMC.Container.Update(%s)'% url)
elif mode.startswith('select'):
    mymode_ = mode.split(':')[-1]

    label,value = fbooster.getCoWybieramy(mymode_)
    s = dialog.select('Wybierz',label)
    if s>-1:
        my_addon.setSetting(mymode_+'V',str(value[s]))
        my_addon.setSetting(mymode_+'N',str(label[s]) )
        xbmc.executebuiltin('XBMC.Container.Refresh')
elif mode.startswith('multiselect'):
    mymode_ = mode.split(':')[-1]
    label,value = fbooster.getCoWybieramy(mymode_)
    s = dialog.multiselect('Wybierz (kilka)',label)
    if isinstance(s,list):
        if 0 in s:
            n = label[0]
            v = ''
        else:
            _mymode=mymode_.split('_')[-1]
            v = ','.join( [value[i] for i in s])
            n = ','.join( [label[i] for i in s])
        my_addon.setSetting(mymode_+'V',v)
        my_addon.setSetting(mymode_+'N',n)
        xbmc.executebuiltin('XBMC.Container.Refresh')
elif mode.startswith('textdialog'):
    mymode_ = mode.split(':')[-1]
    d = dialog.input('Szukaj', type=xbmcgui.INPUT_ALPHANUM)
    my_addon.setSetting(mymode_+'V',d)
    my_addon.setSetting(mymode_+'N',d)
    xbmc.executebuiltin('XBMC.Container.Refresh')
elif mode == 'ListMovies':
    l1ll1111ll1l1ll_fwb_ = '/'.join([x for x in [l1llll111ll1l1ll_fwb_,l1l1l1l1ll1l1ll_fwb_,l1111l1l1ll1l1ll_fwb_] if x]) if '/filmy-online/' in ex_link else ''
    LisMovies(ex_link+l1ll1111ll1l1ll_fwb_,page)
    xbmcplugin.setContent(addon_handle, 'movies')
elif mode == 'ListMoviesKids':
    ListMoviesKids_(ex_link,page)
    xbmcplugin.setContent(addon_handle, 'movies')
elif mode == 'Opcje':
    my_addon.openSettings()
elif mode == '__page__M':
    url = build_url({'mode': 'ListMovies', 'foldername': '', 'ex_link' : ex_link, 'page': page})
    xbmc.executebuiltin('XBMC.Container.Refresh(%s)'% url)
elif mode == '__page__S':
    url = build_url({'mode': 'ListSeriale', 'foldername': '', 'ex_link' : ex_link, 'page': page})
    xbmc.executebuiltin('XBMC.Container.Refresh(%s)'% url)
elif mode == 'getEpisodes':
    getEpisodes(ex_link)
    xbmcplugin.setContent(addon_handle, 'episodes')
elif mode == 'getEpisodes2':
    getEpisodes2(ex_link)
    xbmcplugin.setContent(addon_handle, 'episodes')
elif mode == 'ListSeriale':
    ListSeriale(ex_link,page)
    xbmcplugin.setContent(addon_handle, 'tvshows')
elif mode == 'getSeasons':
    getSeasons(ex_link,dataFB)
    xbmcplugin.setContent(addon_handle, 'tvshows')
elif mode == 'ListFS':
    page=int(page)
elif mode == 'getLinks':
    getVideosFB(dataFB)
elif mode == 'lplay':
    getVideosFB(dataFB)
elif mode == 'Opcje':
    my_addon.openSettings()
elif mode =='Szukaj':
    addDir('[COLOR lightgreen]Nowe Szukanie[/COLOR]',ex_link='',mode='SzukajNowe')
    history = getHistory()
    if not history == ['']:
        for entry in history:
            contextmenu = []
            contextmenu.append(('Usun', 'XBMC.Container.Refresh(%s)'% build_url({'mode': 'SzukajUsun', 'ex_link' : entry})),)
            contextmenu.append(('Usun cała historie', 'XBMC.Container.Update(%s)' % build_url({'mode': 'SzukajUsunAll'})),)
            addDir(name=entry, ex_link=entry.replace(' ','+'), mode='SzukajNowe', fanart=None, contextmenu=contextmenu)
elif mode =='SzukajNowe':
    if not ex_link:
        d = dialog.input('Szukaj, Podaj tytuł filmu/serialu', type=xbmcgui.INPUT_ALPHANUM)
        if d: setHistory(d)
    else:
        d = ex_link
    if d:
        page = int(page)
        dataFB = eval(dataFB)
        hrefFB = dataFB.get('next_url','http://www.filmweb.pl/search?q=')
        items,extra = fbooster.getWyszukanie(d,page,hrefFB)
        if page>1       : addLinkItem(name='[COLOR gold]<< poprzednia strona <<[/COLOR]', url=d, mode='__page__:SzukajNowe', page=page-1, infoLabels=dataFB, IsPlayable=False)
        for f in items  :
            new_mode = 'getSeasons' if f.get('isFolder',False) else 'getLinks'
            if '/person/' in f.get('href'): new_mode = 'showPeopleMovies'
            addLinkItem(name=f.get('title'), url=f.get('href'), mode=new_mode, iconimage=f.get('img'), infoLabels=f, IsPlayable=True,itemcount=len(items))
        if len(items)>8 : addLinkItem(name='[COLOR gold]>> następna strona >>[/COLOR]', url=d, mode='__page__:SzukajNowe', page=page+1, infoLabels=dataFB, IsPlayable=False)
        for fz in extra:
            addLinkItem(name=fz.get('_title'), url=fz.get('_href'), mode='__pageR__:SzukajNowe', page=page, infoLabels=fz, IsPlayable=False)
elif mode =='SzukajUsun':
    remCache(ex_link)
    xbmc.executebuiltin('XBMC.Container.Refresh(%s)'%  build_url({'mode': 'Szukaj'}))
elif mode == 'SzukajUsunAll':
    delHistory()
    xbmc.executebuiltin('XBMC.Container.Refresh(%s)'%  build_url({'mode': 'Szukaj'}))
elif mode == 'folder':
    pass
	
	
	
else:
    xbmcplugin.setResolvedUrl(addon_handle, False, xbmcgui.ListItem(path=''))
xbmcplugin.endOfDirectory(addon_handle)
