# -*- coding: utf-8 -*-

"""
    Incursion Add-on

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""


try:
    from sqlite3 import dbapi2 as database
except:
    from pysqlite2 import dbapi2 as database

import datetime
import json
import os
import re
import sys
import urllib
import urlparse
import xbmc

import control
import cleantitle

class lib_tools:
    @staticmethod
    def create_folder(folder):
        try:
            folder = xbmc.makeLegalFilename(folder)
            control.makeFile(folder)

            try:
                if not 'ftp://' in folder: raise Exception()
                from ftplib import FTP
                ftparg = re.compile('ftp://(.+?):(.+?)@(.+?):?(\d+)?/(.+/?)').findall(folder)
                ftp = FTP(ftparg[0][2], ftparg[0][0], ftparg[0][1])
                try:
                    ftp.cwd(ftparg[0][4])
                except:
                    ftp.mkd(ftparg[0][4])
                ftp.quit()
            except:
                pass
        except:
            pass

    @staticmethod
    def write_file(path, content):
        try:
            path = xbmc.makeLegalFilename(path)
            if not isinstance(content, basestring):
                content = str(content)

            file = control.openFile(path, 'w')
            file.write(str(content))
            file.close()
        except Exception as e:
            pass

    @staticmethod
    def nfo_url(media_string, ids):
        tvdb_url = 'http://thetvdb.com/?tab=series&id=%s'
        tmdb_url = 'https://www.themoviedb.org/%s/%s'
        imdb_url = 'http://www.imdb.com/title/%s/'
        filmweb1_url= 'http://www.filmweb.pl%s'
        filmweb2_url ='http://www.filmweb.pl/Film?id=%s'
        if 'tvdb' in ids:
            return tvdb_url % (str(ids['tvdb']))
        elif 'tmdb' in ids:
            return tmdb_url % (media_string, str(ids['tmdb']))
        elif 'imdb' in ids:
            return imdb_url % (str(ids['imdb']))
        elif 'data_film' in ids:
            return filmweb2_url % (str(ids['data_film']))
        elif 'filmwebhref' in ids:
            return filmweb1_url % (str(ids['filmwebhref']))
        else:
            return ''

    @staticmethod
    def check_sources(title, year, imdb, tvdb=None, season=None, episode=None, tvshowtitle=None, premiered=None):
        try:
            from resources.lib.libraries import sources
            src = sources.sources().getSources(title, year, imdb, tvdb, season, episode, tvshowtitle, premiered)
            return src and len(src) > 5
        except:
            return False

    @staticmethod
    def legal_filename(filename):
        try:
            filename = filename.strip()
            filename = re.sub(r'(?!%s)[^\w\-_\.]', '.', filename)
            filename = re.sub('\.+', '.', filename)
            filename = re.sub(re.compile('(CON|PRN|AUX|NUL|COM\d|LPT\d)\.', re.I), '\\1_', filename)
            xbmc.makeLegalFilename(filename)
            return filename
        except:
            return filename

    @staticmethod
    def make_path(base_path, title, year='', season=''):
        show_folder = re.sub(r'[^\w\-_\. ]', '_', title)
        show_folder = '%s (%s)' % (show_folder, year) if year else show_folder
        path = os.path.join(base_path, show_folder)
        if season:
            path = os.path.join(path, 'Season %s' % season)
        return path
    @staticmethod
    def dekoduj(query):
        def encoded_dict(in_dict):
            out_dict = {}
            for k, v in in_dict.iteritems():
                if isinstance(v, unicode): v = v.encode('utf8')
                elif isinstance(v, str): v.decode('utf8')
                out_dict[k] = v
            return out_dict
        return sys.argv[0] + '?' + urllib.urlencode(encoded_dict(query))
		
class libmovies:
    def __init__(self):
        self.library_folder = os.path.join(control.transPath(control.setting('library.movie')), '')

        self.check_setting = control.setting('library.check_movie') or 'false'
        self.library_setting = control.setting('library.update') or 'true'
        self.dupe_setting = control.setting('library.check') or 'true'
        self.silentDialog = False
        self.infoDialog = False

    def add(self, i):
        if not control.condVisibility('Window.IsVisible(infodialog)') and not control.condVisibility('Player.HasVideo'):
            control.infoDialog('Dodawanie do Biblioteki ...', time=10000000)
            self.infoDialog = True
        files_added = 0
        if self.strmFile(i):
            files_added += 1
        if self.infoDialog == True:
            control.infoDialog('Zako\xc5\x84czono', time=1)
        if self.library_setting == 'true' and not control.condVisibility('Library.IsScanningVideo') and files_added > 0:
            control.execute('UpdateLibrary(video)')
    def strmFile(self, infoLabels):

        title = infoLabels.get('originaltitle',False)
        if title is False:
            title = infoLabels.get('title')
        try:
        	title = title[0]
        except:
        	pass
        name  = infoLabels.get('originaltitle','')
        year  = infoLabels.get('year','')
        
        if isinstance(title,unicode): title = title.encode('utf-8')
        transtitle = cleantitle.normalize(title.translate(None, '\/:*?"<>|')) #transtitle = cleantitle.normalize(title.translate(None, '\/:*?"<>|'))
        infoLabels['filmwebhref']=infoLabels.get('href')
        content = lib_tools.dekoduj({'mode': 'lplay', 'minfo':str(infoLabels)})
        folder = lib_tools.make_path(self.library_folder, transtitle, year)
        lib_tools.create_folder(folder)
        lib_tools.write_file(os.path.join(folder, lib_tools.legal_filename(transtitle) + '.strm'), content)
        lib_tools.write_file(os.path.join(folder, 'movie.nfo'), lib_tools.nfo_url('movie', infoLabels))
        ok = True
        return ok
			
class libtvshows:
    def __init__(self):
        self.library_folder = os.path.join(control.transPath(control.setting('library.tv')),'')

        self.version = control.version()

        self.check_setting = control.setting('library.check_episode') or 'false'
        self.include_unknown = control.setting('library.include_unknown') or 'true'
        self.library_setting = control.setting('library.update') or 'true'
        self.dupe_setting = control.setting('library.check') or 'true'

        self.datetime = (datetime.datetime.utcnow() - datetime.timedelta(hours = 5))
        self.date = (self.datetime - datetime.timedelta(hours = 24)).strftime('%Y%m%d')
        self.silentDialog = False
        self.infoDialog = False
        self.block = False

    def add(self, tvshowtitle, year, items={}):
        if not control.condVisibility('Window.IsVisible(infodialog)') and not control.condVisibility('Player.HasVideo'):
            control.infoDialog('Dodawanie do biblioteki ...', time=10000000)
            self.infoDialog = True
        files_added = 0
        for zz in sorted(items.keys()):
            for inf_lab in items.get(zz,[]):
                if self.strmFile(tvshowtitle, year, inf_lab):
                    files_added+=1
        if self.infoDialog == True:
            control.infoDialog('Zako\xc5\x84czono', time=1)
        if self.library_setting == 'true' and not control.condVisibility('Library.IsScanningVideo') and files_added > 0:
            control.execute('UpdateLibrary(video)')
    def strmFile(self,title, year, infoLabels):
        name  = infoLabels.get('originaltitle','')
        season  = infoLabels.get('season','')
        episode = infoLabels.get('episode','')
        if isinstance(title,unicode): title = title.encode('utf-8')
        try:
        	title = title[0]
        except:
        	pass
        transtitle = cleantitle.normalize(title.translate(None, '\\/:*?"<>|'))
        infoLabels['filmwebhref']=infoLabels.get('href')
        content = lib_tools.dekoduj({'mode': 'lplay', 'minfo':str(infoLabels)})
        folder = lib_tools.make_path(self.library_folder, transtitle, year)
        lib_tools.create_folder(folder)
        folder = lib_tools.make_path(self.library_folder, transtitle, year, season)
        lib_tools.create_folder(folder)
        lib_tools.write_file(os.path.join(folder, lib_tools.legal_filename('%s S%02dE%02d' % (transtitle, int(season), int(episode))) + '.strm'), content)
        ok = True
        return ok
