# -*- coding: UTF-8 -*-
#from __future__ import division
import sys,re,os
import six
from six.moves import urllib_parse


import resolveurl

import requests, json
import xbmcgui
import xbmcplugin
import xbmcaddon
import xbmc, xbmcvfs

if six.PY3:
    basestring = str
    unicode = str
    xrange = range
    from resources.lib.cmf3 import parseDOM
else:
    from resources.lib.cmf2 import parseDOM

base_url = sys.argv[0]
addon_handle = int(sys.argv[1])
params = dict(urllib_parse.parse_qsl(sys.argv[2][1:]))
addon = xbmcaddon.Addon(id='plugin.video.filmowoclub')

PATH            = addon.getAddonInfo('path')
if six.PY2:
    DATAPATH        = xbmc.translatePath(addon.getAddonInfo('profile')).decode('utf-8')
else:
    DATAPATH        = xbmcvfs.translatePath(addon.getAddonInfo('profile'))
RESOURCES       = PATH+'/resources/'
FANART=RESOURCES+'../fanart.jpg'
ikona =RESOURCES+'../icon.png'
prawo =RESOURCES+'../right.png'
exlink = params.get('url', None)
nazwa= params.get('title', None)
rys = params.get('image', None)

page = params.get('page',[1])
infl = params.get('infol', None)
MAIN_URL ='http://filmowo.club' 

fsortv = addon.getSetting('fsortV')
fsortn = addon.getSetting('fsortN') if fsortv else 'ostatnio dodane'

fkatv = addon.getSetting('fkatV')
fkatn = addon.getSetting('fkatN') if fkatv else 'wszystko'

focenav = addon.getSetting('focenaV')
focenan = addon.getSetting('focenaN') if focenav else 'wszystko'

frokv = addon.getSetting('frokV')
frokn = addon.getSetting('frokN') if frokv else 'wszystko'

fwerv = addon.getSetting('fwerV')
fwern = addon.getSetting('fwerN') if fwerv else 'wszystko'

ssortv = addon.getSetting('ssortV')
ssortn = addon.getSetting('ssortN') if ssortv else 'ostatnio dodane' 

skatv = addon.getSetting('skatV')
skatn = addon.getSetting('skatN') if skatv else 'wszystko'

socenav = addon.getSetting('socenaV')
socenan = addon.getSetting('socenaN') if socenav else 'wszystko'

srokv = addon.getSetting('srokV')
srokn = addon.getSetting('srokN') if srokv else 'wszystko'

swerv = addon.getSetting('swerV')
swern = addon.getSetting('swerN') if swerv else 'wszystko'

dsortv = addon.getSetting('dsortV')
dsortn = addon.getSetting('dsortN') if dsortv else 'ostatnio dodane'


docenav = addon.getSetting('docenaV')
docenan = addon.getSetting('docenaN') if docenav else 'wszystko'

drokv = addon.getSetting('drokV')
drokn = addon.getSetting('drokN') if drokv else 'wszystko'

dwerv = addon.getSetting('dwerV')
dwern = addon.getSetting('dwerN') if dwerv else 'wszystko'

dtypv = addon.getSetting('dtypV')
dtypn = addon.getSetting('dtypN') if dtypv else 'wszystko'

dataf =  addon.getSetting('fdata')    
datas =  addon.getSetting('sdata')    
datad =  addon.getSetting('ddata')    


UA = 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:89.0) Gecko/20100101 Firefox/89.0'
TIMEOUT=15

headers = {'User-Agent': UA,}
sess = requests.Session()



#xbmcplugin.addSortMethod( handle=int( sys.argv[ 1 ] ), sortMethod=xbmcplugin.SORT_METHOD_UNSORTED, label2Mask = "%R, %P, %Y")
#xbmcplugin.addSortMethod( handle=int( sys.argv[ 1 ] ), sortMethod=xbmcplugin.SORT_METHOD_DATE, label2Mask = "%R, %P, %Y")
#xbmcplugin.addSortMethod( handle=int( sys.argv[ 1 ] ), sortMethod=xbmcplugin.SORT_METHOD_TITLE, label2Mask = "%R, %P, %Y")
#xbmcplugin.addSortMethod( handle=int( sys.argv[ 1 ] ), sortMethod=xbmcplugin.SORT_METHOD_LABEL, label2Mask = "%R, %P, %Y")
#xbmcplugin.addSortMethod( handle=int( sys.argv[ 1 ] ), sortMethod=xbmcplugin.SORT_METHOD_LASTPLAYED, label2Mask = "%R, %P, %Y")

def build_url(query):
    return base_url + '?' + urllib_parse.urlencode(query)

def add_item(url, name, image, mode, itemcount=1, page=1,fanart=FANART, infoLabels=False,contextmenu=None,IsPlayable=False, folder=False):

    if six.PY3:    
        list_item = xbmcgui.ListItem(name)
    
    else:
        list_item = xbmcgui.ListItem(name, iconImage=image, thumbnailImage=image)
    
    if IsPlayable:
        list_item.setProperty("IsPlayable", 'True')  
        out = []
        out.append(('Informacja', 'Action(Info)'),)
        list_item.addContextMenuItems(out, replaceItems=False)
    list_item.setInfo(type="video", infoLabels=infoLabels)    
    list_item.setArt({'thumb': image, 'poster': image, 'banner': image, 'fanart': fanart})
    if not infoLabels:
        infoLabels={'title': name}  

    xbmcplugin.addDirectoryItem(
        handle=addon_handle,
        url = build_url({'mode': mode, 'url' : url, 'page' : page, 'title':name,'image':image,'infol':infoLabels}),            
        listitem=list_item,
        isFolder=folder)
    xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = "%Y")
    
def home():
    add_item('film', 'Filmy', ikona, "menu",fanart=FANART, folder=True)
    add_item('seriale', 'Seriale', ikona, "menu",fanart=FANART, folder=True)
    add_item('dzieci', 'Dla dzieci', ikona, "menu",fanart=FANART, folder=True)
    
    add_item('walki', 'Powtórki walk', ikona, "menu",fanart=FANART, folder=True)

    add_item('', '[COLOR lightblue]Szukaj[/COLOR]', 'DefaultAddonsSearch.png', "search", folder=True)   
    

def Menu(typ):

    if typ =='film':
        nazw = '[B][COLOR lightgreen]=#=#=#=#= Filmy =#=#=#=#=[/COLOR][/B]'
        sortn = fsortn
        katn = fkatn
        rokn = frokn
        wern = fwern
        ocenan = focenan
        t1 = 'f'
    elif typ=='seriale':
        nazw = '[B][COLOR lightgreen]=#=#=#=#= Seriale =#=#=#=#=[/COLOR][/B]'
        sortn = ssortn
        katn = skatn
        rokn = srokn
        wern = swern
        ocenan = socenan
        t1 = 's'

        
    elif typ=='dzieci':
        sortn = dsortn

        rokn = drokn
        wern = dwern
        ocenan = docenan
        t1 = 'd'

        nazw = '[B][COLOR gold]=#=#=#=#= Dla dzieci =#=#=#=#=[/COLOR][/B]'

    if not 'walki' in typ:
        add_item(typ, nazw, ikona, " ",fanart=FANART, folder=False, IsPlayable=False)
        add_item(typ, '[B]Wyświetl materiały[/B]', ikona, "listcontent",fanart=FANART, folder=True)
        if typ=='dzieci':
            add_item('film',"-    [COLOR lightblue]film/serial:[/COLOR] [B]"+dtypn+'[/B]', ikona, "filtr:"+t1+"typ",fanart=FANART, folder=False)
            add_item('film',"-    [COLOR lightblue]sortuj:[/COLOR] [B]"+sortn+'[/B]', ikona, "filtr:"+t1+"sort",fanart=FANART, folder=False)
        else:
            add_item('film',"-    [COLOR lightblue]sortuj:[/COLOR] [B]"+sortn+'[/B]', ikona, "filtr:"+t1+"sort",fanart=FANART, folder=False)
            add_item('film',"-    [COLOR lightblue]kategoria:[/COLOR] [B]"+katn+'[/B]', ikona, "filtr:"+t1+"kat",fanart=FANART, folder=False)
        add_item('film',"-    [COLOR lightblue]rok wydania:[/COLOR] [B]"+rokn+'[/B]', ikona, "filtr:"+t1+"rok",fanart=FANART, folder=False)
        add_item('film',"-    [COLOR lightblue]ocena:[/COLOR] [B]"+ocenan+'[/B]', ikona, "filtr:"+t1+"ocena",fanart=FANART, folder=False)
        add_item('film',"-    [COLOR lightblue]jakość:[/COLOR] [B]"+wern+'[/B]', ikona, "filtr:"+t1+"wer",fanart=FANART, folder=False)
        add_item(typ, '[B][COLOR khaki]>> wyczyść filtry <<[/COLOR][/B]', ikona, "resetfiltr",fanart=FANART, folder=False)
    else:
        nazw = '[B][COLOR gold]=#=#=#=#= Powtórki walk =#=#=#=#=[/COLOR][/B]'
        add_item(typ, nazw, ikona, " ",fanart=FANART, folder=False, IsPlayable=False)
        add_item(typ, '[B]Wyświetl materiały[/B]', ikona, "listcontent",fanart=FANART, folder=True)
        
        
    xbmcplugin.endOfDirectory(addon_handle)

def ResetFiltr(typ):
    tt = typ[:1]

    addon.setSetting(tt+'data','?filter={"sorting":"newest"}')
    if 'd' ==tt:
        addon.setSetting(tt+'typN','wszystkie')
        addon.setSetting(tt+'typV','')
    else:    
        addon.setSetting(tt+'katN','wszystkie')
        addon.setSetting(tt+'katV','')
        
    addon.setSetting(tt+'sortN','ostatnio dodane')
    addon.setSetting(tt+'sortV','newest')
    
    addon.setSetting(tt+'rokN','wszystkie')
    addon.setSetting(tt+'rokV','')
    
    addon.setSetting(tt+'werN','wszystkie')
    addon.setSetting(tt+'werV','')
    
    addon.setSetting(tt+'ocenaN','wszystkie')
    addon.setSetting(tt+'ocenaV','')
    
def ListSearch(query):
    url ='http://filmowo.club/search/'+query
    html=getUrlReqOk(url)

    result  = parseDOM(html,'div', attrs={'class': "tab-content"})[0]
    links = parseDOM(html,'div', attrs={'class': "list-movie"})
    for link in links:
        href = parseDOM(link,'a', ret="href")[0]
        
        tyt = parseDOM(link,'a', attrs={'class': "list-title"})[0]
        imag = parseDOM(link,'div', ret="data\-src")[0]
        href = MAIN_URL + href if href.startswith('/') else href
        imag = MAIN_URL + imag if imag.startswith('/') else imag
        qual = parseDOM(link,'div', attrs={'class': "quality"})
        qual = qual[0] if qual else ''
        ftitle=tyt.strip()+' [COLOR orange][B]('+qual+')[/COLOR][/B]' if qual else tyt.strip()
        ilabel = {'plot':tyt, 'code':qual}
        if '/serie/' in href:
            mud = 'listseries'
            
        else:
            mud ='listlinks'
        add_item(href, ftitle,imag, mud,fanart=FANART, infoLabels = ilabel, folder=True)
    if links:
        xbmcplugin.setContent(addon_handle, 'videos')    

        xbmcplugin.endOfDirectory(addon_handle)
    else:
        xbmcgui.Dialog().notification('[COLOR red][B]Info[/B][/COLOR]', "[COLOR red][B]Brak materiałów do wyświetlenia.[/B][/COLOR]", xbmcgui.NOTIFICATION_INFO, 8000)

def ListContent(typ, pg):

    if typ =='film':
        abc=dataf
        url = 'http://filmowo.club/movies'+dataf+'&page='+str(pg)
        
    elif typ =='seriale':
        url = 'http://filmowo.club/series'+datas+'&page='+str(pg)
    elif typ =='dzieci':
        url = 'http://filmowo.club/category/dla-dzieci'+datad+'&page='+str(pg)
    elif typ == 'walki':
        url = 'http://filmowo.club/category/powtorki-walk?filter={"sorting":"newest"}&page='+str(pg)
    ntpage = re.sub('\&page\=\d+','&page='+str(int(pg)+1),url)

    html=getUrlReqOk(url)

    nxtpage = False
    pagination = parseDOM(html,'ul', attrs={'class': "pagination\s*mb.*?"})#[0]
    pagination = pagination[0] if pagination else ''

    if ntpage in pagination:#
        nxtpage = True
    links = parseDOM(html,'div', attrs={'class': "list\-movie"})#[0]

    for link in links:
        
        href = parseDOM(link,'a', ret="href")[0]
        
        tyt = parseDOM(link,'a', attrs={'class': "list-title"})[0]
        imag = parseDOM(link,'div', ret="data\-src")[0]
        href = MAIN_URL + href if href.startswith('/') else href
        imag = MAIN_URL + imag if imag.startswith('/') else imag
        
        plot = parseDOM(link,'div', attrs={'class': "opis.*?"})
        plot = plot[0] if plot else tyt.strip()
        qual = parseDOM(link,'div', attrs={'class': "quality"})
        qual = qual[0] if qual else ''
        dane = re.findall('titlesub">([^<]+)',link,re.DOTALL)

        if dane:
            try:
                year,genre = dane[0].split('|')
                year = year.replace('\n','').replace(' ','')
                genre = genre.replace('\n','').replace(' ','')    
            except:
                
                genre = ''
                year =''
                pass

        ftitle=tyt.strip()+' [COLOR orange][B]('+qual+')[/COLOR][/B]' if qual else tyt.strip()
        ilabel = {'plot':plot, 'genre':genre,'year':year, 'code':qual}
        if '/serie/' in href:
            mud = 'listseries'
            
        else:
            mud ='listlinks'
        add_item(href, ftitle,imag, mud,fanart=FANART, infoLabels = ilabel, folder=True)
    if nxtpage:
        add_item(typ, '[B]>>> Następna strona >>>[/B]', prawo, "listcontent",fanart=FANART, page= int(pg)+1, folder=True)
    if links:
        xbmcplugin.setContent(addon_handle, 'videos')    

        xbmcplugin.endOfDirectory(addon_handle)
    else:
        xbmcgui.Dialog().notification('[COLOR red][B]Info[/B][/COLOR]', "[COLOR red][B]Nie znaleziono materiałów\nSpróbuj pozmieniać filtry[/B][/COLOR]", xbmcgui.NOTIFICATION_INFO, 8000)

        
def ListLinks(url):

    html=getUrlReqOk(url)
    buttons = re.findall('data\-embed(.*?)<\/button>',html,re.DOTALL)
    for but in buttons:
        id,typ = re.findall('"([^"]+)".*?name">([^<]+)<',but,re.DOTALL)[0]
        if '/serie/' in url:
            typ =''
        nn = nazwa +' [COLOR gold][B]('+typ+')[/COLOR][/B]'
        add_item(id, nn,rys, 'playLink',fanart=FANART, infoLabels = eval(infl), folder=False, IsPlayable=True)
        abc=''
    xbmcplugin.setContent(addon_handle, 'videos')    
    xbmcplugin.endOfDirectory(addon_handle)
    
def ListSeries(url):
    zz=''

    html=getUrlReqOk(url)

    episodes =  getEpisodes(url)
    #
    imag=episodes[0].get('img')
    plot = episodes[0].get('plot')
    seasons =  splitToSeasons(episodes)
    
    for i in sorted(seasons.keys()):
        aa=urllib_parse.quote(str(seasons[i]))

        add_item(name=i, url=urllib_parse.quote(str(seasons[i])), mode='listEpisodes2', image=imag, infoLabels = eval(infl), folder=True)    
    xbmcplugin.setContent(addon_handle, 'videos')    
    xbmcplugin.endOfDirectory(addon_handle)
    
def splitToSeasons(input):
    out={}
    seasons = [x.get('season') for x in input]
    for s in set(seasons):
        out['Sezon %02d'%s]=[input[i] for i, j in enumerate(seasons) if j == s]
    return out
def ListEpisodes2(exlink):
    episodes = eval(urllib_parse.unquote(exlink))
    itemz=episodes
    items = len(episodes)
    
    for f in itemz:
        add_item(name=f.get('title'), url=f.get('href'), mode='listlinks', image=f.get('img'), folder=True, infoLabels=eval(infl))    

    xbmcplugin.setContent(addon_handle, 'videos')    
    xbmcplugin.endOfDirectory(addon_handle)
    
def ListEpisodes(exlink):
    episodes = getEpisodes(exlink)
    itemz=episodes
    items = len(episodes)
    for f in itemz:
        add_item(name=f.get('title'), url=f.get('href'), mode='getLinks', image=f.get('img'), folder=True, infoLabels={'plot':f.get('title')})        

    xbmcplugin.setContent(addon_handle, 'videos')    
    xbmcplugin.endOfDirectory(addon_handle)
    
def getEpisodes(url):
    

    html = getUrlReqOk(url)

    out=[]

    result = parseDOM(html,'div', attrs={'class': "season\-list"})[0]

    seasons  = parseDOM(result,'li', attrs={'class': "nav\-item"}) 

    for seas in seasons:

        id = re.findall('aria\-controls\s*=\s*"([^"]+)"',seas,re.DOTALL+re.IGNORECASE)[0]    
        ses = re.findall('(\d+)',id,re.DOTALL)[0]

        episodesresult = parseDOM(result,'div', attrs={'id': id})[0]
        episodes =  re.findall('href\s*=s*"([^"]+)".*?"episode">([^<]+)<.*?"name">([^<]+)<',episodesresult,re.DOTALL)
        for href,odc,tyt in episodes:
            epis = re.findall('\-(\d+)\-episod',href,re.DOTALL)[0]

            jaki = ' - S%02dE%02d'%(int(ses),int(epis))

            tyt = tyt.replace('\n','').strip(' ')

            href = MAIN_URL + href if href.startswith('/') else href

            jaki = ' - '+PLchar(tyt)+' - S%02dE%02d'%(int(ses),int(epis))

            tytul = nazwa + jaki
            plot =''

            out.append({'title':tytul,'href':href,'img':rys,'plot':plot,'genre':'', 'season' : int(ses),'episode' : int(epis[0]) if epis else '',})
    return out    

def PlayLink(ids):
    data = {'id':ids}

    html = getUrlReqOk('https://filmowo.club/ajax/embed', data = data)
    iframe = parseDOM(html,'iframe',ret='src')
    exc = None
    if iframe:
        try:
            stream_url = resolveurl.resolve(iframe[0])

        except Exception as error:
            exc = repr(error)
            stream_url = None
            pass

        if stream_url:

            play_item = xbmcgui.ListItem(path=stream_url)
            xbmcplugin.setResolvedUrl(addon_handle, True, listitem=play_item)    
        else:
            msg = "[COLOR red][B]Nie mogę odtworzyć tego streama[/B][/COLOR]"
            msg = "[COLOR red][B]"+exc+"[/B][/COLOR]" if exc else msg
            xbmcgui.Dialog().notification('[COLOR red][B]Błąd[/B][/COLOR]', msg, xbmcgui.NOTIFICATION_INFO, 5000)
    else:
            xbmcgui.Dialog().notification('[COLOR red][B]Błąd[/B][/COLOR]', "[COLOR red][B]Brak tego video.[/B][/COLOR]", xbmcgui.NOTIFICATION_INFO, 5000)
    
    

def getUrlReqOk(url,ref='',data={}):    

    headersok = {
    'User-Agent': UA,
    'Accept': 'text/html',
    'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',
    'Connection': 'keep-alive',
    
    'Referer': ref,}
    if data:
        headersok = {
            'Host': 'filmowo.club',
            'user-agent': UA,
            'content-type': 'application/x-www-form-urlencoded; charset=UTF-8',
            'x-requested-with': 'XMLHttpRequest',
            'referer': ref,}

        content=sess.post(url, headers=headersok,data=data, verify=False).text
    else:
        content=sess.get(url, headers=headersok,verify=False).text
    
    return content

def PLchar(char):
    if type(char) is not str:
        char=char.encode('utf-8')
    char = char.replace('\\u0105','\xc4\x85').replace('\\u0104','\xc4\x84')
    char = char.replace('\\u0107','\xc4\x87').replace('\\u0106','\xc4\x86')
    char = char.replace('\\u0119','\xc4\x99').replace('\\u0118','\xc4\x98')
    char = char.replace('\\u0142','\xc5\x82').replace('\\u0141','\xc5\x81')
    char = char.replace('\\u0144','\xc5\x84').replace('\\u0144','\xc5\x83')
    char = char.replace('\\u00f3','\xc3\xb3').replace('\\u00d3','\xc3\x93')
    char = char.replace('\\u015b','\xc5\x9b').replace('\\u015a','\xc5\x9a')
    char = char.replace('\\u017a','\xc5\xba').replace('\\u0179','\xc5\xb9')
    char = char.replace('\\u017c','\xc5\xbc').replace('\\u017b','\xc5\xbb')
    char = char.replace('&#8217;',"'")
    char = char.replace('&#8211;',"-")    
    char = char.replace('&#8230;',"...")    
    char = char.replace('&#8222;','"').replace('&#8221;','"')    
    char = char.replace('[&hellip;]',"...")
    char = char.replace('&#038;',"&")    
    char = char.replace('&#039;',"'")
    char = char.replace('&quot;','"').replace('&oacute;','ó').replace('&rsquo;',"'")
    char = char.replace('&nbsp;',".").replace('&amp;','&').replace('&eacute;','e')
    return char    
def PLcharx(char):
    char=char.replace("\xb9","ą").replace("\xa5","Ą").replace("\xe6","ć").replace("\xc6","Ć")
    char=char.replace("\xea","ę").replace("\xca","Ę").replace("\xb3","ł").replace("\xa3","Ł")
    char=char.replace("\xf3","ó").replace("\xd3","Ó").replace("\x9c","ś").replace("\x8c","Ś")
    char=char.replace("\x9f","ź").replace("\xaf","Ż").replace("\xbf","ż").replace("\xac","Ź")
    char=char.replace("\xf1","ń").replace("\xd1","Ń").replace("\x8f","Ź");
    return char    
    
def router(paramstring):
    params = dict(urllib_parse.parse_qsl(paramstring))
    if params:    
    
        mode = params.get('mode', None)
    
        if 'filtr:' in mode: 
            filtry = {}
            ff = mode.split(':')[-1]
            tt = ff[:1]
            co = ff[1:]
            datafiltru = eval(addon.getSetting(tt+'data').split('=')[-1])
            if 'sort' in ff:
                dd='sortowanie:'

                value=["newest","popular","released","imdb"]
                label=["ostatnio dodane","popularne","rok wydania","ocena"]
                rodz = 'sorting'
            elif 'kat'  in ff:
                value=["","2","3","4","5","6","7","66","8","9","10","11","12","59","13","71","14","60","63","69","15","67","70","16","17","18","19","20","21","22","23","24","25","26","62","27","28","29","61","73","30","31","32","33","34","35","36","64","37","38","39","72","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","65","56","57","68","74","58"]
                label=['wszystkie',"akcja","animacja","anime","baśń","biblijny","biograficzny","boks","dla dzieci","dokumentalny","dramat","dramat historyczny","dramat obyczajowy","dreszczowiec","erotyczny","fame mma","familijny","fantasy","fen","freakfight","gangsterski","gromda","high league","historyczny","horror","kabaret","katastroficzny","komedia","komedia kryminalna","komedia obyczajowa","komedia romantyczna","kostiumowy","krótkometrażowy","kryminał","ksw","kulinarny","lektury","melodramat","mma","mma-vip","motoryzacyjny","musical","muzyczny","obyczajowy","podróżniczy","poetycki","polityczny","powtórki walk","przygodowy","przyrodniczy","psychologiczny","punchdown","reality-show","religijny","romans","rozrywkowy","satyra","sci-fi","sensacyjny","sport","sportowy","stand up","świąteczny","sztuki walki","talent-show","talk-show","teleturniej","thriller","ufc","western","wojenny","wotore","wwe","xxx"]
                rodz = 'category'

                dd='kategorię'
            elif 'ocena'  in ff:
                value=["","9","8","7","6","5","4"]
                label=['wszystkie',"9 i ponad","8 i ponad","7 i ponad","6 i ponad","5 i ponad","4 i ponad"]
                rodz = 'imdb'

                dd='ocenę'
            elif 'wer'  in ff:
                value=["","HD","SD","CAM"]
                label=['wszystkie',"hd","sd","cam"]
                rodz = 'quality'

                dd='jakość'
            
            elif 'rok'  in ff:
                value=["","2021 -2022","2016 - 2020","2011 - 2015","2006 - 2010","2000 - 2005","1990 - 1999"]
                label=['wszystkie',"2021-2029","2016-2020","2011-2015","2006-2010","2000-2005","1990-1999"]
                rodz = 'released'

                dd='rok wydania'
            elif 'typ'  in ff:
                value=["","movie","serie"]
                label=['wszystkie',"film","serial"]
                rodz = 'type'

                dd='film/serial'

            sel = xbmcgui.Dialog().select('Select '+dd,label)

            if sel>-1: 
                v = value[sel] if value[sel] else ''
                n = label[sel]

                if v:
                    datafiltru[rodz]=v
                else:
                    if rodz in datafiltru:
                        del datafiltru[rodz]
                addon.setSetting(tt+co+'V',v)
                addon.setSetting(tt+co+'N',n)
                addon.setSetting(tt+'data','?filter='+json.dumps(datafiltru, separators=(',', ':')))

            xbmc.executebuiltin('Container.Refresh')
    
        elif mode =='listcontent':
            ListContent(exlink, page)
            
        elif mode =='menu':
            Menu(exlink)
            
        elif mode =='listlinks':
            ListLinks(exlink)
            
        elif mode == 'listseries':
            ListSeries(exlink)
            
            
        elif mode =='listEpisodes2':
            ListEpisodes2(exlink)
            
        elif mode == 'playLink':
            PlayLink(exlink)
            
            
        elif mode == "resetfiltr":
            ResetFiltr(exlink)
        
            xbmc.executebuiltin("Container.Refresh") 

        elif mode=='search':
            query = xbmcgui.Dialog().input(u'Search...', type=xbmcgui.INPUT_ALPHANUM)
            if query:  
                if len(query)>=2:
                    ListSearch(query.replace(' ','%20'))
                else:
                    xbmcgui.Dialog().notification('[COLOR red][B]Info[/B][/COLOR]', "[COLOR red][B]Minimalnie 2 znaki[/B][/COLOR]", xbmcgui.NOTIFICATION_INFO, 8000)

    else:
        home()
        xbmcplugin.endOfDirectory(addon_handle)    
if __name__ == '__main__':
    router(sys.argv[2][1:])