# coding: UTF-8
import ast
import sys, re
import json

import requests
import routing
import xbmcvfs

from .helper import Helper

base_url = sys.argv[0]
handle = int(sys.argv[1])
helper = Helper(base_url, handle)
plugin = routing.Plugin()
FAV_PATH = helper.datapath+'favorites.json'




try:
    # Python 3
    from urllib.parse import quote_plus, unquote_plus, quote, unquote
    import html.entities as htmlentitydefs
    xrange = range
except:
    # Python 2.7
    from urllib import quote_plus, unquote_plus, quote, unquote
    import htmlentitydefs
    
try:
   import StorageServer
except:
   import storageserverdummy as StorageServer
cache = StorageServer.StorageServer('freedisk')
    
    
@plugin.route('/')
def root():
    try:

        html = helper.request_sess(helper.base_api_url, 'get', headers=helper.headers)
        abc = helper._sess.cookies
        helper.save_file(file=helper.datapath+'kukis', data=(abc).get_dict(), isJSON=True) 
        

    except:
        pass
    
    helper.add_item('[COLOR blue]Ranking freedisc.pl (7dni)[/COLOR]', plugin.url_for(listmovies, url=quote_plus('http://freedisc.pl/ranking/week'), fname=None), playable=False, art=helper.art)    
    helper.add_item('[COLOR khaki]Wybrane[/COLOR]', plugin.url_for(listmovies, url='FAVORITE', fname=quote_plus('[COLOR khaki]Wybrane[/COLOR]')), playable=False, art=helper.art)    
    helper.add_item('[COLOR green]Szukaj[/COLOR]', plugin.url_for(szukaj), playable=False, art=helper.art)    
    helper.eod()
    
    
    
    
def HistoryLoad():
    return cache.get('history').split(';')
    

    
def HistoryAdd(entry):
    history = HistoryLoad()
    if history == ['']:
        history = []
    history.insert(0, entry)
    cache.set('history',';'.join(history[:50]))
    
def HistoryDel(entry):
    history = HistoryLoad()
    
    if history:
        history.remove(entry)
        cache.set('history',';'.join(history[:50]))
    else:
        HistoryClear()
        
def HistoryClear():
    cache.delete('history')

    
@plugin.route('/szukajnowe')
def szukajnowe():

    d = helper.input_dialog('Podaj tytuł: ')
    if d:
        HistoryAdd(d)
        ex_link='search|'+d
        listmovies(ex_link,d, rt = False)
    
    
    
    return

@plugin.route('/szukajusun/<url>')
def szukajusun(url):
    url = unquote_plus(url)

    HistoryDel(url)
    helper.update(str( plugin.url_for(szukaj)))
    return
    
    
@plugin.route('/szukajusunall')
def szukajusunall():
    HistoryClear()
    helper.update(str( plugin.url_for(szukaj)))
    return

@plugin.route('/szukaj')
def szukaj():
    helper.add_item('[COLOR green]Nowe Szukanie[/COLOR]', plugin.url_for(szukajnowe), playable=False, art=helper.art, folder=False)    

    historia = HistoryLoad()
    if not historia == ['']:
        for entry in historia:
            menux = []

            menux.append(('Usuń', 'RunPlugin(%s)'%plugin.url_for_path('/szukajusun/%s' % quote_plus(entry))))
            menux.append(('Usuń całą historię', 'RunPlugin(%s)'%plugin.url_for_path('/szukajusunall/' )))
            
            
            
            
            helper.add_item(entry, plugin.url_for(listmovies, url='search|'+quote_plus(entry), fname=quote_plus(entry)), playable=False, art=helper.art, contextmenu = menux)

    helper.eod()


def searchx(phrase_='ziomek72',data_files_='data_files'):
    out=[]
    
    json_data = {
        'search_saved': 0,
        'pages': 1,
        'limit': 150,
        'search_phrase': phrase_,
        'search_type': 'movies',
    }

    response_content = helper.request_sess('https://freedisc.pl/search/get' , 'post', headers=helper.headersSzukaj, data = json_data, json=False, jsdata= True)#.text

    if response_content:
        data=json.loads(response_content)
        resp_data_data = data.get('response',{}).get(data_files_,{}).get('data',[])
        for item in resp_data_data:
            one = {'href'  : 'http://freedisc.pl/embed/video/'+item.get('id',''),
                'title' : PLchar(item.get('name','').encode('utf-8')).replace('',''),
                'img' : '',
                'folder': '',
                'duration': item.get('duration',''),
                'plot' : '',
                }
            if one.get('folder'):
                one['title'] = '[COLOR blue]%s[/COLOR] - [COLOR green]%s[/COLOR]' %(one['title'], one.get('folder'))
            out.append(one)
    return out
    
    
    
@plugin.route('/listmovies/<url>/<fname>')
def listmovies(url,fname,rt = True):
    url = unquote_plus(url)
    fname = unquote_plus(fname)

    if url=='FAVORITE':
        
        items = helper.load_file(FAV_PATH, isJSON=True)
    elif url.startswith('search'):
        items=searchx(url.split('|')[-1].strip())
    else:
        items = scanPage(url)

    contextO=['F_ADD']

    if fname=='[COLOR khaki]Wybrane[/COLOR]':
        contextO=['F_REM','F_DEL']

    if items:    
        for item in items:
            menux = []
            if 'F_ADD' in contextO:
                menux.append(('[COLOR green]Dodaj do Wybranych[/COLOR]', 'RunPlugin(%s)'%plugin.url_for_path('/favoritesADD/%s' % quote_plus(json.dumps(item)))))
            if 'F_REM' in contextO:
                menux.append(('[COLOR red]Usuń z Wybranych[/COLOR]', 'RunPlugin(%s)'%plugin.url_for_path('/favoritesREM/%s' % quote_plus(json.dumps(item)))))
    
            if 'F_DEL' in contextO:
                menux.append(('[COLOR red]Usuń Wszystko[/COLOR]', 'RunPlugin(%s)'%plugin.url_for_path('/favoritesREM/all')))
    
                
            art = {
                'icon': item.get('img'),
                'fanart': helper.addon.getAddonInfo('fanart'),
            }
            if item.get('folder'):

                helper.add_item(item.get('title',''), plugin.url_for(listmovies, url=quote_plus(item.get('href')), fname=quote_plus(item.get('title',''))), playable=False, art=art, contextmenu = menux)    

            else:

                ispla = True
                mod = plugin.url_for(getlinks, url=quote_plus(item.get('href')))
                info = {
                    'title': item.get('title'),
                    'plot':item.get('plot'),}
    
                art = {
                    'icon': item.get('img'),
                    'fanart': helper.addon.getAddonInfo('fanart'),
                }

                helper.add_item(item.get('title'), mod, playable=ispla, info=info, art=art, contextmenu = menux)    

        helper.eod()
    else:

        if rt:
            helper.update(str( plugin.url_for(root)))
        else:

            helper.update(str( plugin.url_for(szukaj)))
@plugin.route('/favoritesREM/<url>/')
def favoritesREM(url):
    if url == 'all':
        tak = helper.dialog_choice('UWAGA','Usunąć wszystkie filmy z Wybranych?',agree='TAK', disagree='NIE')
        if tak:
            import os
            os.remove(FAV_PATH)
            helper.runplugin(( plugin.url_for(listmovies, url='FAVORITE', fname=quote_plus('[COLOR khaki]Wybrane[/COLOR]'))))
    else:
        jdata = helper.load_file(FAV_PATH, isJSON=True)

        jdata = jdata if jdata else []
        remItem=json.loads(unquote_plus(url))
        to_remove=[]

        p1 = True if len(jdata)>1 else False

        for i in xrange(len(jdata)):
            if jdata[i].get('title') in remItem.get('title'):
                to_remove.append(i)
        if len(to_remove)>1:
            tak = helper.dialog_choice('UWAGA',remItem.get('title')+'\nUsuń %d pozycji z Wybranych?' % len(to_remove),agree='TAK', disagree='NIE')

        else:
            tak = True
        if tak:
            for i in reversed(to_remove):
                jdata.pop(i)
            helper.save_file(file=FAV_PATH, data=jdata, isJSON=True) 

        if p1:
            helper.update(( plugin.url_for(listmovies, url='FAVORITE', fname=quote_plus('[COLOR khaki]Wybrane[/COLOR]'))))
        else:
            helper.runplugin(( plugin.url_for(listmovies, url='FAVORITE', fname=quote_plus('[COLOR khaki]Wybrane[/COLOR]'))))
    

@plugin.route('/favoritesADD/<url>/')
def favoritesADD(url):

    import json
    
    jdata = helper.load_file(FAV_PATH, isJSON=True)

    jdata = jdata if jdata else []
    js_out=json.loads(unquote_plus(url))
    js_out['title'] = js_out.get('title','').replace(js_out.get('label',''),'').replace(js_out.get('msg',''),'')

    choose = [x for x in jdata if js_out['title']== x.get('title','')]
    if choose:
        helper.notification('[COLOR pink]Już jest w Wybranych[/COLOR]', js_out.get('title',''))

    else:
        jdata.append(js_out)
        helper.save_file(file=FAV_PATH, data=jdata, isJSON=True) 
        helper.notification('Dodano Do Wybranych', js_out.get('title',''))

    
def getVideoLink(url):
    
    out=''
    url = unquote_plus(url)

    if not '/embed/' in url:
        content = get_url(url)
        vid_id = re.compile('<iframe\\s+src="(http://freedisc.pl/embed/video/.*?)"').findall(content)
        if vid_id:
            url = vid_id[0]
    content = get_url(url)
    video = re.findall('data-video-url="([^"]+)"',content,re.DOTALL)
    data = re.compile('<link rel="video_src" .+? href=["\'](.*)["\'] />').findall(content)
    if data:
        data = data[0]
        file = re.search('file=(http(s)*://[^"\']+)',data)
        if file:
            out=file.group(1)+'|Referer='+url +' swfUrl=http://http://freedisc.pl/static/player/v58/player.swf'
            out=file.group(1)+'|Referer={}&User-Agent={}'.format(url,helper.UA)
    else:
        if video:
            out=video[0]+'|Referer={}&User-Agent={}'.format(url,helper.UA)
    return out
    
@plugin.route('/getlinks/<url>/')
def getlinks(url):
    stream_url = getVideoLink(url)
    if stream_url:
        helper.PlayVid(stream_url)

def get_url(url):
    aa=''
    zz=''
    content = helper.request_sess(url, 'get', headers=helper.headers, cookies=helper.kukis)
    dcv=''
    p1 = True
    if 'streaming/captcha.png' in content:

        from resources.lib import mc
        
        capurl = 'https://freedisc.pl/streaming/captcha.png'
        for i in range(3, 0, -1):
            p1 = False
            dtcontent = helper.request_sess(capurl, 'get', headers=helper.headers, json=False, rysdata=True)

            if sys.version_info >= (3,0,0):

                dtcontent=bytearray(dtcontent)
            rx=mc.keyboard(dtcontent)
            if rx:
                data = {'captcha':rx}

                response_content = helper.request_sess('https://freedisc.pl/' , 'post', headers=helper.headers, data = data, json=False)
                if not 'streaming/captcha.png' in response_content:
                    abc = helper._sess.cookies
                    helper.save_file(file=helper.datapath+'kukis', data=(abc).get_dict(), isJSON=True) 
                    p1 = True
                    content = helper.request_sess(url, 'get', headers=helper.headers, cookies=helper.kukis)

                    break
                elif i == 0:
                    p1 = False
                    break
                import time
                time.sleep(3)
    if p1:
        
        return content
    else:
        return ''

    return content

def scanPage(url):
    out=[]

    content = get_url(url)
    con_elem = re.compile('<div class=["\']content-element padding-5[^"\']+["\']>(.*?</div>)</div>',re.DOTALL).findall(content)
    friends_ = [(a.start(), a.end()) for a in re.finditer('<div class="friends-item hover padding-5 overflow-a">', content)]
    new_files = [(a.start(), a.end()) for a in re.finditer('<div class="w-100-p overflow-a hover margin-t-minus-1" style="border-bottom: 1px solid .dfe0df;border-top: 1px solid .dfe0df;">', content)]
    dirItem_ = [(a.start(), a.end()) for a in re.finditer('<div\\s+class="dir-item">', content)]
    cont_elem = [(a.start(), a.end()) for a in re.finditer('<div\\s+class=["\']content-element padding-5[^"\']+["\']\\s*>', content)]
    if friends_:
        out = getFriends(friends_,content)
    elif new_files:
        out = getW100(new_files,content)
        
    elif dirItem_:
        out = getDirItem(dirItem_,content)
    elif cont_elem:
        out = _get_content_element(cont_elem,content)        
        
        
        
    menuSystem = re.compile('<a class=["\']menu-system["\'] href=["\'](.*?)["\']>').findall(content)
    if menuSystem:
        sysPlik = {'href':helper.base_api_url+menuSystem[0],'title':'[COLOR blue][System Plików][/COLOR]','img':'','folder':True}
        out.insert(0,sysPlik)
    favMenu = re.compile('<a class=["\']menu-fav["\'] href=["\'](.*?)["\']>').findall(content)
    return out
    

def _get_userranking(userranking):
    out=[]
    for item in userranking:
        href = re.compile(' href="(.*?)">').findall(item)
        img = re.compile('<img src=["\'](.*?)["\'] alt=["\'](.*?)["\']').findall(item)
        if href and img:
            one = {'href'   : BASEURL+href[0],
                   'title' : PLchar(img[0][1]).strip(),
                   'img' : img[0][0],
                   'folder': True,
                }
            out.append(one)
    return out
def _get_dir_item(items):
    out=[]
    item=items[0]
    for item in items:
        href = re.compile('<a href=["\'](.*?)["\']').findall(item)
        title = re.compile('<a href=[^>]+>(.*?)<').findall(item)
        id = re.compile('<div class=["\']data["\'] id=["\'](.*?)["\']>').findall(item)
        img = re.compile('src=["\'](.*?)["\']').findall(item)
        info = re.compile('<div class=["\']info["\'][^>]*>(.*?)<').findall(item)
        if href and title:
            if id:
                url='http://freedisc.pl/embed/video/'+id[0].split('-')[-1]
                folder_fd = False
            else:
                url = BASEURL + '/' if not href[0].startswith('/') else BASEURL
                url = url + href[0]
                folder_fd = True if re.search(',d-\\d+',url) else False
            title = PLchar(title[0])
            if info:
                title +=' [COLOR lightblue]%s[/COLOR]'%(info[0])
            img = img[0] if img else ''
            if img.startswith('/'):
                img = BASEURL + img
            one = {'href'   : url,
                   'title' : PLchar(title.strip()),
                   'img' : img,
                   'folder': folder_fd,
                   }
            out.append(one)
    return out
def _get_content_element(element,content):
    element.append( (-1,-1) )
    out=[]
    for i in range(len(element[:-1])):
        item = content[ element[i][1]:element[i+1][0] ]
        img = re.compile('src=["\'](.*?)["\']').findall(item)
        href = re.compile('href=["\'](.*?)["\']').findall(item)
        title = re.compile('title=["\'](.*?)["\']').findall(item)
        info = re.compile('<div\\s+class=["\']size["\'][^>]*>(.*?)<',re.DOTALL).findall(item)
        if href and title:
            id = re.search(',f-(\\d+)',href[0])
            if id:
                url='http://freedisc.pl/embed/video/'+id.group(1)
                folder_fd = False
            else:
                url = helper.base_api_url + '/' if not href[0].startswith('/') else helper.base_api_url
                url = url + href[0]
                folder_fd = True if re.search(',d-\\d+',url) else False
            title = PLchar(title[0])
            if info:
                title +=' [COLOR lightblue]%s[/COLOR]'%(info[0].strip())
            img = img[0] if img else ''
            if img.startswith('/'):
                img = helper.base_api_url + img
            one = {'href'   : url,
                   'title' : PLchar(title.strip()),
                   'img' : img,
                   'folder': folder_fd,
                   }
            out.append(one)
    return out
def getFriends(element,content):
    element.append( (-1,-1) )
    out=[]
    for i in range(len(element[:-1])):
        item = content[ element[i][1]:element[i+1][0] ]
        href = re.compile(' href="(.*?)">').findall(item)
        img = re.compile('<img src=["\'](.*?)["\'] alt=["\'](.*?)["\']').findall(item)
        if href and img:
            one = {'href'   : helper.base_api_url+href[0],

                   'title' : PLchar(img[0][1]).strip(),
                   'img' : img[0][0],
                   'folder': True,
                }
            out.append(one)
    return out
def getW100(element,content):
    element.append( (-1,-1) )
    out=[]
    for i in range(len(element[:-1])):
        item = content[ element[i][1]:element[i+1][0] ]
        href = re.compile('href=["\'](.*?)["\']').findall(item)
        img = re.compile('<img src=["\'](.*?)["\']').findall(item)
        title = re.compile('<a title=["\'](.*?)["\']').findall(item)
        if href and title:
            one = {'href'   : BASEURL+href[0],
                   'title' : PLchar(title[0]).strip(),
                   'img' : img[0],
                   'folder': False,
                   }
            out.append(one)
    return out
def getDirItem(element,content):
    element.append( (-1,-1) )
    out=[]
    for i in range(len(element[:-1])):
        item = content[ element[i][1]:element[i+1][0] ]
        href = re.compile('\s+href=["\'](.*?)["\']').findall(item)
        title = re.compile('\s+href=[^>]+>(.*?)<',re.DOTALL).findall(item)
        id = re.compile('<div class=["\']data["\']\\s+id=["\'](.*?)["\']\\s*>').findall(item)
        img = re.compile('src\\s*=\\s*["\'](.*?)["\']').findall(item)
        info = re.compile('<div\\s+class=["\']info["\'][^>]*>(.*?)<').findall(item)
        if href and title:
            if id:
                url='http://freedisc.pl/embed/video/'+id[0].split('-')[-1]
                folder_fd = False
            else:
                url = helper.base_api_url + '/' if not href[0].startswith('/') else helper.base_api_url
                url = url + href[0]
                folder_fd = True if re.search(',d-\\d+',url) else False
            title = (title[0]).strip()
            if info:

                title +=' [COLOR lightblue]%s[/COLOR]'%(info[0])
            img = img[0] if img else ''
            if img.startswith('/'):
                img = helper.base_api_url + img
            one = {'href'   : url,
                   'title' : PLchar(title.strip()),
                   'img' : img,
                   'folder': folder_fd,
                   }
            out.append(one)
    return out
    
    
    
def html_entity_decode_char(m):
    match = m.group(1)
    if match.startswith('x'):
        return unichr(int(match[1:],16))
    try:
        return unichr(int(match))
    except Exception as l11l11l_fd_:
        if match in htmlentitydefs.name2codepoint:
            return unichr(htmlentitydefs.name2codepoint[match])
        else:
            return match

def html_entity_decode_char(m):

    ent = m.group(1)
    if ent.startswith('x'):
        return unichr(int(ent[1:],16))
    try:
        return unichr(int(ent))
    except Exception as exception:
        if ent in htmlentitydefs.name2codepoint:
            return unichr(htmlentitydefs.name2codepoint[ent])
        else:
            return ent

def html_entity_decode(string):
    try:
        string = string.decode('UTF-8')
    except:
        pass
        
    s = re.compile("&#?(\w+?);").sub(html_entity_decode_char, string)
    return s.encode('UTF-8')    

    
def PLchar(phrase_):
    phrase_ = html_entity_decode(phrase_)
    if sys.version_info >= (3,0,0):
        to_unicode = str
    else:
        to_unicode = unicode

    try:
        if type(phrase_) is not str:
            phrase_=phrase_.encode('utf-8')
        s='JiNcZCs7'
        phrase_ = re.sub(s.decode('base64'),'',phrase_)
    except:
        phrase_=phrase_.decode('utf-8')
        pass

    if sys.version_info >= (3,0,0):
        try:
            phrase_=phrase_.encode('latin-1').decode('utf-8')
        except:
            pass

    phrase_ = phrase_.replace('&lt;h5&gt;','')
    phrase_ = phrase_.replace('&lt;/h5&gt;','')
    phrase_ = phrase_.replace('&nbsp;','')
    phrase_ = phrase_.replace('&lt;br/&gt;',' ')
    phrase_ = phrase_.replace('&quot;','"').replace('&amp;quot;','"')
    phrase_ = phrase_.replace('&oacute;','\xc3\xb3').replace('&Oacute;','\xc3\x93')
    phrase_ = phrase_.replace('&amp;oacute;','\xc3\xb3').replace('&amp;Oacute;','\xc3\x93')
    phrase_ = phrase_.replace('\\u0105','\xc4\x85').replace('\\u0104','\xc4\x84')
    phrase_ = phrase_.replace('\\u0107','\xc4\x87').replace('\\u0106','\xc4\x86')
    phrase_ = phrase_.replace('\\u0119','\xc4\x99').replace('\\u0118','\xc4\x98')
    phrase_ = phrase_.replace('\\u0142','\xc5\x82').replace('\\u0141','\xc5\x81')
    phrase_ = phrase_.replace('\\u0144','\xc5\x84').replace('\\u0144','\xc5\x83')
    phrase_ = phrase_.replace('\\u00f3','\xc3\xb3').replace('\\u00d3','\xc3\x93')
    phrase_ = phrase_.replace('\\u015b','\xc5\x9b').replace('\\u015a','\xc5\x9a')
    phrase_ = phrase_.replace('\\u017a','\xc5\xba').replace('\\u0179','\xc5\xb9')
    phrase_ = phrase_.replace('\\u017c','\xc5\xbc').replace('\\u017b','\xc5\xbb')
    return phrase_

class Freedisc(Helper):
    def __init__(self):
        super().__init__()
        plugin.run()


