# -*- coding: UTF-8 -*-
from __future__ import division
import sys,re,os
import six, ast
from six.moves import urllib_parse


import requests

import xbmcgui
import xbmcplugin
import xbmcaddon
import xbmc, xbmcvfs
from resources.lib.brotlipython import brotlidec

if six.PY3:
    basestring = str
    unicode = str
    xrange = range
    from resources.lib.cmf3 import parseDOM
else:
    from resources.lib.cmf2 import parseDOM
import resolveurl

base_url = sys.argv[0]
addon_handle = int(sys.argv[1])
params = dict(urllib_parse.parse_qsl(sys.argv[2][1:]))
addon = xbmcaddon.Addon(id='plugin.video.grupamirai')

PATH            = addon.getAddonInfo('path')
if six.PY2:
    DATAPATH        = xbmc.translatePath(addon.getAddonInfo('profile')).decode('utf-8')
else:
    DATAPATH        = xbmcvfs.translatePath(addon.getAddonInfo('profile'))
RESOURCES       = PATH+'/resources/'
FANART=RESOURCES+'../fanart.jpg'
ikona =RESOURCES+'../icon.png'

exlink = params.get('url', None)
nazwa= params.get('title', None)
rys = params.get('image', None)

page = params.get('page',[1])#[0]

UA= 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:105.0) Gecko/20100101 Firefox/105.0'
TIMEOUT=15

headers = {'User-Agent': UA,}
sess = requests.Session()
main_url = 'https://www.grupa-mirai.pl'#
proj_url = main_url+'/projekty/'
def build_url(query):
    return base_url + '?' + urllib_parse.urlencode(query)

def add_item(url, name, image, mode, itemcount=1, page=1,fanart=FANART, infoLabels=False,contextmenu=None,IsPlayable=False, folder=False):
    list_item = xbmcgui.ListItem(label=name)
    if IsPlayable:
        list_item.setProperty("IsPlayable", 'True')    
    if not infoLabels:
        infoLabels={'title': name}    
    list_item.setInfo(type="video", infoLabels=infoLabels)    
    list_item.setArt({'thumb': image, 'poster': image, 'banner': image, 'fanart': fanart})
    
    if contextmenu:
        out=contextmenu
        list_item.addContextMenuItems(out, replaceItems=True)
    else:
        out = []
        out.append(('Informacja', 'XBMC.Action(Info)'),)
        list_item.addContextMenuItems(out, replaceItems=False)

    xbmcplugin.addDirectoryItem(
        handle=addon_handle,
        url = build_url({'mode': mode, 'url' : url, 'page' : page, 'title':name,'image':image}),            
        listitem=list_item,
        isFolder=folder)
    xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = "%R, %Y, %P")
   

def home():
    add_item('', 'Projekty', ikona, "listprojekty",fanart=FANART, folder=True)

def ListProjekty():
    html=getUrlReqOk(proj_url)

    menu = parseDOM(html,'ul', attrs={'class':"sub\-menu"})
    if menu:
        for href, title in re.findall('href\s*=\s*"([^"]+)">([^<]+)<',menu[0]):
            if'filmy-i-odcinki-specjalne' in href:
                continue
            title = title.replace('&#x2764;','♥')
            add_item(href, title ,rys, 'odcinki',fanart=FANART, folder=True, IsPlayable=False)
        xbmcplugin.endOfDirectory(addon_handle)
        
def createlisty    (html):

    cdalist = ['']
    megalist = ['']
    siblist = ['']
    cdalist1 = re.findall('var\s*epCda\s*=\s*(\[.*?\])',html,re.DOTALL+re.I)

    cdalist1 = ast.literal_eval(cdalist1[0]) if cdalist1 else []
    cdalist.extend(list(filter(None, cdalist1)))
    cdabulist = cdalist
    cdatfclist = cdalist
    
    megalist1 =re.findall('var\s*epMega\s*=\s*(\[.*?\])',html,re.DOTALL+re.I)
    megalist1 = ast.literal_eval(megalist1[0]) if megalist1 else []
    megalist.extend(list(filter(None, megalist1)))
    
    megabulist = megalist
    megatfclist = megalist
    
    siblist1 = re.findall('var\s*epSibnet\s*=\s*(\[.*?\])',html,re.DOTALL)
    try:
        siblist1 = ast.literal_eval(siblist1[0]) if siblist1 else []
    except:
        siblist1 = []
    
    
    siblist.extend(list(filter(None, siblist1)))
    sibulist = siblist
    sibtfclist = siblist

    cdalist2 = re.findall('var\s*ep2Cda\s*=\s*(\[.*?\])',html,re.DOTALL+re.I)
    cdalist2 = ast.literal_eval(cdalist2[0]) if cdalist2 else []
    cdalist2 = list(filter(None, cdalist2))
    
    
    cdalist3 = re.findall('var\s*ep3Cda\s*=\s*(\[.*?\])',html,re.DOTALL+re.I)
    cdalist3 = ast.literal_eval(cdalist3[0]) if cdalist3 else []
    cdalist3 = list(filter(None, cdalist3))
    cdabulist.extend(cdalist2)
    cdatfclist.extend(cdalist3)

    megalist2 =re.findall('var\s*ep2Mega\s*=\s*(\[.*?\])',html,re.DOTALL+re.I)
    megalist2 = ast.literal_eval(megalist2[0]) if megalist2 else []
    megalist2 = list(filter(None, megalist2))
    megalist3 =re.findall('var\s*ep3Mega\s*=\s*(\[.*?\])',html,re.DOTALL+re.I)
    megalist3 = ast.literal_eval(megalist3[0]) if megalist3 else []
    megalist3 = list(filter(None, megalist3))
    megabulist.extend(megalist2)
    megatfclist.extend(megalist3)

    siblist2 = re.findall('var\s*ep2Sibnet\s*=\s*(\[.*?\])',html,re.DOTALL)
    siblist2 = ast.literal_eval(siblist2[0]) if siblist2 else []
    siblist2 = list(filter(None, siblist2))
    
    
    
    siblist3 = re.findall('var\s*ep3Sibnet\s*=\s*(\[.*?\])',html,re.DOTALL)
    siblist3 = ast.literal_eval(siblist3[0]) if siblist3 else []
    siblist3 = list(filter(None, siblist3))
    sibulist.extend(siblist2)
    sibtfclist.extend(siblist3)
    return cdalist, cdabulist, cdatfclist, megalist, megabulist, megatfclist, siblist, sibulist, sibtfclist

        
def ListOdcinki(url):    
    html=getUrlReqOk(url)

    cda_url = 'https://ebd.cda.pl/620x395/{},'
    mega_url = 'https://mega.nz/embed/{},'
    sibnet_url = 'https://video.sibnet.ru/shell.php?videoid={},'
    streamable = 'https://streamable.com/e/{},'
    yt_url = 'https://www.youtube.com/embed/{},'

    cdalist, cdabulist, cdatfclist, megalist, megabulist, megatfclist, siblist, sibulist, sibtfclist = createlisty(html)

    cdalistsp = re.findall('var\s*epCdaSP\s*=\s*(\[.*?\])',html,re.DOTALL+re.I)
    cdalistsp = ast.literal_eval(cdalistsp[0]) if cdalistsp else []

    megalistsp =re.findall('var\s*epMegaSP\s*=\s*(\[.*?\])',html,re.DOTALL+re.I)
    megalistsp = ast.literal_eval(megalistsp[0]) if megalistsp else []

    siblistsp = re.findall('var\s*epSibnetSP\s*=\s*(\[.*?\])',html,re.DOTALL)
    siblistsp = ast.literal_eval(siblistsp[0]) if siblistsp else []

    servers = re.findall('var\s*servers\s*=\s*(\[.*?\])',html,re.DOTALL)
    servers = ast.literal_eval(servers[0].lower()) if servers else ['cda','mega','sibnet']
    
    img = parseDOM(html,'img', ret="src")#[0]
    if img:
        img = main_url+img[0] if img[0].startswith('/') else img[0]
    else:
        img = rys
    listax = parseDOM(html,'table', attrs={'class':"list"})
    for lista in listax:
        tbody = parseDOM(lista,'tbody')[0]
        for odc in  parseDOM(tbody,'tr'):
            if 'script>genBatch' in odc:
                continue

            try:
                tyt = re.findall('left">([^<]+)<',odc,re.DOTALL)[0]
            except:
                continue
            idx = re.findall('center">([^<]+)<',odc,re.DOTALL)[0]
            try:    
                id_ = re.findall('(\d+)', idx, re.DOTALL)[0]
            except:
                id_ = 1

            title = tyt + ' ' +str(idx)
            srcs =[]

            for ind, x in enumerate(servers):
                if 'cda' in x:
                    if '#' in idx:

                        if 'OnlineBuu(' in odc:
                            cdax = cdabulist
                        elif 'OnlineTFC(' in odc:
                            cdax = cdatfclist
                        else:
                            cdax = cdalist
                        abc = len(cdax)
                    else:
                        cdax = cdalistsp

                    try:
                        cda_id = cdax[int(id_)] if cdax else ''
                    except:

                        continue

                    if cda_id:
                        srcs.append({"host": x,'href':cda_url.format(str(cda_id))})
                elif 'mega' in x:
                    if '#' in idx:
                        if 'OnlineBuu(' in odc:
                            megax = megabulist
                        elif 'OnlineTFC(' in odc:
                            megax = megatfclist
                        else:
                            megax = megalist
                    else:
                        megax = megalistsp
                

                    try:
                        mega_id = megax[int(id_)] if megax else ''
                    except:

                        continue

                    if mega_id:
                        srcs.append({"host": x,'href':mega_url.format(str(mega_id))})
                elif 'sibnet' in x:
                
                    if '#' in idx:
                        if 'OnlineBuu(' in odc:
                            sibx = sibulist
                        elif 'OnlineTFC(' in odc:
                            sibx = sibtfclist
                        else:
                            sibx = siblist
                    else:
                        sibx = siblistsp

                    try:
                        sib_id = sibx[int(id_)] if sibx else ''
                    except:

                        continue

                    if sib_id:
                        srcs.append({"host": x,'href':sibnet_url.format(str(sib_id))})

            add_item(urllib_parse.quote_plus(str(srcs)), title ,img, 'listlinks',fanart=FANART, folder=True, IsPlayable=False)
    xbmcplugin.endOfDirectory(addon_handle)
    
def ListLinks(srcs):

    srcs = ast.literal_eval(urllib_parse.unquote_plus(srcs))
    for x in srcs:
        host = x.get('host', None)
        title = nazwa + ' [B]({})[/B]'.format(host)
        
        add_item(x.get('href', None), title ,rys, 'playvid',fanart=FANART, folder=False, IsPlayable=True)
    xbmcplugin.endOfDirectory(addon_handle)
def PlayVid(url):
    
    try:
        link = resolveurl.resolve(url)
    except:
        link = ''
    play_item = xbmcgui.ListItem(path=link)
    if '.mp4' in link:
        play_item.setProperty('inputstream', 'inputstream.ffmpegdirect')
        play_item.setProperty('inputstream.ffmpegdirect.mime_type', 'video/mp4')
        play_item.setContentLookup(False)
    xbmcplugin.setResolvedUrl(addon_handle, True, listitem=play_item)   

def getUrlReqOk(url,ref=''):    

    headersok = {
    'User-Agent': UA,
    'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
    'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',
    'Connection': 'keep-alive',

    'Referer': ref,}

    content=sess.get(url, headers=headersok,verify=False, timeout=30).content
    if six.PY3:
        content= (content).decode(encoding='utf-8', errors='strict') 
    else:
        content = content
    return content

 
def router(paramstring):
    params = dict(urllib_parse.parse_qsl(paramstring))
    if params:    
    
        mode = params.get('mode', None)

        if mode =='listprojekty':
            ListProjekty()
        elif mode =='odcinki':
            ListOdcinki(exlink)

        elif mode == "listlinks":
            ListLinks(exlink)
            
        elif mode == 'playvid':
            PlayVid(exlink)

    else:
        home()
        xbmcplugin.endOfDirectory(addon_handle)    
if __name__ == '__main__':
    router(sys.argv[2][1:])