# -*- coding: utf-8 -*-

import sys,re,os
import urllib,urllib2
import urlparse,time
import xbmc,xbmcgui,xbmcaddon
import xbmcplugin
import resolveurl as urlresolver

base_url        = sys.argv[0]
addon_handle    = int(sys.argv[1])
args            = urlparse.parse_qs(sys.argv[2][1:])
my_addon        = xbmcaddon.Addon()
addonName       = my_addon.getAddonInfo('name')
addonId     = my_addon.getAddonInfo('id')
FANART      = None
import resources.lib.iitvplug as iitvplug

def addLinkItem(name, url, mode, page=1, iconimage=None, infoLabels=False, IsPlayable=True,fanart=FANART,itemcount=1):
    u = build_url({'mode': mode, 'foldername': name, 'ex_link' : url, 'page':page})
    if iconimage==None:
        iconimage='DefaultFolder.png'
    liz = xbmcgui.ListItem(name, iconImage=iconimage, thumbnailImage=iconimage)
    if not infoLabels:
        infoLabels={'title': name}
    liz.setInfo(type='video', infoLabels=infoLabels)
    if IsPlayable:
        liz.setProperty('IsPlayable', 'true')
    if fanart:
        liz.setProperty('fanart_image',fanart)
    out = []
    out.append(('Informacja', 'XBMC.Action(Info)'))
    liz.addContextMenuItems(out, replaceItems=False)
    ok = xbmcplugin.addDirectoryItem(handle=addon_handle, url=u, listitem=liz,isFolder=False,totalItems=itemcount)
    xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = '%R, %Y, %P')
    return ok
	
def addDir(name,ex_link=None, page=0, mode='folder',iconImage='DefaultFolder.png', infoLabels=None, fanart=FANART,contextmenu=None,itemcount=1):
    url = build_url({'mode': mode, 'foldername': name, 'ex_link' : ex_link, 'page' : page})
    li = xbmcgui.ListItem(name, iconImage=iconImage, thumbnailImage=iconImage)
    if infoLabels:
        li.setInfo(type='movie', infoLabels=infoLabels)
    if fanart:
        li.setProperty('fanart_image', fanart )
    if contextmenu:
        out=contextmenu
        li.addContextMenuItems(out, replaceItems=True)
    else:
        out = []
        out.append(('Informacja', 'XBMC.Action(Info)'),)
        li.addContextMenuItems(out, replaceItems=False)
    ok = xbmcplugin.addDirectoryItem(handle=addon_handle, url=url,listitem=li, isFolder=True,totalItems=itemcount)
    xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = '%R, %Y, %P')
    return ok
	
def encoded_dict(in_dict):
    out_dict = {}
    for k, v in in_dict.iteritems():
        if isinstance(v, unicode):
            v = v.encode('utf8')
        elif isinstance(v, str):
            v.decode('utf8')
        out_dict[k] = v
    return out_dict
	
def build_url(query):
    return base_url + '?' + urllib.urlencode(encoded_dict(query))

def LastSerial(ex_link):
	linksIITV,pagination = iitvplug.scanMainPage(ex_link)
	if pagination[0]:
		addLinkItem(name='[COLOR blue]<< Poprzednia strona <<[/COLOR]', url=pagination[0], mode='__page__', IsPlayable=False)
	for f in linksIITV:
		addLinkItem(name=f.get('title'), url=f.get('url'), mode='getLinks', iconimage=f.get('img'), infoLabels=f, IsPlayable=True)
	if pagination[1]:
		addLinkItem(name='[COLOR blue]>> Nast\xc4\x99pna strona >>[/COLOR]', url=pagination[1], mode='__page__', IsPlayable=False)
	xbmcplugin.endOfDirectory(addon_handle)	
def ListSerial(ex_link):
	if ex_link=='list':
		linksIITV = iitvplug.getIITVlist()
	elif ex_link=='popular':
		linksIITV = iitvplug.getPopList()
	items=len(linksIITV)
	for f in linksIITV:
		addDir(name=f.get('title'), ex_link=f.get('url'), mode='getEpisodes', iconImage=f.get('img'), infoLabels=f,itemcount=items)
	xbmcplugin.endOfDirectory(addon_handle)			
def getEpisodes(ex_link):
	itemz = iitvplug.getEpisodes(ex_link)
	for f in itemz:
		addLinkItem(name=f.get('title'), url=f.get('url'), mode='getLinks', iconimage=f.get('img'), infoLabels=f, IsPlayable=True)
	xbmcplugin.endOfDirectory(addon_handle)			
def getLinks(ex_link):
	streams = iitvplug.getLinks(ex_link)
	link=''
	if len(streams):
		t = [x.get('title') for x in streams]
		s = xbmcgui.Dialog().select('Linki',t)
		href=streams[s].get('url') if s>-1 else ''
		if href:
			link = iitvplug.getHref(href)
			if not link:
				try:
					link = urlresolver.resolve(href)
				except Exception,e:
					xbmcgui.Dialog().ok('[COLOR red]Problem[/COLOR]','ResolveUrl ERROR: [%s]'%str(e))
					link=''
	#print 'stream_url',link
	if link:
		link = urlresolver.resolve(link)
		xbmcplugin.setResolvedUrl(addon_handle, True, xbmcgui.ListItem(path=link))
	else:
		xbmcplugin.setResolvedUrl(addon_handle, False, xbmcgui.ListItem(path=''))
		
xbmcplugin.setContent(addon_handle, 'movies')
mode = args.get('mode', None)
fname = args.get('foldername',[''])[0]
ex_link = args.get('ex_link',[''])[0]
if mode is None:
	addDir(name='Ostatnio dodane',ex_link='1', mode='OstatnieSeriale',iconImage='DefaultFolder.png',fanart=FANART)
	addDir(name='Popularne',ex_link='popular', mode='ListSeriale',iconImage='DefaultFolder.png',fanart=FANART)
	addDir(name='Wszystkie',ex_link='list', mode='ListSeriale',iconImage='DefaultFolder.png',fanart=FANART)
	xbmcplugin.endOfDirectory(addon_handle)		
elif mode[0] == '__page__':
	url = build_url({'mode': 'OstatnieSeriale', 'foldername': '', 'ex_link' : ex_link})
	xbmc.executebuiltin('XBMC.Container.Refresh(%s)'% url)
	xbmcplugin.endOfDirectory(addon_handle)		
elif mode[0] == 'OstatnieSeriale': LastSerial(ex_link)
elif mode[0] == 'ListSeriale': ListSerial(ex_link)
elif mode[0] == 'getEpisodes': getEpisodes(ex_link)
elif mode[0] == 'getLinks': getLinks(ex_link)
elif mode[0] == 'folder': pass


