# -*- coding: utf-8 -*-

import sys,os,re
import urllib,urllib2
import urlparse
import cookielib
import time
import json
mainUrl='http://iitvx.pl/'

def getUrl(url, cj=None,data=None, headers=None,timeout=20):
    if cj is not None:
        cookie = urllib2.HTTPCookieProcessor(cj)
        opener = urllib2.build_opener(cookie,urllib2.HTTPHandler())
    #    print ('getUrl', url)
        req = urllib2.Request(url)
        req.add_header('User-Agent','Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/33.0.1750.154 Safari/537.36')
        if headers:
            for h,hv in headers:
                req.add_header(h,hv)
        response = opener.open(req,data,timeout=timeout)
        link=response.read()
        response.close()
    else:
       # print ('getUrl_basic', url)
        link= getUrlH(url,data,timeout)
    return link;
	
def getUrlH(url,data=None,timeout=10):
    req = urllib2.Request(url,data)
   # print ('getUrl_basic', url)
    req.add_header('User-Agent', 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/33.0.1750.154 Safari/537.36')
    try:
        response = urllib2.urlopen(req,timeout=timeout)
        link = response.read()
        response.close()
    except:
        link=''
    return link
	
def scanMainPage(page=1):
	page=int(page)
	url='http://iitvx.pl/ajax/getCellsList/%d?init=false'%int(page)
	out=[]
	nextPage=False
	prevPage=False
	headers=[['Accept','application/json, text/plain, */*'],
			['Connection','keep-alive'],
			['X-Requested-With','XMLHttpRequest'],
			['Referer',mainUrl]]
	cj=cookielib.LWPCookieJar()
	content  = getUrl(url,cj,headers=headers)
	if content:
		data=json.loads(content)
		for k,v in data['results'].iteritems():
			one={}
			one['title'] = '%s %s'%(v.get('seasonAndEpisodeCode',''),v.get('seriesTitle'))
			one['plot']=v.get('description','')
			imag = v.get('imageUrl','')
			one['img']=imag
			one['url']=v.get('url','')
			one['data']=v.get('date','')
			one['code']=v.get('flag','')
			one['urlSeries']=v.get('theSeriesUrl','')
			out.append(one)
	nextPage=int(page)+1 if len(out) else False
	prevPage = page-1 if page>1 else False
	return (out,(prevPage,nextPage))
	
def getPopList():
    content  = getUrl(mainUrl)
    popLISTcnt = re.compile('<ul id="popular-list">(.*?)</ul>',re.DOTALL).findall(content)
    out=[]
    for u in popLISTcnt:
        hrefTitle=re.compile('<a href="(.+?)">(.+?)<').findall(u)
        for u,t in hrefTitle:
            out.append({'title':PLchar(t) ,'url':u})
    return out
	
def getIITVlist():
    content  = getUrl(mainUrl)
    popLISTcnt = re.compile('<ul id="list">(.*?)</ul>',re.DOTALL).findall(content)
    out=[]
    for u in popLISTcnt:
        hrefTitle=re.compile('<a href="(.+?)">(.+?)<').findall(u)
        for u,t in hrefTitle:
            out.append({'title':PLchar(t) ,'url':u})
    return out
	
def getEpisodes(url):
	content  = getUrl(url)
	out=[]
	epList = re.compile('<div class="episodes-list">(.*?)</div>',re.DOTALL).findall(content)
	try:
		plot = re.compile('<p class="description">.*?<br />(.+?)<h',re.DOTALL).findall(content)[0].replace('<strong>','').replace('</strong>','').replace('<br>','').replace('\n','')
	except:
		plot=''
	imag = re.findall('img class="cover" src="(.*?)"',content)
	imag ='http://iitv.pl'+imag if imag[0].startswith('/') else imag[0]
	if epList:
		for li in re.compile('<li>(.*?)</li>',re.DOTALL).findall(epList[0]):
			colDAT = re.compile('class="column date">(.*?)<').search(li)
			epCODE = re.compile('episode-code">(.*?)<').search(li)
			href = re.compile('href="(http.*?)"[^>]*>(.*?)<').search(li)
			if href:
				code = colDAT.group(1) if colDAT else ''
				title = epCODE.group(1) if colDAT else ''
				title += ' '+href.group(2) if colDAT else ''
				out.append({'title':PLchar(title) ,'url':href.group(1),'code':code,'img':imag,'plot':PLchar(plot)})
	return out
	
def getLinks(url):
    content  = getUrl(url)
   # print content
    popLISTcnt = re.compile('<ul class="tab-content"(.*?)</ul>',re.DOTALL).findall(content)
    out=[]
    for u in popLISTcnt:
        scanID = re.compile('id="(.*?)"').search(u)
        scanID = scanID.group(1) if scanID else ''
        scanID = scanID.replace('org','[COLOR grey]ORYGINA\xc5\x81[/COLOR]')
        scanID = scanID.replace('lecPL','[COLOR lightgreen]Lektor[/COLOR]')
        scanID = scanID.replace('subPL','[COLOR orange]Napisy[/COLOR]')
        hrefz = re.compile('<a .+?class="_episode-link".+?href=[\'"]([^"]*)["\'].+?data-link-id.+?>(.*?)</a>').findall(u)
        for l in hrefz:
            out.append({'title': '[%s] %s'%(scanID,l[-1]),'url':l[0]})
    return out
	
def getHref(url):
    try:
        cj = cookielib.LWPCookieJar()
        urlLINK = urlparse.urljoin(mainUrl,url) if url.startswith('/') else url
        cookie = urllib2.HTTPCookieProcessor(cj)
        opener = urllib2.build_opener(cookie, urllib2.HTTPHandler())
        req = urllib2.Request(urlLINK)
        req.add_header('User-Agent','Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/33.0.1750.154 Safari/537.36')
        response = opener.open(req,timeout=10)
        link=response.read()
        response.close()
        cookiez = ''.join(['%s=%s;'%(c.name, c.value) for c in cj ])
        salt= re.findall('data-salt="(.*?)"',link)[0]
        timeDat= re.findall('data-time="(.*?)"',link)[0]
        actDat= re.findall('data-action="(.*?)"',link)[0]
        time.sleep(int(timeDat))
        data='&salt=%s&blocker=0'%(salt)
        req = urllib2.Request(url,headers={'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Safari/537.36',
            'Cookie':cookiez,
            'X-Requested-With':'XMLHttpRequest',
            'X-OCTOBER-REQUEST-HANDLER':actDat,
            'X-OCTOBER-REQUEST-PARTIALS':'shortcut/link_show',
            'Referer':url}
            )
        response = urllib2.urlopen(req,data)
        setCookie = response.headers.get('set-cookie','')
        response.headers.keys()
        contentX = response.read()
        contentX = contentX.replace('\\','')
        response.close()
        href = re.findall('<a href="(.*?)"',contentX)[0]
        href='http'+href.split('http')[-1]
    except:
        href=''
    return href
	
def PLchar(letter):
    letter = letter.replace('&lt;br/&gt;',' ')
    letter = letter.replace('&quot;','"').replace('&amp;quot;','"')
    letter = letter.replace('&oacute;','ó').replace('&Oacute;','Ó')
    letter = letter.replace('&amp;oacute;','ó').replace('&amp;Oacute;','Ó')
    letter = letter.replace('&amp;','&')
    letter = letter.replace('\u0105','ą').replace('\u0104','Ą')
    letter = letter.replace('\u0107','ć').replace('\u0106','Ć')
    letter = letter.replace('\u0119','ę').replace('\u0118','Ę')
    letter = letter.replace('\u0142','ł').replace('\u0141','Ł')
    letter = letter.replace('\u0144','ń').replace('\u0144','Ń')
    letter = letter.replace('\u00f3','ó').replace('\u00d3','Ó')
    letter = letter.replace('\u015b','ś').replace('\u015a','Ś')
    letter = letter.replace('\u017a','ź').replace('\u0179','Ź')
    letter = letter.replace('\u017c','ż').replace('\u017b','Ż')
    return letter