# coding: UTF-8
import ast
import sys, re

import requests
import routing

from .helper import Helper

base_url = sys.argv[0]
handle = int(sys.argv[1])
helper = Helper(base_url, handle)
plugin = routing.Plugin()

try:
    # Python 3
    from urllib.parse import quote_plus, unquote_plus, quote, unquote,parse_qsl
    to_unicode = str
except:
    # Python 2.7
    from urllib import quote_plus, unquote_plus, quote, unquote
    from urlparse import parse_qsl
    to_unicode = unicode


    
    
@plugin.route('/')
def root():
    CreateDatas()
    if helper.logged:
        startwt()

    else:
        helper.add_item('[COLOR lightgreen][B]Zaloguj[/COLOR][/B]', plugin.url_for(login),folder=False)
    
    helper.add_item('[B]Ustawienia[/B]', plugin.url_for(ustawienia),folder=False)

    helper.eod()

def CreateDatas():
    if not helper.API_CorrelationId:
        import uuid
        CorrelationId = uuid.uuid4()
        helper.set_setting('CorrelationId','client_'+to_unicode(CorrelationId))
    if not helper.DeviceUid:
        import uuid
        DeviceUid = (uuid.uuid4()).hex
        helper.set_setting('DeviceUid',to_unicode(DeviceUid))
    return
    
@plugin.route('/startwt')    
def startwt():
    helper.add_item('[B]Ustawienia[/B]', plugin.url_for(ustawienia),folder=False)
    helper.add_item('[COLOR gold][B]Moja lista[/COLOR][/B]', plugin.url_for(listulubione, idx='1') ,folder=True)
    mainpage()
    
@plugin.route('/mainpage')    
def mainpage():
    
    jsdata = helper.request_sess(helper.main_page, 'get', headers=helper.headers, json=True)
    for j in jsdata:
        _id = str(j.get('id',None))
        title = j.get('title',None)
        slug = j.get('slug',None)

        idx = _id+'|'+slug
        mod = plugin.url_for(listcontent, id=quote_plus(idx))

        ispla = False
        info = {'title': title, 'plot':title}

        helper.add_item('[COLOR gold][B]'+title+'[/COLOR][/B]', mod, playable=ispla, info=info, art=helper.art)    
        
    helper.eod()

def getArts(item):
    fanart=None
    imag=None
    
    for k, v in (item.get('images', None)).items():
    
        if k == '16x9':
            fanart = v[0].get('url', None)
            fanart = 'https:'+fanart if fanart.startswith('//') else fanart
        else:
            imag = v[0].get('url', None)#'id': 1877,
            imag = 'https:'+imag if imag.startswith('//') else imag
    if fanart and not imag:
        imag = fanart
    if not fanart:
        fanart = helper.addon.getAddonInfo('fanart')
    if not imag:

        imag = helper.addon.getAddonInfo('icon')
    art = {'icon': imag, 'fanart': fanart}
    return art, imag, fanart
    
    
@plugin.route('/listulubione/<idx>')    
def listulubione(idx):
    url = helper.base_api_url.format('subscribers/bookmarks?type=FAVOURITE')

    jsdata = helper.request_sess(url, 'get', headers=helper.headers, json=True)

    if idx=='1':
        for j in jsdata.get('items', None):
            menux = []
            
            item = j.get('item', None)
            typx = item.get('type', None)
            id_ = str(item.get('id', None))
            title = item.get('title',None)
            slug = item.get('slug',None)
            descr = item.get('lead',None)
            art,imag,fanart = getArts(item)
            
            info = {'title': title, 'plot':descr}
            if 'duration' in item:
                durat = item.get('duration', None)
                info.update({'duration':durat})
            if typx == 'SERIAL':
                mod = plugin.url_for(listserials, id=id_, art = quote_plus(str(art)), info = quote_plus(str(info)))
                fold = True
                ispla = False    
            else:
                typ =     'MOVIE'
                mod = plugin.url_for(playvid, id=id_, typ = typ)
                fold = False
                ispla = True
            menux.append(('[COLOR orangered]Usuń z Ulubionych[/COLOR]', 'RunPlugin(%s)'%plugin.url_for_path('/delfav/%s' % id_)))
            helper.add_item(title, mod, playable=ispla, info=info, art=art, contextmenu = menux)    
        if jsdata.get('items', None):
            helper.eod()
        else:

            helper.notification('Informacja', 'Moja Lista jest pusta')
            plugin.run([plugin.url_for(startwt)])
        pass
    else:
        pip=[]
        for j in jsdata.get('items', None):
            item = j.get('item', None)

            if item.get('type', None) !='SERIAL':
                pip.append(item.get('id', None))
        return pip

@plugin.route('/delfav/<id_>')
def delfav(id_):
    url = helper.base_api_url.format('subscribers/bookmarks?type=FAVOURITE&itemId[]='+str(id_))
    jsdata = helper.request_sess(url, 'delete', headers=helper.headers)
    helper.notification('Informacja', 'Usunięto z Moja Lista')
    helper.refresh()

@plugin.route('/addfav/<id_>')    
def addfav(id_):

    json_data = {'itemId': int(id_)}
    url = helper.base_api_url.format('subscribers/bookmarks?type=FAVOURITE')
    jsdata = helper.request_sess(url, 'post', headers=helper.headers, data = json_data, json=False, json_data = True)
    helper.notification('Informacja', 'Dodano poprawnie do Moja Lista')
    helper.refresh()

@plugin.route('/listcontent/<id>')    
def listcontent(id):
    ulubione = listulubione('0')
    id = unquote_plus(id)
    elements=[]
    if '|' in id:
        
        id,slug = id.split('|')
    
    else:
        id = id
        slug =''


    if slug == 'nadchodzace-transmisje-na-zywo':
        add=helper.timeNow(True)

        abc = 'liveId[]=1074&liveId[]=39721'+add

        url = helper.base_api_url.format('products/lives/programmes')+'?'+abc

        jsdata = helper.request_sess(url, 'get', headers=helper.headers, json=True)
        for j in jsdata:
            _id = j.get('id', None)
            title = j.get('title', None)
            slug = item.get('slug',None)
            descr = item.get('lead',None)

            art,imag,fanart = getArts(item)
            typ = ''
            if 'live' in j:
                typ ='LIVE'
                _id = j.get('live', None).get('id', None)
                mod = plugin.url_for(playvid, id=_id, typ = typ)
                fold = False
                ispla = True
                info = {'title': title, 'plot':descr}
                helper.add_item(title, mod, playable=ispla, info=info, art=art)
    else:
        
        url = helper.main_page if slug else helper.base_api_url.format('products/sections/'+id)
        jsdata = helper.request_sess(url, 'get', headers=helper.headers, json=True)
        if slug:
            for j in jsdata:
                if str(j.get('id',None)) == id:
                    elements = j.get('elements', None)
                    break
                else:
                    continue
        else:
            elements = jsdata.get('elements', None)
        jsdata =[]
        
        if elements:
            for e in elements:
                menux = []

                item = e.get('item',None)
                typx = item.get('type', None)

                _id = str(item.get('id',None))
                if int(_id) not in ulubione:

                    menux.append(('[COLOR yellowgreen]Dodaj do Ulubionych[/COLOR]', 'RunPlugin(%s)'%plugin.url_for_path('/addfav/%s' % _id)))
            
                
                title = item.get('title',None)
                slug = item.get('slug',None)
                descr = item.get('lead',None)

                art,imag,fanart = getArts(item)
                
                info = {'title': title, 'plot':descr}
                if 'duration' in item:
                    durat = item.get('duration', None)
                    info.update({'duration':durat})
                if typx == 'SERIAL':
                    mod = plugin.url_for(listserials, id=_id, art = quote_plus(str(art)), info = quote_plus(str(info)))
                    fold = True
                    ispla = False    
                elif typx == 'BANNER':
                    webUrl = item.get('webUrl', None)
                    _id = re.findall('(\d+)',webUrl)[0] if webUrl else ''
                    mod = plugin.url_for(listcontent, id=_id)
                    fold = True
                    ispla = False    
                else:
                    typ =     'MOVIE'
                    mod = plugin.url_for(playvid, id=_id, typ = typ)
                    fold = False
                    ispla = True
                
                helper.add_item(title, mod, playable=ispla, info=info, art=art, contextmenu = menux)    
            helper.eod()
            
@plugin.route('/listserials/<id>/<art>/<info>')        
def listserials(id,art,info):

    art = ast.literal_eval(unquote_plus(art))
    info = ast.literal_eval(unquote_plus(info))
    url = helper.base_api_url.format('products/vods/serials/'+id+'/seasons')#+'?'+abc

    jsdata = helper.request_sess(url, 'get', headers=helper.headers, json=True)
    if jsdata:
        for j in jsdata:
            if j.get('type', None) == 'SEASON':
                id_ = str(j.get('id', None))
                title = j.get('title', None)
                mod = plugin.url_for(listepisodes, id=id+'|'+id_)
                fold = True
                ispla = False    
                helper.add_item(title, mod, playable=ispla, info=info, art=art)    
        helper.eod()
    
@plugin.route('/listepisodes/<id>')        
def listepisodes(id):
    serial_id, season_id = id.split('|')
    url = helper.base_api_url.format('products/vods/serials/'+serial_id+'/seasons/'+season_id+'/episodes')#+'?'+abc
    jsdata = helper.request_sess(url, 'get', headers=helper.headers, json=True)

    for item in jsdata:
        typx = item.get('type', None)

        _id = str(item.get('id',None))
        title = item.get('title',None)
        slug = item.get('slug',None)
        descr = item.get('lead',None)

        art,imag,fanart = getArts(item)
        info = {'title': title, 'plot':descr}
        if typx == 'SERIAL':
            mod = plugin.url_for(listserials, id=_id, art = quote_plus(str(art)), info = quote_plus(str(info)))
            fold = True
            ispla = False    
        else:
            typ =     'MOVIE'
            mod = plugin.url_for(playvid, id=_id, typ = typ)
            fold = False
            ispla = True
        
        helper.add_item(title, mod, playable=ispla, info=info, art=art)    
    helper.eod()

@plugin.route('/listsearch')
def listsearch():
    query = helper.input_dialog('Search...')
    if len(query)>2:
        query =quote_plus(query)
        url ='https://www.shudder.com/api/search/videos?q={}&field=title'.format(query)
        jsdata = helper.request_sess(url, 'get', headers=helper.headers, json=True)
        for x in jsdata:
        
            title = x.get('title', None)
            thumbnail = x.get('image', None)
            art = {'icon': thumbnail, 'fanart': helper.addon.getAddonInfo('fanart')}
            info = {'title': title, 'plot':title}
            
            if x.get("videoType", None) == 'movie':
                fold = False
                ispla = True
                _id = x.get("links", None).get('play', None)
                mpd_url = _id.replace('/play/','playlist/')
                widevine_url = 'xx'
                mod = plugin.url_for(playvid, mpd_url=quote_plus(mpd_url),widevine_url = quote_plus(widevine_url))

            elif x.get("videoType", None) == 'series':

                ispla = False
                _id   = x.get("links", None).get('detail', None)

                title = title+' [COLOR gold] (series) [/COLOR]'

                mod = plugin.url_for(listcollect, id=quote_plus(_id))
            
            helper.add_item(title, mod, playable=ispla, info=info, art=art)  
        if jsdata:
            helper.eod()
    else:
        helper.notification('Info', '3 characters min.')

@plugin.route('/ustawienia')
def ustawienia():
    helper.open_settings()
    helper.refresh()


@plugin.route('/logout')
def logout():
    log_out = helper.dialog_choice('Uwaga','Chcesz się wylogować?',agree='TAK', disagree='NIE')
    if log_out:
        helper.save_file(file=helper.datapath+'kukis', data={}, isJSON=True)    
        helper.set_setting('logged', 'false')
        helper.refresh()
        
@plugin.route('/login')
def login():

    if not helper.username or not helper.password:
        helper.notification('Info', 'Brak danych logowania')

        helper.set_setting('logged', 'false')
    else:
    
        json_data = {
            'email': helper.username,
            'rememberMe': True,
            'auth': {
                'type': 'PASSWORD',
                'value': helper.password,
            },
            'appVersion': '006b546',
        }

        cookies = {'uid': helper.DeviceUid}
        jsdata = helper.request_sess(helper.auth_url, 'post', headers=helper.headers, cookies=cookies, data = json_data, json=True, json_data = True)
        if jsdata.get('token', None):
            abc = helper._sess.cookies
            helper.save_file(file=helper.datapath+'kukis', data=(abc).get_dict(), isJSON=True)    
            helper.set_setting('logged', 'true')
        else:

            info=jsdata.get('code', None)
            helper.notification('Information', info)

            helper.set_setting('logged', 'false')

    helper.refresh()

@plugin.route('/playvid/<id>/<typ>')
def playvid(id,typ):

    url = helper.base_api_url.format('products/'+id+'/videos/playlist')
    param = (helper.params).update({'videoType':typ})

    jsdata = helper.request_sess(url, 'get', headers=helper.headers, json=True)
    src = jsdata.get('sources', None).get("DASH", None)[0].get('src', None)
    
    license_url = jsdata.get("drm", None).get('WIDEVINE', None).get('src', None)
    
    mpd_url = 'https:' + src if src.startswith('//') else src
    mpd_url += '|User-Agent=' + quote(helper.UA)
    
    lic_url = license_url  + '|Content-Type=&User-Agent=' + quote(helper.UA)+'|R{SSM}|'

    PROTOCOL = 'mpd'
    DRM = 'com.widevine.alpha'
    subs=[]
    subsout = []
    if helper.subtitles:
        subtitles = jsdata.get("subtitles", None)
        if subtitles:
            for subtitle in subtitles:
                subt = subtitle.get('url',None)
                label = subtitle.get('language',None)
    
                subsout.append({'label':label,'subt':subt})
            if subsout:
                labels = [x.get('label') for x in subsout]
    
                sel = helper.dialog_select('Select subtitle:', labels)
                if sel > -1:
                    subs.append(subsout[sel].get('subt'))

    helper.PlayVid(mpd_url, lic_url, PROTOCOL, DRM, flags=False, subs = subs)






class KanalSportowy(Helper):
    def __init__(self):
        super().__init__()
        plugin.run()


