# coding: UTF-8
import ast
import sys, re

import requests
import routing

from .helper import Helper

base_url = sys.argv[0]
handle = int(sys.argv[1])
helper = Helper(base_url, handle)
plugin = routing.Plugin()

try:
    # Python 3
    from urllib.parse import quote_plus, unquote_plus, quote, unquote,parse_qsl
    to_unicode = str
except:
    # Python 2.7
    from urllib import quote_plus, unquote_plus, quote, unquote
    from urlparse import parse_qsl
    to_unicode = unicode

try:
   import StorageServer
except:
   import storageserverdummy as StorageServer
cache = StorageServer.StorageServer('kanalsportowy')
    
    
@plugin.route('/')
def root():
    CreateDatas()
    if helper.logged:
        startwt()

    else:
        helper.add_item('[COLOR lightgreen][B]Zaloguj[/COLOR][/B]', plugin.url_for(login),folder=False)
    
    helper.add_item('[B]Ustawienia[/B]', plugin.url_for(ustawienia),folder=False)

    helper.eod()

def CreateDatas():
    if not helper.API_CorrelationId:
        import uuid
        CorrelationId = uuid.uuid4()
        helper.set_setting('CorrelationId','client_'+to_unicode(CorrelationId))
    if not helper.DeviceUid:
        import uuid
        DeviceUid = (uuid.uuid4()).hex
        helper.set_setting('DeviceUid',to_unicode(DeviceUid))
    return
    
@plugin.route('/startwt')    
def startwt():
    helper.add_item('[B]Ustawienia[/B]', plugin.url_for(ustawienia),folder=False)
    helper.add_item('[COLOR green]Szukaj[/COLOR]', plugin.url_for(szukaj), playable=False, folder=True, art=helper.art) 
    helper.add_item('[COLOR gold][B]Moja lista[/COLOR][/B]', plugin.url_for(listulubione, idx='1') ,folder=True)
    mainpage()
    
@plugin.route('/mainpage')    
def mainpage():
    
    jsdata = helper.request_sess(helper.main_page, 'get', headers=helper.headers, json=True)
    for j in jsdata:
        _id = str(j.get('id',None))
        title = j.get('title',None)
        slug = j.get('slug',None)

        idx = _id+'|'+slug
        mod = plugin.url_for(listcontent, id=quote_plus(idx))

        ispla = False
        info = {'title': title, 'plot':title}

        helper.add_item('[COLOR gold][B]'+title+'[/COLOR][/B]', mod, playable=ispla, info=info, art=helper.art)    
        
    helper.eod()

def getArts(item):
    fanart=None
    imag=None
    
    for k, v in (item.get('images', None)).items():
    
        if k == '16x9':
            fanart = v[0].get('url', None)
            fanart = 'https:'+fanart if fanart.startswith('//') else fanart
        else:
            imag = v[0].get('url', None)#'id': 1877,
            imag = 'https:'+imag if imag.startswith('//') else imag
    if fanart and not imag:
        imag = fanart
    if not fanart:
        fanart = helper.addon.getAddonInfo('fanart')
    if not imag:

        imag = helper.addon.getAddonInfo('icon')
    art = {'icon': imag, 'fanart': fanart}
    return art, imag, fanart
    
    
@plugin.route('/listulubione/<idx>')    
def listulubione(idx):
    url = helper.base_api_url.format('subscribers/bookmarks?type=FAVOURITE')

    jsdata = helper.request_sess(url, 'get', headers=helper.headers, json=True)

    if idx=='1':
        for j in jsdata.get('items', None):
            menux = []
            
            item = j.get('item', None)
            typx = item.get('type', None)
            id_ = str(item.get('id', None))
            title = item.get('title',None)
            slug = item.get('slug',None)
            descr = item.get('lead',None)
            art,imag,fanart = getArts(item)
            
            info = {'title': title, 'plot':descr}
            if 'duration' in item:
                durat = item.get('duration', None)
                info.update({'duration':durat})
            if typx == 'SERIAL':
                mod = plugin.url_for(listserials, id=id_, art = quote_plus(str(art)), info = quote_plus(str(info)))
                fold = True
                ispla = False    
            else:
                typ =     'MOVIE'
                mod = plugin.url_for(playvid, id=id_, typ = typ)
                fold = False
                ispla = True
            menux.append(('[COLOR orangered]Usuń z Ulubionych[/COLOR]', 'RunPlugin(%s)'%plugin.url_for_path('/delfav/%s' % id_)))
            helper.add_item(title, mod, playable=ispla, info=info, art=art, contextmenu = menux)    
        if jsdata.get('items', None):
            helper.eod()
        else:

            helper.notification('Informacja', 'Moja Lista jest pusta')
            plugin.run([plugin.url_for(startwt)])
        pass
    else:
        pip=[]
        for j in jsdata.get('items', None):
            item = j.get('item', None)

            if item.get('type', None) !='SERIAL':
                pip.append(item.get('id', None))
        return pip

@plugin.route('/delfav/<id_>')
def delfav(id_):
    url = helper.base_api_url.format('subscribers/bookmarks?type=FAVOURITE&itemId[]='+str(id_))
    jsdata = helper.request_sess(url, 'delete', headers=helper.headers)
    helper.notification('Informacja', 'Usunięto z Moja Lista')
    helper.refresh()

@plugin.route('/addfav/<id_>')    
def addfav(id_):

    json_data = {'itemId': int(id_)}
    url = helper.base_api_url.format('subscribers/bookmarks?type=FAVOURITE')
    jsdata = helper.request_sess(url, 'post', headers=helper.headers, data = json_data, json=False, json_data = True)
    helper.notification('Informacja', 'Dodano poprawnie do Moja Lista')
    helper.refresh()

@plugin.route('/listcontent/<id>')    
def listcontent(id):
    ulubione = listulubione('0')
    id = unquote_plus(id)
    elements=[]
    
    if '|' in id:
        
        id,slug = id.split('|')
    
    else:
        id = id
        slug =''
    
    
    if slug == 'nadchodzace-transmisje-na-zywo':
        add=helper.timeNow(True)
    
        abc = 'liveId[]=1074&liveId[]=39721'+add
    
        url = helper.base_api_url.format('products/lives/programmes')+'?'+abc
    
        jsdata = helper.request_sess(url, 'get', headers=helper.headers, json=True)
        for j in jsdata:

            _id = j.get('id', None)
            title = j.get('title', None)
            slug = j.get('slug',None)
            descr = j.get('lead',None)
            since = j.get('since',None)
            till = j.get('till',None)

            try:
                since = re.findall('^(.*?)\+',since,re.DOTALL)[0]
                till = re.findall('^(.*?)\+',till,re.DOTALL)[0]
                format_data = "%Y-%m-%dT%H:%M:%S"
                since = helper.formatTime(since, format_data)
                till  = helper.formatTime(till, format_data)
            except:
                since =''
                till=''
                pass
                
            art,imag,fanart = getArts(j)
            typ = ''
            if 'live' in j:
                typ ='LIVE'
                _id = j.get('live', None).get('id', None)
                mod = plugin.url_for(playvid, id=_id, typ = typ)
                fold = False
                ispla = True
                info = {'title': title, 'plot':descr}
                
                if since and till:
                    title = '[B]'+since + ' - '+till+ ' : [COLOR gold]' +title+'[/COLOR][/B]'
                helper.add_item(title, mod, playable=ispla, info=info, art=art)
        if jsdata:
            helper.eod()
    else:
        
        url = helper.main_page if slug else helper.base_api_url.format('products/sections/'+id)
        jsdata = helper.request_sess(url, 'get', headers=helper.headers, json=True)
        if slug:
            for j in jsdata:
                if str(j.get('id',None)) == id:
                    elements = j.get('elements', None)
                    break
                else:
                    continue
        else:
            elements = jsdata.get('elements', None)
        jsdata =[]
        
        if elements:
            for e in elements:
                menux = []
    
                item = e.get('item',None)
                typx = item.get('type', None)
    
                _id = str(item.get('id',None))
                if int(_id) not in ulubione:
    
                    menux.append(('[COLOR yellowgreen]Dodaj do Ulubionych[/COLOR]', 'RunPlugin(%s)'%plugin.url_for_path('/addfav/%s' % _id)))
            
                
                title = item.get('title',None)
                slug = item.get('slug',None)
                descr = item.get('lead',None)
    
                art,imag,fanart = getArts(item)
                
                info = {'title': title, 'plot':descr}
                if 'duration' in item:
                    durat = item.get('duration', None)
                    info.update({'duration':durat})
                if typx == 'SERIAL':
                    mod = plugin.url_for(listserials, id=_id, art = quote_plus(str(art)), info = quote_plus(str(info)))
                    fold = True
                    ispla = False    
                elif typx == 'BANNER':
                    webUrl = item.get('webUrl', None)
                    _id = re.findall('(\d+)',webUrl)[0] if webUrl else ''
                    mod = plugin.url_for(listcontent, id=_id)
                    fold = True
                    ispla = False    
                else:
                    typ =     'MOVIE'
                    mod = plugin.url_for(playvid, id=_id, typ = typ)
                    fold = False
                    ispla = True
                
                helper.add_item(title, mod, playable=ispla, info=info, art=art, contextmenu = menux)    
            helper.eod()
            
@plugin.route('/listserials/<id>/<art>/<info>')        
def listserials(id,art,info):

    art = ast.literal_eval(unquote_plus(art))
    info = ast.literal_eval(unquote_plus(info))
    url = helper.base_api_url.format('products/vods/serials/'+id+'/seasons')#+'?'+abc

    jsdata = helper.request_sess(url, 'get', headers=helper.headers, json=True)
    if jsdata:
        for j in jsdata:
            if j.get('type', None) == 'SEASON':
                id_ = str(j.get('id', None))
                title = j.get('title', None)
                mod = plugin.url_for(listepisodes, id=id+'|'+id_)
                fold = True
                ispla = False    
                helper.add_item(title, mod, playable=ispla, info=info, art=art)    
        helper.eod()
    
@plugin.route('/listepisodes/<id>')        
def listepisodes(id):
    serial_id, season_id = id.split('|')
    url = helper.base_api_url.format('products/vods/serials/'+serial_id+'/seasons/'+season_id+'/episodes')#+'?'+abc
    jsdata = helper.request_sess(url, 'get', headers=helper.headers, json=True)

    for item in jsdata:
        typx = item.get('type', None)

        _id = str(item.get('id',None))
        title = item.get('title',None)
        slug = item.get('slug',None)
        descr = item.get('lead',None)

        art,imag,fanart = getArts(item)
        info = {'title': title, 'plot':descr}
        if typx == 'SERIAL':
            mod = plugin.url_for(listserials, id=_id, art = quote_plus(str(art)), info = quote_plus(str(info)))
            fold = True
            ispla = False    
        else:
            typ =     'MOVIE'
            mod = plugin.url_for(playvid, id=_id, typ = typ)
            fold = False
            ispla = True
        
        helper.add_item(title, mod, playable=ispla, info=info, art=art)    
    helper.eod()

    
@plugin.route('/empty/')
def empty():
    return
    
@plugin.route('/listszukaniecd/<url>')
def listszukaniecd(url):
    ulubione = listulubione('0')
    url = unquote_plus(url)
    items = (helper.request_sess(url.format(id), 'get', headers=helper.headers, json=True, result=True)).get('items', [])
    for item in items:
        menux = []
        typx = item.get('type', None)
        
        _id = str(item.get('id',None))
        if int(_id) not in ulubione:
        
            menux.append(('[COLOR yellowgreen]Dodaj do Ulubionych[/COLOR]', 'RunPlugin(%s)'%plugin.url_for_path('/addfav/%s' % _id)))
        
        
        title = item.get('title',None)
        slug = item.get('slug',None)
        descr = item.get('lead',None)
        
        art,imag,fanart = getArts(item)
        
        info = {'title': title, 'plot':descr}
        if 'duration' in item:
            durat = item.get('duration', None)
            info.update({'duration':durat})
        if typx == 'SERIAL':
            mod = plugin.url_for(listserials, id=_id, art = quote_plus(str(art)), info = quote_plus(str(info)))
            fold = True
            ispla = False    
        elif typx == 'BANNER':
            webUrl = item.get('webUrl', None)
            _id = re.findall('(\d+)',webUrl)[0] if webUrl else ''
            mod = plugin.url_for(listcontent, id=_id)
            fold = True
            ispla = False    
        else:
            typ =     'MOVIE'
            mod = plugin.url_for(playvid, id=_id, typ = typ)
            fold = False
            ispla = True
        
        helper.add_item(title, mod, playable=ispla, info=info, art=art, contextmenu = menux)    
    helper.eod()
    

@plugin.route('/listszukanie/<id>')
def listszukanie(id):
    id = unquote_plus(id)

    vod = serial = episode = catchup = False
    titleszuk = ' Wyniki dla: [B]'+id.replace('+',' ')+' [/B]'
    art = {'icon': helper.addon.getAddonInfo('icon'), 'fanart': helper.addon.getAddonInfo('fanart')}
    info = {'title': titleszuk, 'plot':titleszuk}
    mod = plugin.url_for(empty)

    ispla = False  
    fold = False
    helper.add_item(titleszuk, mod, playable=ispla, folder=fold, info=info, art=art)
    for url in helper.searchurls:
        urlk = url.format(id)
        jsdata = helper.request_sess(urlk, 'get', headers=helper.headers, json=True, result=False)
        a = len(jsdata.json().get('items', []))#>0
        if a > 0:
            if '/VOD?' in url:
                title = 'VOD [{}]'.format(str(a))    
                vod = True
            elif '/SERIAL?' in url:
                title = 'Programy [{}]'.format(str(a))    
                serial = True
            elif '/EPISODE?' in url:
                title = 'Odcinki [{}]'.format(str(a))    
                episode = True                
            elif 'catchup=false' in url:
                title = 'Rozkład jazdy [{}]'.format(str(a))    
                catchup = True    
            elif 'catchup=true' in url:
                title = 'Rozkład jazdy [{}]'.format(str(a))    
                catchup = True    
            art = {'icon': helper.addon.getAddonInfo('icon'), 'fanart': helper.addon.getAddonInfo('fanart')}
            info = {'title': title, 'plot':title}
            mod = plugin.url_for(listszukaniecd, url=quote_plus(urlk))
                #fold = True
            ispla = False  
            helper.add_item(title, mod, playable=ispla, info=info, art=art)

    if True in (vod, serial, episode, catchup):
        helper.eod()

    return

@plugin.route('/ustawienia')
def ustawienia():
    helper.open_settings()
    helper.refresh()


@plugin.route('/logout')
def logout():
    log_out = helper.dialog_choice('Uwaga','Chcesz się wylogować?',agree='TAK', disagree='NIE')
    if log_out:
        helper.save_file(file=helper.datapath+'kukis', data={}, isJSON=True)    
        helper.set_setting('logged', 'false')
        helper.refresh()
        
@plugin.route('/login')
def login():

    if not helper.username or not helper.password:
        helper.notification('Info', 'Brak danych logowania')

        helper.set_setting('logged', 'false')
    else:
    
        json_data = {
            'email': helper.username,
            'rememberMe': True,
            'auth': {
                'type': 'PASSWORD',
                'value': helper.password,
            },
            'appVersion': '006b546',
        }

        cookies = {'uid': helper.DeviceUid}
        jsdata = helper.request_sess(helper.auth_url, 'post', headers=helper.headers, cookies=cookies, data = json_data, json=True, json_data = True)
        if jsdata.get('token', None):
            abc = helper._sess.cookies
            helper.save_file(file=helper.datapath+'kukis', data=(abc).get_dict(), isJSON=True)    
            helper.set_setting('logged', 'true')
        else:

            info=jsdata.get('code', None)
            helper.notification('Information', info)

            helper.set_setting('logged', 'false')

    helper.refresh()

@plugin.route('/playvid/<id>/<typ>')
def playvid(id,typ):

    url = helper.base_api_url.format('products/'+id+'/videos/playlist')
    param = (helper.params).update({'videoType':typ})

    jsdata = helper.request_sess(url, 'get', headers=helper.headers, json=True)
    src = jsdata.get('sources', None).get("DASH", None)[0].get('src', None)
    
    license_url = jsdata.get("drm", None).get('WIDEVINE', None).get('src', None)
    
    mpd_url = 'https:' + src if src.startswith('//') else src
    mpd_url += '|User-Agent=' + quote(helper.UA)
    
    lic_url = license_url  + '|Content-Type=&User-Agent=' + quote(helper.UA)+'|R{SSM}|'

    PROTOCOL = 'mpd'
    DRM = 'com.widevine.alpha'
    subs=[]
    subsout = []
    if helper.subtitles:
        subtitles = jsdata.get("subtitles", None)
        if subtitles:
            for subtitle in subtitles:
                subt = subtitle.get('url',None)
                label = subtitle.get('language',None)
    
                subsout.append({'label':label,'subt':subt})
            if subsout:
                labels = [x.get('label') for x in subsout]
    
                sel = helper.dialog_select('Select subtitle:', labels)
                if sel > -1:
                    subs.append(subsout[sel].get('subt'))

    helper.PlayVid(mpd_url, lic_url, PROTOCOL, DRM, flags=False, subs = subs)

    
    
    
def HistoryLoad():
    return cache.get('history').split(';')
    

    
def HistoryAdd(entry):
    history = HistoryLoad()
    if history == ['']:
        history = []
    history.insert(0, entry)
    cache.set('history',';'.join(history[:50]))
    
def HistoryDel(entry):
    history = HistoryLoad()
    
    if history:
        history.remove(entry)
        cache.set('history',';'.join(history[:50]))
    else:
        HistoryClear()
        
def HistoryClear():
    cache.delete('history')

    
@plugin.route('/szukajnowe')
def szukajnowe():

    d = helper.input_dialog('Podaj tytuł: ')
    if d:
        if len(d)>2:
            HistoryAdd(d)
            ex_link=d.replace(' ', '+')

            listszukanie(ex_link)
        else:
            helper.notification('Info', 'Minimum 3 znaki.')
    
    
    return

@plugin.route('/szukajusun/<url>')
def szukajusun(url):
    url = unquote_plus(url)

    HistoryDel(url)
    helper.update(str( plugin.url_for(szukaj)))
    return
    
    
@plugin.route('/szukajusunall')
def szukajusunall():
    HistoryClear()
    helper.update(str( plugin.url_for(szukaj)))
    return

@plugin.route('/szukaj')
def szukaj():
    helper.add_item('[COLOR green]Nowe Szukanie[/COLOR]', plugin.url_for(szukajnowe), playable=False, art=helper.art, folder=True)    

    historia = HistoryLoad()
    if not historia == ['']:
        for entry in historia:
            menux = []

            menux.append(('Usuń', 'RunPlugin(%s)'%plugin.url_for_path('/szukajusun/%s' % quote_plus(entry))))
            menux.append(('Usuń całą historię', 'RunPlugin(%s)'%plugin.url_for_path('/szukajusunall/' )))
            
            
            
            
            helper.add_item(entry, plugin.url_for(listszukanie, id=quote_plus(entry)), playable=False, art=helper.art, contextmenu = menux)

    helper.eod(False)






class KanalSportowy(Helper):
    def __init__(self):
        super().__init__()
        plugin.run()


