# -*- coding: UTF-8 -*-
import sys,re,os
import urlparse
from urlparse import parse_qsl
import base64
import urllib
import urllib2
import urllib3
import requests
import xbmcgui
import xbmcplugin
import xbmcaddon
import xbmc
from CommonFunctions import parseDOM
import resolveurl as urlresolver

urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)
base_url = sys.argv[0]
addon_handle = int(sys.argv[1])
params = dict(parse_qsl(sys.argv[2][1:]))
addon = xbmcaddon.Addon(id='plugin.video.kreskowkitv')

PATH            = addon.getAddonInfo('path')
DATAPATH        = xbmc.translatePath(addon.getAddonInfo('profile')).decode('utf-8')
RESOURCES       = PATH+'/resources/'
FANART=PATH+'fanart.jpg'
blad=PATH+'error.png'
sys.path.append( os.path.join( RESOURCES, "lib" ) )

exlink = params.get('url', None)
name= params.get('title', None)
page = params.get('page',[1])[0]

s = requests.Session()
def build_url(query):
    return base_url + '?' + urllib.urlencode(query)

def add_item(url, name, image, folder, mode, infoLabels=False, itemcount=1, page=1):
	list_item = xbmcgui.ListItem(label=name)

	if folder:
		list_item.setProperty("IsPlayable", 'false')
	else:
		list_item.setProperty("IsPlayable", 'true')
		
	if not infoLabels:
		infoLabels={'title': name}
	list_item.setInfo(type="video", infoLabels=infoLabels)	
	list_item.setArt({'thumb': image, 'poster': image, 'banner': image, 'fanart': image})
	xbmcplugin.addDirectoryItem(
		handle=addon_handle,
		url = build_url({'mode': mode, 'url' : url, 'page' : page}),			
		listitem=list_item,
		isFolder=folder)
	xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = "%R, %Y, %P")
	
def home():
	add_item('https://www.kreskowki.tv/kategoria/najnowsze/', 'Najnowsze', RESOURCES+'Filmy.png', True, "listPage")	
	add_item('https://www.kreskowki.tv/kategoria/najnowsze', 'Popularne', RESOURCES+'Filmy.png', True, "listpopular")	
	add_item('https://www.kreskowki.tv/kategoria', 'Spis alfabetyczny', '', True, "listalfabet")		
	add_item('', '[COLOR lightblue]Szukaj[/COLOR]', '', True, "search")		
	xbmcplugin.endOfDirectory(addon_handle)
	
def ListPage(exlink,page):
	page = int(page) if page else 1		
	links, pagin = getPage(exlink,page)
	if pagin[0]:
		add_item(name='[COLOR blue]<< poprzednia strona <<[/COLOR]', url=exlink, mode='__page__M', image='', folder=True, page=pagin[0])	
	itemz=links
	if itemz:
		items = len(links)
		for f in itemz:
			add_item(name=f.get('title'), url=f.get('href'), mode='getLinks', image=f.get('img'), folder=False, infoLabels=f, itemcount=items)	
	else:
		add_item(name='[COLOR red]Brak materiałów[/COLOR]', url='', mode=' ', image='', folder=False, infoLabels='', itemcount=1)			
	if pagin[1]:
		add_item(name='[COLOR blue]>> Nastepna strona >>>[/COLOR]', url=exlink, mode='__page__M', image='', folder=True, page=pagin[1])
	xbmcplugin.setContent(addon_handle, 'movies')	
	xbmcplugin.endOfDirectory(addon_handle)	
	
def ListAlfabet(exlink):
	links= getAlfabet(exlink)
	itemz=links
	items = len(links)
	for f in itemz:
		add_item(name=f.get('title'), url=f.get('href'), mode='listalfabet2', image=f.get('img'), folder=True, infoLabels=f, itemcount=items)		
	xbmcplugin.setContent(addon_handle, 'movies')
	xbmcplugin.endOfDirectory(addon_handle)	

def ListAlfabet2(exlink):	
	links= getAlfabet2(exlink)
	itemz=links
	items = len(links)
	for f in itemz:
		add_item(name=f.get('title'), url=f.get('href'), mode='listMaterial', image=f.get('img'), folder=True, infoLabels=f, itemcount=items)		
	xbmcplugin.setContent(addon_handle, 'movies')
	xbmcplugin.endOfDirectory(addon_handle)	
	
def ListPopular(exlink):		
	links= getPopular(exlink)
	itemz=links
	items = len(links)
	for f in itemz:
		add_item(name=f.get('title'), url=f.get('href'), mode='listMaterial', image=f.get('img'), folder=True, infoLabels=f, itemcount=items)		
	xbmcplugin.setContent(addon_handle, 'movies')
	xbmcplugin.endOfDirectory(addon_handle)
	
def ListMaterial(exlink):	
	links= getMaterial(exlink)
	itemz=links
	items = len(links)
	for f in itemz:
		add_item(name=f.get('title'), url=f.get('href'), mode='listPage', image=f.get('img'), folder=True, infoLabels=f, itemcount=items)		
	xbmcplugin.setContent(addon_handle, 'movies')	
	xbmcplugin.endOfDirectory(addon_handle)	
def getUrlReq(url):
	content=s.get(url,headers=s.headers, verify=False).text	
	return content

def getAlfabet(url):	
	html=getUrlReq(url)
	out=[]
	result=parseDOM(html,'ol', attrs={'class': "breadcrumb"})[0]
	links= parseDOM(result, 'li')
	for link in links:
		href= parseDOM(link, 'a', ret='href')[0]
		title= parseDOM(link, 'a')[0]
		out.append({'title':'[B][COLOR white]'+PLchar(title)+'[/B][/COLOR]','href':PLchar(href)})
	return out	

def getAlfabet2(url):	
	html=getUrlReq(url)
	out=[]
	result=parseDOM(html,'div', attrs={'class': "panel-body"})[0] 
	links = parseDOM(result, 'div', attrs={'class': "cinema-list-grid"})
	for link in links:
		imag = parseDOM(link, 'img', ret='src')[0]
		href= parseDOM(link, 'a', ret='href')[0]
		if 'ostrzezenie/' in href:
			nast=re.findall('ostrzezenie(\/\d+)',href)[0]
			href='https://www.kreskowki.tv/kategoria'+nast
		else:
			href=re.findall("(.+\d+\/)",href)[0]
		title= parseDOM(link, 'a')[1]
		out.append({'title':PLchar(title),'href':href,'img':imag})
	return out	
	
def getPopular(url):	
	html=getUrlReq(url)
	out=[]
	result=parseDOM(html,'div', attrs={'class': "panel-body"})[4]	#<div class="panel-body">
	links= parseDOM(result, 'ul', attrs={'class': "mov_list"}) #<ul class="mov_list">
	for link in links:
		poz = parseDOM(link, 'li')[1]
		href= parseDOM(link, 'a', ret='href')[0]
		title= parseDOM(link, 'a')[0]
		out.append({'title':poz+'. '+title,'href':href,'img':'','plot':'', 'year':''})
	return out

def getMaterial(url):	
	html=getUrlReq(url)
	out=[]
	try:
		plot= PLchar(parseDOM(html, 'div', attrs={'class': "panel-body odesc"})[0])
	except:
		plot=''

	links= parseDOM(html, 'div', attrs={'class': "col-sm-6 pad-10"}) #<ul class="mov_list">
	for link in links:
		imag = parseDOM(link, 'img', ret='src')[0]
		href= parseDOM(link, 'a', ret='href')[0]
		if 'ostrzezenie/' in href:
			nast=re.findall('ostrzezenie(\/\d+)',href)[0]
			href='https://www.kreskowki.tv/kategoria'+nast
		else:
			href=re.findall("(.+\d+\/)",href)[0]
		title= parseDOM(link, 'a')[1]
		out.append({'title':PLchar(title),'href':href,'img':imag,'plot':plot})
	return out	
	
def getPage(url,page=1):
	url = url + 'page/%d.html' %page
	html=getUrlReq(url)
	out=[]
	prevpage=False #gr=False
	nextpage=False  # pr=False	
	np=str(page+1)
	if html.find('/page/'+np+'.html">'+np+'<')>0:
		nextpage = page+1
	result=parseDOM(html,'div', attrs={'class': "list-of-movies col-md-8"})[0] 
	links = parseDOM(result, 'div', attrs={'class': "col-sm-12"})

	for link in links:	
		try:
			plot= parseDOM(link, 'p')[0] 
			plot=PLchar(plot)
		except:
			plot=''
		if'text/javascript' not in link:
			try:
				imag = parseDOM(link, 'img', ret='src')[0]
			except:
				imag=''
			href = parseDOM(link, 'a', ret='href')#[0]   
			title=parseDOM(link,'a')#[1]
			if href and title:
				out.append({'title':PLchar(title[1]),'href':href[0],'img':imag,'plot':plot})
			else:
				continue
		else:
			continue
	prevpage = page-1 if page>1 else False
	return (out,(prevpage,nextpage))	
	
def getLinks(ex_link):
	items = getVideosOk(exlink)

	link=''
	if len(items)>0:
		select = xbmcgui.Dialog().select('Wyb\xc3\xb3r', [ x.get('host') for x in items])
		if select>-1:
			link = items[select].get('href')
			if 'myvi.tv' in link:
				link=link.replace("myvi.tv/embed/html/","myvi.ru/player/embed/html/")
		else:
			return
	#		quit()
		if link:
			try:
				if 'youtube' in link:
					stream_url=link
				else:
					stream_url = urlresolver.resolve(link)
			except Exception,e:
				stream_url=''
				s = xbmcgui.Dialog().ok('[COLOR red]Problem[/COLOR]','Może inny link bedzie działał?','ERROR: %s'%str(e))
			if stream_url:
				xbmcplugin.setResolvedUrl(addon_handle, True, xbmcgui.ListItem(path=stream_url))
			else:
				xbmcplugin.setResolvedUrl(addon_handle, False, xbmcgui.ListItem(path=''))
		else:
				xbmcgui.Dialog().notification('Ups...', 'Wystąpił błąd.', blad, 6000)
	else:
		s = xbmcgui.Dialog().ok('[COLOR red]Problem[/COLOR]','Brak linków','')	


def getVideosOk(url):
	html=getUrlReq(url)	
	out=[]

	result=parseDOM(html,'div', attrs={'class': "mopen"})[0]
	links=parseDOM(result,'div', attrs={'class': "sembed.+?"})
	for link in links:
		if 'cda.pl' in link: # or 
			href= parseDOM(link, 'iframe', ret='src')[0]
			host='cda.pl'

		elif 'youtube' in link:
			href= parseDOM(link, 'iframe', ret='src')[0]
			host = urlparse.urlsplit(href).netloc
			href=href.split('?rel=')[0]			
			vid=urlparse.urlparse(href).path.split('/')[-1]
			href = 'plugin://plugin.video.youtube/play/?video_id=' + vid
		else:
			href= parseDOM(link, 'a', ret='href')[0]
			host = urlparse.urlsplit(href).netloc
		if href.startswith('//'):
			href = 'https:'+href		
		film = {'href' : href,'host' : host.strip(),}
		out.append(film)	
	return out

def PLchar(char):
	if type(char) is not str:
		char=char.encode('utf-8')
	char = char.replace('\\u0105','\xc4\x85').replace('\\u0104','\xc4\x84')
	char = char.replace('\\u0107','\xc4\x87').replace('\\u0106','\xc4\x86') #E9
	char = char.replace('\\u00e9','\xc3\xa9').replace('\\u00C9','\xc3\x89') #E9	
	char = char.replace('\\u0119','\xc4\x99').replace('\\u0118','\xc4\x98')
	char = char.replace('\\u0142','\xc5\x82').replace('\\u0141','\xc5\x81')
	char = char.replace('\\u0144','\xc5\x84').replace('\\u0144','\xc5\x83')
	char = char.replace('\\u00f3','\xc3\xb3').replace('\\u00d3','\xc3\x93')
	char = char.replace('\\u015b','\xc5\x9b').replace('\\u015a','\xc5\x9a')
	char = char.replace('\\u017a','\xc5\xba').replace('\\u0179','\xc5\xb9')
	char = char.replace('\\u017c','\xc5\xbc').replace('\\u017b','\xc5\xbb')
	char = char.replace('&#8217;',"'")
	char = char.replace('&#8211;',"-")	
	char = char.replace('&#8230;',"...")	
	char = char.replace('&#8222;','"').replace('&#8221;','"')	
	char = char.replace('[&hellip;]',"...")
	char = char.replace('&#038;',"&")	
	char = char.replace('&nbsp;',".").replace('&amp;','&')
	return char	

if __name__ == '__main__':
	mode = params.get('mode', None)
	if not mode:
		home()
		xbmcplugin.endOfDirectory(addon_handle)				
	elif mode == 'listpopular':
		ListPopular(exlink)
		xbmcplugin.endOfDirectory(addon_handle)				
	elif mode == 'listalfabet':
		ListAlfabet(exlink)
		xbmcplugin.endOfDirectory(addon_handle)		
	elif mode == 'listalfabet2':
		ListAlfabet2(exlink)
		xbmcplugin.endOfDirectory(addon_handle)		
	elif mode == 'listMaterial':
		ListMaterial(exlink)	
		xbmcplugin.endOfDirectory(addon_handle)				
	elif mode == 'listPage':
		ListPage(exlink,page)	
		xbmcplugin.endOfDirectory(addon_handle)		
	elif mode == 'getLinks':
		getLinks(exlink)					
	elif mode == '__page__M':
		url = build_url({'mode': 'listPage', 'foldername': '', 'url' : exlink, 'page' : page})
		xbmc.executebuiltin('XBMC.Container.Refresh(%s)'% url)
		xbmcplugin.endOfDirectory(addon_handle)
	elif mode=='search':
		query = xbmcgui.Dialog().input(u'Szukaj, Czego szukasz', type=xbmcgui.INPUT_ALPHANUM)
		if query:  	
			q=query.replace(' ','+')
			elink='https://www.kreskowki.tv/kreskowka/szukaj/'+q+'/'#+q
			ListPage(elink,page)		
			xbmcplugin.endOfDirectory(addon_handle)
	else:
		xbmcplugin.setResolvedUrl(addon_handle, False, xbmcgui.ListItem(path=''))