# -*- coding: UTF-8 -*-
import ast
import sys, re

import requests, time
import routing
import xbmc
from .helper import Helper

from base64 import urlsafe_b64encode, urlsafe_b64decode, b64encode
base_url = sys.argv[0]
handle = int(sys.argv[1])
helper = Helper(base_url, handle)
plugin = routing.Plugin()

try:
    #python 3
    from urllib.parse import quote_plus, unquote_plus, quote, unquote,parse_qsl, urlencode
    to_unicode = str
except:
    #python 2
    from urllib import quote_plus, unquote_plus, quote, unquote, urlencode
    from urlparse import parse_qsl
    to_unicode = unicode

from datetime import datetime, timedelta
import json    
    
@plugin.route('/')
def root():
    createDatas()
    
    dod, logged = loguj()

    if not logged:

        helper.add_item('[COLOR lightgreen][B]Zaloguj[/COLOR][/B]', plugin.url_for(loguj),folder=False)
    else:
        helper.add_item('Zalogowany jako: '+dod, plugin.url_for(empty), info={'plot':dod},folder=False)
        helper.add_item('Strona głowna', plugin.url_for(mainpage),folder=True)

    helper.eod()
    
@plugin.route('/nagrania/<pg>')
def nagrania(pg):

    cat = 'recordings/feeds?page_size=30&offset='+str(pg)+'&natco_key='+helper.natco_key+'F&device_type=WEB&type=subscriber&app_language=pl&natco_code=pl'
    url = helper.api_url.format(cat)
    
    
    jsdata = helper.request_sess(url, 'get', headers=helper.headers, json=True, result=True)
    if jsdata.get('assets', None):
        for asset in jsdata.get('assets', None):
            title = asset.get('title', None) 
            id_ = asset.get('id', None)
            description = asset.get('description', None)
            description = description if description else title
            thumbnail = asset.get('thumbnail', None)
            type = asset.get('type', None)
            content_type = asset.get('content_type', None).lower()
            if type =='Movie' or content_type=='program':
                
                url = quote_plus('details/'+content_type.lower()+'/'+id_+'/actions/v2?natco_key='+helper.natco_key+'&interacted_with_nPVR=false&app_language=pl&natco_code=pl')
                fold = True
                ispla = False
                mod = plugin.url_for(listplay, url)
                info = {'title': title, 'plot':description}
                art = {'icon': thumbnail, 'fanart': helper.addon.getAddonInfo('fanart')}
                helper.add_item(title, mod, playable=ispla, info=info, art=art) 
    if jsdata.get('assets', None):
        helper.eod()

def createDatas():
    url = 'https://www.magentatv.pl/'
    headers = {
        'User-Agent': helper.UA,
        'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,*/*;q=0.8',
        'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',

    }

    jsdata = helper.request_sess(url, 'get', headers=headers,result=True)
    jsdata = jsdata.replace('null','False')
    init_state = re.findall('INITIAL_STATE\s*=\s*({.*?\})\\n',jsdata,re.DOTALL)[0]
    app_const = re.findall('APP_CONSTANTS\s*=\s*({.*?\})\\n',jsdata,re.DOTALL)[0]


    rsapassword = re.findall('password.*?"rsaPublicKey"\:"(.*?)"',init_state,re.DOTALL)[0]
    
    helper.set_setting('rsapassword', rsapassword.replace('\\u002F','/'))
    app_const = json.loads(app_const)
    app_key = app_const.get('CMS_CONFIGURATION_API_KEY', None)
    
    if not helper.dev_id:
        dev_id = app_const.get('DEVICE_ID', None)
        helper.set_setting('dev_id', dev_id)
    app_ver = app_const.get('APP_VERSION', None)
    natco_key = app_const.get("NATCO_KEY", None)
    
    helper.set_setting('natco_key', natco_key)
    helper.set_setting('app_key', app_key)
    helper.set_setting('app_ver', app_ver)
    helper.set_setting('auth_user','false')
    if not helper.request_id:
        import uuid
        request_id = str(uuid.uuid4())
        helper.set_setting('request_id', request_id)
    return

@plugin.route('/mainpage/')
def mainpage():

    cat_url = 'home/root/categories?natco_key='+helper.natco_key+'&device_type=WEB&app_language=pl&natco_code=pl'
    url = helper.api_url.format(cat_url)
    
    
    jsdata = helper.request_sess(url, 'get', headers=helper.headers, json=True, result=True)

    for cat in jsdata.get('categories', None):
        title = cat.get('title', None)
        id_ = quote_plus(cat.get('cta', None).get('deeplink', None).split('//')[-1].replace('?','/').replace('=','/'))

        mod = plugin.url_for(listkateg, id_, '0')
        fold = True
        ispla = False

        info = {'title': title, 'plot':title}
        art = {'icon': helper.addon.getAddonInfo('icon'), 'fanart': helper.addon.getAddonInfo('fanart')}
        helper.add_item(title, mod, playable=ispla, info=info, art=art)  
    if jsdata.get('categories', None):
        helper.eod()

@plugin.route('/listkateg/<idx>/<pg>')
def listkateg(idx,pg):
    
    id = unquote_plus(idx)
    if 'store_id' in id:
        cat_url = id+'&page_size=25&offset='+str(pg)+'&natco_key='+helper.natco_key+'&device_type=WEB&app_language=pl&natco_code=pl'
    else:
        cat_url = id+'?page_size=25&offset='+str(pg)+'&natco_key='+helper.natco_key+'&device_type=WEB&app_language=pl&natco_code=pl'
    

    url = helper.api_url.format(cat_url)
    
    
    jsdata = helper.request_sess(url, 'get', headers=helper.headers, json=True, result=True)

    if jsdata.get('components', None):
        for component in jsdata.get('components', None):
            title = component.get('title', None) 
            if title.lower() == 'highlights' or title.lower() == 'highlight':
                continue
            id_ = component.get('id', None)
            if 'content_details' in component:
                content_details = component.get('content_details', None)
                end_point = content_details.get('end_point', None)
                type = content_details.get('type', None)
                store_id = component.get('store_id', None)
                
                id_ = quote_plus(end_point+'?type='+type+'&store_id='+quote(store_id)) if store_id else quote_plus(end_point+'?type='+type)
            
            mod = plugin.url_for(listkateg, id_, '0')
            fold = True
            ispla = False
    
            info = {'title': title, 'plot':title}
            art = {'icon': helper.addon.getAddonInfo('icon'), 'fanart': helper.addon.getAddonInfo('fanart')}
            helper.add_item(title, mod, playable=ispla, info=info, art=art)  
    elif jsdata.get('assets', None):    
        for asset in jsdata.get('assets', None):
            title = asset.get('title', None) 
            id_ = asset.get('id', None)
            description = asset.get('description', None)
            thumbnail = asset.get('thumbnail', None)
            type = asset.get('type', None)
            content_type = asset.get('content_type', None).lower() if asset.get('content_type', None) else asset.get('content_type', None)
            cta = asset.get('cta', None).get('deeplink', None).lower()
            if type =='Movie' or content_type=='program' or 'player/live' in cta:
                
                #xbmc.log('assetassetassetassetassetassetassetasset: %s'%(str(asset)), level=xbmc.LOGINFO)
                if content_type:
                    url = quote_plus('details/'+content_type.lower()+'/'+id_+'/actions/v2?natco_key='+helper.natco_key+'&interacted_with_nPVR=false&app_language=pl&natco_code=pl')
                else:
                    cta = asset.get('cta', None).get('deeplink', None).lower()
                    if 'player/live' in cta:
                        thumbnail = asset.get('channel_logo', None)
                        channel_number = asset.get('channel_number', None)
                        program_id = asset.get('program_id', None)
                        station_id = asset.get('station_id', None)
                        url = quote_plus('/player/playinfo/channel?natco_key='+helper.natco_key+'&device_type=WEB&channel_number='+str(channel_number)+'&program_id='+str(program_id)+'&station_id='+str(station_id)+'&app_language=pl&natco_code=pl')

                fold = True
                ispla = False
                mod = plugin.url_for(listplay, url)
            elif content_type=='series' :
                if content_type:
                    url = quote_plus('details/'+content_type.lower()+'/'+id_+'?natco_key='+helper.natco_key+'&interacted_with_nPVR=false&app_language=pl&natco_code=pl')
                
                
                else:
                    cta = asset.get('cta', None).get('deeplink', None).lower()
                    if 'player/live' in cta:
                        channel_number = asset.get('channel_number', None)
                        thumbnail = asset.get('channel_logo', None)
                        program_id = asset.get('program_id', None)
                        station_id = asset.get('station_id', None)
                        url = quote_plus('/player/playinfo/channel?natco_key='+helper.natco_key+'&device_type=WEB&channel_number='+str(channel_number)+'&program_id='+str(program_id)+'&station_id='+str(station_id)+'&app_language=pl&natco_code=pl')

            
            
            
                fold = True
                ispla = False
                mod = plugin.url_for(listseries, url)
            info = {'title': title, 'plot':description}
            art = {'icon': thumbnail, 'fanart': helper.addon.getAddonInfo('fanart')}
            helper.add_item(title, mod, playable=ispla, info=info, art=art) 
        
    next_offset = jsdata.get('next_offset', None)
    if next_offset and next_offset !=-1:
        mod = plugin.url_for(listkateg, idx, str(next_offset))
        fold = True
        ispla = False

        info = {'title': 'Następna strona', 'plot':'Następna strona'}
        art = {'icon': helper.addon.getAddonInfo('icon'), 'fanart': helper.addon.getAddonInfo('fanart')}
        helper.add_item('Następna strona', mod, playable=ispla, info=info, art=art)  
    if jsdata.get('components', None) or jsdata.get('assets', None):
        helper.eod()
    

@plugin.route('/listseries/<idx>')
def listseries(idx):
    id = unquote_plus(idx)

    url = helper.api_url.format(id)
    
    zz=''
    jsdata = helper.request_sess(url, 'get', headers=helper.headers, json=True, result=True)
    seasons = jsdata.get('seasons', None)
    tit = jsdata.get('name', None)
    poster_image_url = jsdata.get('poster_image_url', None)
    descr = ''
    idx1 = jsdata.get('id', None)
    details = jsdata.get('details', None)
    if details:
        descr = details.get('description', None)
    
    for seas in seasons:
        display_name = seas.get('display_name', None)
        number = str(seas.get('number', None))
        title = tit+' - '+display_name
        idx = seas.get('id', None) 
        descr = descr if descr else title
        url = quote_plus('details/series/'+idx1+'/season/'+idx+'/v2?natco_key='+helper.natco_key+'&interacted_with_nPVR=true&season_number='+number+'&app_language=pl&natco_code=pl')
        mod = plugin.url_for(listseasepis, url)
        fold = True
        ispla = False

        info = {'title': title, 'plot':descr}
        art = {'icon': poster_image_url, 'fanart': helper.addon.getAddonInfo('fanart')}
        helper.add_item(title, mod, playable=ispla, info=info, art=art)  
    helper.eod()
    
@plugin.route('/listseasepis/<idx>')
def listseasepis(idx):
    program = xbmc.getInfoLabel("ListItem.Title")
    id_ = unquote_plus(idx)

    url = helper.api_url.format(id_)
    jsdata = helper.request_sess(url, 'get', headers=helper.headers, json=True, result=True)
    episodes= jsdata.get('episodes', None) 
    for epis in episodes:
        idepis = epis.get('id', None)
        title = epis.get('name', None)
        poster_image_url = epis.get('poster_image_url', None)
        release_year = epis.get('poster_image_url', None)
        runtime_seconds = epis.get('runtime_seconds', None)
        details = epis.get('details', None)
        descr =''
        if details:
            descr = details.get('description', None)
        descr = descr if descr else title
        
        url = quote_plus('details/program/'+idepis+'/actions/v2?natco_key='+helper.natco_key+'&interacted_with_nPVR=false&app_language=pl&natco_code=pl')

        
        mod = plugin.url_for(listplay, url)
        fold = True
        ispla = False

        info = {'title': title, 'plot':descr}
        art = {'icon': poster_image_url, 'fanart': helper.addon.getAddonInfo('fanart')}
        helper.add_item(title, mod, playable=ispla, info=info, art=art)  
    helper.eod()
def createDrmToken(aid):

    def base64UrlEncode(data):
        return urlsafe_b64encode(data).rstrip(b'=')
    
    
    def base64UrlDecode(base64Url):
        padding = b'=' * (4 - (len(base64Url) % 4))
    
        return urlsafe_b64decode(base64Url + padding)
    
    tokenSplit = helper.accessToken.split(".")[1].encode(encoding='utf-8', errors='strict')
    x1 = base64UrlDecode(tokenSplit)
    ac = json.loads(x1)
    dc_cts_personaToken = (ac.get('dc_cts_personaToken',None))
    cdurl = 'http://access.auth.theplatform.com/data/Account/'+str(aid)+':'+dc_cts_personaToken
    cdu = cdurl.encode(encoding='utf-8', errors='strict')
    xx = b64encode(cdu)
    return xx.decode(encoding='utf-8', errors='strict')
    
@plugin.route('/listplay/<idx>')
def listplay(idx):
    zzz=''
    program = xbmc.getInfoLabel("ListItem.Title")

    

    img = xbmc.getInfoLabel("ListItem.Icon")    


    id = unquote_plus(idx)
    url = helper.api_url.format(id)

    jsdata = helper.request_sess(url, 'get', headers=helper.headers, json=True, result=True)
    axc=''
    
    try:
        schedules = jsdata.get('actions', None).get('catchup_schedules', None)
    except:
        schedules = []

    if not schedules:
        try:
            schedules = jsdata.get('actions', None).get('schedules', None)
        except:
            schedules = []
    eod = False
    wkrotce= False
    msg =''
    #xbmc.log('schedulesschedulesschedulesschedules: %s'%(str(schedules)), level=xbmc.LOGINFO)
    if schedules:
        for sched in schedules:
            
            start_utc, kiedy, start_utc2 = helper.getCorrectTime(sched.get('start_utc', None))
            end_utc, kiedy2, end_utc2 = helper.getCorrectTime(sched.get('end_utc', None))
            ac=helper.parse_datetime(start_utc, localize= True)

            start_=helper.to_timestamp(ac)
            ter = int(time.time())*1000
            if start_ > ter:
                eod = False
                wkrotce= True
                msg =kiedy
                break
            
            hghghg=''
            station_id = sched.get('station_id', None)
            program_id = sched.get('program_id', None)
            
            cdn = 'player/playinfo/catchup?program_id='+program_id+'&natco_key='+helper.natco_key+'&device_type=WEB&station_id='+station_id+'&start_time='+start_utc+'&end_time='+end_utc+'&app_language=pl&natco_code=pl'
            url = helper.api_url.format(cdn)
            zzzzzzz=''
            
            jsdata2 = helper.request_sess(url, 'get', headers=helper.headers, json=True, result=True)
            zxzxz=''
            catalogInfoResponse = jsdata2.get('catalogInfoResponse', None)
            descr = catalogInfoResponse.get('description', None)
            channel_logo = catalogInfoResponse.get('channel_logo', None)
            
            playBackInfoResponse = jsdata2.get('playBackInfoResponse', None)
            call_letters = playBackInfoResponse.get('call_letters', None)
            type = playBackInfoResponse.get('type', None).lower()
            
            media_id = playBackInfoResponse.get('service_items', None)[0].get('media_id', None)
            cdn = 'media?client_id='+helper.dev_id+'&media_id='+media_id+'&natco_key='+helper.natco_key+'&src_format=MPEG-DASH&content_type='+type+'&app_language=pl&natco_code=pl'
            
        
            url = helper.api_url.format(cdn)
            zzzzzzz=''
            
            jsdata3 = helper.request_sess(url, 'get', headers=helper.headers, json=True, result=True)
            lock_id = None
            lock_sequence_token = None
            lock = None
            lockx = jsdata3.get('lock', None)
            unl ='none'
            if lockx:
                lock_id = lockx.get('lock_id', None)
                
                if lock_id:
                
                    lock_id = quote_plus(lockx.get('lock_id', None))
                    lock_sequence_token = quote_plus(lockx.get('lock_sequence_token', None))
                
                    lock = quote_plus(lockx.get('lock', None))
                    unl = quote_plus('https://concurrency.delivery.theplatform.eu/concurrency/web/Concurrency/unlock?_clientId='+helper.dev_id+'&form=json&schema=1.0&natco_key='+helper.natco_key+'&_encryptedLock='+lock+'&_id='+lock_id+'&_sequenceToken='+lock_sequence_token)
            
            video = jsdata3.get('video', None)
            if not video:
                continue
            video_src = video.get('video_src', None)
            pid = video.get('pid', None)
            aid = video.get('aid', None)
            drmtoken = createDrmToken(aid)

            src = quote_plus(str({'stream_url':video_src,'pid':pid,'unlock':unl,'aid':drmtoken,'cdurl':'http://access.auth.theplatform.com/data/Account/'+str(aid)}))
            mod = plugin.url_for(playvid, src)
            fold = False
            ispla = True
            title = call_letters + ' '+program+ ' '+kiedy
            info = {'title': title, 'plot':descr}
            channel_logo = channel_logo if channel_logo else img
            art = {'icon': channel_logo, 'fanart': helper.addon.getAddonInfo('fanart')}
            helper.add_item(title, mod, playable=ispla, info=info, art=art) 
            
            eod=True
    else:

        jsdata4=jsdata
      #  xbmc.log('jsdata4jsdata4jsdata4jsdata4jsdata4: %s'%(str(jsdata4)), level=xbmc.LOGINFO)
        catalogInfoResponse = jsdata4.get('catalogInfoResponse', None)
        if not catalogInfoResponse:
            watch = jsdata4.get('actions', None).get('watch', None)
            if watch:
                watch = watch[0]
                id1 = jsdata4.get('id', None)
                id2 = watch.get('video', None).get('id', None)
                url ='https://tv-pl-prod.yo-digital.com/pl-bifrost/player/playinfo/program?program_id='+id1+'&video_id='+id2+'&natco_key='+helper.natco_key+'&device_type=WEB&app_language=pl&natco_code=pl'
                jsdata4 = helper.request_sess(url, 'get', headers=helper.headers, json=True, result=True)
                catalogInfoResponse = jsdata4.get('catalogInfoResponse', None)

        if catalogInfoResponse:
            descr = catalogInfoResponse.get('description', None)
            channel_logo = catalogInfoResponse.get('channel_logo', None)
            
            playBackInfoResponse = jsdata4.get('playBackInfoResponse', None)
            call_letters = playBackInfoResponse.get('call_letters', None)
            call_letters = call_letters if call_letters else ''
            type = playBackInfoResponse.get('type', None)
            
            media_id = playBackInfoResponse.get('service_items', None)[0].get('media_id', None)
            cdn = '/media?client_id='+helper.dev_id+'&media_id='+media_id+'&natco_key='+helper.natco_key+'&src_format=MPEG-DASH&content_type='+type+'&app_language=pl&natco_code=pl'
            url = helper.api_url.format(cdn)
            zzzzzzz=''
            
            jsdata3 = helper.request_sess(url, 'get', headers=helper.headers, json=True, result=True)
            lockx = jsdata3.get('lock', None)
            
            unl = 'none'
            if lockx:
                lock_id = lockx.get('lock_id', None)
                if lock_id:
                    lock_id = quote_plus(lockx.get('lock_id', None))
                    lock_sequence_token = quote_plus(lockx.get('lock_sequence_token', None))
                    
                    lock = quote_plus(lockx.get('lock', None))
                    unl = quote_plus('https://concurrency.delivery.theplatform.eu/concurrency/web/Concurrency/unlock?_clientId='+helper.dev_id+'&form=json&schema=1.0&natco_key='+helper.natco_key+'&_encryptedLock='+lock+'&_id='+lock_id+'&_sequenceToken='+lock_sequence_token)

            video = jsdata3.get('video', None)
          #  xbmc.log('jsdata3jsdata3jsdata3jsdata3jsdata3: %s'%(str(jsdata3)), level=xbmc.LOGINFO)
            if video:
                video_src = video.get('video_src', None)
                pid = video.get('pid', None)
                aid = video.get('aid', None)
                drmtoken = createDrmToken(aid)
                
                src = quote_plus(str({'stream_url':video_src,'pid':pid,'unlock':unl,'aid':drmtoken,'cdurl':'http://access.auth.theplatform.com/data/Account/'+str(aid)}))
                mod = plugin.url_for(playvid, src)
                fold = False
                ispla = True
                title = '[B]'+program + '  [COLOR khaki]('+call_letters+')[/COLOR][/B]'
                channel_logo = channel_logo if channel_logo else img
                info = {'title': title, 'plot':descr}
                art = {'icon': channel_logo, 'fanart': helper.addon.getAddonInfo('fanart')}
                helper.add_item(title, mod, playable=ispla, info=info, art=art) 
                
                eod=True
            else:
                if 'debugMessage' in jsdata3:
                    displayMessage = jsdata3.get('displayMessage', None)
                    displayMessage = displayMessage if displayMessage else ''
                    debugMessage = jsdata3.get('debugMessage', None)
                    debugMessage = debugMessage if debugMessage else ''
                    helper.notification('[B]'+displayMessage+'[/B]', '[B][COLOR red]'+debugMessage+'[/COLOR][/B]') 
                    return
    if wkrotce:
        helper.notification('[B]Program będzie\n dostępny[/B]', '\n\n    [B][COLOR yellowgreen]'+msg+'[/COLOR][/B]') 
        return
    if eod:
        helper.eod()
    return   
	
@plugin.route('/unlockVideo/<id>')    
def unlockVideo(id):
	unl = helper.get_setting('unl_vid')
	if unl != '':
		ghu = helper.request_sess(unl, 'get', headers=helper.headers, result=True)
		#xbmc.log('lic_urllic_urllic_urllic_urllic_url: %s'%(str(unl)), level=xbmc.LOGINFO)
	return
    
@plugin.route('/playvid/<id>')    
def playvid(id):
    
    
    src = ast.literal_eval(unquote_plus(id))
    stream_url = src.get('stream_url', None)
    pid = src.get('pid', None)
    cdurl = src.get('cdurl', None)
    unl = unquote_plus(src.get('unlock', None))
    helper.set_setting('unl_vid', unl)
    #if unl !='none':
    #    ghu = helper.request_sess(unl, 'get', headers=helper.headers, result=True)
    
    aid = src.get('aid', None)

    mpdurl = helper.request_sess(stream_url, 'get', headers=helper.headers, result=False).url
    
    headers44 = {
        'Host': 'widevine.entitlement.theplatform.eu',
        'User-Agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:107.0) Gecko/20100101 Firefox/107.0',
        'Accept': '*/*',
        'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',
        'authorization': 'Basic '+aid,
        'content-type': 'application/json',
        'Origin': 'https://www.magentatv.pl',
        'Sec-Fetch-Dest': 'empty',
        'Sec-Fetch-Mode': 'cors',
        'Sec-Fetch-Site': 'cross-site',}

    license_url = 'https://widevine.entitlement.theplatform.eu/wv/web/ModularDrm/getRawWidevineLicense?schema=1.0&form=json&releasePid='+pid

    DRM = 'com.widevine.alpha'
    #xbmc.log('lic_urllic_urllic_urllic_urllic_url', level=xbmc.LOGINFO)
    lic_url = license_url+'|'+urlencode(headers44)+'|R{SSM}|'
    subs =[]
    PROTOCOL='mpd'
    helper.PlayVid(mpdurl, lic_url, PROTOCOL, DRM, flags=False, subs = subs)

@plugin.route('/empty/')
def empty():
    return

@plugin.route('/loguj')    
def loguj():

    ok = False
    
    if helper.login and helper.password:
        
        hashedpassword = helper.HashPassword()

        data = {
            'appVersion': helper.app_ver,
            'channel': {
                'id': 'Tv',
            },
            'natco': 'pl',
            'type': 'telekom',
            'forceRegister': False,
            'context': 'login',
            'device': {
                'id': helper.dev_id,
                'model': 'WEB',
                'os': 'Windows',
                'deviceName': 'WEB',
                'manageDevice': False,
                'deviceType': 'WEB',
                'deviceOS': 'Windows',
                'deviceModel': 'web|web|Firefox-107|'+helper.app_ver+'|1',
                'deviceManufacturer': 'Windows 99',
                'concurrencyLimitParam': 'TVSOA-restriction-unmanagedDeviceStreamLimit',
                'broadcastingStreamLimitationApplies': False,
            },
            'telekomLogin': {
                'username': helper.login,
                'password':  hashedpassword,
            },
        }

        jsdata = helper.request_sess(helper.subscrlogin, 'post', headers=helper.headers, data = data, json=True, json_data = True)

        if 'accessToken' in jsdata:

            helper.set_setting('accessToken',jsdata.get('accessToken',None))
            
            helper.set_setting('refreshToken',jsdata.get('refreshToken',None))
            helper.set_setting('auth_user','true')
            return helper.login, True

        else:
            helper.notification('[B]Uwaga[/B]', '[B]Błąd logowania[/B]') 
    
            return None,False
    else:
        helper.notification('[B]Uwaga[/B]', '[B]Brak danych logowania[/B]') 
        ustawienia()
     #   return None,False

@plugin.route('/ustawienia')
def ustawienia():
    helper.open_settings()
    helper.refresh()


@plugin.route('/logout')
def logout():
    log_out = helper.dialog_choice('Uwaga','Chcesz się wylogować?',agree='TAK', disagree='NIE')
    if log_out:
        helper.save_file(file=helper.datapath+'kukis', data={}, isJSON=True)    
        helper.set_setting('logged', 'false')
        helper.refresh()


class MagentaTV(Helper):
    def __init__(self):
        super().__init__()
        plugin.run()


