# coding: UTF-8
from __future__ import division

import xbmc, xbmcgui

import sys, re

import json
import requests, urllib3

import calendar
import iso8601
from datetime import datetime, timedelta

import time

if sys.version_info >= (3,0,0):
# for Python 3
    to_unicode = str

    from urllib.parse import unquote, quote

else:
    # for Python 2
    to_unicode = unicode

    from urllib import unquote, quote

    
urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)

sess = requests.Session()


        
class Orange:
    def __init__(self, plugin, fanartx, ikona ):
    
    
    
    
        self.plugin = plugin
        self.fanart  = fanartx
        self.ikona  = ikona
        self.datapath = self.plugin.translate_path(self.plugin.get_path('profile'))
        try:
            self.kukis = self.plugin.load_file(self.datapath+'kukis', isJSON=True)
        except:
            self.kukis = {}
        
        
        self.currentProfileId = self.plugin.get_setting('currentProfileId') 
        self.householdExtId = self.plugin.get_setting('householdExtId') 

        self.UA ='Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:93.0) Gecko/20100101 Firefox/93.0'
        self.host = 'tvgo.orange.pl'
        self.OtvDeviceInfo = '[web_otf]/[3.3.1/5361]/{}'.format(self.UA)
        self.main_url =  'https://tvgo.orange.pl' 
        self.api_url = self.main_url+'/gpapi/{}'
        

        self.chan_url = 'https://tvgo.orange.pl/gpapi/live/channel/{}?deviceCat=otg'
        
        
        self.chan_session_url = 'https://tvgo.orange.pl/gpapi/live/channel/{}/session'
        
        
        
        self.headers = {
            'Host': self.host,
            'User-Agent': self.UA,
            'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',
            'Content-Type': 'application/vnd.orangeott.v1+json',
            'OtvDeviceInfo': self.OtvDeviceInfo,
            'X-Country-Code': 'pl',
            'Origin': 'https://tvgo.orange.pl'}    

        
        self.subscrlogin = self.api_url.format('user/login')

        self.login = self.plugin.get_setting('login')
        self.password = self.plugin.get_setting('password')
        try:
            self.epg, self.tstamp = self.getEpgs()
        except:
            self.epg = ''
            self.tstamp =''
        
        
        
        
    def home(self):

        dod, logged = self.logowanie()
    
        if not logged:
            self.plugin.add_item('film', 'Zaloguj', 'DefaultUser.png', "loguj", folder=False,fanart=self.fanart)
        else:
        
            self.plugin.add_item('film', 'Zalogowany jako: '+dod, 'DefaultUser.png', "  ", folder=True, infoLabels={'plot':dod}, fanart=self.fanart)
            self.plugin.add_item('film', 'Telewizja', 'DefaultMovies.png', "listtv", folder=True,fanart=self.fanart)
            self.plugin.add_item('VOD_WEB', 'VOD', 'DefaultMovies.png', "listvodcat", folder=True,fanart=self.fanart)

        self.plugin.EOD()

        
        
    def request_sess(self, url, method='get', headers = {}    , data = {}    , cookies = {},result=True):
        if method == 'get':
            data = sess.get(url, headers=headers, cookies = cookies, verify=False)
        elif method == 'post':
            data = sess.post(url, headers=headers, json = data, cookies = cookies, verify=False)
        elif method == 'delete':
            data = sess.delete(url, headers=headers, cookies = cookies, verify=False)
        if result:
            return data.json()
        else:
            return data
        
        
    def logowanie(self):
        ok = False
    
        if self.login and self.password:

            data = {"username":self.login,"password":self.password}
            self.headers.update({'Accept': 'application/vnd.orangeott.v5+json','Content-Type': 'application/vnd.orangeott.v1+json' })

            jsdata = self.request_sess(self.subscrlogin, 'post', headers=self.headers, data=data, cookies = self.kukis)

            
            if not "errCode" in jsdata:
                gg=(sess.cookies).get_dict()
                self.plugin.set_setting('currentProfileId',jsdata.get('userInfo',None).get('currentProfileId',None))
                self.plugin.set_setting('householdExtId',jsdata.get('householdInfo',None).get('householdExtId',None))

                self.plugin.save_file(file=self.datapath+'kukis', data=(sess.cookies).get_dict(), isJSON=True)
                return self.login, True

            else:
                self.plugin.notification_dialog('[B]Uwaga[/B]', '[B]Błąd logowania[/B]',xbmcgui.NOTIFICATION_INFO, 8000,False) 

                return None,False
        else:
            self.plugin.notification_dialog('[B]Uwaga[/B]', '[B]Brak danych logowania[/B]',xbmcgui.NOTIFICATION_INFO, 8000,False) 
        
            return None,False
    def getEpgs(self):
        dzis=self.timeNow(sek=True)
        dzis2=self.timeNow(sek=False)
        timestampdzis = calendar.timegm(dzis.timetuple())
        timestampdzis2 = calendar.timegm(dzis2.timetuple())
        try:
            del self.headers['Content-Type']
        except:
            pass
        self.headers.update({'Accept': 'application/vnd.orangeott.v3+json'})
        url = self.api_url.format('epg/epg?hhTech=&deviceCat=otg&chosen-day='+str(timestampdzis2))
        jsdata = self.request_sess(url, 'get', headers=self.headers, cookies = self.kukis,result=False)

        return jsdata, timestampdzis

    def getPlot(self, id):
        plot=''
        for epg in ((self.epg).json()).get("epg", None):
            if id in epg.get("channelExternalId", None):

                pokolei = sorted((epg.get('schedule', None)), key=lambda items: items['startDate'])
                for sch in epg.get('schedule', None):
                    endDate = sch.get('endDate', None)
                    if int(self.tstamp)<endDate:
                        
                        endDate = datetime.fromtimestamp(endDate).strftime('%H:%M')
                        startDate = datetime.fromtimestamp(sch.get('startDate', None)).strftime('%H:%M') 
                        pr =  sch.get('name', None)
                        plot+= '[COLOR khaki]%s - %s[/COLOR] : %s [CR]'%(startDate, endDate, pr)
        return plot        
        
        
    def listTV(self):

        try:
            del self.headers['Content-Type']
        except:
            pass

        self.headers.update({'Accept': 'application/vnd.orangeott.v4+json'})
        jsdata = self.request_sess(self.api_url.format('live/channel-list?hhTech=iptv&deviceCat=otg'), 'get', headers=self.headers, cookies = self.kukis)
        
        
        channelList = jsdata.get("channelList",None)
        for ch in channelList:
            id = ch.get("channelExtId",None)
            title = ch.get("name",None)
            img = ch.get("logoSignature",None)
            img = self.api_url.format('resource/image/')+img

            plot = self.getPlot(id)
            
            
            isSubscribed = ch.get("isSubscribed",None)
            if not isSubscribed:
                continue
            keczup = ch.get("playFeatures",None).get("otg",None).get("isCatchUp",None)
            dod = ' [COLOR gold](+)[/COLOR]' if keczup else ''
            tytul = title+dod
            mod = 'playtv'
            fold = False
            ispla = True
            if keczup:
                mod = 'listkeczup'
                fold = True
                ispla = False

            self.plugin.add_item(name=self.plugin.PLchar(tytul), url=id, mode=mod, image=img, folder=fold, IsPlayable=ispla, fanart = self.fanart, infoLabels={'plot':self.plugin.PLchar(plot)})


        if channelList:
            self.plugin.EOD()
    
    
    
    
    def timeNow(self, sek=False):
        now=datetime.utcnow()+timedelta(hours=2)

        czas=now.strftime('%Y-%m-%d')

        try:
            format_date=datetime.strptime(czas, '%Y-%m-%d')
        except TypeError:
            format_date=datetime(*(time.strptime(czas, '%Y-%m-%d')[0:6]))    
        if sek:
                now=datetime.utcnow()
                czas=now.strftime('%Y-%m-%d %H:%M')
                
                try:
                    format_date=datetime.strptime(czas, '%Y-%m-%d %H:%M')
                except TypeError:
                    format_date=datetime(*(time.strptime(czas, '%Y-%m-%d %H:%M')[0:6]))
        return format_date
    
    def CreateDays(self):
        dzis=self.timeNow()
        timestampdzis = calendar.timegm(dzis.timetuple())
        tydzien = int(timestampdzis)-604800
        out=[]
        for i in range(int(timestampdzis),tydzien,-86400):
            x = datetime.utcfromtimestamp(i)
            dzien = (x.strftime('%d.%m'))
            dnitygodnia = ("poniedziałek","wtorek","środa","czwartek","piątek","sobota","niedziela")
            
            day = x.weekday()

            dzientyg = dnitygodnia[day]

            out.append({'dzien':dzientyg+ ' '+dzien,'tstamp':str(i)}) 
            
        return out    
            

        
    def listKeczup(self, id, program, img):
        program = program.replace('(+)','(na żywo)')
        plot = self.getPlot(id)
        self.plugin.add_item(name=program , url=id, mode='playtv', image=img, folder=False, IsPlayable=True, fanart = self.fanart, infoLabels={'plot':plot})

        out = self.CreateDays()
        for x in out:
            uid = id+'|'+str(x.get('tstamp',None))
            self.plugin.add_item(name=x.get('dzien',None) , url=uid, mode='listekczup2', image=img, folder=True, IsPlayable=False, fanart = self.fanart, infoLabels={})

        self.plugin.EOD()
    
    
    def listKeczup2(self, idts):

        try:
            del self.headers['Content-Type']
        except:
            pass
        id,tstamp = idts.split('|')
        self.headers.update({'Accept': 'application/vnd.orangeott.v3+json'})
        url = self.api_url.format('epg/epg?hhTech=&deviceCat=otg&chosen-day='+str(tstamp))

        jsdata = self.request_sess(url, 'get', headers=self.headers, cookies = self.kukis,result=False)

        for epg in (jsdata.json()).get("epg",None):
            if id in epg.get("channelExternalId",None):

                schedules = epg.get('schedule', None)
                for sch in schedules:
                    if not 'isCatchUpDisabled' in sch:
                        startDate = sch.get("startDate", None)
                        endDate = sch.get("endDate", None)

                        imagePath = sch.get("imagePath", None)
                        poster = self.main_url+imagePath if imagePath else ''
                        name = sch.get("name", None)
                        referenceProgramId = sch.get("referenceProgramId", None)
                        if int(self.tstamp)>sch.get("startDate", None):
                            czasod = datetime.fromtimestamp(sch.get("startDate", None)).strftime('%H:%M')
                            czasdo = datetime.fromtimestamp(sch.get("endDate", None)).strftime('%H:%M')
                            uid = id+'|'+referenceProgramId
                            tit = '[COLOR khaki]%s - %s[/COLOR] %s'%(czasod, czasdo, self.plugin.PLchar(name))
                            self.plugin.add_item(name=tit , url=uid, mode='playtv', image=poster, folder=False, IsPlayable=True, fanart = self.fanart, infoLabels={})
        self.plugin.EOD()

    def ListVodSub(self, url):
        try:
            del self.headers['Content-Type']
        except:
            pass

        jsdata = self.request_sess(url, 'get', headers=self.headers, cookies = self.kukis)
        vodCategoriesList = jsdata.get('vodCategoriesList', None)
        for vdlist in vodCategoriesList:
            vodDirList = vdlist.get('vodDirList', None)
            for vdir in vodDirList:
                
                externalId = vdir.get("externalId", None)
                title = vdir.get("name", None)
                mode = 'listcontent'
                coverImagePath = vdir.get("coverImagePath", None)
                poster = self.main_url+coverImagePath
                
                self.plugin.add_item(name=self.plugin.PLchar(title), url=str(externalId), mode=mode, image=poster, folder=True, IsPlayable=False, fanart = self.fanart, infoLabels={})

                
                
        self.plugin.setContent('videos')    
        self.plugin.EOD()        

    def listVOD(self, id, pg, kateg = False):

        self.plugin.add_item('https://tvgo.orange.pl/gpapi/vod/movie-dir-list?deviceCat=otg', 'Podkategorie', 'DefaultMovies.png', "listvodsubcat", folder=True,fanart=self.fanart)

        try:
            del self.headers['Content-Type']
        except:
            pass

        self.headers.update({'Accept': 'application/vnd.orangeott.v2+json'})

        jsdata = self.request_sess(self.api_url.format('vod/root-content'), 'get', headers=self.headers, cookies = self.kukis)
        voddirlists = jsdata.get('vodDirList', None)
        for vlist in voddirlists:
            externalId = vlist.get("externalId", None)
            title = vlist.get("name", None)
            mode = 'listcontent'
            poster = self.ikona
            self.plugin.add_item(name=self.plugin.PLchar(title), url=str(externalId), mode=mode, image=poster, folder=True, IsPlayable=False, fanart = self.fanart, infoLabels={})

        jsdata = self.request_sess(self.api_url.format('vod/packages?deviceCat=otg'), 'get', headers=self.headers, cookies = self.kukis)

        packages = jsdata.get('packages', None)
        out=[]
        for pkg in packages:
            definition = pkg.get('definition', None)
            title = pkg.get('name', None)
            coverImagePath = pkg.get('coverImagePath', None)
            poster = self.main_url+coverImagePath
            externalId = pkg.get('externalId', None)
            
            packageType = pkg.get('packageType', None)
            
            serviceName = pkg.get('serviceName', None)
            
            desc = pkg.get('desc', None)
            uid = "{}|{}|{}".format(self.plugin.PLchar(externalId), packageType, serviceName)
            if packageType == 'SVOD':
                self.plugin.add_item(name=self.plugin.PLchar(title), url=str(uid), mode='listcontent', image=poster, folder=True, IsPlayable=False, fanart = self.fanart, infoLabels={'plot': self.plugin.PLchar(desc)})
            else:
                out.append({"title": self.plugin.PLchar(title), 'url':str(uid), 'image':poster, 'plot': self.plugin.PLchar(desc)})
        for x in out:
            self.plugin.add_item(name=x.get("title",None) , url=x.get("url",None), mode='listcontent', image=x.get("image",None), folder=True, IsPlayable=False, fanart = self.fanart, infoLabels={'plot': x.get("plot",None)})

        if voddirlists or packages:
            self.plugin.setContent('videos')    
            self.plugin.EOD()

            
            
            
    def ListContent(self, idt):
        try:
            del self.headers['Content-Type']
        except:
            pass
        
        if '|' in idt:
            id,tt,xx = idt.split('|')
        else:
            id = idt
        self.headers.update({'Accept': 'application/vnd.orangeott.v2+json'})
        
        url = self.api_url.format('vod/dir/')+str(id)+'?deviceCat=otg'

        jsdata = self.request_sess(url, 'get', headers=self.headers, cookies = self.kukis)

        vodDirList = jsdata.get('vodDirList', None)
        vodList = jsdata.get('vodList', None)
        if vodDirList:
            for vodR in vodDirList:
                title = vodR.get('name', None)
                vodListx = vodR.get('vodList', None)
                poster =''
                if vodListx:
                    poster = vodListx[0].get('bannerImage', None)
                    description = vodListx[0].get('description', None)
                    uid = quote(json.dumps(vodListx))
                self.plugin.add_item(name=self.plugin.PLchar(title), url=str(uid), mode='listsubdir', image=poster, folder=True, IsPlayable=False, fanart = self.fanart, infoLabels={'plot': self.plugin.PLchar(description)}) 

        elif vodList:
            self.CreateVodList(vodList)
        if vodList or vodDirList:
            self.plugin.setContent('videos')    
            self.plugin.EOD()        

    def CreateVodList(self, vodList):
        for vodL in vodList:
            assetExternalId = vodL.get('assetExternalId', None)
            genres = vodL.get('genres', None)
            kateg = ','.join([x.strip() for x in genres]) if genres else ''
            description = vodL.get('description', None)
            description = description if description else ''
            title = vodL.get('name', None) 
            year = vodL.get('year', None) 
            duration = vodL.get('duration', None) 
            duration = int (duration)/1000 if duration else '0'
            poster = vodL.get('coverImageVertical', None) 

            videoId =  ''
            packageType =  ''
            externalId =  ''
            parentVodPackageId =  ''
            versions = vodL.get('versions', None) 
            trailer = vodL.get('trailer', None) 
            
            
            
            if versions:
                videoId =  versions[0].get('videoId', None)
                packageType =  versions[0].get('packageType', None)
                externalId =  versions[0].get('externalId', None)
                parentVodPackageId =  versions[0].get('parentVodPackageId', None)

            uid = "{}|{}|{}".format(self.plugin.PLchar(assetExternalId), videoId, self.plugin.PLchar(externalId))
        
            self.plugin.add_item(name=self.plugin.PLchar('[COLOR gold]'+title+'[/COLOR]'), url=str(uid), mode='playvid', image=poster, folder=False, IsPlayable=True, fanart = self.fanart, infoLabels={'plot': self.plugin.PLchar(description), 'year': year, 'genre': kateg, 'duration': int(duration)}) 
            if trailer:

                title2 = "     -[COLOR lightgreen][I]"+ title + ' (trailer)[/COLOR][/I]'
                uid2 = self.api_url.format('vod/video/trailer/')+str(assetExternalId)+'?device-type=web_otf&auto-buy=false&deviceCat=otg' 
                
                self.plugin.add_item(name=self.plugin.PLchar(title2), url=str(uid2), mode='playvid', image=poster, folder=False, IsPlayable=True, fanart = self.fanart, infoLabels={'plot': self.plugin.PLchar(description), 'year': year, 'genre': kateg, 'duration': int(duration)}) 


    def ListSubDir(self, jsdata):

        vods = json.loads(unquote(jsdata))
        self.CreateVodList(vods)
        self.plugin.setContent('videos')    
        self.plugin.EOD()    

    def PlayVid(self, id):

        try:
            del self.headers['Content-Type']
        except:
            pass
        
        if 'http' in id:
            del self.headers['Accept']
            self.headers.update({"Cache-Control": "no-cache","Pragma": "no-cache"})
            mpdurl = id
            jsdata = self.request_sess(mpdurl, 'get', headers=self.headers, cookies = self.kukis)
            
        else:
            self.headers.update({'Accept': 'application/vnd.orangeott.v2+json'})
            hd = {
            'User-Agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:93.0) Gecko/20100101 Firefox/93.0',
            'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,*/*;q=0.8',
            'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',
            'Connection': 'keep-alive'}

            x,x1,id = id.split('|')
            mpdurl = self.api_url.format('vod/play-info/')+id+'?device-type=web_otf&auto-buy=false&deviceCat=otg'

            jsdata = self.request_sess(mpdurl, 'get', headers=hd, cookies = self.kukis)

        if 'errCode' in jsdata:
            if 'not registered' in (jsdata.get('errMsg', None)).lower():
                self.CreateTerminal()
                try:
                    del self.headers['Content-Type']
                except:
                    pass
                jsdata = self.request_sess(mpdurl, 'get', headers=self.headers, cookies = self.kukis)
            elif 'no valid ticket' in (jsdata.get('errMsg', None)).lower():
                self.plugin.notification_dialog('[B]Uwaga[/B]', '[B]Brak dostępu do materiału[/B]',xbmcgui.NOTIFICATION_INFO, 8000,False)
                sys.exit(0)
                
        mpdurl = jsdata.get('url', None) 
        lic_url=''
        drm= ''
        if 'playReadyToken' in jsdata:
            casToken = jsdata.get('playReadyToken')

            license_url ='https://tvgo.orange.pl/RTEFacade_RIGHTV/widevinedrm?token='+quote(casToken)
            drm = 'com.widevine.alpha'
            lic_url = license_url+'|Content-Type=|R{SSM}|'

        self.plugin.PlayVid(mpdurl, lic_url = lic_url, PROTOCOL = 'mpd', DRM = drm)
        
        
    def CreateTerminal(self):
        self.headers.update({'Accept': 'application/vnd.orangeott.v3+json', 'Content-Type': 'application/vnd.orangeott.v1+json'})
        data = {"name":"FIREFOX","serialNumber":"FIREFOX_WEB_TERMINAL_1"+self.householdExtId,"deviceType":"web_otf","deviceManufacture":"web","deviceModel":"web"}
        jsdata = self.request_sess(self.api_url.format('user/terminals'), 'post', headers=self.headers, data=data, cookies = self.kukis,result=False)
        return

        
    def CreateBlad2(self, id):

        self.headers = {
            'Host': self.host,
            'User-Agent': self.UA,
            'Accept': '*/*',
            'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',
            'Content-Type': 'application/vnd.orangeott.v1',
            'X-Country-Code': 'pl',
            'Origin': 'https://tvgo.orange.pl',
            'DNT': '1',
            'Referer': 'https://tvgo.orange.pl/live/stream/{}'.format(id),
            'Sec-Fetch-Dest': 'empty',
            'Sec-Fetch-Mode': 'cors',
            'Sec-Fetch-Site': 'same-origin',
        }
        
        
        jsdata = self.request_sess((self.chan_session_url).format(id), 'delete', headers=self.headers, cookies = self.kukis,result=False)
        if 'erminal is not registered' in jsdata.text:
            self.headers = {
                'Host': self.host,
                'User-Agent': self.UA,
                'Accept': 'application/vnd.orangeott.v3+json',
                'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',
                'Content-Type': 'application/vnd.orangeott.v1+json',
                'OtvDeviceInfo': self.OtvDeviceInfo,
                'X-Country-Code': 'pl',
                'Origin': 'https://tvgo.orange.pl',
                'DNT': '1',
                'Referer': 'https://tvgo.orange.pl/live/stream/{}'.format(id),
                'Sec-Fetch-Dest': 'empty',
                'Sec-Fetch-Mode': 'cors',
                'Sec-Fetch-Site': 'same-origin',}
            data = {"name":"FIREFOX","serialNumber":"FIREFOX_WEB_TERMINAL_1"+self.householdExtId,"deviceType":"web_otf","deviceManufacture":"web","deviceModel":"web"}
            jsdata = self.request_sess(self.api_url.format('user/terminals'), 'post', headers=self.headers, data=data, cookies = self.kukis,result=False)
            self.plugin.save_file(file=self.datapath+'kukis', data=(sess.cookies).get_dict(), isJSON=True)
            if jsdata.status_code == 201:
                url = (self.chan_url).format(id)
                if '|' in id:
                    id,subid = id.split('|')
                    url = ('https://tvgo.orange.pl/gpapi/live/channel/{0}/{1}/catchup?deviceCat=otg').format(id,subid)
                    
                    
                self.headers = {
                    'Host': self.host,
                    'User-Agent': self.UA,
                    'Accept': 'application/vnd.orangeott.v2+json',
                    'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',
                    'OtvDeviceInfo': self.OtvDeviceInfo,
                    'X-Country-Code': 'pl',
                    'DNT': '1',
                    'Sec-Fetch-Dest': 'empty',
                    'Sec-Fetch-Mode': 'cors',
                    'Sec-Fetch-Site': 'same-origin',}
                jsdata = self.request_sess(url, 'get', headers=self.headers, cookies = sess.cookies,result=False)
        else:
            url = (self.chan_url).format(id)
            if '|' in id:
                id,subid = id.split('|')
                url = ('https://tvgo.orange.pl/gpapi/live/channel/{0}/{1}/catchup?deviceCat=otg').format(id,subid)
                
                
            self.headers = {
                'Host': self.host,
                'User-Agent': self.UA,
                'Accept': 'application/vnd.orangeott.v2+json',
                'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',
                'OtvDeviceInfo': self.OtvDeviceInfo,
                'X-Country-Code': 'pl',
                'DNT': '1',
                'Sec-Fetch-Dest': 'empty',
                'Sec-Fetch-Mode': 'cors',
                'Sec-Fetch-Site': 'same-origin',}
    
            jsdata = self.request_sess(url, 'get', headers=self.headers, cookies  = self.kukis,result=False)
        try:
            ab = jsdata.json()
        except:
            ab =jsdata.text
        return ab
    def PlayTV(self, id):

        jsdata = self.CreateBlad2(id)

        if not 'errCode' in jsdata:
            casToken = jsdata.get('casToken',None)
            streamUrl = jsdata.get('streamUrl',None) 

            
            license_url = 'https://tvgo.orange.pl/RTEFacade_RIGHTV/widevinedrm?token='+quote(casToken)
            mpdurl = streamUrl.split('?bpk-ser')[0]
            PROTOCOL = 'mpd'
            DRM = 'com.widevine.alpha'
            
            lic_url = license_url+'|Content-Type=|R{SSM}|'
            
            
            
            self.plugin.PlayVid(mpdurl, lic_url, PROTOCOL, DRM)
        else:
            self.plugin.notification_dialog('[B]Uwaga[/B]', '[B]'+jsdata.get('errMsg',None)+'[/B]',xbmcgui.NOTIFICATION_INFO, 8000,False) 
  


  
