# -*- coding: UTF-8 -*-

import sys, os

if sys.version_info >= (3,0,0):
# for Python 3
    from urllib.parse import parse_qsl
else:
    # for Python 2
    from urlparse import parse_qsl

import xbmcaddon

base_url = sys.argv[0]
addon_handle = int(sys.argv[1])

from resources.lib.itemsy import Itemsy
from resources.lib.orange import Orange

Items = Itemsy(
    addon=xbmcaddon.Addon('plugin.video.orangetvgo'),
    addon_handle=addon_handle,
    base_url=base_url
)


params = dict(parse_qsl(sys.argv[2][1:]))
exlink = params.get('url', None)
page = params.get('page',[1])
title = params.get('title', None)
icona  = params.get('image', None)

PATH            =    Items.get_path('path')
PROFILE         =    Items.get_path('profile')

DATAPATH        =    Items.translate_path(PROFILE)

if not os.path.exists(DATAPATH):
    os.makedirs(DATAPATH)
    
RESOURCES      =     PATH+'/resources/'

FANART         =     RESOURCES+'../fanart.jpg'
ikona          =     RESOURCES+'../icon.png'

Orange = Orange(Items, FANART, ikona)

def router(paramstring):
    args = dict(parse_qsl(paramstring))
    
    if args:
        mode = args.get('mode', None)

        if mode  == 'loguj':
            Items.open_settings()
            xbmc.executebuiltin('Container.Refresh()')
            
        elif mode  == 'listtv':
            Orange.listTV()

        elif mode  == 'listvodcat':
            Orange.listVOD(exlink, page, kateg = True)

        elif mode == 'playtv':
            Orange.PlayTV(exlink)

        elif mode == 'listkeczup':
            Orange.listKeczup(exlink, title, icona)
            
        elif mode == 'listekczup2':
            Orange.listKeczup2(exlink)

        elif mode == 'listcontent':
            Orange.ListContent(exlink)

        elif mode == 'playvid':
            Orange.PlayVid(exlink)


        elif mode == 'listsubdir':
            Orange.ListSubDir(exlink)
            

        elif mode == 'listvodsubcat':
            Orange.ListVodSub(exlink)

    else:
        Orange.home()    
if __name__ == '__main__':
    router(sys.argv[2][1:])
