# -*- coding: UTF-8 -*-
import sys,re,os

try:
    # For Python 3.0 and later
    from resources.lib.cmf3 import parseDOM
    from resources.lib.cmf3 import replaceHTMLCodes
    from urllib.parse import parse_qsl, quote, urlencode
    import http.cookiejar as cookielib
except ImportError:
    # Python 2
    from resources.lib.cmf2 import parseDOM
    from resources.lib.cmf2 import replaceHTMLCodes
    from urlparse import parse_qsl
    import  cookielib
    from urllib import unquote, quote, urlencode

PY3 = sys.version_info >= (3,0,0)

import base64

import urllib3
import requests
import xbmcgui
import xbmcplugin
import xbmcaddon
import xbmc
import xbmcvfs

import resolveurl as urlresolver

urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)
base_url = sys.argv[0]
addon_handle = int(sys.argv[1])
params = dict(parse_qsl(sys.argv[2][1:]))

addon = xbmcaddon.Addon(id='plugin.video.pastebinVID')
PATH            = addon.getAddonInfo('path')
try:
    DATAPATH        = xbmcvfs.translatePath(addon.getAddonInfo('profile'))#.decode('utf-8')
except:
    DATAPATH        = xbmc.translatePath(addon.getAddonInfo('profile')).decode('utf-8')
RESOURCES       = PATH+'/resources/'
FANART=PATH+'fanart.jpg'
link_path = os.path.join(DATAPATH, 'links')
file_link = 'linki.txt'

if not os.path.exists(DATAPATH):
    os.mkdir(DATAPATH)
if not os.path.exists(link_path):
    os.mkdir(link_path)

sys.path.append( os.path.join( RESOURCES, "lib" ) )

from filmweb.filmweb import Filmweb
fw = Filmweb()

exlink = params.get('url', None)
name= params.get('title', None)
paths= params.get('path', None)
index= params.get('index', None)
page = params.get('page',[1])#[0]

UA='Mozilla/5.0 (Linux; Android 7.0; PLUS Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/61.0.3163.98 Mobile Safari/537.36'
TIMEOUT=10
sess = requests.Session()
sess2 = requests.Session()
COOKIEFILE = os.path.join(DATAPATH,'pastebin.cookie')
sess.cookies = cookielib.LWPCookieJar(COOKIEFILE)
def build_url(query):
    return base_url + '?' + urlencode(query)

def add_item(url, name, image, folder, mode, infoLabels=False, playable=True, itemcount=1, page=0,contextmenu=None):
    list_item = xbmcgui.ListItem(label=name)

    if playable:
        list_item.setProperty("IsPlayable", 'true')
    else:
        list_item.setProperty("IsPlayable", 'false')
        folder=False
        
    if not infoLabels:
        infoLabels={'title': name}
    if contextmenu:
        isp=contextmenu
        list_item.addContextMenuItems(isp, replaceItems=True)
    list_item.setInfo(type="video", infoLabels=infoLabels)    
    list_item.setArt({'thumb': image, 'poster': image, 'banner': image, 'fanart': image})
    xbmcplugin.addDirectoryItem(
        handle=addon_handle,
        url = build_url({'mode': mode, 'title':name, 'url' : url,'page' : page}),            
        listitem=list_item,
        isFolder=folder)
    xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = "%R, %Y, %P")
    
def home():    
    try:
        import kurw
        kurw.abc()
    except:
        pass
    add_item('bb', '[COLOR khaki]Dodaj nową listę[/COLOR]', '', False, 'dodajnowa',False,False)    
    #add_item(url='x', name='[COLOR khaki]Dodaj nową listę z PASTEBIN[/COLOR]', image='', mode='dodajnowa', folder=False, infoLabels=False, playable=False)    
        
        
        
        
#    add_item(url='', name='[COLOR khaki]Dodaj nową listę z PASTEBIN[/COLOR]', image='' , mode="dodajnowa", folder=False, infoLabels=False, playable=False,,contextmenu=None)    
    #add_item(name='[COLOR khaki]Dodaj nową listę z PASTEBIN[/COLOR]', url='', mode="dodajnowa", image='', folder=False, playable=False)        
#    add_item('', '[COLOR khaki]Dodaj nową listę z PASTEBIN[/COLOR]', '', False, "dodajnowa", infoLabels=False, playable=False)    
    path, dirs, files = get_directory(link_path)
    if file_link in files:
        link_file = os.path.join(path, file_link)
        with open(link_file) as f:
            for i, line in enumerate(f):
                item = line.split('|')
                href = item[0].strip()
                if not href: 
                    continue
                try: 
                    title = item[1]
                except: 
                    title = item[0]
                dalejxx(i, href, title, path)

    xbmcplugin.setContent(addon_handle, 'videos')
    #xbmcplugin.endOfDirectory(addon_handle, cacheToDisc=True)
    xbmcplugin.endOfDirectory(addon_handle)    
def dalejxx(index, href, title, path):    
    contextmenu = [] 
    contextmenu.append(('Usuń tę listę', 'RunPlugin(%s)' % build_url({'mode': 'usunlist', 'url' : index, 'index': index, 'path': path})),)
    
    contextmenu.append((u'Usuń wszystkie listy', 'Container.Update(%s)' % build_url({'mode': 'delall', 'index': index, 'path': path})),)
    contextmenu.append((u'Zmiana nazwy', 'RunPlugin(%s)' % build_url({'mode': 'zmiananazwy', 'index': index, 'path': path})),)
    add_item(href, title, '', True, "pastebin",contextmenu=contextmenu)

def get_directory(path):
    try: return next(os.walk(path))
    except: return (path, [], [])
def dalej():
    history = HistoryLoad()
    if not history == ['']:
        for entry in history:
            entryok=entry.split('|')
            contextmenu = []
            contextmenu.append((u'Usuń tę listę', 'Container.Update(%s)'% build_url({'mode': 'SzukajUsun', 'url' : entry})),)
            contextmenu.append((u'Usuń wszystkie listy', 'Container.Update(%s)' % build_url({'mode': 'SzukajUsunAll'})),)
            contextmenu.append((u'Zmiana nazwy', 'Container.Update(%s)' % build_url({'mode': 'zmiananazwy'})),)            
            add_item(entryok[0],entryok[1], '', True, "pastebin", contextmenu=contextmenu)    

            
def ListPastebin(exlink,page):

    exlink2=exlink.split('|')[0]
    lists,np = getPastebin(exlink2,page)            
    itemz=lists
    items = len(lists)
    add_item(name='[COLOR khaki]Przeszukaj listę[/COLOR]', url=exlink2, mode='szukaj', image='', folder=True)    
    for f in itemz:
        add_item(name=PLchar(f.get('title')), url=f.get('href'), mode='getLinks', image=f.get('img'), folder=False, infoLabels={'plot':PLchar(f.get('plot'))}, itemcount=items)        

    if np:
        np=np[0]
        add_item(name=np.get('title'), url=exlink, mode='pastebin', image=np.get('img'), folder=True,page=np.get('pg'))    
        
    xbmcplugin.setContent(addon_handle, 'movies')
    xbmcplugin.endOfDirectory(addon_handle)    
    
def getUrlReq(url,post=False, data=''):
    if 'pwd=' in url:
        headers = {
            'Host': 'pastebin.com',
            'user-agent': UA,
            'accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
            'accept-language': 'pl,en-US;q=0.7,en;q=0.3',
            'content-type': 'application/x-www-form-urlencoded',
            'origin': 'https://pastebin.com',
            'referer': url,
            'upgrade-insecure-requests': '1',
            'te': 'trailers',
        }
        url,pwd = url.split('?pwd=')
        content=sess.get(url,verify=False).text
        dt = re.findall('_csrf-frontend" value="(.+?)"', content,re.DOTALL)[0]    
        isb = re.findall('"is_burn" value="(.+?)"', content,re.DOTALL)[0]    
        nmpwd = re.findall('form\-control"\s*name\=\s*"(.+?)"\s*aria\-required', content,re.DOTALL)[0]    
        
        data = {
                '_csrf-frontend': dt,
                'is_burn': isb,
                nmpwd: pwd}
        content = sess.post(url, headers=headers , data=data).text
    else:    
        content=sess.get(url, verify=False).text
        if 'Warning - Potentially offensive content ahead' in content:
        
            
            headers = {
                'Host': 'pastebin.com',
                'user-agent': UA,
                'accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
                'accept-language': 'pl,en-US;q=0.7,en;q=0.3',
                'content-type': 'application/x-www-form-urlencoded',
                'origin': 'https://pastebin.com',
                'referer': url,
                'upgrade-insecure-requests': '1',
                'te': 'trailers',
            }
    
            dt = re.findall('_csrf-frontend" value="(.+?)"', content,re.DOTALL)[0]
            data = '_csrf-frontend='+quote(dt)+'&is_spam=0'
            content=sess.post(url,data = data, headers = headers, verify=False).text
    try:
        import chardet
        kodowanie = chardet.detect(content)
        content = unicode(content, kodowanie["encoding"])
    except Exception as e:
        pass

    return content
def rot47(data):
    decode = []
    for i in xrange(len(data)):
        encoded = ord(data[i])
        if encoded >= 33 and encoded <= 126:
            decode.append(chr(33 + ((encoded + 14) % 94)))
        else:
            decode.append(data[i])
    return ''.join(decode)
import base64

def isBase64(sb):
        try:
                if isinstance(sb, str):
                        # If there's any unicode here, an exception will be thrown and the function will return false
                        sb_bytes = bytes(sb, 'ascii')
                elif isinstance(sb, bytes):
                        sb_bytes = sb
                else:
                        raise ValueError("Argument must be string or bytes")
                return base64.b64encode(base64.b64decode(sb_bytes)) == sb_bytes
        except Exception:
                return False

def getPastebin(exlink,page):

    if 'http' in exlink:
        html=getUrlReq(exlink)

        try:
            if exlink.count('http')<2:
                result=parseDOM(html,'span', attrs={'class': "go_right"})
                if not result:
                    result =re.findall('raw to clipboard">(.*?)<\/div',html,re.DOTALL+re.I)[0]

                else:
                    result = result[0]
                href = parseDOM(result, 'a', ret='href')[0]  
                href = 'https://pastebin.com' + href if href.startswith('/raw') else href
                if href.startswith('/'):
                    html = parseDOM(html,'textarea', attrs={'class': "textarea"})[0] 
                else:
                    if '?pwd=' in exlink:
                        html = re.findall('paste-raw">([^<]+)<\/textarea',html, re.DOTALL)[0]
                    else:
                        html=getUrlReq(href)
            else:
                exlink = re.sub('https://pastebin.com/','',exlink)
                html=getUrlReq(exlink)
        except:
            pass
    else:
        with open(exlink,'r') as f:
            html = f.read()
            f.close()
    
    #chk = isBase64(html)
    #if chk:
    try:
        html2=base64.b64decode(html)
        if 'http' in html2:
            html=html2
        else:
            html = html
    except:
        pass
    try:
        if not 'http' in html:
            html=replaceHTMLCodes(html)
            html=rot47(html)

        else:
            html=html
    except:
        pass

    ass = html.splitlines()
    dl=len(ass)
    ass = ass[int(page):int(page)+20]
    imag=''
    plot =''
    out=[]
    npout=[]
    for aser in ass:
        try:
            links=aser.split('|')
            link=links[0]#
            try:
                dod=links[4]
            except:
                dod=''
            #if dod:
            #    dodaj=dod[0]
            #else:
            #    dodaj=''
            try:
                tytul=links[1]#aser.partition(' ')[2]
            except:
                pass
            if not tytul:
                tytul = link

            if 'true' in addon.getSetting('showPosters'):
                try:

                    year=links[2]
                    typ=links[3]
                    imag,plot=getImag(tytul,year,typ)#title,year        
                except:
                    pass
            tytul=tytul+' '+dod
            out.append({ 'href'  : link,'title' : tytul,'img': imag,'plot':PLchar(plot)})    
        except:
            pass
    if dl>20:
        npout.append({ 'href'  : '','title' : 'Następna strona','img': '','pg':int(page)+20})
    return out,npout
def getImag(title,year,typ):

###                   https://github.com/lopezloo/pyfilmweb
    titlemain=title.split(' (')
    title=PLchar(titlemain[0])
    title = title.replace(', ',' ')
    tyt=repr(title)
    tyt = re.sub("\[[^\]]*\]","",tyt)

    tyt=tyt.encode("utf8").replace("'",'').lower() if not PY3 else tyt.replace("'",'').lower()

    items = fw.search(title)

    for item in items:
        imag=''
        plot=''
        try:
            ab=PLchar(item['tyt'])#item.name
            
            ab = repr(ab.lower().replace(', ',' '))

            yr= item['year']#.year

            ab= (ab.encode('utf-8')).replace("'",'').lower() if not PY3 else (ab).replace("'",'').lower()
            if tyt == ab and year ==yr:

                imag= item['img']#.get_poster(size='big')
                plot= item['plot']#.get_description()
                break    
            if tyt == ab and not year ==yr:
                imag= item['img']
                plot = '[CR][COLOR deeppink]rok nie pasuje do filmu[/COLOR]'
                break

        except:
            plot=''
            imag=''

    return imag,plot
def PLchar(char):
    if type(char) is not str:
        char=char.encode('utf-8')
    char = char.replace('\\u0105','\xc4\x85').replace('\\u0104','\xc4\x84')
    char = char.replace('\\u0107','\xc4\x87').replace('\\u0106','\xc4\x86') #E9
    char = char.replace('\\u00e9','\xc3\xa9').replace('\\u00C9','\xc3\x89') #E9    
    char = char.replace('\\u0119','\xc4\x99').replace('\\u0118','\xc4\x98')
    char = char.replace('\\u0142','\xc5\x82').replace('\\u0141','\xc5\x81')
    char = char.replace('\\u0144','\xc5\x84').replace('\\u0144','\xc5\x83')
    char = char.replace('\\u00f3','\xc3\xb3').replace('\\u00d3','\xc3\x93')
    char = char.replace('\\u015b','\xc5\x9b').replace('\\u015a','\xc5\x9a')
    char = char.replace('\\u017a','\xc5\xba').replace('\\u0179','\xc5\xb9')
    char = char.replace('\\u017c','\xc5\xbc').replace('\\u017b','\xc5\xbb')
    char = char.replace('&#8217;',"'")
    char = char.replace('&#8211;',"-")    
    char = char.replace('&#8230;',"...")    
    char = char.replace('&#8222;','"').replace('&#8221;','"')    
    char = char.replace('[&hellip;]',"...")
    char = char.replace('&#038;',"&").replace('&ndash;','-').replace('&quot;','-')
    char = char.replace('&nbsp;',".").replace('&amp;','&').replace('&oacute;','ó').replace('<br/>','')
    
    return char    
    
def getPlaytube(stream_url,nturl):
    cuk = addon.getSetting('fjkukz2')
    str_url=''
    import jsunpack
    try:
        headers = {
                    'User-Agent': UA,
                    'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
                    'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',
                    'Referer': nturl,
                    'cookie':cuk,
                    'Connection': 'keep-alive',
                    'Upgrade-Insecure-Requests': '1',
                    'Cache-Control': 'max-age=0',}
        html = requests.get(stream_url,headers=headers)
        kuks =''.join(['%s=%s;'%(c.name, c.value) for c in html.cookies])
        html = html.text
        dal=re.findall('cookie\("([^"]+)", "([^"]+)"',html)
        
        kuks2 =''.join(['%s=%s;'%(cn, cv) for cn,cv in dal])
        kuks+=kuks2

        packer = re.compile(r'(eval\(function\(p,a,c,k,e,(?:r|d).*)')

        packed = packer.findall(html)
        if packed:
            packed =packed[0]
            html+= jsunpack.unpack(packed)
        sources = re.findall('sources:\s*\[(.+?)\]',html)
        if sources:
            str_url=re.findall('"(.+?)"',sources[0])[0]
            str_url += '|User-Agent='+quote(UA)+'&Referer='+nturl+'&Cookie='+quote(kuks)
    except:
        pass
    return str_url
def getFdisc(stream):
    out=''
    head = {
                'User-Agent': UA,
                'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
                'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',
                'Connection': 'keep-alive',}

    html = sess2.get(stream, headers=head,verify=False).text
    
    if 'captcha.png' in html:
        html =rozwCaptcha2(html,stream)
    if 'captcha.png' in html:
        xbmcgui.Dialog().notification('[B]Błędna captcha[/B]', 'Spróbuj ponownie',xbmcgui.NOTIFICATION_INFO, 8000,False)
        return out
    else:
        sc=''.join(['%s=%s;'%(c.name, c.value) for c in sess2.cookies])
    
        data = re.compile('<link rel="video_src" .+? href=["\'](.*)["\'] />').findall(html)
    
        if data:
            data = data[0]
            file = re.search('file=(http(s)*://[^"\']+)',data)
            if file:
                out=file.group(1)+'|Referer='+stream +'&Cookie='+sc+' swfUrl=http://http://freedisc.pl/static/player/v58/player.swf'
        return out        

def rozwCaptcha2(html,url):

    import mc


    headers = {
        'Host': 'freedisc.pl',
        'user-agent': UA,
        'accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
        'accept-language': 'pl,en-US;q=0.7,en;q=0.3',
        'dnt': '1',
        'upgrade-insecure-requests': '1',
        'te': 'trailers',
    }
    headersx = {
    'User-Agent': UA,
    'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
    'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',
    'Content-Type': 'application/x-www-form-urlencoded',
    'Origin': 'https://freedisc.pl',
    'Connection': 'keep-alive',
    'Referer': url,
    'Upgrade-Insecure-Requests': '1',
    'TE': 'Trailers',}
    
    head = {
                'User-Agent': UA,
                'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
                'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',
                'Connection': 'keep-alive',}

                
                
                
                
                
    capurl = re.findall('"(\/streaming\/captcha.+?)"',html)[0]
    capurl = 'https://freedisc.pl'+capurl
    response = sess2.get(capurl, headers=head,cookies=sess2.cookies, verify=False)
    rx=mc.keyboard(response.content)
    data = {'captcha':rx}
    response = sess2.post(url, headers=headersx, data=data,cookies=sess2.cookies, verify=False)
    response = sess2.get(url, headers=sess2.headers,cookies=sess2.cookies, verify=False)
    return response.text
    
def rozwCaptcha(html,host='vider.info'):

    import mc


    headers = {
        'Host': host,
        'user-agent': UA,
        'accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
        'accept-language': 'pl,en-US;q=0.7,en;q=0.3',
        'dnt': '1',
        'upgrade-insecure-requests': '1',
        'te': 'trailers',
    }
    headersx = {
        'Host': 'vider.info',
        'user-agent': UA,
        'accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
        'accept-language': 'pl,en-US;q=0.7,en;q=0.3',
        'content-type': 'application/x-www-form-urlencoded',
        'referer': 'http://%s/'%(host),
        'origin': 'http://%s'%(host),
        'upgrade-insecure-requests': '1',
        'te': 'trailers',
    }
    head = {
                'User-Agent': UA,
                'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
                'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',
                'Connection': 'keep-alive',}

    capurl = re.findall('"(\/streaming\/captcha.+?)"',html)[0]
    capurl = 'https://%s'%(host)+capurl
    response = sess2.get(capurl, headers=head,cookies=sess2.cookies, verify=False)
    rx=mc.keyboard(response.content)
    data = {'captcha':rx}
    response = sess2.post('https://%s/'%(host), headers=headersx, data=data,cookies=sess2.cookies, verify=False)
    
def getVider(url):
    video_link=''
    head = {
                'User-Agent': UA,
                'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
                'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',
                'Connection': 'keep-alive',}
    content = sess2.get(url,headers=head,verify=False).text
    if 'captcha.png' in content:
        rozwCaptcha(content)
        
        content=sess2.get(url,headers=sess2.headers, cookies=sess2.cookies).text

    data = re.compile('data-video-url="(.*?)"').findall(content)
    if data:
        video_link=data[0]+'|Referer={}&User-Agent={}'.format(url,UA)
    return video_link
def getResetoff(url):
    video_link=''
    head = {
                'User-Agent': UA,
                'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
                'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',
                'Connection': 'keep-alive',}
    content = sess2.get(url,headers=head,verify=False).text
    if 'captcha.png' in content:
        rozwCaptcha(content,host='resetoff.pl')
        
        content=sess2.get(url,headers=sess2.headers, cookies=sess2.cookies).text

    data = re.compile('data-video-url="(.*?)"').findall(content)
    if data:
        video_link=data[0]+'|Referer={}&User-Agent={}'.format(url,UA)
    return video_link
def getLinks(exlink):
    stream=exlink
    if ' ' in stream:
        stream=stream.strip(' ')
    
    hlink='https://freedisc.pl/'
    strfile=''
    if 'freedisc.pl' in stream:
        if 'embed/video' in stream:
            stream=getFdisc(stream)
            if    stream:
                strfile=stream+'|Referer='+hlink +' swfUrl=http://http://freedisc.pl/static/player/v58/player.swf'
        else:
            strfile=stream+'|Referer='+hlink +' swfUrl=http://http://freedisc.pl/static/player/v58/player.swf'
        if strfile:
            play_item = xbmcgui.ListItem(path=strfile)
            xbmcplugin.setResolvedUrl(addon_handle, True, listitem=play_item)
    elif 'resetoff.pl' in stream:
        strfile=getVider(stream)
        #xbmc.log('@#@strfilestrfilestrfilestrfilestrfile: %s' % str(strfile), xbmc.LOGNOTICE)
        if strfile:
            play_item = xbmcgui.ListItem(path=strfile)
            xbmcplugin.setResolvedUrl(addon_handle, True, listitem=play_item)
    elif 'vider.info/embed/' in stream:# or 'resetoff.pl' in stream:

        strfile=getVider(stream)
        if strfile:
            play_item = xbmcgui.ListItem(path=strfile)
            xbmcplugin.setResolvedUrl(addon_handle, True, listitem=play_item)
    elif 'cda.pl' in stream:

        try:
            stream = urlresolver.resolve(stream)
        except Exception as e:
            import cdapl 
            stream = cdapl.getLinkCda(stream)
            
            if type(stream) is list:
                if len(stream)>1:
                    qual = [x[1] for x in stream]
                    select = xbmcgui.Dialog().select('Wybierz jakość (cda)', qual)
                    
                    if select>-1:
                        stream = stream[select][0]
                        play_item = xbmcgui.ListItem(path=stream)
                        xbmcplugin.setResolvedUrl(addon_handle, True, listitem=play_item)
                    else:
                        
                        stream_url=''
                else:
                    stream = stream[0][0]
        play_item = xbmcgui.ListItem(path=stream)
        xbmcplugin.setResolvedUrl(addon_handle, True, listitem=play_item)
    elif 'playtube' in stream:
        stream = getPlaytube(stream,stream)
        if stream:
            play_item = xbmcgui.ListItem(path=stream)
            xbmcplugin.setResolvedUrl(addon_handle, True, listitem=play_item)
        else:
            play_item = xbmcgui.ListItem(path='')
            xbmcplugin.setResolvedUrl(addon_handle, False, listitem=play_item)
    elif '.mp4' in stream and 'zaq' in stream:
        headers = {
            #'Host': 'filmninja.ws',
        #   'Referer':host,
            'user-agent': UA,
            'accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
            'accept-language': 'pl,en-US;q=0.7,en;q=0.3',
        #  'dnt': '1',
        # 'upgrade-insecure-requests': '1',
        #  'te': 'trailers',
        }
        response = requests.get("https://stream.zaq2.pl",headers=headers,verify=False)#.text
        kuks =''.join(['%s=%s;'%(c.name, c.value) for c in response.cookies])
    
    
        stream+='|User-Agent='+quote(UA)+'&Referer=https://stream.zaq2.pl&Cookie='+quote(kuks)
        play_item = xbmcgui.ListItem(path=stream)
        xbmcplugin.setResolvedUrl(addon_handle, True, listitem=play_item)
    else:
    
        try:
            stream_url = urlresolver.resolve(stream)
        except Exception as e:
                stream_url=''
                s = xbmcgui.Dialog().ok('[COLOR red]Problem[/COLOR]','Może inny link bedzie działał?\nERROR: %s'%str(e))    
        if stream_url:    
            play_item = xbmcgui.ListItem(path=stream_url)
            xbmcplugin.setResolvedUrl(addon_handle, True, listitem=play_item)
        else:
            play_item = xbmcgui.ListItem(path='')
            xbmcplugin.setResolvedUrl(addon_handle, False, listitem=play_item)        

def DelList(index, paths):
    try:
        ret = xbmcgui.Dialog().yesno('Kodi', 'Jesteś pewien?')
    except:
        return
        
    if ret: 
        path = os.path.join(paths, file_link)
        new_lines = []
        with open(path) as f:
            for i, line in enumerate(f):
                if i == int(index):
                    continue
                new_lines.append(line)
        write_links(path, new_lines)           
        xbmc.executebuiltin("Container.Refresh") 
    else:
        return    
        
def DelAll(index, paths):
    try:
        ret = xbmcgui.Dialog().yesno('Kodi', 'Jesteś pewien?')
    except:
        return
        
    if ret: 
        path = os.path.join(paths, file_link)
        open(path, 'w').close()        
        xbmc.executebuiltin("Container.Refresh") 
    else:
        return
    
def write_links(path, links):
    with open(path, 'w') as f:
        for line in links:
            if not line.endswith('\n'):
                line += '\n'               
            f.write(line)    

def edit_link(index, paths):
    path = os.path.join(paths, file_link)
    new_lines = []
    with open(path) as f:
        for i, line in enumerate(f):
            if i == int(index):
                item = line.split('|')
                result = prompt_for_link(*item)
                if result:
                    line = '|'.join(result)                
            new_lines.append(line)    
    write_links(path, new_lines)
    xbmc.executebuiltin("Container.Refresh") 
    
def prompt_for_link(old_link='', old_name=''):
    if old_link.endswith('\n'): old_link = old_link[:-1]
    if old_name.endswith('\n'): old_name = old_name[:-1]

    new_name = xbmcgui.Dialog().input(u'Podaj nową nazwę', type=xbmcgui.INPUT_ALPHANUM)
    if new_name is None:
        return
    
    if new_name:
        return (old_link, new_name)
    else:
        return (old_link, )

def prompt_for_link2(old_link='', old_name=''):
    if old_link.endswith('\n'): old_link = old_link[:-1]
    if old_name.endswith('\n'): old_name = old_name[:-1]
    
    dt =['Plik','Adres url']

    select = xbmcgui.Dialog().select('Skąd lista:', dt)
    if select>-1:
        if select==0:
            new_name =''
            dialog = xbmcgui.Dialog()
            fn = dialog.browse(1, 'pliki', '')
            if fn:
                with open(fn,'r') as f:
    
                    content = f.read()
                    f.close()
                    tt = fn.split(':\\')[-1]
                    new_link = os.path.join(DATAPATH, tt)
                    if os.path.isfile(new_link):
                        new_link = new_link.replace('.txt','_.txt')
                    #    plik=plik+'_'
                #    else:
                        
                    f = xbmcvfs.File(new_link, "wb")
                    f.write(content)
                    f.close()
    
                new_name = xbmcgui.Dialog().input(u'Podaj nazwę', type=xbmcgui.INPUT_ALPHANUM)
                if not new_name:
                    return
            else:
                return
        else:    
            new_link = xbmcgui.Dialog().input(u'Podaj link z PASTEBIN.COM', type=xbmcgui.INPUT_ALPHANUM)
            if not new_link:
                return
            if 'pastebin.com' in new_link:
                new_link=new_link
            else:
                new_link='https://pastebin.com/'+new_link
            new_name = xbmcgui.Dialog().input(u'Podaj nazwę', type=xbmcgui.INPUT_ALPHANUM)
            if not new_name:
                return
        
            check,pwd = CheckPwd(new_link)
            if check:
                if pwd:
                    new_link = new_link+'?pwd='+pwd
                    
                else:
                    return    
            
        if new_name:
    
            return (new_link, new_name)
        else:
            if 'pwd=' in new_link:
                nazw = new_link.split('?pwd')[0]
                return (new_link, nazw)    
            else:
                return (new_link, )
    else:
        return

def CheckPwd(new_link):

    sess.headers.update({'User-Agent': UA})
    content=sess.get(new_link,verify=False).text
    headers = {
        'Host': 'pastebin.com',
        'user-agent': UA,
        'accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
        'accept-language': 'pl,en-US;q=0.7,en;q=0.3',
        'content-type': 'application/x-www-form-urlencoded',
        'origin': 'https://pastebin.com',
        'referer': new_link,
        'upgrade-insecure-requests': '1',
        'te': 'trailers',
    }
    if '>Enter password<' in content:
        
        pwd = xbmcgui.Dialog().input(u'Podaj hasło dla\n[B]%s[/B] :'%(new_link), type=xbmcgui.INPUT_ALPHANUM)
        if not pwd:
            xbmcgui.Dialog().notification('Dla [B]%s[/B]'%(new_link), 'wymagane jest hasło.\nSpróbuj ponownie.',xbmcgui.NOTIFICATION_INFO, 8000,False)
            return True, None
        else:
            dt = re.findall('_csrf-frontend" value="(.+?)"', content,re.DOTALL)[0]    
            isb = re.findall('"is_burn" value="(.+?)"', content,re.DOTALL)[0]    
            nmpwd = re.findall('form\-control"\s*name\=\s*"(.+?)"\s*aria\-required', content,re.DOTALL)[0]    
    
            data = {
                    '_csrf-frontend': dt,
                    'is_burn': isb,
                    nmpwd: pwd}
            content = sess.post(new_link, headers=headers , data=data).text
            if '>Enter password<' in content:
                xbmcgui.Dialog().notification('Błędne hasło dla [B]%s[/B]'%(new_link), 'Spróbuj ponownie.',xbmcgui.NOTIFICATION_INFO, 8000,False)
                return True, None
            else:
                return True, pwd
    
    else:
        return False, False
        
def DodajNowa(link=None, name=None, path=None):
    if path is None: path = link_path
    if link is None:
        result = prompt_for_link2()

    else:
        if name is None:
            

            result = (link, )
        else:
            result = (link, name)
            
    if result:
        if not os.path.exists(os.path.dirname(path)):
            os.mkdir(os.path.dirname(path))
            
        path = os.path.join(path, file_link)
        with open(path, 'a') as f:
            line = '|'.join(result)
            if not line.endswith('\n'):
                line += '\n'
            f.write(line)
        
    xbmc.executebuiltin("Container.Refresh") 
def ListSearch(query,exlink):
    print('')
    out=[]
    html=getUrlReq(exlink)
    try:
        result=parseDOM(html,'span', attrs={'class': "go_right"})[0]
        href = parseDOM(result, 'a', ret='href')[0]  
        href = 'https://pastebin.com' + href if href.startswith('/raw') else href
        html=getUrlReq(href)
    except:
        pass
    ass = html.splitlines()
    for asr in ass:
        if query.lower() in PLchar(asr.lower()):
            links=asr.split('|')
            link=links[0]#
            try:
                dod=links[4]
            except:
                dod=''
            #if dod:
            #    dodaj=dod[0]
            #else:
            #    dodaj=''
            try:
                tytul=links[1]#aser.partition(' ')[2]
            except:
                pass
            if not tytul:
                tytul = link
 
            if 'true' in addon.getSetting('showPosters'):
                try:
                    year=links[2]
                    typ=links[3]
                    imag,plot=getImag(tytul,year,typ)#title,year        
                except:
                    pass
            tytul=tytul+' '+dod
            out.append({ 'href'  : link,'title' : tytul,'img': imag,'plot':PLchar(plot)})    
    return out
    
def router(paramstring):
    params = dict(parse_qsl(paramstring))
    if params:    

        mode = params.get('mode', None)

        if mode == 'getLinks':
            getLinks(exlink)    
        elif mode == 'pastebin':
            ListPastebin(exlink,page)            
        elif mode == 'dodajnowa':
            DodajNowa()        
        elif mode == 'delall':
            DelAll(index, paths)
        elif mode == 'usunlist':
            DelList(index, paths)    
        elif mode == 'zmiananazwy':
            edit_link(index, paths)    
        elif mode == 'szukaj':
            query = xbmcgui.Dialog().input(u'Szukaj, Co szukasz?', type=xbmcgui.INPUT_ALPHANUM)
            if query:
                itemz=ListSearch(PLchar(query),exlink)
                if itemz:
                    items = len(itemz)
                    for f in itemz:
                        add_item(name=f.get('title'), url=f.get('href'), mode='getLinks', image=f.get('img'), folder=False, infoLabels=f, itemcount=items)
                    xbmcplugin.setContent(addon_handle, 'movies')
                    xbmcplugin.endOfDirectory(addon_handle)    
                else:
                    xbmcgui.Dialog().notification('[B]Błąd[/B]', 'Nic nie znaleziono',xbmcgui.NOTIFICATION_INFO, 8000,False)
    else:
        home()
                
                
if __name__ == '__main__':
    router(sys.argv[2][1:])        