# -*- coding: utf-8 -*-

#'\nCreated on Thu Feb 11 18:47:43 2016\n\n@author: ramic\n'
import requests
import re
import jsunpack as jsunpack
import sys
import string

if sys.version_info >= (3,0,0):
# for Python 3
    from urllib.parse import unquote
    import urllib.parse as urlparse
else:
    # for Python 2
    from urllib import unquote


BASEURL='https://www.cda.pl'
TIMEOUT = 5
PY3 = sys.version_info[0] == 3
if PY3:
    rot13 = str.maketrans(
        "ABCDEFGHIJKLMabcdefghijklmNOPQRSTUVWXYZnopqrstuvwxyz",
        "NOPQRSTUVWXYZnopqrstuvwxyzABCDEFGHIJKLMabcdefghijklm")
else:
    rot13 = string.maketrans(
        "ABCDEFGHIJKLMabcdefghijklmNOPQRSTUVWXYZnopqrstuvwxyz",
        "NOPQRSTUVWXYZnopqrstuvwxyzABCDEFGHIJKLMabcdefghijklm")

def getUrl(url,data=None,cookies=None):
    headers = {
        'User-Agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:63.0) Gecko/20100101 Firefox/63.0',
        'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
        'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',
        'Connection': 'keep-alive',
        'Upgrade-Insecure-Requests': '1',}
    link=requests.get(url,verify=False,headers=headers).content
    if PY3:
        link = link.decode(encoding='utf-8', errors='strict')
    return link
    
def _get_encoded(content):
    src=''
    idx1 = content.find('|||http')
    if  idx1>0:
        idx2 = content.find('.split', idx1)
        encoded =content[ idx1: idx2]
        if encoded:
            tmp = encoded.split('player')[0]
            tmp=re.sub('[|]+\\w{2,3}[|]+','|',tmp,re.DOTALL)
            tmp=re.sub('[|]+\\w{2,3}[|]+','|',tmp,re.DOTALL)
            remwords=['http','cda','pl','logo','width','height','true','static','st','mp4','false','video','static',
                    'type','swf','player','file','controlbar','ads','czas','position','duration','bottom','userAgent',
                    'match','png','navigator','id', '37', 'regions', '09', 'enabled', 'src', 'media']
            remwords=['http', 'logo', 'width', 'height', 'true', 'static', 'false', 'video', 'player',
                'file', 'type', 'regions', 'none', 'czas', 'enabled', 'duration', 'controlbar', 'match', 'bottom',
                'center', 'position', 'userAgent', 'navigator', 'config', 'html', 'html5', 'provider', 'black',
                'horizontalAlign', 'canFireEventAPICalls', 'useV2APICalls', 'verticalAlign', 'timeslidertooltipplugin',
                'overlays', 'backgroundColor', 'marginbottom', 'plugins', 'link', 'stretching', 'uniform', 'static1',
                'setup', 'jwplayer', 'checkFlash', 'SmartTV', 'v001', 'creme', 'dock', 'autostart', 'idlehide', 'modes',
               'flash', 'over', 'left', 'hide', 'player5', 'image', 'KLIKNIJ', 'companions', 'restore', 'clickSign',
                'schedule', '_countdown_', 'countdown', 'region', 'else', 'controls', 'preload', 'oryginalne', 'style',
                '620px', '387px', 'poster', 'zniknie', 'sekund', 'showAfterSeconds', 'images', 'Reklama', 'skipAd',
                 'levels', 'padding', 'opacity', 'debug', 'video3', 'close', 'smalltext', 'message', 'class', 'align',
                  'notice', 'media']
            for one in remwords:
                tmp=tmp.replace(one,'')
            cleanup=tmp.replace('|',' ').split()
            out={'server': '', 'e': '', 'file': '', 'st': ''}
            if len(cleanup)==4:
                for one in cleanup:
                    if one.isdigit():
                        out['e']=one
                    elif re.match('[a-z]{2,}\\d{3}',one) and len(one)<10:
                        out['server'] = one
                    elif len(one)==22:
                        out['st'] = one
                    else:
                        out['file'] = one
                src='https://%s.cda.pl/%s.mp4?st=%s&e=%s'%(out.get('server'),out.get('file'),out.get('st'),out.get('e'))
    return src
########################################################
def cda_replace(match, link):
    data = getUrl('https://www.cda.pl/js/player.js')
    if match == '1':
        data1 = getDataBeetwenMarkers(data, '11:344', ';return', False)[1]
        dane1 = re.compile('replace\((.+?)\)', re.DOTALL).findall(data1)
        for i in range(len(dane1)):
            rep = dane1[i]
            item = rep.split(',')
            a = item[0].replace('"','')
            b = item[1].replace('"','')
            link = link.replace(a, b)
        return link
    else:
     #   data2 = getDataBeetwenMarkers(data, 'da=function', '}};', False)[1]
        data2 = getDataBeetwenMarkers(data, 'Aa=function', '}};', False)[1]
        
        
        dane2 = re.compile('replace\((.+?)\)', re.DOTALL).findall(data2)
        for i in range(len(dane2)):
            rep = dane2[i]
            item = rep.split(',')
            a = item[0].replace('"','')
            b = item[1].replace('"','')
            link = link.replace(a, b)
        return link
def getDataBeetwenMarkers(data, marker1, marker2, withMarkers=True, caseSensitive=True):
    if caseSensitive:
        idx1 = data.find(marker1)
    else:
        idx1 = data.lower().find(marker1.lower())
    if -1 == idx1: return False, ''
    if caseSensitive:
        idx2 = data.find(marker2, idx1 + len(marker1))
    else:
        idx2 = data.lower().find(marker2.lower(), idx1 + len(marker1))
    if -1 == idx2: return False, ''   
    if withMarkers:
        idx2 = idx2 + len(marker2)
    else:
        idx1 = idx1 + len(marker1)
    return True, data[idx1:idx2]        
#########################################
def _videoLink(content):
    src =''
    evals = re.compile('eval(.*?)\\{\\}\\)\\)',re.DOTALL).findall(content)
    if evals:
        for eval in evals:
            eval=re.sub('  ',' ',eval)
            eval=re.sub('\n','',eval)
            try:
                unp = jsunpack.unpack(eval)
            except:
                unp=''
            if unp:
                unp=re.sub('\\\\','',unp)
                match = re.compile('["\']*file["\']*\\s*:\\s*["\'](.+?)["\'],',  re.DOTALL).search(content)
                match2 = re.compile('["\']file["\']:["\'](.*?\\.mp4)["\']',  re.DOTALL).search(content)
                if match:   src = match.group(1)
                elif match2: src = match2.group(1)
                if src:
                    break
    else:
        match = re.compile('["\']*file["\']*\\s*:\\s*["\'](.+?)["\'],',  re.DOTALL).search(content)
        match2 = re.compile('["\']file["\']:["\'](.*?\\.mp4)["\']',  re.DOTALL).search(content)
        if match:   src = match.group(1)
        elif match2: src = match2.group(1)
        else:
            src = _get_encoded_unpaker(content)
            if not src:
                src = _get_encoded(content)
        
    return src

def getLinkCda(url):
    added='|Cookie=PHPSESSID=1&Referer=http://static.cda.pl/flowplayer/flash/flowplayer.commercial-3.2.18.swf'
    url=url.split('?wersja=')
    try:
        ab=url[0].replace('http://www.cda','https://www.cda')
    except:
        ab=''
    content = getUrl(ab)
    out=[]
    def cdadecode(videofile):
        videofile = cda_replace('1', videofile) ############
        a = videofile
        cc =len(a)
        linkvid=''
        for e in range(cc):
            f = ord(a[e])
            if f >=33 or f <=126:
                b=chr(33 + (f + 14) % 94)
            else:
                b=chr(f)
            linkvid+=b
        if not linkvid.endswith('.mp4'):
            linkvid += '.mp4'
        linkvid = cda_replace('2', linkvid) ############
        if not linkvid.startswith('http'):
            linkvid = 'https://'+linkvid    
        return linkvid
    
    
    
    #def cdadecode(videofile):
    #    a = videofile
    #    cc =len(a)
    #    linkvid=''
    #    for e in range(cc):
    #        f = ord(a[e])
    #        if f >=33 or f <=126:
    #            b=chr(33 + (f + 14) % 94)
    #        else:
    #            b=chr(f)
    #        linkvid+=b
    #    linkvid=linkvid[:-4]
    #    if not linkvid.endswith('.mp4'):
    #        linkvid += '.mp4'
    #    linkvid = linkvid.replace("0)sss.mp4", ".mp4")  
    #    linkvid = linkvid.replace(".cda.mp4", "").replace(".cda.mp4", "").replace(".2cda.pl", ".cda.pl").replace(".3cda.pl", ".cda.pl");
    #    if not linkvid.startswith('http'):
    #        linkvid = 'https://'+linkvid
    #    return linkvid
    if not'Trwa konwersja wgranego' in content and not 'ten link zosta' in content:
        qua = re.compile('a data-quality="(.*?)"(.*?)</div>', re.DOTALL).findall(content)
        if qua:
            srce = re.compile('href="(.*?)"', re.DOTALL).findall(qua[0][1])[::-1]
            for h1 in srce:
                h1=BASEURL+h1 if not h1.startswith('http') else h1
                content2 = getUrl(h1)    
                
                un=_videoLink(content2)
    
                un = cdadecode(unquote(un))        
                un+=added
                h1=h1.split('wersja=')                
                out.append((un,h1[1]))
        else:
            un=_videoLink(content)
            
            un = cdadecode(unquote(un))        
            un+=added
            h1='max'                
            out.append((un,h1))
    else:
        out='trwa konwersja'
    return out
