# -*- coding: utf-8 -*-



import sys,re,os
try:
    # For Python 3.0 and later
    from urllib.parse import urlencode, parse_qsl, parse_qs

    LOGNOTICE = xbmc.LOGINFO
except ImportError:
    # Python 2
    LOGNOTICE = xbmc.LOGNOTICE
    from urlparse import parse_qsl, parse_qs

    from urllib import urlencode

try:
    string_type = basestring
except NameError:
    string_type = (bytes, str)
    unicode = str

import xbmc,xbmcgui,xbmcaddon, xbmcvfs
import xbmcplugin
from six import iteritems

base_url        = sys.argv[0]
addon_handle    = int(sys.argv[1])
args            = parse_qs(sys.argv[2][1:])

my_addon        = xbmcaddon.Addon()
addonName       = xbmcaddon.Addon().getAddonInfo('name')
addonId     = xbmcaddon.Addon().getAddonInfo('id')
PATH            = xbmcaddon.Addon().getAddonInfo('path')

try:
    DATAPATH        = xbmcvfs.translatePath(xbmcaddon.Addon().getAddonInfo('profile'))#.decode('utf-8')
except:
    DATAPATH        = xbmc.translatePath(xbmcaddon.Addon().getAddonInfo('profile')).decode('utf-8')
    
    
RESOURCES       = PATH+'/resources/'
FANART=PATH+'/fanart.jpg'
ICON = PATH+'/icon.png'
import resources.lib.pnews as psnews
def addLinkItem(name, url, mode, params={}, iconImage=None, infoLabels={}, IsPlayable=True,fanart=FANART,itemcount=1):
    u = build_url({'mode': mode, 'foldername': name, 'ex_link' : url, 'params':params})
    liz = xbmcgui.ListItem(name)

    liz.setArt({ 'poster': infoLabels.get('poster',iconImage), 'thumb' : iconImage, 'icon' : iconImage ,'fanart':infoLabels.get('fanart',iconImage),'banner':infoLabels.get('banner',iconImage)})
    infoLabels['url']=str(infoLabels.get('url'))
    liz.setInfo(type='video', infoLabels=infoLabels)
    if IsPlayable:liz.setProperty('IsPlayable', 'true')
    if fanart:liz.setProperty('fanart_image',fanart)
    ok = xbmcplugin.addDirectoryItem(handle=addon_handle, url=u, listitem=liz,isFolder=False,totalItems=itemcount)
    xbmcplugin.setContent(addon_handle, 'videos')    
    xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = '%R, %Y, %P')
    return ok
def addDir(name,url=None, mode='',params={},iconImage=ICON,fanart=FANART,infoLabels={},totalItems=1):
    u = build_url({'mode': mode, 'foldername': name, 'ex_link' : url, 'params':params})

    if iconImage==None:
        iconImage='DefaultFolder.png'

    li = xbmcgui.ListItem(name)
    li.setArt({ 'poster': infoLabels.get('poster',iconImage), 'thumb' : iconImage, 'icon' : iconImage ,'fanart':infoLabels.get('fanart',iconImage),'banner':infoLabels.get('banner',iconImage)})
    if infoLabels: li.setInfo(type='video', infoLabels=infoLabels)
    if fanart:li.setProperty('fanart_image', fanart )
    xbmcplugin.addDirectoryItem(handle=addon_handle, url=u,listitem=li, isFolder=True)

def encoded_dict(in_dict):
    out_dict = {}
    
    try:
        # Python 2
        iter_dict = in_dict.iteritems()
    except AttributeError:
        # Python 3
        iter_dict = in_dict.items()
    
    
    for k, v in iter_dict:
        if isinstance(v, unicode):
            v = v.encode('utf8')
        elif isinstance(v, str):
            v.decode('utf8')
        out_dict[k] = v
    return out_dict
def build_url(query):
    return base_url + '?' + urlencode(encoded_dict(query))
    
def play(url):
    qual=url.keys();
    stream_url=url.get(qual[0]) if qual else ''
    select = xbmcgui.Dialog().select('Jakość', qual)
    if select>-1: stream_url = url.get(qual[select])
    if stream_url: xbmcplugin.setResolvedUrl(addon_handle, True, xbmcgui.ListItem(path=stream_url))
    else: xbmcplugin.setResolvedUrl(addon_handle, False, xbmcgui.ListItem(path=''))

fname = args.get('foldername',[''])[0]
ex_link = args.get('ex_link',[''])[0]
params = args.get('params',[{}])[0]

def router(paramstring):
    args2 = dict(parse_qsl(paramstring))

    if args2:   
        mode = args2.get('mode', None)
        if mode == 'polsatnews_programy':
            items = psnews.getProgramy()
            for item in items:
                addDir(item.get('title'), item.get('url'), params={}, mode='polsatnews_content',infoLabels=item ,iconImage=item.get('img'))
            xbmcplugin.endOfDirectory(addon_handle)
        elif mode == 'polsatnews_content':
            items,pagination = psnews.getContentVideos(ex_link)
            for item in items: addLinkItem(item.get('title',''),  item['url'], mode='polsatnews_play', IsPlayable=True, infoLabels=item, iconImage=item.get('img',''))
            if pagination[1]: addDir('[COLOR blue]>> następna strona >>[/COLOR]', pagination[1], params={}, mode='polsatnews_page',iconImage=RESOURCES+'polsatnews.png')
            xbmcplugin.endOfDirectory(addon_handle)
        
        elif mode == 'polsatnews_content_najnowsze':
            items,pagination = psnews.getVideoList(ex_link)
            for item in items: addLinkItem(item.get('title',''),  item['url'], mode='polsatnews_play', IsPlayable=True, infoLabels=item, iconImage=item.get('img',''))
            xbmcplugin.endOfDirectory(addon_handle)
        elif mode == 'polsatnews_page':
            items,pagination = psnews.getContentVideosJson(ex_link)
            for item in items: addLinkItem(item.get('title',''),  item['url'], mode='polsatnews_play', IsPlayable=True, infoLabels=item, iconImage=item.get('img',''))
            if pagination[1]: addDir('[COLOR blue]>> następna strona >>[/COLOR]', pagination[1], params={}, mode='polsatnews_page',iconImage=RESOURCES+'polsatnews.png')
            xbmcplugin.endOfDirectory(addon_handle)
        elif mode == 'polsatnews_play':
            stream_url = psnews.getVideos(ex_link)
            stream_url=stream_url.get('url',False)
            if stream_url: xbmcplugin.setResolvedUrl(addon_handle, True, xbmcgui.ListItem(path=stream_url))
            else: xbmcplugin.setResolvedUrl(addon_handle, False, xbmcgui.ListItem(path=''))
        elif mode.startswith('polsatnews'):

            if '_play_' in mode:
                stream_url = psnews.getVideos(ex_link)
                stream_url=stream_url.get('url',False)
                if stream_url: xbmcplugin.setResolvedUrl(addon_handle, True, xbmcgui.ListItem(path=stream_url))
                else: xbmcplugin.setResolvedUrl(addon_handle, False, xbmcgui.ListItem(path=''))
            elif 'live' in mode:
                mpd = psnews.getLive()

                play_item = xbmcgui.ListItem(path=mpd)
                
                if sys.version_info >= (3,0,0):
                    play_item.setProperty('inputstream', 'inputstream.adaptive')
                else:
                    play_item.setProperty('inputstreamaddon', 'inputstream.adaptive')
                play_item.setProperty('inputstream.adaptive.manifest_type', 'hls')

                play_item.setContentLookup(False)
                
                xbmcplugin.setResolvedUrl(addon_handle, True, listitem=play_item)

            elif '_folder_' in mode:
                params = eval(params)
                items = psport.getContentDir(**params)
                for item in items:
                    addDir(item.get('title'), ex_link=item.get('url'), params={}, mode='polsatnews_content_',iconImage=item.get('img'))
                xbmcplugin.endOfDirectory(addon_handle)
            elif '_content_' in mode:
                items,pagination = psport.getContentVideos(ex_link)
                if pagination[0]: addLinkItem(name='[COLOR blue]<< poprzednia strona <<[/COLOR]', url='', params=pagination[0], mode='polsatnews_page_', IsPlayable=False)
                for item in items: addLinkItem(item.get('title',''),  item['url'], mode='polsatnews_play_', IsPlayable=True,infoLabels=item, l1ll1l_po_=item.get('img'))
                if pagination[1]: addLinkItem(name='[COLOR blue]>> następna strona >>[/COLOR]', url='', params=pagination[1], mode='polsatnews_page_', IsPlayable=False)
                xbmcplugin.endOfDirectory(addon_handle)
            elif '_page_' in mode:
                url = build_url({'mode': 'polsatnews_content_', 'foldername': '', 'ex_link' : params,'params':'', })
                xbmc.executebuiltin('Container.Refresh(%s)'% url)
            else:
                addDir('Magazyny', ex_link='', params={'type':'magazyny'}, mode='polsatnews_folder_',iconImage=RESOURCES+'polsatnews.png')
                addDir('Dyscypliny', ex_link='', params={'type':'dyscypliny'}, mode='polsatnews_folder_',iconImage=RESOURCES+'polsatnews.png')
                xbmcplugin.endOfDirectory(addon_handle)
    else:
        addLinkItem(name='[COLOR gold][B]Polsat News LIVE[/COLOR][/B]', url='', mode='polsatnews_live', IsPlayable=True)
        for item in psnews.scanStrony():
            addDir(item.get('title',''), url=item.get('url'), mode=item.get('mode'), infoLabels=item,  iconImage=item.get('img',''))
        addDir('Programy','',mode='polsatnews_programy',iconImage=ICON)
        xbmcplugin.endOfDirectory(addon_handle)
if __name__ == '__main__':
    router(sys.argv[2][1:]) 
