# -*- coding: utf-8 -*-

import re,os
import json

import base64

mainurl= 'www.polsatnews.pl'

import six
from six.moves import urllib_request, urllib_parse
from resources.lib.brotlipython import brotlidec
import requests
sess = requests.Session()

def resp_text(resp):
    """Return decoded response text."""

    if resp and resp.headers.get('content-encoding') == 'br':
        out = []
        # terrible implementation but it's pure Python
        return brotlidec(resp.content, out).decode('utf-8')
    page = (resp.content).decode(encoding='utf-8', errors='strict')	if six.PY3 else resp.content
    return page

TIMEOUT = 10
UA='Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/48.0.2564.97 Safari/537.36'

def getUrl(url):

    hdrs = {
        'User-Agent': UA,
    }
    resp = sess.get(url, headers=hdrs, verify=False)
    return resp_text(resp)

def getContentDir(type='magazyny'):
    if type=='magazyny':
        return getMagazyny()
    elif type == 'dyscypliny':
        return getDyscypliny()
    return []
def getDyscypliny():
    url='http://www.polsatnews.pl/wideo-lista/'
    content = getUrl(url)
    out=[]
    ids = [(a.start(), a.end()) for a in re.finditer('<li class="disciplines-aside-', content)]
    ids.append( (-1,-1) )
    out=[]
    mTitle=['[COLOR blue][B]%s[/B][/COLOR]','[COLOR green][B]%s[/B][/COLOR]']
    sTitle=['   [COLOR lightblue]%s[/COLOR]','   [COLOR lightgreen]%s[/COLOR]']
    for i in range(len(ids[:-1])):
        subset = content[ ids[i][1]:ids[i+1][0] ]
        d = re.compile('<a href="(http://www.polsatsport.pl/wideo-kategoria.*)">(.*)</a>').findall(subset)
        if d:
            maind = d.pop(0)
            t=mTitle[i%2]%PLchar(maind[1])
            out.append({'title':t,'url':maind[0],'img':''})
            for item in d:
                    t=sTitle[i%2]%PLchar(item[1])
                    out.append({'title':t,'url':item[0],'img':''})
    return out
def getContent(url,type='magazyny',nextUrl='',prevUrl='',**kwargs):
    if type == 'magazyny':
        return getMagazyny()
    return []
def getVideoList(url):
   # url='http://www.polsatnews.pl/wideo-lista/'

    content = getUrl(url)
    tds = re.compile('<article class="news news--video">(.*?)</article>',re.DOTALL).findall(content)
    out=[]
    nextPage=False
    prevPage=False
    for td in tds:
        href = re.compile('<a href="(.*?)"',).findall(td)
        code = re.compile('datetime="(.+?)"').findall(td)
        title = re.compile('alt="(.*?)"').findall(td)
        imag = re.compile('src="(.*?)"').findall(td)
        if href and title:
            h = href[0]
            t = PLchar(title[0].strip())
            i = imag[0] if imag else ''
            c = code[0] if code else ''
            out.append({'url':h,'title':t,'img':i,'code':c,'plot':t})
    return (out,(prevPage,nextPage))
url='http://www.polsatnews.pl/wjdmhk/module34275/page2/wystarczy-chciec_2855/'
url='http://www.polsat.pl/program/idol/'

def convertUnixTime(liczba):
    import time
    try:
        czas = time.localtime(liczba)
        czas = time.strftime("%Y-%m-%d %H:%M", czas)
    except:
        czas=None
    return czas
    
def getContentVideosJson(url):
    content = getUrl(url)
    jsonData=json.loads(content)
    out=[]
    nextPage=False
    prevPage=False
    for item in jsonData['items']:
        imag= item.get('img').get('maxi')
        href= item.get('url')
        tyt= item.get('title')
        czas=item.get('timestamp')
        czas=convertUnixTime(int(czas)/1000)
        if href and tyt:
            h = href#[0]
            t = PLchar(tyt.strip())
            i = imag if imag else ''
            c = czas if czas else ''
            out.append({'url':h,'title':t,'img':i,'code':'[COLOR green]'+c+'[/COLOR]','plot':t})

    if out:
        pagin=jsonData['button']
        nextPage=re.findall("""data-url=['"](.+?)['"]""",pagin)#[0]
        nextPage=nextPage[0] if nextPage else False
    return (out,(prevPage,nextPage))


def getContentVideos(url):
    content = getUrl(url)
    tds = re.compile('<article(.*?)</article>',re.DOTALL).findall(content)
    out=[]
    nextPage=False
    prevPage=False

    for td in tds:

        href = re.compile('href="(.*?)"',).findall(td)        
        code = re.compile('datetime="(.+?)"').findall(td)
        title = re.compile('alt="(.*?)"').findall(td)
        imag = re.compile('src="(.*?)"').findall(td)
        if href and title:
            h = href[0]
            t = PLchar(title[0].strip())
            i = imag[0] if imag else ''
            c = code[0] if code else ''
            out.append({'url':h,'title':t,'img':i,'code':'[COLOR green]'+c+'[/COLOR]','plot':t})
    if out:
        nextPage = re.compile('pager__button" data-url="(.+?)"').findall(content)
        nextPage = nextPage[0] if nextPage else False
    return (out,(prevPage,nextPage))
url='http://www.polsatsport.pl/magazyn/cafe-futbol-06092015-dogrywka_6345047/'
url='http://www.polsatnews.pl/wideo-program/20170429-wydarzenia-2200_6399340/'
def getVideos(url):
    content = getUrl(url)

    v={'msg':'Video link not found or not supported yet'}
    src = re.compile('<source src="(.*?)" type="video/mp4">').findall(content)
    if not src:
        src = re.compile('<source data-src="(.*?)" type="video/mp4">').findall(content)
    if src:
        v={'msg':'','url':src[0]}
    return v
def test():
    out,pagination = l1l111l1l_po_('http://www.livefootballol.me/video/england/')
    for item in out:
        l1l11ll1l_po_=getVideos(item.get('url'))
    #@    print l1l11ll1l_po_
def _1l11l1ll_po_():
    url='http://www.polsatnews.pl/program/dorotagawrylukzaprasza/'
    content = getUrl(url)
    out=[]
    l11llllll_po_ = re.compile('<ul class="wideo-menu-list">(.*)</ul>',re.DOTALL).findall(content)
    l11llllll_po_ = l11llllll_po_[0] if l11llllll_po_ else ''
    l11lll11l_po_ = re.compile('<a href="(.*?)"').findall(l11llllll_po_)
    for href in l11lll11l_po_:
        if 'http://www.polsatnews.pl/program/' in href:

            content=getUrl(href)
            title = re.compile('<h1 [^>]*>(.*?)</h1>').findall(content)
            title= title[0] if title else ''
            code= re.compile('<div class="np-date">(.*?)</div>').findall(content)
            code= code[0] if code else ''
            plot = re.compile('<p>(.*?)</p>',re.DOTALL).findall(content)
            plot = plot[0] if plot else ''
            imag=re.compile('<figure>\\s*<img src="(.*?)"',re.DOTALL).findall(content)
            imag = imag[0] if imag else ''
            url = re.compile('jQuery.ajax\\(\\{url: [\'"](http://www.polsatnews.pl/.*?)[\'"]').findall(content)
            if url and title:
                out.append({'title':PLchar(title),'url':url[0],'plot':PLchar(plot),'img':imag,'code':code})
    return out
    
def getLive():
    content = getUrl('http://polsatnews.pl/wideo-lista')
    stru = re.findall('embed__iframe.*?data\-src="(.+?)"',content, re.DOTALL)[0]
    content = getUrl(stru)
    mid = re.findall('mediaId\:\s*"(.+?)"',content, re.DOTALL)[0]
    playerDataUrl = re.findall('playerDataUrl\:\s*"(.+?)"',content, re.DOTALL)[0]
    playerDataUrl = playerDataUrl.replace('MEDIA_ID', mid)
    content = getUrl(playerDataUrl)
    urlqual = re.findall('url"\:"([^"]+)".+?quality":"([^"]+)"', content, re.DOTALL)#[0]
    for url,qual in urlqual:
        if '720' in qual:
            return url+'|User-Agent='+UA
def scanStrony():
    out=[
        {'img': 'http://s.redefine.pl/dcs/o2/redefine/cp/r4/r412vb83za8aj3jm3mbmzhjsjj6fdui6.jpg',
        'plot': 'Flagowy program Telewizji Polsat i kana\xc5\x82u informacyjnego Polsat News. Zespó "Wydarze\xc5\x84" przedstawia wiarygodne i obiektywne informacje dotycz\xc4\x85ce bie\xc5\xbc\xc4\x85cych zdarze\xc5\x84. Wiele przedstawionych materia\xc5\x82\xc3\xb3w po\xc5\x9bwi\xc4\x99conych jest problematyce spo\xc5\x82ecznej.&nbsp;',
        'title': 'Wydarzenia','mode':'polsatnews_content',
        'url': 'http://www.polsatnews.pl/program/wydarzenia/'},
        {'img': 'https://encrypted-tbn3.gstatic.com/images?q=tbn:ANd9GcSVVDeAFFcJiLVgAhAmOGRAAJqKk-7PrBDTte9ea2Fiu-v0PNo2sQ','plot': '','mode':'polsatnews_content_najnowsze',
        'title': ' [COLOR blue]Najnowsze[/COLOR]', 'url': 'http://www.polsatnews.pl/wideo-najnowsze/'},
        {'img': 'https://encrypted-tbn3.gstatic.com/images?q=tbn:ANd9GcSVVDeAFFcJiLVgAhAmOGRAAJqKk-7PrBDTte9ea2Fiu-v0PNo2sQ','plot': '','mode':'polsatnews_content',
        'title': ' [COLOR blue]Kraj[/COLOR]', 'url': 'http://www.polsatnews.pl/wideo-kategoria/kraj/'},
        {'img': 'https://encrypted-tbn3.gstatic.com/images?q=tbn:ANd9GcSVVDeAFFcJiLVgAhAmOGRAAJqKk-7PrBDTte9ea2Fiu-v0PNo2sQ','plot': '','mode':'polsatnews_content',
        'title': ' [COLOR blue]Świat[/COLOR]', 'url': 'http://www.polsatnews.pl/wideo-kategoria/swiat/'},
        {'img': 'https://encrypted-tbn3.gstatic.com/images?q=tbn:ANd9GcSVVDeAFFcJiLVgAhAmOGRAAJqKk-7PrBDTte9ea2Fiu-v0PNo2sQ','plot': '','mode':'polsatnews_content',
        'title': ' [COLOR blue]Biznes[/COLOR]', 'url': 'http://www.polsatnews.pl/wideo-kategoria/biznes/'},
        {'img': 'https://encrypted-tbn3.gstatic.com/images?q=tbn:ANd9GcSVVDeAFFcJiLVgAhAmOGRAAJqKk-7PrBDTte9ea2Fiu-v0PNo2sQ','plot': '','mode':'polsatnews_content',
        'title': ' [COLOR blue]Technologie i Medycyna[/COLOR]', 'url': 'http://www.polsatnews.pl/wideo-kategoria/nauka-technologie-medycyna/'},
        {'img': 'https://encrypted-tbn3.gstatic.com/images?q=tbn:ANd9GcSVVDeAFFcJiLVgAhAmOGRAAJqKk-7PrBDTte9ea2Fiu-v0PNo2sQ','plot': '','mode':'polsatnews_content',
        'title': ' [COLOR blue]Rozrywka[/COLOR]', 'url': 'http://www.polsatnews.pl/wideo-kategoria/rozrywka/'},
        {'img': 'https://encrypted-tbn3.gstatic.com/images?q=tbn:ANd9GcSVVDeAFFcJiLVgAhAmOGRAAJqKk-7PrBDTte9ea2Fiu-v0PNo2sQ','plot': '','mode':'polsatnews_content',
        'title': ' [COLOR blue]Moto[/COLOR]', 'url': 'https://www.polsatnews.pl/wideo-kategoria/moto/'},
        ]
    return out
def getProgramy():
    out=[
        {'code': 'NIEDZIELA 10:00','img': 'https://s.redefine.pl/file/o2/redefine/cp/jw/jwiw477nhj9f2rrme5j1sb4ku644z8yg.jpg','plot': '','title': 'Cztery strony prasy','url': 'http://www.polsatnews.pl/program/cztery-strony-prasy/'},
        {'code': 'PONIEDZIAŁEK-PIĄTEK 07:45','img': 'http://s.redefine.pl/dcs/o2/redefine/cp/gm/gm8hoao3wnriigx118a4hkaxf5nkjb4b.jpg','plot': '','title': 'Graffiti','url': 'http://www.polsatnews.pl/program/graffiti/'},
        {'code': 'SOBOTA 16:30','img': 'http://s.redefine.pl/dcs/o2/redefine/cp/jd/jdj3fop9z35856jrieowfsg9sawfhhkj.jpg','plot': '','title': 'Horyzont zdarzeń','url': 'http://www.polsatnews.pl/program/horyzont-zdarzen/'},
        {'code': 'PONIEDZIAŁEK-PIĄTEK, POLSAT 16:15, POLSAT NEWS 18:30','img': 'http://s.redefine.pl/dcs/o2/redefine/cp/jr/jrqrwz6yf7k46mmbv9xqwgc44i5rkp8p.jpg','plot': '','title': 'Interwencja','url': 'http://www.polsatnews.pl/program/interwencja/'},
        {'code': 'NIEDZIELA 19:30','img': 'http://s.redefine.pl/dcs/o2/redefine/cp/e3/e3fweha2kkurjk5fnhvrx6a32ogfuvjq.jpg','plot': '','title': 'Państwo w Państwie','url': 'http://www.polsatnews.pl/program/panstwo-w-panstwie/'},
        {'code': 'PONIEDZIAŁEK-PIĄTEK 20:00','img': 'https://s.redefine.pl/file/o2/redefine/cp/zp/zprf2h868doadu1rw9ezhyrw3zggzety.jpg','plot': '','title': 'Polityka na Ostro','url': 'http://www.polsatnews.pl/program/polityka-na-ostro/'},
        {'code': 'PIĄTEK 21:00','img': 'http://s.redefine.pl/dcs/o2/redefine/cp/r8/r824on2va2d26q7k2hgc1yqma7z14b7c.jpg','plot': '','title': 'Prezydenci i Premierzy','url': 'http://www.polsatnews.pl/program/prezydenci-i-premierzy/'},
        {'code': 'SOBOTA 20:00','img': 'http://s.redefine.pl/dcs/o2/redefine/cp/ak/akkiu5yrsyzj78xf1n484qpw1yk28w1f.jpg','plot': '','title': 'Skandaliści','url': 'http://www.polsatnews.pl/program/skandalisci/'},
        {'code': 'NIEDZIELA 9:00','img': 'http://s.redefine.pl/file/o2/redefine/cp/a2/a2oi9b1j89ib7xznb2obcy36zew25o2y.jpg','plot': '','title': 'Śniadanie w Polsat News','url': 'http://www.polsatnews.pl/program/sniadanie-w-polsat-news/'},
        {'code': 'SOBOTA 9:30','img': 'http://s.redefine.pl/dcs/o2/redefine/cp/g4/g41pb3p3bivrwxstyey4b2t9jdq5otad.jpg','plot': '','title': 'Top wtop','url': 'http://www.polsatnews.pl/program/top-wtop/'},
        {'code': '&nbsp;','img': 'http://s.redefine.pl/dcs/o2/redefine/cp/hr/hr7ggvj3r1z28m5i5hism8pdcdt5s9xm.png','plot': '','title': 'Transmisje live. Zapis','url': 'http://www.polsatnews.pl/program/archiwum-wydarzen/'},
        {'code': 'SOBOTA 11:30','img': 'http://s.redefine.pl/file/o2/redefine/cp/e2/e2gz4doter4kvto3mzhpv4fikc622zr9.jpg','plot': '','title': 'W bliskim planie','url': 'http://www.polsatnews.pl/program/w-bliskim-planie/'},
        {'code': 'CODZIENNIE','img': 'http://s.redefine.pl/dcs/o2/redefine/cp/r4/r412vb83za8aj3jm3mbmzhjsjj6fdui6.jpg','plot': '','title': 'Wydarzenia 18:50','url': 'http://www.polsatnews.pl/program/wydarzenia/'},
        {'code': 'PONIEDZIAŁEK-PIĄTEK 19:15','img': 'http://s.redefine.pl/file/o2/redefine/cp/d4/d46tqb8dmm2tb2gjkr6a32xojjcybpoc.png','plot': '','title': 'Wydarzenia i Opinie','url': 'http://www.polsatnews.pl/program/wydarzenia-i-opinie/'},
        {'code': 'NIEDZIELA 13:30','img': 'http://s.redefine.pl/dcs/o2/redefine/cp/hu/huf51g63ikbek37fsws9omvevmfxvrga.jpg','plot': '','title': 'Wystarczy Chcieć','url': 'http://www.polsatnews.pl/program/wystarczy-chciec/'},
  ]
    return out
def PLchar(txt):
	
    txt = txt.replace('&#215;','x')    

    if type(txt) is not str:
        txt=txt.encode('utf-8')
        
    txt = txt.replace('&lt;br/&gt;',' ')

    txt = txt.replace('','').replace('','')
    txt = txt.replace('&nbsp;','')
    txt = txt.replace('&quot;','"').replace('&amp;quot;','"')
    txt = txt.replace('&oacute;','ó').replace('&Oacute;','Ó')
    txt = txt.replace('&amp;oacute;','ó').replace('&amp;Oacute;','Ó')
    txt = txt.replace('&amp;','&')
    
    txt = txt.replace('\u0105','ą').replace('\u0104','Ą')
    txt = txt.replace('\u0107','ć').replace('\u0106','Ć')
    txt = txt.replace('\u0119','ę').replace('\u0118','Ę')
    txt = txt.replace('\u0142','ł').replace('\u0141','Ł')
    txt = txt.replace('\u0144','ń').replace('\u0144','Ń')
    txt = txt.replace('\u00f3','ó').replace('\u00d3','Ó')
    txt = txt.replace('\u015b','ś').replace('\u015a','Ś')
    txt = txt.replace('\u017a','ź').replace('\u0179','Ź')
    txt = txt.replace('\u017c','ż').replace('\u017b','Ż')
    return txt

