# -*- coding: utf-8 -*-

import urllib2,urllib,json
import re,os
from urlparse import urlparse
import base64
import cookielib
mainurl= 'www.polsatsport.pl'
TIMEOUT = 10
UA='Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/48.0.2564.97 Safari/537.36'
def getUrl(url,data=None,cookies=None):
    req = urllib2.Request(url,data)
    req.add_header('User-Agent', UA)
    if cookies:
        req.add_header('Cookie', cookies)
    try:
        response = urllib2.urlopen(req,timeout=TIMEOUT)
        link = response.read()
        response.close()
    except:
        link=''
    return link
def getContentDir(type='magazyny'):
    if type=='magazyny':
        return getMagazyny()
    elif type == 'dyscypliny':
        return getDyscypliny()
    return []
def getDyscypliny():
    url='http://www.polsatsport.pl/wideo-lista/'
    content = getUrl(url)
    out=[]
    ids = [(a.start(), a.end()) for a in re.finditer('<li class="disciplines-aside-', content)]
    ids.append( (-1,-1) )
    out=[]
    mTitle=['[COLOR blue][B]%s[/B][/COLOR]','[COLOR green][B]%s[/B][/COLOR]']
    sTitle=['   [COLOR lightblue]%s[/COLOR]','   [COLOR lightgreen]%s[/COLOR]']
    for i in range(len(ids[:-1])):
        subset = content[ ids[i][1]:ids[i+1][0] ]
        d = re.compile('<a href="(http://www.polsatsport.pl/wideo-kategoria.*)">(.*)</a>').findall(subset)
        if d:
            maind = d.pop(0)
            t=mTitle[i%2]%PLchar(maind[1])
            out.append({'title':t,'url':maind[0],'img':''})
            for item in d:
                    t=sTitle[i%2]%PLchar(item[1])
                    out.append({'title':t,'url':item[0],'img':''})
    return out
def getContent(url,type='magazyny',nextUrl='',prevUrl='',**kwargs):
    if type == 'magazyny':
        return getMagazyny()
    return []
def getConentVideos(url):
    content = getUrl(url)
    tds = re.compile('<article(.*?)</article>',re.DOTALL).findall(content)
    out=[]
    nextPage=False
    prevPage=False
    for td in tds:
        href = re.compile('<a href="(.*?)"',).findall(td)
        title = re.compile('alt="(.*?)"').findall(td)
        imag = re.compile('src="(.*?)"').findall(td)
        if href and title:
            h = href[0]
            t = PLchar(title[0].strip())
            i = imag[0] if imag else ''
            out.append({'url':h,'title':t,'img':i})
    if out:
        nextPage = re.compile('<a href="(.*?)" class="next-page ico"></a>').findall(content)
        nextPage = nextPage[0] if nextPage else False
        prevPage = re.compile('<a href="(.*?)" class="prev-page ico"></a>').findall(content)
        prevPage = prevPage[0] if prevPage else False
    return (out,(prevPage,nextPage))
url='http://www.polsatsport.pl/magazyn/cafe-futbol-06092015-dogrywka_6345047/'
def getVideos(url):
    content = getUrl(url)
    v={'msg':'Video link not found or not supported yet'}
    src = re.compile('<source src="(.*?)" type="video/mp4">').findall(content)
    if src:
        v={'msg':'','url':src[0]}
    return v

def _scanMagazyny():
    url='http://www.polsatsport.pl/program/atleci/'
    content = getUrl(url)
    out=[]
    magazyny = re.compile('<li class="disciplines-aside-item"><a href="(.*)" [^>]*>(.*)</a></li>').findall(content)
    for magazyn in magazyny:
        tmp=getUrl(magazyn[0])
        plot = re.compile('<div class="article-preview"(.*?)</div>',re.DOTALL).findall(tmp)
        plot = plot[0] if plot else ''
        if plot:
            plot = re.compile('<p><span>(.*?)</span></p>').findall(plot)
            plot = PLchar(plot[0]) if plot else ''
        imag=re.compile('<div class="fl-right">\\s*<figure>\\s*<img src="(.*?)"',re.DOTALL).findall(tmp)
        imag = imag[0] if imag else ''
        out.append({'title':PLchar(magazyn[1]),'url':magazyn[0],'plot':plot,'img':imag})
    return out
def getMagazyny():
    out=[{'img': 'http://s.redefine.pl/dcs/o2/redefine/cp/p8/p8par25wy336d3ynjs5gcgi4nrbmnqzo.jpg',
            'plot': 'Atleci to program dla wszystkich, kt\xc3\xb3rzy kochaj\xc4\x85 sport - i ogl\xc4\x85da\xc4\x87, i uprawia\xc4\x87, a w nim co tydzie\xc5\x84 rozmowy z gwiazdami lekkiej atletyki, wiadomo\xc5\x9bci ze \xc5\x9bwiata kr\xc3\xb3lowej sportu; poka\xc5\xbcemy tak\xc5\xbce, \xc5\xbce biega\xc4\x87 ka\xc5\xbcdy mo\xc5\xbce.',
            'title': 'Atleci',
            'url': 'http://www.polsatsport.pl/program/atleci/'},
            {'img': 'http://s.redefine.pl/dcs/o2/redefine/cp/nm/nm1vnqzacinsd1rhet1zkdr4wdptch7t.jpg',
            'plot': '',
            'title': 'Cafe Futbol',
            'url': 'http://www.polsatsport.pl/program/cafe-futbol/'},
            {'img': 'http://s.redefine.pl/dcs/o2/redefine/cp/f8/f8rpnhhyf1srvkufno325j4w1adfj2fn.jpg',
            'plot': '',
            'title': 'Fanatyk',
            'url': 'http://www.polsatsport.pl/program/fanatyk/'},
            {'img': 'http://s.redefine.pl/dcs/o2/redefine/cp/rc/rcquncrsj893hhoe92vbp7bo4pn2sam7.jpg',
            'plot': 'Magazyn o pi\xc5\x82ce kopanej realizowany podczas mistrzostw \xc5\x9bwiata Brazylia 2014 przy wsp\xc3\xb3\xc5\x82pracy z redaktorami Wydawnictwa Kopalnia - Markiem Wawrzynowskim i Piotrem \xc5\xbbelaznym. W ka\xc5\xbcdym odcinku wyj\xc4\x85tkowy futbolowy go\xc5\x9b\xc4\x87!',
            'title': 'Kopalnia',
            'url': 'http://www.polsatsport.pl/program/kopalnia/'},
            {'img': 'http://s.redefine.pl/dcs/o2/redefine/cp/ta/ta3iaw7gfyeukidot3cz3rn4vme19v82.jpg',
            'plot': 'Najlepszy w Polsce magazyn sportowy po\xc5\x9bwi\xc4\x99cony pi\xc5\x82ce siatkowej.',
            'title': 'Kr\xc3\xb3tka Pi\xc5\x82ka',
            'url': 'http://www.polsatsport.pl/program/krotka-pilka/'},
            {'img': 'http://s.redefine.pl/dcs/o2/redefine/cp/h9/h9uuvp49kw6zi15udd6tucky3g3sftmr.jpg',
            'plot': 'Roman Ko\xc5\x82to\xc5\x84 rozmawia z wybitnymi postaciami polskiego i \xc5\x9bwiatowego sportu.',
            'title': 'Kulisy Sportu',
            'url': 'http://www.polsatsport.pl/program/kulisy-sportu/'},
            {'img': 'http://s.redefine.pl/dcs/o2/redefine/cp/9n/9n1sh7rrxogqt8dnkzeys5jkoo6sqvyd.jpg',
            'plot': '',
            'title': 'Magazyn Koszykarski',
            'url': 'http://www.polsatsport.pl/program/magazyn-koszykarski/'},
            {'img': 'http://s.redefine.pl/dcs/o2/redefine/cp/hv/hv763sufe8uib61r5vgvidw35u4k37fa.png',
            'plot': 'KSW action to nowy projekt ipla, stworzony wsp\xc3\xb3lnie z federacj\xc4\x85 KSW, ma w swoim za\xc5\x82o\xc5\xbceniu przybli\xc5\xbcy\xc4\x87 widzom niezwykle emocjonuj\xc4\x85c\xc4\x85 i widowiskow\xc4\x85 dyscyplin\xc4\x99, jak\xc4\x85 jest MMA.&nbsp;</span><br /><br /><span>KSW Action to oko\xc5\x82o p\xc3\xb3\xc5\x82godzinna porcja wiadomo\xc5\x9bci ze \xc5\x9bwiata MMA. W ka\xc5\xbcdym odcinku zobaczymy obszerny wywiad, unikalne felietony oraz reporta\xc5\xbce, ca\xc5\x82o\xc5\x9b\xc4\x87 uzupe\xc5\x82nia specjalny przegl\xc4\x85d aktualno\xc5\x9bci zrobiony we wsp\xc3\xb3\xc5\x82pracy z portalem MMA Rocks.',
            'title': 'Magazyn KSW Action',
            'url': 'http://www.polsatsport.pl/program/magazyn-ksw-action/'},
            {'img': 'http://s.redefine.pl/dcs/o2/redefine/cp/1k/1kb4vpx9pgnmetpoi73zyjpzfagxx1hh.jpg',
            'plot': 'Znajdziesz tu przegl\xc4\x85d wydarze\xc5\x84 z polskich rozgrywek ligowych. Dowiesz si\xc4\x99 co wydarzy\xc5\x82o si\xc4\x99 ostatnio w krajowej siatk\xc3\xb3wce, pi\xc5\x82ce r\xc4\x99cznej czy \xc5\xbcu\xc5\xbclu.',
            'title': 'Magazyn Liga',
            'url': 'http://www.polsatsport.pl/program/magazyn-liga/'},
            {'img': 'http://s.redefine.pl/dcs/o2/redefine/cp/y8/y86z94886b3e9xvqn45vmf7rc3a4w77e.jpg',
            'plot': "Wszystko o polskim 'szczypiorniaku', czyli pi\xc5\x82ce r\xc4\x99cznej. Cotygodniowe, podsumowanie kolejek polskiej Superligi kobiet i m\xc4\x99\xc5\xbcczyzn, wyst\xc4\x99p\xc3\xb3w Vive Kielce w Lidze Mistrz\xc3\xb3w i naszych obu reprezentacji. W programie nie zabraknie te\xc5\xbc publicystyki i rozm\xc3\xb3w z trenerami, pi\xc5\x82karzami i ekspertami. Gospodarzami magazynu s\xc4\x85 dziennikarze Polsatu Sport Tomasz W\xc5\x82odarczyk i Marcin Muras.&nbsp;",
            'title': 'Magazyn Pi\xc5\x82ki R\xc4\x99cznej',
            'url': 'http://www.polsatsport.pl/program/magazyn-pilki-recznej/'},
            {'img': 'http://s.redefine.pl/dcs/o2/redefine/cp/an/anu5dgoe4f8vpit4pzfp8t7493acow27.jpg',
            'plot': 'Magazyn SET powsta\xc5\x82 z my\xc5\x9bl\xc4\x85 o kibicach siatk\xc3\xb3wki. Znajdziesz w nim rozmowy z lud\xc5\xbami zwi\xc4\x85zanymi z tym sportem. Gospodarzem programu jest Krzysztof Wanio.',
            'title': 'Magazyn SET',
            'url': 'http://www.polsatsport.pl/program/magazyn-set/'},
            {'img': 'http://s.redefine.pl/dcs/o2/redefine/cp/qr/qrhwg294tqbh9jz2gc7ao12oui7i9i3a.jpg',
            'plot': 'Najlepszy, najtrudniejszy, najwa\xc5\xbcniejszy&hellip; Szablonowe has\xc5\x82a te\xc5\xbc mog\xc4\x85 by\xc4\x87 NAJ, a nawet &bdquo;NAJz&hellip;&rdquo;, je\xc5\x9bli sportowiec chce zmierzy\xc4\x87 si\xc4\x99 ze swoimi decyzjami, wspomnieniami, sukcesami lub pasjami. Tylko w IPLI nowy program, dzi\xc4\x99ki kt\xc3\xb3remu poznasz r\xc3\xb3\xc5\xbcne oblicza NAJlepszych, NAJciekawszych, NAJoryginalniejszych sportowc\xc3\xb3w!',
            'title': 'NAJZ...',
            'url': 'http://www.polsatsport.pl/program/najz/'},
            {'img': 'http://s.redefine.pl/dcs/o2/redefine/cp/rn/rn1k1wiqepbbupk71sw6u4bg9ywvqb9x.jpg',
            'plot': 'Nowy program boksera i zawodnika MMA Przemys\xc5\x82awa Salety oraz komentatora sport\xc3\xb3w walki Jerzego Mielewskiego. W ka\xc5\xbcdym odcinku prowadz\xc4\x85cy zaprezentuj\xc4\x85 sylwetk\xc4\x99 odnosz\xc4\x85cego sukcesy boksera. Widzowie b\xc4\x99d\xc4\x85 mieli okazj\xc4\x99 pozna\xc4\x87 histori\xc4\x99 kariery zawodowej Tomasza Adamka, Krzysztofa &bdquo;Diablo&rdquo; W\xc5\x82odarczyka, Mike&rsquo;a Tysona czy Oskara de la Hoyi.',
            'title': 'Pi\xc4\x99\xc5\x9bciarze',
            'url': 'http://www.polsatsport.pl/program/piesciarze/'},
            {'img': 'http://s.redefine.pl/dcs/o2/redefine/cp/nu/nuua357y1c5ciskg7pq19iutav1mxq8x.jpg',
            'plot': '',
            'title': 'Polska 2016 - Magazyn Pi\xc5\x82ki R\xc4\x99cznej',
            'url': 'http://www.polsatsport.pl/program/polska-2016-magazyn-pilki-recznej/'},
            {'img': 'http://s.redefine.pl/dcs/o2/redefine/cp/3u/3uax93kys2g3uxtuctdzw2vt61bw9fcm.jpg',
            'plot': '&bdquo;Polska Liga Cudzoziemska&rdquo; to propozycja dla kibic\xc3\xb3w, kt\xc3\xb3rzy chcieliby pozna\xc4\x87 kulisy \xc5\xbcycia polskich sportowc\xc3\xb3w, wyst\xc4\x99puj\xc4\x85cych w barwach zagranicznych klub\xc3\xb3w. Odwiedzimy wielu z nich i b\xc4\x99dziemy \xc5\x9bwiadkami jednego dnia z \xc5\xbcycia poszczeg\xc3\xb3lnych os\xc3\xb3b towarzysz\xc4\x85c im w codziennych zaj\xc4\x99ciach domowo-rodzinnych oraz treningach lub wyst\xc4\x99pach w klubie.',
            'title': 'Polska Liga Cudzoziemska',
            'url': 'http://www.polsatsport.pl/program/polska-liga-cudzoziemska/'},
            {'img': 'http://s.redefine.pl/dcs/o2/redefine/cp/2y/2y3ke55pagen5hdae7xv2v9vkzufmebn.jpg',
            'plot': 'Wszystko co powiniene\xc5\x9b wiedzie\xc4\x87 o sportach walki, \xc5\xbceby by\xc4\x87 na bie\xc5\xbc\xc4\x85co. Prowadz\xc4\x85cy Mateusz Borek wraz z zaproszonymi go\xc5\x9b\xc4\x87mi i ekspertami dyskutuj\xc4\x85 nie tylko o boksie zawodowym, ale i amatorskim. Zajmuj\xc4\x85 si\xc4\x99 tak\xc5\xbce tematami zwi\xc4\x85zanymi z MMA.',
            'title': 'Puncher',
            'url': 'http://www.polsatsport.pl/program/puncher/'},
            {'img': 'http://s.redefine.pl/dcs/o2/redefine/cp/x5/x5npvv9qnx6w5853123xjow1iuc84gka.jpg',
            'plot': 'Jak wygl\xc4\x85da \xc5\xbcycie siatkarza na walizkach? Kto ma najwi\xc4\x99ksze poczucie humoru? Co robi\xc4\x85 siatkarze, jak nie graj\xc4\x85 i nie trenuj\xc4\x85? Zobacz koniecznie! Kadziu projekt oraz Ig\xc5\x82\xc4\x85 Szyte.',
            'title': 'Siatkarska Reprezentacja Inaczej',
            'url': 'http://www.polsatsport.pl/program/siatkarska-reprezentacja-inaczej/'},
            {'img': 'http://s.redefine.pl/dcs/o2/redefine/cp/g9/g93drifcgpm58k2u9xk2fz5vbjyanu44.jpg',
            'plot': 'Aktualno\xc5\x9bci, relacje z konferencji, wywiady - to wszystko znajdziecie w sport news. Wiadomo\xc5\x9bci ze \xc5\x9bwiata sportu dla prawdziwych kibic\xc3\xb3w!',
            'title': 'Sport News',
            'url': 'http://www.polsatsport.pl/program/sport-news/'},
            {'img': 'http://s.redefine.pl/dcs/o2/redefine/cp/e4/e42jii77qoowhugr8mhgs1cvmzpre2ea.jpg',
            'plot': 'Autorski program Bo\xc5\xbcydara Iwanowa, jednego z czo\xc5\x82owych komentator\xc3\xb3w mecz\xc3\xb3w pi\xc5\x82karskich, w kt\xc3\xb3rym przybli\xc5\xbca nam sylwetki prawdziwych facet\xc3\xb3w! Sportowcy, biznesmeni... Supermani!',
            'title': 'Superman',
            'url': 'http://www.polsatsport.pl/program/superman/'},
            {'img': 'http://s.redefine.pl/dcs/o2/redefine/cp/4g/4gkhr26sse983xvq8dxwn4qb21i2jkor.jpg',
            'plot': 'Bokserskie pojedynki na s\xc5\x82owa! Szczero\xc5\x9b\xc4\x87, emocje, adrenalina. Oto konfrontacje pi\xc4\x99\xc5\x9bciarzy przed najwa\xc5\xbcniejszymi galami transmitowanymi na antenie Polsatu. Zawodnicy zaproszeni do naro\xc5\xbcnika siadaj\xc4\x85 twarz\xc4\x85 w twarz, mog\xc4\x85 spojrze\xc4\x87 sobie prosto w oczy i stoczy\xc4\x87 s\xc5\x82own\xc4\x85 walk\xc4\x99. Program prowadzi: Mateusz Borek',
            'title': 'W naro\xc5\xbcniku Polsatu',
            'url': 'http://www.polsatsport.pl/program/w-narozniku-polsatu/'},
            {'img': 'http://s.redefine.pl/dcs/o2/redefine/cp/et/et4tryz11hv33duz9zxcbyoe2waee391.jpg',
            'plot': 'Program Przemys\xc5\x82awa Salety, w kt\xc3\xb3rym bokser przybli\xc5\xbcy widzom Polsat Play polsk\xc4\x85 scen\xc4\x99 sport\xc3\xb3w walki, takich jak: MMA, K1, boks, kickboxing. Sporty te, mimo i\xc5\xbc widowiskowe, nie s\xc4\x85 w naszym kraju powszechnie znane.&nbsp;</span><br /><span>W ka\xc5\xbcdym odcinku Przemys\xc5\x82aw Saleta przeprowadzi wywiad ze sportowcem, kt\xc3\xb3ry odnosi sukcesy w jednej z dyscyplin sport\xc3\xb3w walki, m.in. z Paw\xc5\x82em Nastul\xc4\x85, Marcinem R\xc3\xb3\xc5\xbcalskim, Markiem Piotrowskim czy Mamedem Khalidovem.',
            'title': 'Wojownicy',
            'url': 'http://www.polsatsport.pl/program/wojownicy/'},
            {'img': 'http://s.redefine.pl/dcs/o2/redefine/cp/wj/wj2h8s9pumnuc4r5yczso6t22aisntkf.jpg',
            'plot': 'Program, w kt\xc3\xb3rym prowadz\xc4\x85cy w zabawny spos\xc3\xb3b komentuj\xc4\x85 kr\xc3\xb3tkie filmy b\xc4\x99d\xc4\x85ce zapisem spektakularnych, ciekawych, czasem \xc5\x9bmiesznych, ale zazwyczaj nieudanych akcji sportowych ze \xc5\x9bwiata. Nie chc\xc4\x85c ogranicza\xc4\x87 si\xc4\x99 jedynie do pi\xc5\x82ki no\xc5\xbcnej, si\xc4\x99gaj\xc4\x85 po interesuj\xc4\x85ce zapisy dziwnych przypadk\xc3\xb3w w niemal wszystkich dziedzinach sportowych, wybieraj\xc4\x85c jedynie najzabawniejsze i najbardziej zaskakuj\xc4\x85ce z nich.',
            'title': 'Wysportowani',
            'url': 'http://www.polsatsport.pl/program/wysportowani/'}]
    return out
def PLchar(char):
    char = char.replace('\\u0105','\xc4\x85').replace('\\u0104','\xc4\x84')
    char = char.replace('\\u0107','\xc4\x87').replace('\\u0106','\xc4\x86')
    char = char.replace('\\u0119','\xc4\x99').replace('\\u0118','\xc4\x98')
    char = char.replace('\\u0142','\xc5\x82').replace('\\u0141','\xc5\x81')
    char = char.replace('\\u0144','\xc5\x84').replace('\\u0144','\xc5\x83')
    char = char.replace('\\u00f3','\xc3\xb3').replace('\\u00d3','\xc3\x93')
    char = char.replace('\\u015b','\xc5\x9b').replace('\\u015a','\xc5\x9a')
    char = char.replace('\\u017a','\xc5\xba').replace('\\u0179','\xc5\xb9')
    char = char.replace('\\u017c','\xc5\xbc').replace('\\u017b','\xc5\xbb')
    return char