import json

import sys, io, os
import calendar
from datetime import datetime, timedelta
import time
import collections

import iso8601
import requests
from urllib.parse import quote, unquote

import xbmc
import xbmcgui
import xbmcvfs
import xbmcaddon
import xbmcplugin

from resources.lib.brotlipython import brotlidec

def resp_text(resp):
	"""Return decoded response text."""
	if resp and resp.headers.get('content-encoding') == 'br':
		out = []
		# terrible implementation but it's pure Python
		return brotlidec(resp.content, out).decode('utf-8')
	response_content = resp.text

	return response_content.replace("\'",'"')

class Helper:
	def __init__(self, base_url=None, handle=None):
		self.base_url = base_url
		self.handle = handle
		self.addon = xbmcaddon.Addon()
		self.addon_name = xbmcaddon.Addon().getAddonInfo('id')
		self.addon_version = xbmcaddon.Addon().getAddonInfo('version')
		self.datapath = self.translate_path(self.get_path('profile'))
		
		self.art = {'icon': self.addon.getAddonInfo('icon'),
					'fanart': self.addon.getAddonInfo('fanart'),
				}
		
		
		
		self.proxyport = self.get_setting('proxyport')

		self._sess = None
	  #  self.kuk = {}

		# API
		self.params = {'platform': 'BROWSER','system': 'tvonline','language': 'pl'}
		
		#AUTH_USER
		

		self.uuid = self.get_setting('uuid') 
		self.bearer = self.get_setting('bearer') 
		self.raz = self.get_setting('raz') 
		
		self.UA ='Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:108.0) Gecko/20100101 Firefox/108.0'

		self.api_url = 'https://api.redcarpet.blueonline.tv/{}'

		self.headers = {
			'Host': 'api.redcarpet.blueonline.tv',
			'user-agent': self.UA,
			'accept': 'application/json',
			'accept-language': 'pl,en-US;q=0.7,en;q=0.3',
			'access-control-allow-origin': '*',
			'api-deviceuid': self.uuid,
			'api-device':  'Kodi; 19; Windows; 19; Windows; 19;',
			'origin': 'https://www.redgo.film',
			'dnt': '1',
			'referer': 'https://www.redgo.film/',
			'sec-fetch-dest': 'empty',
			'sec-fetch-mode': 'cors',
			'sec-fetch-site': 'cross-site',
			# Requests doesn't support trailers
			# 'te': 'trailers',
		}
		
		if self.bearer:
			self.headers.update({'authorization': 'Bearer '+self.bearer })
		
		
		

		self.subscrlogin = self.api_url.format('subscriber/login')

		self.login = self.get_setting('login')
		self.password = self.get_setting('password')


	@property
	def sess(self):
		if self._sess is None:
			self._sess = requests.Session()
			#if self.kukis:
			 #   self._sess.cookies.update(self.kukis)
				
				
			#	self._sess.cookies.update(self.kuk)

		return self._sess	

	def input_dialog(self, text, typ=None):
		typ = xbmcgui.INPUT_ALPHANUM if not typ else typ
		return xbmcgui.Dialog().input(text, type=typ)
		
	def get_path(self ,data):	
		return self.addon.getAddonInfo(data)
		
	def translate_path(self ,data):
		try:
			return xbmcvfs.translatePath(data)
		except:
			return xbmc.translatePath(data).decode('utf-8')
			
	def save_file(self, file, data, isJSON=False):
		with io.open(file, 'w', encoding="utf-8") as f:
			if isJSON == True:
				str_ = json.dumps(data,indent=4, sort_keys=True,separators=(',', ': '), ensure_ascii=False)
				f.write(str(str_))
			else:
				f.write(data)

	def load_file(self, file, isJSON=False):

		if not os.path.isfile(file):
			return None
	
		with io.open(file, 'r', encoding='utf-8') as f:
			if isJSON == True:
				return json.load(f, object_pairs_hook=collections.OrderedDict)
			else:
				return f.read() 

		
	def get_setting(self, setting_id):
		setting = xbmcaddon.Addon(self.addon_name).getSetting(setting_id)
		if setting == 'true':
			return True
		elif setting == 'false':
			return False
		else:
			return setting
	
	def set_setting(self, key, value):
		return xbmcaddon.Addon(self.addon_name).setSetting(key, value)
		
		
	def open_settings(self):
		xbmcaddon.Addon(self.addon_name).openSettings()

	def sleep(self, time):
		return xbmc.sleep(int(time))
	
	def dialog_select(self, heading, label):
		return xbmcgui.Dialog().select(heading,label)
		
	def dialog_multiselect(self, heading, label):
		return xbmcgui.Dialog().dialog_multiselect(heading,label)
		
	def dialog_choice(self, heading, message, agree, disagree):
		return xbmcgui.Dialog().yesno(heading, message, yeslabel=agree, nolabel=disagree)
		
		
	def add_item(self, title, url, playable=False, info=None, art=None, content=None, folder=True, contextmenu = None):

		list_item = xbmcgui.ListItem(label=title)
		if playable:
			list_item.setProperty('IsPlayable', 'true')
			folder = False
			out = []
			out.append(('Informacja', 'Action(Info)'),)
			list_item.addContextMenuItems(out, replaceItems=False)
		if art:
			list_item.setArt(art)
		else:
			art = {
				'icon': self.addon.getAddonInfo('icon'),
				'fanart': self.addon.getAddonInfo('fanart')
			}
			list_item.setArt(art)
		if info:
			list_item.setInfo('Video', info)
		if content:
			xbmcplugin.setContent(self.handle, content)
		if contextmenu:
			list_item.addContextMenuItems(contextmenu, replaceItems=True)
		if not playable and not folder:
			out = []
			out.append(('Informacja', 'Action(Info)'),)
			list_item.addContextMenuItems(out, replaceItems=False)
		xbmcplugin.addSortMethod(self.handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = "%R, %Y, %P")	
		xbmcplugin.addDirectoryItem(self.handle, url, list_item, isFolder=folder)

	def eod(self, cache=True):
		xbmcplugin.endOfDirectory(self.handle, cacheToDisc=cache)

	def refresh(self):
		return xbmc.executebuiltin('Container.Refresh()')
		
	def update(self,func=''):
		return xbmc.executebuiltin('Container.Refresh(%s)'%func)
		
	def updatex(self,func=''):
		return xbmc.executebuiltin('Container.Update(%s)'%func)

	def update(self,func=''):
		return xbmc.executebuiltin('Container.Refresh(%s)'%func)
		
	def runplugin(self,func=''):
		return xbmc.executebuiltin('RunPlugin(%s))'%func)
		
	def notification(self, heading, message):
		xbmcgui.Dialog().notification(heading, message, time=3000)
		
	def setContent(self,content):
		xbmcplugin.setContent(self.handle, content)
		
	def request_sess(self, url, method='get', data={}, headers={}, cookies={}, params = {}, result=True, json=False, allow=True , json_data = False):
		params = params if params else self.params
		if method == 'get':
			resp = self.sess.get(url, headers=headers, cookies=cookies, timeout=30, params = params, verify=False, allow_redirects=allow)
		elif method == 'post':
			if json_data:
				resp = self.sess.post(url, headers=headers, json=data, cookies=cookies, timeout=30, params = params, verify=False, allow_redirects=allow)
			else:
				resp = self.sess.post(url, headers=headers, data=data, cookies=cookies, timeout=30, params = params, verify=False, allow_redirects=allow)
		elif method == 'delete':
			resp = self.sess.delete(url, headers=headers, cookies=cookies, timeout=30, params = params, verify=False, allow_redirects=allow)
		if result:
			return resp.json() if json else resp_text(resp)
		else:
			return resp
			
	def cookies_string(self, kukiz):
		return ''.join(['%s=%s;'%(cn, quote(cv)) for (cn,cv) in (kukiz).items()]) 
		
	def PlayVid (self, mpdurl, lic_url='', PROTOCOL='', DRM='', certificate = '', flags=True, subs = None):
		from inputstreamhelper import Helper
		play_item = xbmcgui.ListItem(path=mpdurl)
		if subs:
			play_item.setSubtitles(subs)
		if PROTOCOL:

			is_helper = Helper(PROTOCOL, drm=DRM)
			if is_helper.check_inputstream():
				if sys.version_info >= (3,0,0):
					play_item.setProperty('inputstream', is_helper.inputstream_addon)
				else:
					play_item.setProperty('inputstreamaddon', is_helper.inputstream_addon)
				if 'mpd' in PROTOCOL:
					play_item.setMimeType('application/xml+dash')
				else:
					play_item.setMimeType('application/vnd.apple.mpegurl')
				play_item.setProperty('inputstream.adaptive.manifest_type', PROTOCOL)
				if DRM and lic_url:
					play_item.setProperty('inputstream.adaptive.license_type', DRM)
					play_item.setProperty('inputstream.adaptive.manifest_update_parameter', 'full')
					play_item.setProperty('inputstream.adaptive.license_key', lic_url)
					if certificate:
						play_item.setProperty('inputstream.adaptive.server_certificate', certificate)
					play_item.setProperty('inputstream.adaptive.play_timeshift_buffer', 'true')	
					#play_item.setProperty('inputstream.adaptive.original_audio_language', 'pol')	
				if flags:
					play_item.setProperty('inputstream.adaptive.license_flags', "persistent_storage")
				play_item.setContentLookup(False)
		xbmcplugin.setResolvedUrl(self.handle, True, listitem=play_item)
		
	def formatTime(self, czas, format):
		try:
			formated = datetime.strptime(czas, format) 
		except TypeError:
			formated = datetime(*(time.strptime(czas, format)[0:6]))
		formatedx = (formated).strftime('%H:%M')
		return formatedx

	def getCorrectTime(self, czas):
		try:
			current_date_temp = datetime.strptime(czas, "%Y-%m-%dT%H:%M:%S.%fZ") #'2022-04-16T12:30:00Z' '2022-12-23T07:25:00.00Z'
		except TypeError:
			current_date_temp = datetime(*(time.strptime(czas, "%Y-%m-%dT%H:%M:%S.%fZ")[0:6]))
		datastart = (current_date_temp + timedelta(hours=+1)).strftime("%Y-%m-%dT%H:%M:%S.%fZ")
		nowe  = (current_date_temp + timedelta(hours=+1)).strftime("%d.%m %H:%M")
	#	datastart = (current_date_temp).strftime("%Y-%m-%dT%H:%M:%S.%fZ")
		return czas, nowe,datastart
		
	def timeNow(self, sek=False):
		now=datetime.utcnow()+timedelta(hours=2)

		czas=now.strftime('%Y-%m-%d')

		try:
			format_date=datetime.strptime(czas, '%Y-%m-%d')
		except TypeError:
			format_date=datetime(*(time.strptime(czas, '%Y-%m-%d')[0:6]))	
		if sek:
				now=datetime.utcnow()
				czas=now.strftime('%Y-%m-%d %H:%M')
				
				try:
					format_date=datetime.strptime(czas, '%Y-%m-%d %H:%M')
				except TypeError:
					format_date=datetime(*(time.strptime(czas, '%Y-%m-%d %H:%M')[0:6]))
		return format_date
	
	def CreateDays(self):
		dzis=self.timeNow()
		timestampdzis = calendar.timegm(dzis.timetuple())
		tydzien = int(timestampdzis)-604800
		out=[]
		for i in range(int(timestampdzis),tydzien,-86400):
			x = datetime.utcfromtimestamp(i)
			dzien = (x.strftime('%d.%m'))
			dnitygodnia = ("poniedziałek","wtorek","środa","czwartek","piątek","sobota","niedziela")
			
			day = x.weekday()

			dzientyg = dnitygodnia[day]

			out.append({'dzien':dzientyg+ ' '+dzien,'tstamp':str(i)}) 
			
		return out	 

	def string_to_date(self, string, string_format):
		s_tuple = tuple([int(x) for x in string[:10].split('-')]) + tuple([int(x) for x in string[11:].split(':')])
		s_to_datetime = datetime(*s_tuple).strftime(string_format)
		return s_to_datetime

	def parse_datetime(self, iso8601_string, localize=False):
		"""Parse ISO8601 string to datetime object."""
		datetime_obj = iso8601.parse_date(iso8601_string)
		if localize:
			return self.utc_to_local(datetime_obj)
		else:
			return datetime_obj

	def to_timestamp(self, a_date):
		if a_date.tzinfo:
			epoch = datetime(1970, 1, 1, tzinfo=pytz.UTC)
			diff = a_date.astimezone(pytz.UTC) - epoch
		else:
			epoch = datetime(1970, 1, 1)
			diff = a_date - epoch
		return int(diff.total_seconds())*1000
	

	@staticmethod
	def utc_to_local(utc_dt):
		# get integer timestamp to avoid precision lost
		timestamp = calendar.timegm(utc_dt.timetuple())
		local_dt = datetime.fromtimestamp(timestamp)
		assert utc_dt.resolution >= timedelta(microseconds=1)
		return local_dt.replace(microsecond=utc_dt.microsecond)
		
		
	def HashPassword(self):	
		import base64
		rsapass = self.get_setting('rsapassword')
		keyx= "-----BEGIN PUBLIC KEY-----\n{}\n-----END PUBLIC KEY-----".format(rsapass)
		privKey = RSA.importKey(keyx)
		cipher = PKCS1_OAEP.new(key=privKey, hashAlgo=SHA1, mgfunc=lambda x,y: pss.MGF1(x,y, SHA1))
		ciphertext = cipher.encrypt(self.password.encode(encoding='utf-8', errors='strict'))
		ac = base64.b64encode(ciphertext)
		return ac.decode(encoding='utf-8', errors='strict')
