# -*- coding: UTF-8 -*-
import ast
import sys, re

import requests, time
import routing
import xbmc
from .helper import Helper

from base64 import urlsafe_b64encode, urlsafe_b64decode, b64encode
base_url = sys.argv[0]
handle = int(sys.argv[1])
helper = Helper(base_url, handle)
plugin = routing.Plugin()

try:
    #python 3
    from urllib.parse import quote_plus, unquote_plus, quote, unquote,parse_qsl, urlencode
    to_unicode = str
except:
    #python 2
    from urllib import quote_plus, unquote_plus, quote, unquote, urlencode
    from urlparse import parse_qsl
    to_unicode = unicode

from datetime import datetime, timedelta
import json    
    
@plugin.route('/')
def root():
    createDatas()
    
    dod, logged = loguj()
    if dod:
        if '|' in dod:
            dodx, plot = dod.split('|')
        else:
            dodx, plot = dod,dod
    if not logged:

        helper.add_item('[COLOR lightgreen][B]Zaloguj[/COLOR][/B]', plugin.url_for(loguj),folder=False)
    else:
        helper.add_item('Zalogowany jako: '+dodx, plugin.url_for(empty), info={'plot':plot},folder=False)
        helper.add_item('Strona głowna', plugin.url_for(mainpage),folder=True)

    helper.eod()

def createDatas():

    if not helper.uuid:
        import uuid
        uuid_ = str(uuid.uuid4())
        helper.set_setting('uuid', uuid_)
    helper.set_setting('bearer', '')

    return

@plugin.route('/mainpage/')
def mainpage():

    url = helper.api_url.format('menus/list')
    
    
    jsdata = helper.request_sess(url, 'get', headers=helper.headers, json=True, result=True)

    for dt in jsdata.get('data', None):
        if dt.get("name", None).lower() !='start' and dt.get("platform_group", None) != "mobile":
            title = dt.get("name", None)

            id_ = dt.get("model_id", None)

            mod = plugin.url_for(listsections, id_)
            if id_=='_':
                mod = plugin.url_for(listproduct, 'channel')

            info = {'title': title, 'plot':title}
            art = {'icon': helper.addon.getAddonInfo('icon'), 'fanart': helper.addon.getAddonInfo('fanart')}
            fold = True
            ispla = False

            helper.add_item(title, mod, playable=ispla, info=info, art=art)  
    if jsdata.get('data', None):
        helper.eod()
        
def filter_non_printable(s):

    import unicodedata
    printable = {'Lu', 'Ll', 'Zs', 'Nd','Sm','Sc','Pc', 'Pd', 'Ps', 'Pe', 'Pi', 'Pf', 'Po'}#,'Sk','So'}
    
    
    
    return ''.join(c for c in s if unicodedata.category(c) in printable)        
@plugin.route('/listsectionst/<id>')
def listsections(id):

    url = helper.api_url.format('sections/page/'+id)
    jsdata = helper.request_sess(url, 'get', headers=helper.headers, json=True, result=True)
    
    ok = False
    for x in jsdata:
        if x.get('active', None) and x.get('type', None) !='banner':
            ok = True
            title = x.get("name", None)
            title = filter_non_printable ( title).lstrip()#title.encode('ascii', errors='ignore').decode()

            id_ = str(x.get('id', None))
            mod = plugin.url_for(listkateg, id_, '0')
            fold = True
            ispla = False
            
            info = {'title': title, 'plot':title}
            art = {'icon': helper.addon.getAddonInfo('icon'), 'fanart': helper.addon.getAddonInfo('fanart')}
            helper.add_item(title, mod, playable=ispla, info=info, art=art) 
    if ok:
        helper.eod()

def checkPakiety(avin):
    pakiety = helper.get_setting('pakiety')
    pakiety = ast.literal_eval(unquote_plus(helper.get_setting('pakiety')))
    dost = False

    for x in avin:
        for a in pakiety:
            if a==x:
                dost = True
                return dost
    return dost
    
def createInfoArts(title, item, meta=False):
    plot = item.get('short_desc', None)
    plot = plot if plot else title
    info = {'title': title, 'plot':filter_non_printable(plot).lstrip()}
    year = item.get('year', None)
    if year:
        info.update({'year':year})
    country = item.get('country', None)
    if country:
        info.update({'country':country.lower()})
    kateg = ''
    if item.get('genres', None):    
        out=[]
        [out.append(a.get("name", None) . lower() )  for a in item.get('genres', None)]
        kateg = ', '.join([x.lower() for x in out ]) if out else ''
        if kateg:
            info.update({'genre':kateg})
    images = item.get('images', None)
    img =''
    if images:
        if 'cover' in images:
            img = images.get('cover', None)[0].get('url', None)
        else:
            img = helper.addon.getAddonInfo('icon')    
    else:
        img = helper.addon.getAddonInfo('icon')
    art = {'icon': img, 'poster':img, 'thumb':img, 'fanart': helper.addon.getAddonInfo('fanart')}
    return info, art
    
@plugin.route('/listproduct/<idx>')
def listproduct(idx):
    url = helper.api_url.format('products/packet/'+idx+'/products') if not 'channel' in idx else helper.api_url.format('products/channel?offset=0&limit=300&platform=BROWSER&system=tvonline&language=pl')
    jsdata = helper.request_sess(url, 'get', headers=helper.headers, json=True, result=True)
    for x in jsdata.get('data', None):
        ww(x)
    if jsdata.get('data', None):
        helper.eod()

def ww(x):
    dod =''
    if x.get('available_in', None):
        dod = '' if checkPakiety(x.get('available_in', None)) else ' [COLOR red][B](-)[/COLOR][/B]'
    uuid_ = x.get('uuid', None)
    title = x.get('title', None)+dod

    title = filter_non_printable(title).lstrip()
    info, art = createInfoArts(title,x)
    type = x.get('subtype', None)

    fold = False
    ispla = False
    mod = plugin.url_for(empty)
    if not '[COLOR red][B](-)[/COLOR][/B]' in dod:
        if type == 'vod' or type =='episode': 
            fold = False
            ispla = True
            mod = plugin.url_for(playvid, uuid_)
        elif type == 'collection':
            fold = True
            ispla = False
            mod = plugin.url_for(listproduct, uuid_)
        elif type == 'channel':    
            fold = True
            ispla = False
            mod = plugin.url_for(listchannel, uuid_)
        elif type == 'series':
            fold = True
            ispla = False
            mod = plugin.url_for(listseries, uuid_)
            
    helper.add_item(title, mod, playable=ispla, folder = fold, info=info, art=art) 
    return
    
def getOdDo(catchup=False):
    from datetime import datetime, timedelta
    a=datetime.utcnow()
    czasteraz = a.strftime('%Y-%m-%dT%H:%M')
    czasteraz = helper.parse_datetime(czasteraz, localize=True)

    do = czasteraz +timedelta(hours=4) 
    od = czasteraz 
    if catchup:
        do = czasteraz +timedelta(minutes=4) 
        od = czasteraz +timedelta(days=-3) 
    do = do .strftime('%Y%m%d%H0000')
    od = od .strftime('%Y%m%d%H0000')
    return od,do
    
def getEpgs(catchup = False):
    od,do = getOdDo(catchup)

    url = helper.api_url.format('epg?startDate='+od+'&endDate='+do+'&platform=BROWSER&system=tvonline')#.format(self.api_url,od,do)
    epgs = helper.request_sess(url, 'get', headers=helper.headers, json=True, result=True)

    return epgs    
@plugin.route('/listchannel/<idx>')
def listchannel(idx):
    
    epgs = getEpgs()
    ok = False
    for channel in epgs:
    
        if channel.get('channel_uuid', None) == idx:
            ok = True
            programs = channel.get('programs', None)
            for program in programs:
                czasod = helper.parse_datetime(program.get('since', None) , localize=True) 
                
                czasod2 = czasod.strftime('%d-%m')
                
                czasod = czasod.strftime('%d-%m %H:%M')
                czasdo =helper.parse_datetime(program.get('till', None) , localize=True) 
                czasdo = czasdo.strftime('%H:%M')
                
                tit = program.get('title', None)
                tit1='[COLOR khaki]%s - %s[/COLOR] %s[CR]'%(czasod, czasdo, tit)
                
                uuid = program.get('uuid', None)
                channel_uuid = program.get('channel_uuid', None)
                description_short = program.get("description_short", None)
                plot = description_short if description_short else tit1
                info = {'title': tit1, 'plot':plot}
                art = {'icon': helper.addon.getAddonInfo('icon'), 'fanart': helper.addon.getAddonInfo('fanart')}
                mod = plugin.url_for(playvid, channel_uuid+'|chan')
                fold = False
                ispla = True
                helper.add_item(tit1, mod, playable=ispla, folder = fold, info=info, art=art) 
    if ok:
        helper.eod()

@plugin.route('/listseries/<idx>')
def listseries(idx):

    url = helper.api_url.format('products/season/'+idx)
    jsdata = helper.request_sess(url, 'get', headers=helper.headers, json=True, result=True)
    idx = jsdata.get('episodes', None)[0].get('uuid', None)
    url = helper.api_url.format('products/season/'+idx)
    jsdata = helper.request_sess(url, 'get', headers=helper.headers, json=True, result=True)

    for x in jsdata.get('episodes', None):
        uuid_ = x.get('uuid', None)
        title = x.get('title', None)
        summary_short = x.get('summary_short', None)
        img = 'https://api.redcarpet.blueonline.tv/assets/{}/cover'.format(uuid_)
        dod =''
        if x.get('available_in', None):
            dod = '' if checkPakiety(x.get('available_in', None)) else ' [COLOR red][B](-)[/COLOR][/B]'
        title = title+dod    
        info = {'title': title, 'plot':filter_non_printable(summary_short).lstrip()}
        art = {'icon': img, 'fanart': helper.addon.getAddonInfo('fanart')}
        fold = False
        ispla = True
        mod = plugin.url_for(playvid, uuid_)

        helper.add_item(title, mod, playable=ispla, folder = fold, info=info, art=art) 
    
    if jsdata.get('episodes', None):
        helper.eod()
@plugin.route('/listkateg/<idx>/<pg>')
def listkateg(idx,pg):

    url = helper.api_url.format('sections/'+idx+'/content')#?limit=100&offset=0&platform=BROWSER&system=tvonline&language=pl

    params = {'platform': 'BROWSER','system': 'tvonline','language': 'pl', 'limit': '25', 'offset':str(pg),'order':'title','orderDir':'asc'}

    jsdata = helper.request_sess(url, 'get', headers=helper.headers, params = params, json=True, result=True)

    for x in jsdata.get('data', None):

        ww(x)

    params2 = {'platform': 'BROWSER','system': 'tvonline','language': 'pl', 'limit': '25', 'offset':str(int(pg)+25),'order':'title','orderDir':'asc'}

    jsdata2 = helper.request_sess(url, 'get', headers=helper.headers, params = params2, json=True, result=True)
    if jsdata2.get('data', None):
        next_offset = str(int(pg)+25)

        mod = plugin.url_for(listkateg, idx, str(next_offset))
        fold = True
        ispla = False
        
        info = {'title': 'Następna strona', 'plot':'Następna strona'}
        art = {'icon': helper.addon.getAddonInfo('icon'), 'fanart': helper.addon.getAddonInfo('fanart')}
        helper.add_item('Następna strona', mod, playable=ispla, info=info, art=art) 


    if jsdata.get('data', None):
        helper.eod()

@plugin.route('/playvid/<idx>')    
def playvid(idx):

    params = {'platform': 'BROWSER','system': 'tvonline','language': 'pl', 'type': 'vod'}#, 'offset':str(pg),'order':'title','orderDir':'asc'}

    if 'chan' in idx:
        idx,x = idx.split('|')
        params = {'platform': 'BROWSER','system': 'tvonline','language': 'pl', 'type': 'channel'}
    url = helper.api_url.format('player/product/'+idx+'/configuration')#http
        
    jsdata = helper.request_sess(url, 'get', headers=helper.headers, params=params, json=True, result=True)

    if jsdata.get('videoSession', None):
        vidses = jsdata.get('videoSession', None).get('videoSessionId', None)
        params = {'platform': 'BROWSER','system': 'tvonline','language': 'pl', 'videoSessionId': vidses}    
        url = helper.api_url.format('player/product/'+idx+'/playlist')#http
        jsdata = helper.request_sess(url, 'get', headers=helper.headers, params=params, json=True, result=True)
        mpdurl = jsdata.get('sources', None).get('DASH', None)[0].get('src', None)
        widevine = jsdata.get('drm', None).get('WIDEVINE', None)#[0].get('src', None)

        DRM = 'com.widevine.alpha'

        lic_url = widevine+'|'+urlencode(helper.headers)+'|R{SSM}|'
        subs =[]
        PROTOCOL='mpd'
        helper.PlayVid(mpdurl, lic_url, PROTOCOL, DRM, flags=False, subs = subs)
    else:
        helper.notification('[B]Uwaga[/B]', '[B]Nie można odtworzyć\ntego materiału[/B]') 
        xbmc.log('blad_blad_blad: %s'%(str(jsdata)), level=xbmc.LOGINFO)
        quit()
@plugin.route('/empty/')
def empty():
    return

@plugin.route('/loguj')    
def loguj():

    ok = False
    
    if helper.login and helper.password:
        helper.set_setting('raz', 'false')
        link1 = helper.api_url.format('documents/byAlias/popup-cookies')
        link2 = helper.api_url.format('documents/byAlias/okno-zgody-cookies')
        jsdata = helper.request_sess(link1, 'get', headers=helper.headers)
        jsdata = helper.request_sess(link2, 'get', headers=helper.headers)
        json_data = {
            'os': 'Windows',
            'osVersion': '19',
            'maker': 'unknown',
            'agent': 'Kodi',
            'login': helper.login,
            'password': helper.password,
            'uid': helper.uuid}
        jsdata = helper.request_sess(helper.subscrlogin, 'post', headers=helper.headers, data = json_data, json=True, json_data = True)
        if jsdata.get('token', None):
            helper.set_setting('bearer', str(jsdata.get('token', None)))
            url = helper.api_url.format('subscriber/products/uuids')
            helper.headers.update({'authorization': 'Bearer '+jsdata.get('token', None) })
            hdrs = helper.headers
            jsdata = helper.request_sess(url, 'get', headers=hdrs, json=True, json_data = True)
            
            pakiety = jsdata.get('data')
            helper.set_setting('pakiety', quote_plus(str(pakiety)))
            url = helper.api_url.format('products/packet')
            jsdata = helper.request_sess(url, 'get', headers=helper.headers, json=True, json_data = True)
            out=[]
            for x in pakiety:[out.append(a.get("title", None) . lower() )  for a in jsdata.get('data', None) if x in a.get('uuid', None)]
            tit = '[CR]'.join([x.lower() for x in out ]) if out else ''

            dod = helper.login+'|'+tit if tit else helper.login

            return dod, True

        else:
            helper.notification('[B]Uwaga[/B]', '[B]Błąd logowania[/B]') 
            helper.set_setting('raz', 'false')
            helper.set_setting('password', '')
            helper.set_setting('login', '')
            return None,False
    else:
        if helper.raz:
            helper.notification('[B]Uwaga[/B]', '[B]Brak danych logowania[/B]') 
            helper.set_setting('raz', 'false')
            return None,False

        else:
            ustawienia()

            helper.update(str( plugin.url_for(loguj)) )


@plugin.route('/ustawienia')
def ustawienia():
    helper.open_settings()
    helper.refresh()


@plugin.route('/logout')
def logout():
    log_out = helper.dialog_choice('Uwaga','Chcesz się wylogować?',agree='TAK', disagree='NIE')
    if log_out:
        helper.save_file(file=helper.datapath+'kukis', data={}, isJSON=True)    
        helper.set_setting('logged', 'false')
        helper.refresh()


class RedgoFilm(Helper):
    def __init__(self):
        super().__init__()
        plugin.run()


