# -*- coding: UTF-8 -*-
import sys,re,os

import six
from six.moves import urllib_parse

import requests
import xbmcgui
import xbmcplugin
import xbmcaddon
import xbmc,xbmcvfs

if six.PY3:
    basestring = str
    unicode = str
    xrange = range
    from resources.lib.cmf3 import parseDOM
    import http.cookiejar as cookielib
    xbmc_LOGNOTICE = xbmc.LOGINFO
else:
    from resources.lib.cmf2 import parseDOM
    import  cookielib
    

    xbmc_LOGNOTICE = xbmc.LOGNOTICE

import random
import time

base_url = sys.argv[0]
addon_handle = int(sys.argv[1])
params = dict(urllib_parse.parse_qsl(sys.argv[2][1:]))
addon = xbmcaddon.Addon(id='plugin.video.sportpremium')

PATH            = addon.getAddonInfo('path')

if six.PY2:
    DATAPATH        = xbmc.translatePath(addon.getAddonInfo('profile')).decode('utf-8')
else:
    DATAPATH        = xbmcvfs.translatePath(addon.getAddonInfo('profile'))

COOKIEFILE = os.path.join(DATAPATH,'emocje.cookie')

RESOURCES       = PATH+'/resources/'
FANART=PATH+'fanart.jpg'

exlink = params.get('url', None)
name= params.get('title', None)
opisy= params.get('plot', None)
imig=params.get('image', None)
page=params.get('page', None)
sess=requests.Session()
sess2=requests.Session()
sess2.cookies = cookielib.LWPCookieJar(COOKIEFILE)
abc=sess2.cookies
API_URL = 'https://api.popler.tv/'
MAIN_URL = 'https://emocje.tv'
sess2.headers = {
    'Host': 'api.popler.tv',
    'User-Agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:86.0) Gecko/20100101 Firefox/86.0',
    'Accept': 'application/json, text/javascript, */*; q=0.01',
    'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',
    'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8',
    'Origin': 'https://emocje.tv'}


UA='Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0'
UAX = 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:86.0) Gecko/20100101 Firefox/86.0'
auth_url='https://b2c-www.redefine.pl/rpc/auth/'
navigate_url='https://b2c-www.redefine.pl/rpc/navigation/'

clid = addon.getSetting('clientId')
devid = addon.getSetting('devid')

stoken = addon.getSetting('sesstoken')
sexpir = addon.getSetting('sessexpir')
skey = addon.getSetting('sesskey')





def encoded_dict(in_dict):
    out_dict = {}
    for k, v in in_dict.iteritems():
        if isinstance(v, unicode):
            v = v.encode('utf8')
        elif isinstance(v, str):
            # Must be encoded in UTF-8
            v.decode('utf8')
        out_dict[k] = v
    return out_dict
    
def build_url(query):
    return base_url + '?' + urllib_parse.urlencode(query)

    
def add_item(url, name, image, folder, mode,  isPlayable=True, infoLabels=False, FANART=None,itemcount=1, page=0):

    list_item = xbmcgui.ListItem(label=name)    
        
    if isPlayable:
        list_item.setProperty("IsPlayable", 'true')

    else:
        list_item.setProperty("IsPlayable", 'false')
        
    if not infoLabels:
        infoLabels={'title': name,'plot':name}

    list_item.setInfo(type="video", infoLabels=infoLabels)

    FANART = FANART if FANART else image
    list_item.setArt({'thumb': image, 'poster': image, 'banner': image, 'fanart': FANART})
    xbmcplugin.addDirectoryItem(
        handle=addon_handle,    
        url = build_url({'title':name,'mode': mode, 'url' : url, 'page' : page,'plot':infoLabels}),    
        listitem=list_item,
        isFolder=folder)
    xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = "%R, %Y, %P")


def home():
    add_item(name='Emocje.tv', url='', mode="emocjetvlist", image=RESOURCES+'emocje.png', folder=True, FANART='https://ncplus-sport.files.e56-po.insyscd.net/backgrounds/ekstraklasa.jpg')    



    #add_item(name='CANAL+ Sport', url='', mode="canallist", image=RESOURCES+'cpo.png', folder=True, FANART='https://ncplus-sport.files.e56-po.insyscd.net/backgrounds/ekstraklasa.jpg')    
    add_item(name='ElevenSports', url='', mode="elevenlist", image=RESOURCES+'es.png', folder=True, FANART='https://ncplus-sport.files.e56-po.insyscd.net/backgrounds/ekstraklasa.jpg')    

    xbmcplugin.endOfDirectory(addon_handle)
def homeEleven():
    loginEleven()
    
def homeEmocje():
    loginEmocje()
    
def homeCanal():
    login()
    
    #add_item(name='Na żywo', url='https://canalplussport.pl', mode="listnazywo", image=RESOURCES+'nazywo.png', folder=True, FANART='https://ncplus-sport.files.e56-po.insyscd.net/backgrounds/ekstraklasa.jpg')    
    #add_item(name='Magazyny PKO BP Ekstraklasa', url='https://canalplussport.pl/magazyn/ekstraklasa', mode="listmagazyny", image='https://ncplus-sport.img.rd.insyscd.net/online-liga-14092019-25028665/p20.jpg', folder=True, FANART='https://ncplus-sport.files.e56-po.insyscd.net/backgrounds/ekstraklasa.jpg')    
    xbmcplugin.endOfDirectory(addon_handle)

def reqestsEmocje(url,typ='js', data=''):
    if os.path.isfile(COOKIEFILE):
        sess2.cookies.load()
    
    if data:
        
        html = sess2.post(url, data, headers=sess2.headers, cookies=sess2.cookies, verify=False)
    else:
        html = sess2.get(url, headers=sess2.headers, cookies=sess2.cookies, verify=False)
    if typ=='js':
        html = html.json()
    else:
        html = html.content
        if PY3:     
            html = html.decode(encoding='utf-8', errors='strict')
    return html
    
def loginEmocje():

        
    usernameEmo = addon.getSetting('usernameEmocje')
    passwordEmo = addon.getSetting('passwordEmocje')    
    if usernameEmo and passwordEmo:
        if not os.path.exists(DATAPATH):
            os.makedirs(DATAPATH)
        sess2.cookies.clear()
        #sess2.cookies.save(COOKIEFILE, ignore_discard = True)
        
        headers = {
            'Host': 'api.popler.tv',
            'User-Agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:86.0) Gecko/20100101 Firefox/86.0',
            'Accept': 'application/json, text/javascript, */*; q=0.01',
            'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',
            'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8',
            'Origin': 'https://emocje.tv',
            'Referer': 'https://emocje.tv/vod-archiwum',
        }
        
        data = 'akcja_autoryzacja=zaloguj&podany_login='+usernameEmo+'&podane_haslo='+passwordEmo+'&zapamietaj=0'

        response = sess2.post('https://api.popler.tv/emocje/loginemocje.php', headers=headers, data=data ,verify=False).json()
        if response.get('sessionid',None) and response.get('UID',None):
            addon.setSetting('sessionid',  response.get('sessionid',None))
            addon.setSetting('UID',  response.get('UID',None))
            sess2.cookies.save(COOKIEFILE, ignore_discard = True)
            xbmcgui.Dialog().notification('[B]Logowanie[/B]', 'Zalogowano poprawnie.',xbmcgui.NOTIFICATION_INFO, 6000)
            
            
            
            add_item(name='Transmisje', url='', mode='listtransmisje', image=RESOURCES+'nazywo.png', folder=True, FANART='https://ncplus-sport.files.e56-po.insyscd.net/backgrounds/ekstraklasa.jpg',page=1)    
            add_item(name='VOD', url='', mode='listvodemocje', image=RESOURCES+'wideo.png', folder=True, FANART='https://ncplus-sport.files.e56-po.insyscd.net/backgrounds/ekstraklasa.jpg',page=1)        
            
            xbmcplugin.endOfDirectory(addon_handle)
        else:
            xbmcgui.Dialog().notification('[B]Logowanie[/B]', 'Błędne dane logowania.',xbmcgui.NOTIFICATION_INFO, 6000)

            add_item('', '[B]Zaloguj[/B]','DefaultAddonService.png',False,'settings',False,FANART='https://ncplus-sport.files.e56-po.insyscd.net/backgrounds/ekstraklasa.jpg')
            xbmcplugin.endOfDirectory(addon_handle)
    else:
        xbmcgui.Dialog().notification('[B]Logowanie[/B]', 'Błędne dane logowania.',xbmcgui.NOTIFICATION_INFO, 6000)
    
        add_item('', '[B]Zaloguj[/B]','DefaultAddonService.png',False,'settings',False,FANART='https://ncplus-sport.files.e56-po.insyscd.net/backgrounds/ekstraklasa.jpg')
        xbmcplugin.endOfDirectory(addon_handle)

    return    
def ListTransmisje():
    sess2.cookies.load()
    headers = {
        'Host': 'emocje.tv',
        'user-agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:86.0) Gecko/20100101 Firefox/86.0',
        'accept': 'text/html, */*; q=0.01',
        'accept-language': 'pl,en-US;q=0.7,en;q=0.3',
        'x-requested-with': 'XMLHttpRequest',
        'referer': 'https://emocje.tv/transmisje',
        'te': 'trailers',
    }

    html = sess2.get('https://emocje.tv/inc/transmisje_full.php', headers=headers, cookies=sess2.cookies,verify=False).content
    if six.PY3:     
        html = html.decode(encoding='utf-8', errors='strict')
    html = html.replace("\'",'"')

    dd = html.split('div id="dzien')
    
    for d in dd:
        if '<li ' in d:


            data = re.findall('40px\;\">(.*?)<',d,re.DOTALL)[0]
            
            t2 = '[COLOR blue][B]'+data+'[/COLOR][/B]'
            add_item(name=t2, url='non', mode='xx', image=RESOURCES+'emocje.png', folder=False, isPlayable=False , infoLabels={'plot':t2},FANART='https://ncplus-sport.files.e56-po.insyscd.net/backgrounds/ekstraklasa.jpg')    

            events = parseDOM(d, 'li')  
            for event in events:
                href = parseDOM(event, 'a', ret='href')[0]  
                href = MAIN_URL+href if href.startswith('/live') else href
                imag = parseDOM(event, 'img', ret='src')[0]    
                imag = MAIN_URL+imag if imag.startswith('/') else imag
                tt = parseDOM(event, 'div', attrs={'class': "time.*?"})[0]
                tt = re.sub("<[^>]*>"," ",tt)

                liga, kto = re.findall('nowrap;">([^>]+)<\/span>.*?<\/span>([^>]+)<\/div>',event,re.DOTALL)[0]
                
                
                tyt = kto + ' ('+liga+') - '+tt.replace("TRWA",'[COLOR gold]TRWA[/COLOR]')
                opis = data+'[CR]'+tyt

                add_item(name=PLchar(tyt), url=href, mode='playvodemocje', image=RESOURCES+'emocje.png', folder=False, isPlayable=True , infoLabels={'plot':PLchar(opis),'code':data},FANART='https://ncplus-sport.files.e56-po.insyscd.net/backgrounds/ekstraklasa.jpg')    
    xbmcplugin.endOfDirectory(addon_handle)
def ListVodEmocje(pagin):

    sess2.cookies.load()
    ntpage = str(int(pagin)+1)

    pg = str(pagin)

    headers = {
    'Host': 'emocje.tv',
    'user-agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:86.0) Gecko/20100101 Firefox/86.0',
    'accept': 'text/html, */*; q=0.01',
    'accept-language': 'pl,en-US;q=0.7,en;q=0.3',
    'content-type': 'application/x-www-form-urlencoded; charset=UTF-8',
    'x-requested-with': 'XMLHttpRequest',
    'origin': 'https://emocje.tv',
    'referer': 'https://emocje.tv/vod-archiwum',
    'te': 'trailers',}

    data = 'id=%23vod_box&page='+pg+'&limit=20&pagin=1&fraza=0&polecane=0'

    html = sess2.post('https://emocje.tv/inc/nagrania.php', headers=headers, cookies=sess2.cookies, data=data, verify=False).content
    if six.PY3:     
        html = html.decode(encoding='utf-8', errors='strict')
    html = html.replace("\'",'"')

    linki = parseDOM(html, 'div', attrs={'class': "vod"})#[0]
    for link in linki:
        href = parseDOM(link, 'a', ret='href')[0]
        #vod
        href = MAIN_URL+'/'+href if href.startswith('vod') else href
        imag = parseDOM(link, 'img', ret='src')[0]    
        imag = MAIN_URL+imag if imag.startswith('/') else imag

        opis = re.findall('class="">(.*?)<\/p',link,re.DOTALL)
        try:
            liga,dr1,dr2 = re.findall('>([^<]+)<br>(.*?)<br>(.*?)</p>',link,re.DOTALL)[0]
        except:


            ads=''
        tytul = dr1+ ' - '+dr2+' ('+liga+')'

        data = parseDOM(html, 'div', attrs={'class': "date"})
        data = data[0] if data else ''
        opis = opis[0].replace('<br>','[CR]')+'[CR]'+data if opis else ''
        add_item(name=PLchar(tytul), url=href, mode='playvodemocje', image=imag, folder=False, isPlayable=True , infoLabels={'plot':PLchar(opis),'code':data},FANART='https://ncplus-sport.files.e56-po.insyscd.net/backgrounds/ekstraklasa.jpg')    

    if '#vod_box",%s,20,1,"0",0)'%(ntpage) in html:
        add_item(name='Następna strona', url='non', mode='listvodemocje', image='non', folder=True,page=ntpage)    
        
        
    xbmcplugin.endOfDirectory(addon_handle)
    
    
def PlayVodEmocje(url):

    sess2.cookies.load()
    
    headers = {
    'Host': 'emocje.tv',
    'user-agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:86.0) Gecko/20100101 Firefox/86.0',
    'accept': 'text/html, */*; q=0.01',
    'accept-language': 'pl,en-US;q=0.7,en;q=0.3',
    'content-type': 'application/x-www-form-urlencoded; charset=UTF-8',
    'x-requested-with': 'XMLHttpRequest',
    'origin': 'https://emocje.tv',
    'referer': 'https://emocje.tv/vod-archiwum',
    'te': 'trailers',}
    html = sess2.get(url,headers=headers,cookies=sess2.cookies, verify=False).content
    if six.PY3:     
        html = html.decode(encoding='utf-8', errors='strict')
    html = html.replace("\'",'"')
    
    nturl=''
    nturls = parseDOM(html, 'iframe', ret='data-src')

    for nt in nturls:
        if 'embed' in nt:
            nturl = nt
            break
            
    if nturl:
    
        headers = {
            'Host': 'www.popler.tv',
            'User-Agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:86.0) Gecko/20100101 Firefox/86.0',
            'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
            'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',
            'Referer': url,
            'Upgrade-Insecure-Requests': '1',
        }
    
        html = sess2.get(nturl,headers=headers,cookies=sess2.cookies, verify=False).content
        if six.PY3:     
            html = html.decode(encoding='utf-8', errors='strict')
        html = re.sub('(<!--<source.*?>)','',html)
        if '/live/' in url:
            link = re.findall('application\/x-mpegurl",\s+src\:\s*"(.+?)"',html,re.DOTALL)[0]
        else:
            link = re.findall('player\.src.*?src\:\s*"([^"]+)',html,re.DOTALL)[0]
        link+='|User-Agent='+UAX+'&Referer='+nturl
        play_item = xbmcgui.ListItem(path=link)
    
        xbmcplugin.setResolvedUrl(addon_handle, True, listitem=play_item)

def newtime(ff):
    from datetime import datetime
    import time
    ff=re.sub(':\d+Z','',ff)
    dd=re.findall('T(\d+)',ff)[0]
    dzien=re.findall('(\d+)T',ff)[0]
    dd='{:>02d}'.format(int(dd)+2)
    if dd=='24':
        dd='00'
        dzien='{:>02d}'.format(int(dzien)+1)
    if dd=='25':
        dd='01'
        dzien='{:>02d}'.format(int(dzien)+1)

    ff=re.sub('(\d+)T(\d+)','%sT%s'%(dzien,int(dd)),ff)

    try:
        format_date = datetime.strptime(ff, '%Y-%m-%dT%H:%M') 
    except TypeError:
        format_date = datetime(*(time.strptime(ff, '%Y-%m-%dT%H:%M')[0:6]))

    dd= int('{:0}'.format(int(time.mktime(format_date.timetuple()))))
    return dd,format_date    
    
def getEpg2():

    import datetime 
    now = datetime.datetime.now()
    now2 = datetime.datetime.now()+ datetime.timedelta(days=1)

    aa=now2.strftime('%Y-%m-%dT%H:%M:%S') + ('.%03dZ' % (now.microsecond / 10000))



    headers = {
            'User-Agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0',
        'Accept': 'application/json, text/plain, */*',
        'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',
        'Content-Type': 'text/plain',
        'Origin': 'https://www.elevensports.pl',
        'DNT': '1',
        'Connection': 'keep-alive',
        'Referer': 'https://www.elevensports.pl/',
    }
    dane =stoken+'|'+sexpir+'|navigation|getChannelsProgram'
    authdata=getHmac(dane)

    data1 = {"id":1,"jsonrpc":"2.0","method":"getChannelsProgram","params":{"userAgentData":{"portal":"eleven","deviceType":"pc","application":"firefox","os":"windows","build":1},"channelIds":["11633"],"toDate":aa,"clientId":clid}}
    data2 = {"id":1,"jsonrpc":"2.0","method":"getChannelsProgram","params":{"userAgentData":{"portal":"eleven","deviceType":"pc","application":"firefox","os":"windows","build":1},"channelIds":["11644"],"toDate":aa,"clientId":clid}}
    data3 = {"id":1,"jsonrpc":"2.0","method":"getChannelsProgram","params":{"userAgentData":{"portal":"eleven","deviceType":"pc","application":"firefox","os":"windows","build":1},"channelIds":["13105"],"toDate":aa,"clientId":clid}}
    data4 = {"id":1,"jsonrpc":"2.0","method":"getChannelsProgram","params":{"userAgentData":{"portal":"eleven","deviceType":"pc","application":"firefox","os":"windows","build":1},"channelIds":["18830"],"toDate":aa,"clientId":clid}}

    epg1 = requests.post('https://b2c-www.redefine.pl/rpc/navigation/', headers=headers, json=data1).json()
    
    epg2 = requests.post('https://b2c-www.redefine.pl/rpc/navigation/', headers=headers, json=data2).json()
    epg3 = requests.post('https://b2c-www.redefine.pl/rpc/navigation/', headers=headers, json=data3).json()
    epg4 = requests.post('https://b2c-www.redefine.pl/rpc/navigation/', headers=headers, json=data4).json()

    danks1=epg1['result']['11633']
    danks2=epg2['result']['11644']
    danks3=epg3['result']['13105']
    danks4=epg4['result']['18830']
    items=[]
    for dank in danks1:
        item = {}
        item['tyt1']=dank['title']
        item['tyt2']=dank['genre']
        item['czas']=dank['startTime']
        items.append(item)

    import datetime 
    now = datetime.datetime.now()
    ab=now.strftime('%Y-%m-%dT%H:%M:%SZ')

    from datetime import datetime
    
    try:
        format_date=datetime.strptime(ab, '%Y-%m-%dT%H:%M:%SZ')
    except TypeError:
        format_date=datetime(*(time.strptime(ab, '%Y-%m-%dT%H:%M:%SZ')[0:6]))
        
    zz= int('{:0}'.format(int(time.mktime(format_date.timetuple()))))

    el1=''
    for i in range(len(items)):
        try:
            nowy,format_date=newtime(items[i]['czas'])
            nowy2,format_date2=newtime(items[i+1]['czas'])
            trwa=nowy2-nowy
            if nowy<zz and nowy+trwa>zz:
                tyt=items[i]['tyt1']
                tyt2=items[i]['tyt2']
                cc=re.sub(':\d+$','',str(format_date))
                el1+='[COLOR khaki]'+cc+'[/COLOR] - '+tyt+' '+tyt2+'[CR]'

            elif nowy>zz:
                tyt=items[i]['tyt1']
                tyt2=items[i]['tyt2']
                cc=re.sub(':\d+$','',str(format_date))
                el1+='[COLOR khaki]'+cc+'[/COLOR] - '+tyt+' '+tyt2+'[CR]'

        except:
            pass

    items=[]
    for dank in danks2:
        item = {}
        item['tyt1']=dank['title']
        item['tyt2']=dank['genre']
        item['czas']=dank['startTime']
        items.append(item)
    import datetime 
    now = datetime.datetime.now()
    ab=now.strftime('%Y-%m-%dT%H:%M:%SZ')
    
    from datetime import datetime
    try:
        format_date=datetime.strptime(ab, '%Y-%m-%dT%H:%M:%SZ')
    except TypeError:
        format_date=datetime(*(time.strptime(ab, '%Y-%m-%dT%H:%M:%SZ')[0:6]))
    zz= int('{:0}'.format(int(time.mktime(format_date.timetuple()))))

    el2=''
    for i in range(len(items)):
        try:
            nowy,format_date=newtime(items[i]['czas'])
            
            nowy2,format_date2=newtime(items[i+1]['czas'])
            trwa=nowy2-nowy
            if nowy<zz and nowy+trwa>zz:
            
            
                tyt=items[i]['tyt1']
                tyt2=items[i]['tyt2']
                cc=re.sub(':\d+$','',str(format_date))
                el2+='[COLOR khaki]'+cc+'[/COLOR] - '+tyt+' '+tyt2+'[CR]'

            elif nowy>zz:
                tyt=items[i]['tyt1']
                tyt2=items[i]['tyt2']
                cc=re.sub(':\d+$','',str(format_date))
                el2+='[COLOR khaki]'+cc+'[/COLOR] - '+tyt+' '+tyt2+'[CR]'

        except:
            pass
            
            
    items=[]        
    for dank in danks3:
        item = {}
        item['tyt1']=dank['title']
        item['tyt2']=dank['genre']
        item['czas']=dank['startTime']
        items.append(item)
    import datetime 
    now = datetime.datetime.now()
    ab=now.strftime('%Y-%m-%dT%H:%M:%SZ')
    
    from datetime import datetime
    try:
        format_date=datetime.strptime(ab, '%Y-%m-%dT%H:%M:%SZ')
    except TypeError:
        format_date=datetime(*(time.strptime(ab, '%Y-%m-%dT%H:%M:%SZ')[0:6]))
    zz= int('{:0}'.format(int(time.mktime(format_date.timetuple()))))

    el3=''
    for i in range(len(items)):
        try:
            nowy,format_date=newtime(items[i]['czas'])
            nowy2,format_date2=newtime(items[i+1]['czas'])
            trwa=nowy2-nowy
            if nowy<zz and nowy+trwa>zz:
            
            
                tyt=items[i]['tyt1']
                tyt2=items[i]['tyt2']
                cc=re.sub(':\d+$','',str(format_date))
                el3+='[COLOR khaki]'+cc+'[/COLOR] - '+tyt+' '+tyt2+'[CR]'

            elif nowy>zz:
                tyt=items[i]['tyt1']
                tyt2=items[i]['tyt2']
                cc=re.sub(':\d+$','',str(format_date))
                el3+='[COLOR khaki]'+cc+'[/COLOR] - '+tyt+' '+tyt2+'[CR]'

        except:
            pass
    items=[]        
    for dank in danks4:
        item = {}
        item['tyt1']=dank['title']
        item['tyt2']=dank['genre']
        item['czas']=dank['startTime']
        items.append(item)

    import datetime 
    now = datetime.datetime.now()
    ab=now.strftime('%Y-%m-%dT%H:%M:%SZ')
    
    from datetime import datetime
    try:
        format_date=datetime.strptime(ab, '%Y-%m-%dT%H:%M:%SZ')
    except TypeError:
        format_date=datetime(*(time.strptime(ab, '%Y-%m-%dT%H:%M:%SZ')[0:6]))
    zz= int('{:0}'.format(int(time.mktime(format_date.timetuple()))))

    el4=''
    for i in range(len(items)):
        try:
            nowy,format_date=newtime(items[i]['czas'])
            nowy2,format_date2=newtime(items[i+1]['czas'])
            trwa=nowy2-nowy
            if nowy<zz and nowy+trwa>zz:
            
            
                tyt=items[i]['tyt1']
                tyt2=items[i]['tyt2']
                cc=re.sub(':\d+$','',str(format_date))
                el3+='[COLOR khaki]'+cc+'[/COLOR] - '+tyt+' '+tyt2+'[CR]'

            elif nowy>zz:
                tyt=items[i]['tyt1']
                tyt2=items[i]['tyt2']
                cc=re.sub(':\d+$','',str(format_date))
                el4+='[COLOR khaki]'+cc+'[/COLOR] - '+tyt+' '+tyt2+'[CR]'
        except:
            pass
    return el1,el2,el3,el4    

    
def ListElevenVidCat():
    add_item(name='Piłka nożna', url='5015744', mode="listelevid", image=RESOURCES+'pilka.png', folder=True, FANART='https://ncplus-sport.files.e56-po.insyscd.net/backgrounds/ekstraklasa.jpg')        
    add_item(name='Formuła 1', url='5015745', mode="listelevid", image=RESOURCES+'formula.png', folder=True, FANART='https://ncplus-sport.files.e56-po.insyscd.net/backgrounds/ekstraklasa.jpg')    
    add_item(name='Żużel', url='5015746', mode="listelevid", image=RESOURCES+'zuzel.png', folder=True, FANART='https://ncplus-sport.files.e56-po.insyscd.net/backgrounds/ekstraklasa.jpg')    
    add_item(name='Hity Eleven', url='5017920', mode="listelevid", image=RESOURCES+'es.png', folder=True, FANART='https://ncplus-sport.files.e56-po.insyscd.net/backgrounds/ekstraklasa.jpg')    




    xbmcplugin.endOfDirectory(addon_handle)
def ListTVeleven():
    el1,el2,el3,el4=getEpg2()
    add_item(name='Eleven Sports 1', url='11633', mode="playtv", image=RESOURCES+'el1.png', folder=False, infoLabels={'plot':el1},isPlayable=False, FANART='https://ncplus-sport.files.e56-po.insyscd.net/backgrounds/ekstraklasa.jpg')    
    add_item(name='Eleven Sports 2', url='11644', mode="playtv", image=RESOURCES+'el2.png', folder=False, infoLabels={'plot':el2},isPlayable=False, FANART='https://ncplus-sport.files.e56-po.insyscd.net/backgrounds/ekstraklasa.jpg')    
    add_item(name='Eleven Sports 3', url='13105', mode="playtv", image=RESOURCES+'el3.png', folder=False, infoLabels={'plot':el3},isPlayable=False, FANART='https://ncplus-sport.files.e56-po.insyscd.net/backgrounds/ekstraklasa.jpg')    
    add_item(name='Eleven Sports 4', url='18830', mode="playtv", image=RESOURCES+'el4.png', folder=False, infoLabels={'plot':el4},isPlayable=False, FANART='https://ncplus-sport.files.e56-po.insyscd.net/backgrounds/ekstraklasa.jpg')    
    xbmcplugin.endOfDirectory(addon_handle)
    
def cookieString(COOKIEFILE):
    sc=''
    if os.path.isfile(COOKIEFILE):
        sess.cookies.load(COOKIEFILE)
        sc=''.join(['%s=%s;'%(c.name, c.value) for c in sess.cookies])
    return sc    
    
    cookieString(COOKIEFILE)
    
    
    
def getUrl(url,coki='bb',redir=True):
    kukis= addon.getSetting('kukiz')
    headers = {
        'Host': 'canalplussport.pl',
        'user-agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36',
        'accept': '*/*',
        'Cookie':kukis,
        'accept-language': 'pl,en-US;q=0.7,en;q=0.3',
        'referer': 'https://canalplussport.pl/',
        'te': 'trailers',
    }

    if redir:
        html=sess.get(url,verify=False,headers=headers,allow_redirects=redir).content
    else:
        html=sess.get(url,verify=False,headers=headers,allow_redirects=redir)#.content
    return html

def login():
    username = addon.getSetting('username')
    password = addon.getSetting('password')    
    logowanie = addon.getSetting('logowanie')
    
    if username and password and logowanie == 'true':
        headers = {
            'Host': 'canalplussport.pl',
            'user-agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/77.0.3865.90 Safari/537.36',
            'accept': '*/*',
            'accept-language': 'pl,en-US;q=0.7,en;q=0.3',
            'content-type': 'application/x-www-form-urlencoded; charset=UTF-8',
            'x-requested-with': 'XMLHttpRequest',
            'referer': 'https://canalplussport.pl/',
            'te': 'trailers',
        }
        
        data = 'ReturnUrl=https://canalplussport.pl/&Email=%s&Password=%s'%(username,password)
        
        response = sess.post('https://canalplussport.pl/zaloguj', headers=headers, data=data)
        html=response.text
        if html.find('<span class="error">')>0:
            xbmcgui.Dialog().notification('[B]Logowanie[/B]', 'Błąd logowania.',xbmcgui.NOTIFICATION_INFO, 6000)
            add_item('', '[B]Zaloguj[/B]','DefaultAddonService.png',False,'settings',False,FANART='https://ncplus-sport.files.e56-po.insyscd.net/backgrounds/ekstraklasa.jpg')

        else:
            sc=''.join(['%s=%s;'%(c.name, c.value) for c in sess.cookies])
            dataPath=os.path.dirname(COOKIEFILE)
            if not os.path.exists(dataPath):
                os.makedirs(dataPath)
            sess.cookies.save(COOKIEFILE, ignore_discard = True)
            addon.setSetting('kukiz',sc)
            xbmcgui.Dialog().notification('[B]Logowanie[/B]', 'Zalogowano poprawnie.',xbmcgui.NOTIFICATION_INFO, 6000)
            add_item(name='Na żywo', url='https://canalplussport.pl', mode="listnazywo", image=RESOURCES+'nazywo.png', folder=True, FANART='https://ncplus-sport.files.e56-po.insyscd.net/backgrounds/ekstraklasa.jpg')    
            add_item(name='Magazyny PKO BP Ekstraklasa', url='https://canalplussport.pl/magazyn/ekstraklasa', mode="listmagazyny", image='https://ncplus-sport.img.rd.insyscd.net/online-liga-14092019-25028665/p20.jpg', folder=True, FANART='https://ncplus-sport.files.e56-po.insyscd.net/backgrounds/ekstraklasa.jpg')    

    else:
        xbmcgui.Dialog().notification('[B]Logowanie[/B]', 'Brak danych logowania.',xbmcgui.NOTIFICATION_INFO, 6000)
        add_item('', '[B]Zaloguj[/B]','DefaultAddonService.png',False,'settings',False,FANART='https://ncplus-sport.files.e56-po.insyscd.net/backgrounds/ekstraklasa.jpg')

    return

def PLznak(char):
    char = char.replace('&#260;','Ą')
    char = char.replace('&#261;','ą')
    char = char.replace('&#280;','Ę')
    char = char.replace('&#281;','ę')
    char = char.replace('&#211;','Ó')
    char = char.replace('&#243;','ó')
    char = char.replace('&#262;','Ć')
    char = char.replace('&#263;','ć')
    char = char.replace('&#321;','Ł')
    char = char.replace('&#322;','ł')
    char = char.replace('&#323;','Ń')
    char = char.replace('&#324;','ń')
    char = char.replace('&#346;','Ś')
    char = char.replace('&#347;','ś')
    char = char.replace('&#377;','Ź')
    char = char.replace('&#378;','ź')
    char = char.replace('&#379;','Ż')
    char = char.replace('&#380;','ż')
    char = char.replace('&#252;','u')
    char = char.replace('&#252','u')
    char = char.replace('&#260','Ą')
    char = char.replace('&#261','ą')
    char = char.replace('&#280','Ę')
    char = char.replace('&#281','ę')
    char = char.replace('&#211','Ó')
    char = char.replace('&#243','ó')
    char = char.replace('&#262','Ć')
    char = char.replace('&#263','ć')
    char = char.replace('&#321','Ł')
    char = char.replace('&#322','ł')
    char = char.replace('&#323','Ń')
    char = char.replace('&#324','ń')
    char = char.replace('&#346','Ś')
    char = char.replace('&#347','ś')
    char = char.replace('&#377','Ź')
    char = char.replace('&#378','ź')
    char = char.replace('&#379','Ż')
    char = char.replace('&#380','ż')
    char = char.replace('&#233;','é')
    char = char.replace('&#39;',"'")
    return char
    
def PLchar(char):
    if type(char) is not str:
        char=char.encode('utf-8')
    char = char.replace('\\u0105','\xc4\x85').replace('\\u0104','\xc4\x84')
    char = char.replace('\\u0107','\xc4\x87').replace('\\u0106','\xc4\x86')
    char = char.replace('\\u0119','\xc4\x99').replace('\\u0118','\xc4\x98')
    char = char.replace('\\u0142','\xc5\x82').replace('\\u0141','\xc5\x81')
    char = char.replace('\\u0144','\xc5\x84').replace('\\u0144','\xc5\x83')
    char = char.replace('\\u00f3','\xc3\xb3').replace('\\u00d3','\xc3\x93')
    char = char.replace('\\u015b','\xc5\x9b').replace('\\u015a','\xc5\x9a')
    char = char.replace('\\u017a','\xc5\xba').replace('\\u0179','\xc5\xb9')
    char = char.replace('\\u017c','\xc5\xbc').replace('\\u017b','\xc5\xbb')
    char = char.replace('&#8217;',"'")
    char = char.replace('&#8211;',"-")    
    char = char.replace('&#8230;',"...")        
    char = char.replace('&quot;','"')    
    char = char.replace('&#039;',"'")    
    char = char.replace('Napisy PL',"[COLOR lightblue](napisy pl)[/COLOR]")
    char = char.replace('Lektor PL',"[COLOR lightblue](lektor pl)[/COLOR]")
    char = char.replace('Dubbing PL',"[COLOR lightblue](dubbing pl)[/COLOR]")    
    return char  
def getNaZywo(url):
    url='https://canalplussport.pl/Main/RedirectToMain'
    html=getUrl(url)
    if 'zaloguj' in html:
        zaloguj()
        html=getUrl(url)
    out=[]
    html=PLznak(html)
    links = parseDOM(html, 'div', attrs={'class': "rotator__item__background rotator__item__background--match"})#[0]#'

    for link in links:

        href = parseDOM(link, 'a', ret='href')#[0]    
        if href:
            href = 'https://canalplussport.pl'+href[0] 
        else:
            continue

        teams= re.findall('text--l">([^>]+)<\/h2>',link)
        time = re.findall('>([^>]+)<\/em>',link)#[0]
        
        
        kiedy = re.findall('>([^<]+)<\/time>',link)
        time = time[0] if time else ''
        kiedy = kiedy[0] if kiedy else ''
        
        try:
            tyt = '%s vs %s  - (%s o %s)'%(teams[0],teams[1],kiedy,time)
            cod =  '%s, %s'%(kiedy,time)
        except:
            continue
        if 'header__watch-icon icon__watch-live' in link:
            tyt=u'[COLOR lime]► [/COLOR]'+tyt
        else:    
            tyt=u'[COLOR orangered]■ [/COLOR]'    +tyt
        imag=re.findall('src="(.+?)" width="150"',link)[0]#''
        out.append({'title':str(tyt),'href':href,'img':imag,'plot':str(tyt),'code':cod})
    return out
def ListNaZywo(exlink):
    links = getNaZywo(exlink)
    if links:
        itemz=links
        items = len(links)

        fold=False
        for f in itemz:
            add_item(name=f.get('title'), url=f.get('href'), mode='playnazywo', image=f.get('img'), folder=False, isPlayable=True , infoLabels=f,FANART='https://ncplus-sport.files.e56-po.insyscd.net/backgrounds/ekstraklasa.jpg', itemcount=items)    
        xbmcplugin.endOfDirectory(addon_handle)

def PlayNaZywo(url):
    html=getUrl(url,'ekstr')

    if 'zalogowany live' in html:

        result = parseDOM(html, 'div', attrs={'class': "col-xs-6"})[0]
        href = parseDOM(result, 'a', ret='href')#[0]    
        if href:
            href = 'https://canalplussport.pl'+href[0] 

        if 'zaloguj?returnUrl='    in href:
            zaloguj()
            PlayNaZywo(url)
        PlayMagazyn(href)
    return
        
def getMagazyny(url):
    html=getUrl(url)
    out=[]

    links = parseDOM(html, 'li', attrs={'class': "col-xs-4.+?"})
    for link in links:
        href = parseDOM(link, 'a', ret='href')#[0]    
        if href:
            href = 'https://canalplussport.pl'+href[0] 
        else:
            continue
        imag = parseDOM(link, 'img', ret='src')[0]        
        imag=re.findall('(^.+?.jpg)',imag)[0]
        title = (parseDOM(link, 'h4')[0])#.replace('ONLINE','')
        out.append({'title':title,'href':href,'img':imag,'plot':title})
    return out
        
def ListMagazyny(exlink):

    links = getMagazyny(exlink)
    if links:
        itemz=links
        items = len(links)

        fold=False
        for f in itemz:
            add_item(name=f.get('title'), url=f.get('href'), mode='playmagazyny', image=f.get('img'), folder=False, isPlayable=True , infoLabels=f,FANART='https://ncplus-sport.files.e56-po.insyscd.net/backgrounds/ekstraklasa.jpg', itemcount=items)    
    
        xbmcplugin.endOfDirectory(addon_handle)
        
def zaloguj():

    username = addon.getSetting('username')
    password = addon.getSetting('password')    
    logowanie = addon.getSetting('logowanie')
    
    if username and password:

        headers = {
            'Host': 'canalplussport.pl',
            'user-agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0',
            'accept': '*/*',
            'accept-language': 'pl,en-US;q=0.7,en;q=0.3',
            'content-type': 'application/x-www-form-urlencoded; charset=UTF-8',
            'x-requested-with': 'XMLHttpRequest',
            'referer': 'https://canalplussport.pl/magazyn/ekstraklasa',
            'te': 'trailers',
        }
        data = 'ReturnUrl=https://canalplussport.pl/magazyn/ekstraklasa&Email=%s&Password=%s'%(username,password)

        response = sess.post('https://canalplussport.pl/zaloguj', headers=headers, data=data)
        sc=''.join(['%s=%s;'%(c.name, c.value) for c in sess.cookies])
        sess.cookies.save(COOKIEFILE, ignore_discard = True)
        addon.setSetting('kukiz',sc)

    
    
def PlayMagazyn(url):

    html=getUrl(url,'ekstr')

    if 'zaloguj">zalog' in html:
        zaloguj()
        html=getUrl(url,'ekstr')
        html=replaceHTMLCodes(html)
 
    DrmChallengeCustomData=re.findall('"DrmChallengeCustomData"\:\s*"(.+?)"',html)
    source=re.findall('src="(.+?\.mpd)"',html)
    import inputstreamhelper
    PROTOCOL = 'mpd'
    DRM = 'com.widevine.alpha'
    hdrs={
            'user-agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0',
            'accept': '*/*',
            'referer': url,

        }
    try:
        STREAM_URL = source[0]
        LICENSE_URL = 'https://wv.drm.insyscd.net/AcquireLicense.ashx'
    
        is_helper = inputstreamhelper.Helper(PROTOCOL, drm=DRM)
        if is_helper.check_inputstream():
            play_item = xbmcgui.ListItem(path=STREAM_URL)
            if six.PY2:
                play_item.setProperty('inputstreamaddon', is_helper.inputstream_addon)
            else:
                play_item.setProperty('inputstream', is_helper.inputstream_addon)
            play_item.setProperty('inputstream.adaptive.manifest_type', PROTOCOL)
            play_item.setProperty('inputstream.adaptive.license_type', DRM)
            play_item.setProperty('inputstream.adaptive.stream_headers', str(hdrs))
            bb=urllib_parse.quote(DrmChallengeCustomData[0])
            play_item.setProperty('inputstream.adaptive.license_key', LICENSE_URL + '|DrmChallengeCustomData='+bb+'|R{SSM}|')
            xbmcplugin.setResolvedUrl(addon_handle, True, listitem=play_item)
    except:
        pass
    
    
def loginEleven():
    clid = addon.getSetting('clientId')
    devid = addon.getSetting('devid')
    
    stoken = addon.getSetting('sesstoken')
    sexpir = addon.getSetting('sessexpir')
    skey = addon.getSetting('sesskey')
    
    def gen_hex_code(myrange=6):
        return ''.join([random.choice('0123456789ABCDEF') for x in range(myrange)])
    
    def ipla_system_id():
        myrand = gen_hex_code(10) + '-' + gen_hex_code(4) + '-' + gen_hex_code(4) + '-' + gen_hex_code(4) + '-' + gen_hex_code(12)
    
        return myrand
    if not clid and not devid:
    
        clientid=ipla_system_id()
        deviceid=ipla_system_id()
        
        addon.setSetting('clientId', clientid)
        addon.setSetting('devid', deviceid)
        loginEleven()
    else:
        usernameEl = addon.getSetting('usernameEleven')
        passwordEl = addon.getSetting('passwordEleven')    
        if usernameEl and passwordEl:
        
            headers = {
                'Host': 'b2c-www.redefine.pl',
                'User-Agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0',
                'Accept': 'application/json, text/plain, */*',
                'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',
                'Content-Type': 'text/plain',
                'Origin': 'https://www.elevensports.pl',
                'Referer': 'https://www.elevensports.pl/uzytkownik/zaloguj/natywnie',
            }
        
            data = {"id":1,"jsonrpc":"2.0","method":"login","params":{"userAgentData":{"portal":"eleven","deviceType":"pc","application":"firefox","os":"windows","build":1},"authData":{"deviceId":{"type":"other","value":devid},"login":usernameEl,"password":passwordEl},"clientId":clid}}
            response = requests.post(auth_url, headers=headers, json=data,verify=False).json()
            if 'error' not in response:
                sesja=response['result']['session']
                
                sesstoken=sesja['id']
                sessexpir=sesja['keyExpirationTime']
                sesskey=sesja['key']
                
                addon.setSetting('sesstoken', sesstoken)
                addon.setSetting('sessexpir', str(sessexpir))
                addon.setSetting('sesskey', sesskey)
                xbmcgui.Dialog().notification('[B]Logowanie[/B]', 'Zalogowano poprawnie.',xbmcgui.NOTIFICATION_INFO, 6000)
                
                
                
                add_item(name='Na żywo', url='', mode='listtveleven', image=RESOURCES+'nazywo.png', folder=True, FANART='https://ncplus-sport.files.e56-po.insyscd.net/backgrounds/ekstraklasa.jpg')    
                add_item(name='Wideo', url='', mode='listelevidcat', image=RESOURCES+'wideo.png', folder=True, FANART='https://ncplus-sport.files.e56-po.insyscd.net/backgrounds/ekstraklasa.jpg')    

                xbmcplugin.endOfDirectory(addon_handle)
            else:
                xbmcgui.Dialog().notification('[B]Logowanie[/B]', 'Błędne dane logowania.',xbmcgui.NOTIFICATION_INFO, 6000)
                add_item('', '[B]Zaloguj[/B]','DefaultAddonService.png',False,'settings',False,FANART='https://ncplus-sport.files.e56-po.insyscd.net/backgrounds/ekstraklasa.jpg')
                xbmcplugin.endOfDirectory(addon_handle)

        else:
            xbmcgui.Dialog().notification('[B]Logowanie[/B]', 'Błędne dane logowania.',xbmcgui.NOTIFICATION_INFO, 6000)

            add_item('', '[B]Zaloguj[/B]','DefaultAddonService.png',False,'settings',False,FANART='https://ncplus-sport.files.e56-po.insyscd.net/backgrounds/ekstraklasa.jpg')
            xbmcplugin.endOfDirectory(addon_handle)

    return
def getHmac(dane):
    skey = addon.getSetting('sesskey')
    import hmac
    import hashlib 
    import binascii
    import base64
    from hashlib import sha256
    ssdalej=dane
    import base64
    
    
    
    
    def base64_decode(s):
        """Add missing padding to string and return the decoded base64 string."""
        #log = logging.getLogger()
        s = str(s).strip()
        try:
            return base64.b64decode(s)
        except TypeError:
            padding = len(s) % 4
            if padding == 1:
                #log.error("Invalid base64 string: {}".format(s))
                return ''
            elif padding == 2:
                s += b'=='
            elif padding == 3:
                s += b'='
            return base64.b64decode(s)
    secretAccessKey = base64_decode(skey.replace('-','+').replace('_','/'))

    auth = hmac.new(secretAccessKey, ssdalej.encode("ascii"), sha256)
    vv=base64.b64encode(auth.digest())
    if  six.PY3:     
        vv = vv.decode(encoding='utf-8', errors='strict')

    return ssdalej+'|'+vv.replace('+','-').replace('/','_')

def PlayEleven(stream_url,data):


    dane=eval(opisy)

    import inputstreamhelper
   # from urllib import quote
    PROTOCOL = 'mpd'
    DRM = 'com.widevine.alpha'
    LICENSE_URL = 'https://gm2.redefine.pl/rpc/drm/'
    is_helper = inputstreamhelper.Helper(PROTOCOL, drm=DRM)
    
    UA= 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0'
    if is_helper.check_inputstream():
    
        play_item = xbmcgui.ListItem(path=stream_url)#
        play_item.setInfo(type="Video", infoLabels={"title": name,'plot':dane['plot']})
        
        play_item.setArt({'thumb': imig, 'poster': imig, 'banner': imig, 'fanart': FANART})
        
        play_item.setProperty("IsPlayable", "true")
        play_item.setMimeType('application/xml+dash')
        play_item.setContentLookup(False)
        
        if six.PY2:
            play_item.setProperty('inputstreamaddon', is_helper.inputstream_addon)
        else:
            play_item.setProperty('inputstream', is_helper.inputstream_addon)
        
    #    play_item.setProperty('inputstreamaddon', is_helper.inputstream_addon)
        play_item.setProperty('inputstream.adaptive.manifest_type', PROTOCOL)
        play_item.setProperty('inputstream.adaptive.license_type', DRM)

        play_item.setProperty('inputstream.adaptive.manifest_update_parameter', 'full')
        play_item.setProperty('inputstream.adaptive.stream_headers', 'Referer: https://www.elevensports.pl/')
        play_item.setProperty('inputstream.adaptive.license_key',
                            LICENSE_URL + '|Content-Type=application%2Fjson&Referer=https://www.elevensports.pl/&User-Agent=' + urllib_parse.quote(UA) +
                            '|'+data+'|JBlicense')                        
        play_item.setProperty('inputstream.adaptive.license_flags', "persistent_storage")

        Player = xbmc.Player()
        Player.play(stream_url, play_item)

def cofanie():
    seek_secs=86399
    while not xbmc.Player().isPlayingVideo():
        xbmc.Monitor().waitForAbort(0.25)
    
    if xbmc.Player().isPlayingVideo():
        xbmc.executebuiltin('Seek(' + str(seek_secs) + ')')    
        
def getDuration(seconds):
    try:
        seconds=int(seconds)
        m, s = divmod(seconds, 60)
        h, m = divmod(m, 60)
        if h>0:
            out = "%d:%02d:%02d" % (h, m, s)
        else:
            out = "%02d:%02d" % (m, s)
    except:
        out=''
    return out
def getImag(images):
    for image in images:
        if int(image['size']['width'])>= 500:
            img = image['src']
            break
    return img
def getElevenVid(id,ofset):
    clid = addon.getSetting('clientId')
    devid = addon.getSetting('devid')
    
    stoken = addon.getSetting('sesstoken')
    sexpir = addon.getSetting('sessexpir')
    
    dane =stoken+'|'+sexpir+'|navigation|getCategoryContentWithFlatNavigation'
    authdata=getHmac(dane)
    headers = {
        'Host': 'b2c.redefine.pl',
        'User-Agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0',
        'Accept': '*/*',
        'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',
        'Content-Type': 'text/plain;charset=UTF-8',
        'Origin': 'https://www.elevensports.pl',
        'DNT': '1',
        'Referer': 'https://www.elevensports.pl/',
    }
    
    
    data = {"id":1,"jsonrpc":"2.0","method":"getCategoryContentWithFlatNavigation","params":{"userAgentData":{"portal":"eleven","deviceType":"pc","application":"firefox","os":"windows","build":1},"catid":int(id),"offset":int(ofset),"limit":30,"collection":{"type":"sortedby","name":"Ostatnio dodane","default":True,"value":"12"},"authData":{"sessionToken":authdata},"clientId":clid}}
    response = requests.post('https://b2c.redefine.pl/rpc/navigation/', headers=headers, json=data).json()
    totvid = response['result']['total']
    ofs = response['result']['offset']
    npage=[]
    if int(ofs)+30<int(totvid):

        ofset = int(ofs)+30
        npage.append({'title':'Następna strona','href':id,'img':'','plot':'','page':int(ofset)}) 
    results = response['result']['results']
    out=[]
    for result in results:

        categ = result['category']['name']
        tytul = result['title']
        opis = result['description']
        durat = getDuration(result['duration'])
        pubdate = re.findall('^(.+?)T',result['publicationDate'])
        pubdate = pubdate[0] if pubdate else ''
        mediaid = result['id']
        cpid = str(result['cpid'])
        imag = getImag(result['thumbnails'])
        href = mediaid+'|'+cpid
        tytul = tytul+' ('+categ+')'
        cod = pubdate+', '+durat
        out.append({'title':tytul,'href':href,'img':imag,'plot':opis,'code':cod})
    return out,npage
    
def ListElevenVid(id,page):
    links,npage = getElevenVid(id,page)
    items = len(links)
    if links:
        for f in links:
            add_item(name=f.get('title'), url=f.get('href'), mode="playtv", image=f.get('img'), folder=False, isPlayable=False , infoLabels={'plot':f.get('plot'),'code':f.get('code')},FANART='https://ncplus-sport.files.e56-po.insyscd.net/backgrounds/ekstraklasa.jpg', itemcount=items)    

    if npage:
        for f in npage:    
            add_item(name=f.get('title'), url=f.get('href'), mode='listelevid', image=f.get('img'), folder=True,page=f.get('page'))
    xbmcplugin.setContent(addon_handle, 'videos')
    xbmcplugin.endOfDirectory(addon_handle)
def PlayTVeleven(id):

    cpid = '0'
    if '|' in id:
        id,cpid=id.split('|')

    clid = addon.getSetting('clientId')
    devid = addon.getSetting('devid')
    
    stoken = addon.getSetting('sesstoken')
    sexpir = addon.getSetting('sessexpir')
    
    dane =stoken+'|'+sexpir+'|navigation|prePlayData'
    authdata=getHmac(dane)
    
    
    headers = {
        'Host': 'b2c.redefine.pl',
        'User-Agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:69.0) Gecko/20100101 Firefox/69.0',
        'Accept': '*/*',
        'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',
        'Content-Type': 'text/plain;charset=UTF-8',
        'Origin': 'https://www.elevensports.pl',
        'DNT': '1',
        'Referer': 'https://www.elevensports.pl/',
    }

    data = {"jsonrpc":"2.0","id":1,"method":"prePlayData","params":{"ua":"eleven_pc_windows_firefox/1 (Windows 7; widevine=true)","userAgentData":{"deviceType":"pc","application":"firefox","os":"windows","build":1,"portal":"eleven","player":"html","widevine":True},"cpid":int(cpid),"mediaId":id,"authData":{"sessionToken":authdata},"clientId":clid}}

    response = requests.post('https://b2c.redefine.pl/rpc/navigation/', headers=headers, json=data).json()
    xbmc.log('@#@CHANNxx: %s' % str(response), xbmc_LOGNOTICE)
    playback = response['result']['mediaItem']['playback']
    mediaid = playback['mediaId']['id']
    mediaSources = playback['mediaSources'][0]
    keyid = mediaSources['keyId']
    sourceid = mediaSources['id']
    stream_url = mediaSources['url']
    
    dane =stoken+'|'+sexpir+'|drm|getWidevineLicense'

    authdata=getHmac(dane)
    data=urllib_parse.quote('{"jsonrpc":"2.0","id":1,"method":"getWidevineLicense","params":{"userAgentData":{"deviceType":"pc","application":"firefox","os":"windows","build":1,"portal":"eleven","player":"html","widevine":true},"cpid":'+cpid+',"mediaId":"'+mediaid+'","sourceId":"'+sourceid+'","keyId":"'+keyid+'","object":"b{SSM}","deviceId":{"type":"other","value":"'+devid+'"},"ua":"eleven_pc_windows_firefox_html/1","authData":{"sessionToken":"'+authdata+'"},"clientId":"'+clid+'"}}')
    PlayEleven(stream_url,data)

def router(paramstring):
    params = dict(urllib_parse.parse_qsl(paramstring))
    if params:    
    
        mode = params.get('mode', None)
    
        if mode == 'canallist':
            homeCanal()
        elif mode == 'emocjetvlist':
    
            homeEmocje()
            
        elif mode == 'listvodemocje':
            ListVodEmocje(page)
        elif mode == 'playvodemocje':
            PlayVodEmocje(exlink)
        elif mode == 'listtransmisje':
            ListTransmisje()
    
        
            
        elif mode == 'elevenlist':
            homeEleven()
        elif mode == 'listmagazyny':
            ListMagazyny(exlink)
        elif mode == 'playmagazyny':
            PlayMagazyn(exlink)
        elif mode == "listnazywo":
            ListNaZywo(exlink)
        elif mode == 'playnazywo':
            PlayNaZywo(exlink)
        elif mode == 'playtv':
            PlayTVeleven(exlink)
        elif mode == 'listtveleven':
            ListTVeleven()
        elif mode == 'listelevidcat':
            ListElevenVidCat()
        
        elif mode == 'listelevid':
            ListElevenVid(exlink,page)
            
        elif mode == 'settings':
            addon.openSettings()
            xbmc.executebuiltin('Container.Refresh()')
    else:
        home()
if __name__ == '__main__':
    router(sys.argv[2][1:])