# coding: UTF-8
import ast
import sys, re

import requests
import routing

from .helper import Helper

base_url = sys.argv[0]
handle = int(sys.argv[1])
helper = Helper(base_url, handle)
plugin = routing.Plugin()

try:
    # Python 3
    from urllib.parse import quote_plus, unquote_plus, quote, unquote,parse_qsl
    to_unicode = str
except:
    # Python 2.7
    from urllib import quote_plus, unquote_plus, quote, unquote
    from urlparse import parse_qsl
    to_unicode = unicode


    
    
@plugin.route('/')
def root():
    CreateDatas()
	
    if helper.logged:
        startwt()

    else:
        helper.add_item('[COLOR lightgreen][B]Zaloguj[/COLOR][/B]', plugin.url_for(login),folder=False)
        helper.add_item('[B]Ustawienia[/B]', plugin.url_for(ustawienia),folder=False)

    helper.eod()

def CreateDatas():
    if not helper.uuid:
        import uuid
        uuidx = uuid.uuid4()
        helper.set_setting('uuid',to_unicode(uuidx))
    return
    
@plugin.route('/startwt')    
def startwt():
    helper.add_item('[B]TV[/B]', plugin.url_for(mainpage),folder=True)
    helper.add_item('[B]Wyloguj[/B]', plugin.url_for(logout),folder=False)
def refreshToken():

    json_data = {
        'device': {
            'type': 'DT_Web_Browser',
            'application': {
                'type': 'AT_SWEET_TV_Player',
            },
            'model': helper.UA,
            'firmware': {
                'versionCode': 1,
                'versionString': helper.version,
            },
            'uuid': helper.uuid,
            'supported_drm': {
                'widevine_modular': True,
            },
            'screen_info': {
                'aspectRatio': 6,
                'width': 1366,
                'height': 768,
            },
        },
        'refresh_token': helper.refresh_token,
    }
    jsdata = helper.request_sess(helper.token_url, 'post', headers=helper.headers, data = json_data, json=True, json_data = True)
    if jsdata.get("result", None) == 'OK':

        access_token = jsdata.get("access_token", None)

        helper.set_setting('bearer', 'Bearer '+to_unicode(access_token))

        return True
    else:
        
        return False

@plugin.route('/mainpage')    
def mainpage():
    import time
    timestamp = str(int(time.time() * 1000.0))
    json_data = {
    'epg_limit_prev': 1,
    'epg_limit_next': 100,
    'epg_current_time': timestamp,
    'need_epg': True,
    'need_list': True,
    'need_categories': True,
    'need_offsets': False,
    'need_hash': False,
    'need_icons': False,
    'need_big_icons': False,}

    url = helper.base_api_url.format('TvService/GetChannels.json')
    headers = {
            'Host': 'api.sweet.tv',
            'user-agent': helper.UA,
            'accept': 'application/json, text/plain, */*',
            'accept-language': 'pl',
            'x-device': '1;22;0;2;3.2.57',
            'origin': 'https://sweet.tv',
            'dnt': '1',
            'referer': 'https://sweet.tv/',
            'authorization': helper.get_setting('bearer')
            }
    acx = helper.get_setting('bearer')
    acx2 = helper.get_setting('refresh_token')

    jsdata = helper.request_sess(url, 'post', headers=headers, data = json_data, json=True, json_data = True)

    if jsdata.get("code", None) == 16:
        if jsdata.get("message", None) == 'token is expired':
            helper.set_setting('bearer', '')
            refr = refreshToken()
            if refr:
                mainpage()
            else:
                return
    if jsdata.get("status", None) == 'OK':
        for j in jsdata.get('list', []):
            _id = str(j.get('id',None))
            title = j.get('name',None)
            slug = j.get('slug',None)
            available = j.get('available',None)
            catchup = j.get('catchup',None)
            epgs = j.get('epg',None)
            epg =''
            if epgs:
                pass

            idx = _id+'|'+slug
            mod = plugin.url_for(playvid, id=idx)
            fold = False
            ispla = True
            imag = j.get('icon_v2_url',None)
            art = {'icon': imag, 'fanart': helper.addon.getAddonInfo('fanart')}
            
            
            if not available:
                title = title+' (brak)'
                ispla = False
                fold = False
                mod = plugin.url_for(empty)

            info = {'title': title, 'plot':epg}
            
            helper.add_item('[COLOR gold][B]'+title+'[/COLOR][/B]', mod, playable=ispla, info=info, art=helper.art, folder=fold)    

    helper.eod()
    
@plugin.route('/empty')    
def empty():
    return

@plugin.route('/ustawienia')
def ustawienia():
    helper.open_settings()
    helper.refresh()


@plugin.route('/logout')
def logout():
    log_out = helper.dialog_choice('Uwaga','Chcesz się wylogować?',agree='TAK', disagree='NIE')
    if log_out:
        helper.set_setting('bearer', '')    
        helper.set_setting('logged', 'false')
        helper.refresh()
        
@plugin.route('/login')
def login():

    if not helper.username or not helper.password:
        helper.notification('Info', 'Brak danych logowania.\n Wpisz je w usatwieniach')
    
        helper.set_setting('logged', 'false')

    else:
    
        json_data = {
            'device': {
                'type': 'DT_Web_Browser',
                'application': {
                    'type': 'AT_SWEET_TV_Player',
                },
                'model': helper.UA,
                'firmware': {
                    'versionCode': 1,
                    'versionString': helper.version,
                },
                'uuid': helper.uuid,
                'supported_drm': {
                    'widevine_modular': True,
                },
                'screen_info': {
                    'aspectRatio': 6,
                    'width': 1366,
                    'height': 768,
                },
            },
            'email': helper.username,
            'password': helper.password,
        }

        jsdata = helper.request_sess(helper.auth_url, 'post', headers=helper.headers, data = json_data, json=True, json_data = True)
        if jsdata.get("result", None) == 'OK':

            access_token = jsdata.get("access_token", None)
            refresh_token = jsdata.get("refresh_token", None)
            helper.set_setting('bearer', 'Bearer '+to_unicode(access_token))
            helper.set_setting('refresh_token', to_unicode(refresh_token))
            helper.set_setting('logged', 'true')

        else:

            info=jsdata.get('result', None)
            helper.notification('Information', info)

            helper.set_setting('logged', 'false')

    helper.refresh()

@plugin.route('/playvid/<id>')
def playvid(id):
    idx,slug = id.split('|')
    json_data = {
        'without_auth': True,
        'channel_id': int(idx),
        'accept_scheme': [
            'HTTP_HLS',
        ],
        'multistream': True,
    }

    url = helper.base_api_url.format('TvService/OpenStream.json')
    jsdata = helper.request_sess(url, 'post', headers=helper.headers, data = json_data, json=True, json_data = True)
    
    host = jsdata.get('http_stream', None).get('host', None).get('address', None)
    nt = jsdata.get('http_stream', None).get('url', None)
    stream_url = 'https://'+host+nt
    lic_url = None
    mpdurl =''
    DRM = None
    PROTOCOL = 'hls'
    subs =None
    helper.PlayVid(stream_url, lic_url, PROTOCOL, DRM, flags=False, subs = subs)

class SweetTV(Helper):
    def __init__(self):
        super().__init__()
        plugin.run()


