# -*- coding: UTF-8 -*-
from __future__ import absolute_import
import sys, re, os

try:
    import http.cookiejar
    import urllib.request, urllib.parse, urllib.error
    from urllib.parse import urlencode, quote_plus, quote, unquote, parse_qsl
    from resources.lib.cmf3 import parseDOM
    xrange = range

except ImportError:
    import cookielib
    from urllib import urlencode, quote_plus, quote, unquote
    from urlparse import parse_qsl
    from resources.lib.cmf2 import parseDOM

    
import requests
import xbmcgui
import xbmcplugin
import xbmcaddon
import xbmc, xbmcvfs

import json

import inputstreamhelper

from resources.lib import compr2

base_url = sys.argv[0]
addon_handle = int(sys.argv[1])
params = dict(parse_qsl(sys.argv[2][1:]))
addon = xbmcaddon.Addon(id='plugin.video.tvn24pl')

PATH            = addon.getAddonInfo('path')
if sys.version_info[0] > 2:
    DATAPATH        = xbmcvfs.translatePath(addon.getAddonInfo('profile'))
else:
    DATAPATH        = xbmc.translatePath(addon.getAddonInfo('profile'))
RESOURCES       = PATH+'/resources/'


ikona = RESOURCES+'../icon.png'
FANART=RESOURCES+'../fanart.jpg'

exlink = params.get('url', None)
name= params.get('name', None)
page = params.get('page','')

rys= params.get('image', None)

kukz=''

TIMEOUT=15

UA = 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:80.0) Gecko/20100101 Firefox/80.0'
#UAandroid = 'okhttp/3.3.1 Android'

UAandroid = 'tvn24go/1.1.1(45) okhttp/3.11.0 AndroidTV'



login_api = 'https://konto.tvn.pl/oauth/'
GETTOKEN = login_api + 'tvn-reverse-onetime-code/create'
POSTTOKEN = login_api + 'token'

HEADERS3 = {
    'Host': 'konto.tvn.pl',
    'user-agent': UAandroid,
    'content-type': 'application/x-www-form-urlencoded; charset=UTF-8'}

    
access_token = addon.getSetting('access_token')
refresh_token = addon.getSetting('refresh_token')


sess = requests.Session()

def build_url(query):

    return base_url + '?' + urlencode(query)

def add_item(url, name, image, mode, folder=False, IsPlayable=False, infoLabels=False, page=1,fanart=FANART):
    list_item = xbmcgui.ListItem(label=name)

    if IsPlayable:
        list_item.setProperty("IsPlayable", 'True')
    if not infoLabels:
        infoLabels={'title': name,'plot':name}
    list_item.setInfo(type="video", infoLabels=infoLabels)    
    list_item.setArt({'thumb': image, 'poster': image, 'banner': image, 'fanart': FANART})
    ok=xbmcplugin.addDirectoryItem(
        handle=addon_handle,
        url = build_url({'mode': mode, 'url' : url, 'page' : page,'name':name,'image':image}),            
        listitem=list_item,
        isFolder=folder)
    xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = "%R, %Y, %P")
    return ok

    
    
    
    
def getStreams(href):
    dd=compr2.compr2(href)

    headers = {

        'User-Agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:80.0) Gecko/20100101 Firefox/80.0',
        'Accept': '*/*',
        'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',

        'Content-Type': 'application/json',

    }
    url ='https://tvn24.pl/api/%s'%dd
    response = sess.get(url, headers=headers,verify=False).json()
    data = response.get("data",None)

    Kt = data.get("resolution",None).get("publication",None).get("name",None)

    tn = data.get("resolution",None).get("section",None).get("uniqueName",None)
    cn = data.get("context",None).get("contextType",None)

    r = '&r='+'-'.join(x.lower() for x in [Kt, tn, cn])
    mainhref = response.get('data',None).get('context',None).get('href',None)

    if not mainhref.endswith('/'):
        mainhref+='/'
    hrefok = mainhref + 'nuviArticle?playlist&ap=1&statsPwa=browser&id='
    out=[]
    vids = response.get('data',None).get('context',None).get('mainVideo',[])

    for vid in vids:

        try:
            id = vid.get('content',None).get('id',None)
            href = hrefok+id+r
            tytul = vid.get('title',None)

            try:
                if vid.get("updated",''):
                    publ = czs(vid.get("updated",'').replace(':00Z',':00.000Z'))
                else:
                    publ = czs(vid.get('content','').get("published",'').replace(':00Z',':00.000Z'))
            except:

                publ =''
            opis = vid.get('content',None).get('fields',None).get('description',None)
            opis = opis if opis else tytul
            plot = opis+'[CR][COLOR yellow]%s[/COLOR]'%(publ)
            ilab = {'code':'[COLOR yellow]%s[/COLOR]'%(publ), 'plot': plot}
            imig = vid.get('content',None).get('keyframes',None)[0].get('content',None).get('binary',None).get('href',None)

            out.append({'title':tytul,'href':href,'image':imig,'ilab':ilab})
        except:
            vids2 = vid.get('content',None).get('relatedVideos',[])
            
            if vids2:

                for vid2 in vids2:
                    id2 = vid2.get('content',None).get('id',None)
                    href2 = hrefok+id2+r
                    tytul2 = vid2.get('title',None)
                    try:
                        if vid2.get("updated",''):
                            publ2 = czs(vid2.get("updated",'').replace(':00Z',':00.000Z'))
                        else:
                            publ2 = czs(vid2.get('content','').get("published",'').replace(':00Z',':00.000Z'))
                    except:

                        publ2 =''

                    opis2 = vid2.get('content',None).get('fields',None).get('description',None)

                    opis2 = opis2 if opis2 else tytul2
                    plot2 = opis2+'[CR][COLOR yellow]%s[/COLOR]'%(publ2)
                    ilab2 = {'code':'[COLOR yellow]%s[/COLOR]'%(publ2), 'plot': plot2}
                    imig2 = vid2.get('content',None).get('keyframes',None)[0].get('content',None).get('binary',None).get('href',None)
                    out.append({'title':tytul2,'href':href2,'image':imig2,'ilab':ilab2})
            else:
                vids2 = vid.get('content',None).get('taggedVideos',[])    
                for vid2 in vids2:

                    id2 = vid2.get('id',None)
                    href2 = hrefok+id2+r
                    tytul2 = vid2.get('fields',None).get('title',None)
                    try:
                        if vid2.get("updated",''):
                            publ2 = czs(vid2.get("updated",'').replace(':00Z',':00.000Z'))
                        else:
                            publ2 = czs(vid2.get("published",'').replace(':00Z',':00.000Z'))
                    except:

                        publ2 =''

                    opis2 = vid2.get('fields',None).get('description',None)

                    opis2 = opis2 if opis2 else tytul2
                    plot2 = opis2+'[CR][COLOR yellow]%s[/COLOR]'%(publ2)
                    ilab2 = {'code':'[COLOR yellow]%s[/COLOR]'%(publ2), 'plot': plot2}
                    imig2 = vid2.get('keyframes',None)[0].get('content',None).get('binary',None).get('href',None)
                    out.append({'title':tytul2,'href':href2,'image':imig2,'ilab':ilab2})

    return out
def getStreamsExt(href):
    headers = {

        'User-Agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:80.0) Gecko/20100101 Firefox/80.0',
        'Accept': '*/*',
        'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',

        'Content-Type': 'application/json',

    }

    response = sess.get(href, headers=headers,verify=False).content
    if sys.version_info >= (3,0,0):
        response = response.decode(encoding='utf-8', errors='strict')
    result = parseDOM(response,'div', attrs={'class': "videoPlaylist.+?"})
    links = parseDOM(result[0],'li', attrs={'class': "item.+?"})
    co = 0
    out=[]
    for link in links:

        href = re.findall('data\-src="(.+?)"',link)[0]
        title = parseDOM(link, 'a', ret='title')[0]

        img = re.findall('data\-poster="(.+?)"',link)[0]

        plot = parseDOM(link,'span', attrs={'class': "photoDescription"})[0]
        ilab = {'plot':plot}
        if co == 4:
            break
        out.append({'title':title,'href':href,'image':img,'ilab':ilab})    
        co+=1
    return out    

def getVideos(hreftype):
    href,typ = hreftype.split('|')
    if typ != 'ext':
        streams = getStreams(href)
        for f in streams:
            add_item(f.get('href'), PLchar(f.get('title')),f.get('image'), "playhqq", folder=False, IsPlayable=True,infoLabels=f.get('ilab'))
    else:
        streams = getStreamsExt(href)
        for f in streams:
            add_item(f.get('href'), PLchar(f.get('title')),f.get('image'), "playhqq", folder=False, IsPlayable=True,infoLabels=f.get('ilab'))

    xbmcplugin.setContent(addon_handle, 'videos')    
    xbmcplugin.endOfDirectory(addon_handle)

def playhqq(href):
    src = href
    if not 'mp4' in href:
        dd=compr2.compr2(href)
    
        headers = {
            'User-Agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:80.0) Gecko/20100101 Firefox/80.0',
            'Accept': '*/*',
            'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',
            'Content-Type': 'application/json',

        }
        url ='https://tvn24.pl/api/%s/plst'%dd
        response = sess.get(url, headers=headers,verify=False).json()
        src = response.get('movie',None).get('video',None).get("sources",None).get("hls",None).get('url',None)
    play_item = xbmcgui.ListItem(path=src)
    xbmcplugin.setResolvedUrl(addon_handle, True, listitem=play_item)

def home():
    add_item('', "TVN24.PL",ikona, "tvn24main", folder=True)
    add_item('', "Fakty TVN",ikona, "listfakty", folder=True)
    add_item('', "Live AUDIO",ikona, "listaudio", folder=True)

def Tvn24Main():

    add_item('', "TVN24.PL",ikona, "tvn24main", folder=False, IsPlayable=False)
    add_item('https://tvn24.pl/najnowsze/', "Najnowsze",ikona, "tvn24najnowsze", folder=True)
    add_item('https://tvn24.pl/polska/', "Polska",ikona, "tvn24najnowsze", folder=True)
    add_item('https://tvn24.pl/swiat/', PLchar("Świat"),ikona, "tvn24najnowsze", folder=True)

    
    
def getFakty(pg):
    out=[]
    npout=[]
    url = 'https://fakty.tvn24.pl/ogladaj-online,60/'
    url2 = url + str(pg)
    headers = {
        'User-Agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:80.0) Gecko/20100101 Firefox/80.0',
        'Accept': '*/*',
        'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',


    }

    response = sess.get(url2, headers=headers,verify=False).content
    if sys.version_info >= (3,0,0):
        response = response.decode(encoding='utf-8', errors='strict')
    
    videos = parseDOM(response,'section', attrs={'class': "list-watch-facts"})
    pagination = parseDOM(response,'nav', attrs={'class': "pagination"}) 

    for vid in videos:
        
        try:
            maintitle = parseDOM(vid, 'time')[0]
        except:
            maintitle = parseDOM(vid,'h1', attrs={'class': "section-title"})[0] 

        maint = '[COLOR lightgreen]'+maintitle+'[/COLOR]'
        out.append({ 'title':maint,'href':'','image':ikona,'secttitle':True,'ilab':{}})    
        articles = re.findall('<article(.*?)<\/article>',vid,re.DOTALL)
        for article in articles:
            
            title = parseDOM(article, 'a', ret='title')[0]
            href = parseDOM(article, 'a', ret='href')[0]

            href = 'https://fakty.tvn24.pl' + href if href.startswith('/') else href

            img = parseDOM(article, 'img', ret='src')[1]
            img = img.replace('&amp;','&')

            opi = parseDOM(article, 'hgroup')
            if opi:
                opis = parseDOM(opi[0], 'h1')[0]
            else:
                opis = title
            ilab ={'plot':opis}
            out.append({'title':title,'href':href,'image':img,'secttitle':False, 'ilab' : ilab})    
    if pagination:
        nxt = re.findall('next" href="(.+?)"',pagination[0])[0]
        if 'ogladaj-' in nxt:
            urln = 'https://fakty.tvn24.pl/ogladaj-online,60/'
            href = urln + str(int(pg)+1)
            npout.append({'href':href,'page':int(int(pg)+1)})
        
    return out,npout
    
    
def ListFakty(pg):
    fakty,nast = getFakty(pg)
    for f in fakty:
        playa =True
        mud = "playfakty"

        if f.get('secttitle'):
            playa = False
            mud =' '

        
        add_item(url=f.get('href'), name=PLchar(f.get('title')), image=f.get('image'), mode=mud, folder=False, IsPlayable=playa, infoLabels=f.get('ilab'))
    if nast:
        add_item(url=nast[0].get('href'), name='Nast. strona', image=ikona, mode='listfakty', folder=True, IsPlayable=False, infoLabels={}, page = nast[0].get('page'))

    xbmcplugin.endOfDirectory(addon_handle)
    
    
    
def czas():
    import pytz
    import datetime 
    now = datetime.datetime.now(tz=pytz.UTC)
    czas=now.strftime('%Y-%m-%dT%H:%M:%SZ')
    from datetime import datetime
    import time

    try:
        format_date=datetime.strptime(czas, '%Y-%m-%dT%H:%M:%SZ')
    except TypeError:
        format_date=datetime(*(time.strptime(czas, '%Y-%m-%dT%H:%M:%SZ')[0:6]))


    def to_timestamp(a_date):
        from datetime import datetime
        
        #try:
        #    
        #except:
        #    pass
        if a_date.tzinfo:
            epoch = datetime(1970, 1, 1, tzinfo=pytz.UTC)
            diff = a_date.astimezone(pytz.UTC) - epoch
        else:
            epoch = datetime(1970, 1, 1)
            diff = a_date - epoch
        return int(diff.total_seconds())*1000    

    tst4 =     to_timestamp(format_date)

    return int(tst4)#tstampnow
    
def createHash():

    import random, string, math, pytz
    
    def random_string(length):
        return ''.join(random.choice(string.ascii_lowercase + string.digits) for _ in range(length))
    
    vv = random_string(11)
    
    int2base = lambda a, b: ''.join(
        [(string.digits +
        string.ascii_lowercase +
        string.ascii_uppercase)[(a // b ** i) % b]
        for i in range(int(math.log(a, b)), -1, -1)]
    )
    num= czas()
    #num = 1412823931503067241
    part2 = int2base(num, 36)
    hsh = vv+part2[2:18]
    return hsh
    
def xbmc_sleep(time):
    return xbmc.sleep(time)
    
def dialog_progress():
    return xbmcgui.DialogProgress()
    
def refreshTokenTVN():
    refresh_token = addon.getSetting('refresh_token')
    POST_DATA = 'grant_type=refresh_token&refresh_token=%s&client_id=GoTVN24_TV_Android_bdd8016a25d9afa8'%refresh_token
    data = requests.post(POSTTOKEN,data = POST_DATA, headers=HEADERS3, verify=False).json()
    if data.get('error_description') == 'Token is still valid.':
        return False
    ACCESS_TOKEN = data.get('access_token')
    REFRESH_TOKEN = data.get('refresh_token')
    addon.setSetting('access_token', ACCESS_TOKEN)

    addon.setSetting('refresh_token', REFRESH_TOKEN)

    return True
    
    
    
def createDatas():

    def gen_hex_code(myrange=6):
        import random
        return ''.join([random.choice('0123456789abcdef') for x in xrange(myrange)])

    def uniq_id():
        device_id = ''
    
        if addon.getSetting('device_id'):
            device_id = addon.getSetting('device_id')
        else:
            device_id = gen_hex_code(16)
        addon.setSetting('device_id', device_id)
        return device_id
    DEVICE_ID =uniq_id()
    return

def sprawdzenie1():
    device_id=addon.getSetting('device_id')
    if not device_id:
        createDatas()
    if not refresh_token:
        POST_DATA = 'scope=/pub-api/user/me&client_id=GoTVN24_TV_Android_bdd8016a25d9afa8'
        data = requests.post(GETTOKEN, data = POST_DATA, headers=HEADERS3, verify=False).json()
        kod = data.get('code')
        dg = dialog_progress()
        dg.create('Uwaga','Przepisz kod: [B]%s[/B]\n Na stronie https://tvn24.pl/go/zaloguj-tv'%kod)
        
        time_to_wait=340
        secs = 0
        increment = 100 // time_to_wait
        cancelled = False
        b= 'acces_denied'
        while secs <= time_to_wait:
            if (dg.iscanceled()): cancelled = True; break
            if secs != 0: xbmc_sleep(3000)
            secs_left = time_to_wait - secs
            if secs_left == 0: percent = 100
            else: percent = increment * secs
            POST_DATA = 'grant_type=tvn_reverse_onetime_code&code=%s&client_id=GoTVN24_TV_Android_bdd8016a25d9afa8'%kod
            data = requests.post(POSTTOKEN, data=POST_DATA, headers=HEADERS3, verify=False).json()
            token_type = data.get("token_type",None)
            errory = data.get('error',None)
            if token_type == 'bearer': break
            secs += 1
        
        
            dg.update(percent)
            secs += 1
        dg.close()
        
        if not cancelled:
            ACCESS_TOKEN = data.get('access_token',None)
            REFRESH_TOKEN = data.get('refresh_token',None)
        
            addon.setSetting('access_token', ACCESS_TOKEN)
            addon.setSetting('refresh_token', REFRESH_TOKEN)
            return True

        
def Logowanie():
    refresh_token = addon.getSetting('refresh_token')
    if refresh_token:
        ab=refreshTokenTVN()

    else:
        chk = sprawdzenie1()

    ListAudio()

    
def ListAudio():
    refresh_token = addon.getSetting('refresh_token')
    if not refresh_token:
        add_item(url='x', name='[B]Zaloguj[/B]', image='DefaultUser.png', mode='loguj', folder=True, IsPlayable=False, infoLabels={})
    
    else:
        ab=refreshTokenTVN()
        add_item(url='12330', name='TVN24 AUDIO', image='http://r-scale-07.dcs.redcdn.pl/scale/o2/tvn24go/portal/prod/upload/live/12330/images/79453?dsth=200&dstw=400&srcmode=0&srcx=0&srcy=0&quality=65&type=0&srcw=1/1&srch=1/1', mode='playaudio', folder=False, IsPlayable=True, infoLabels={})
        add_item(url='12331', name='TVN24 BiS AUDIO', image='http://r-scale-0d.dcs.redcdn.pl/scale/o2/tvn24go/portal/prod/upload/live/12331/images/79458?dsth=200&dstw=400&srcmode=0&srcx=0&srcy=0&quality=65&type=0&srcw=1/1&srch=1/1', mode='playaudio', folder=False, IsPlayable=True, infoLabels={})
    
        add_item(url='x', name='[B]Wyloguj[/B]', image='DefaultUser.png', mode='logout', folder=False, IsPlayable=False, infoLabels={})
    xbmcplugin.endOfDirectory(addon_handle)

def PlayAudio(id):
    PROTOCOL = 'mpd'
    DRM = 'com.widevine.alpha'
    ab=refreshTokenTVN()
    access_token = addon.getSetting('access_token')
    device_id = addon.getSetting('device_id')
    headers2 = {
    
        'Host': 'go.tvn24.pl',
        'user-agent': 'tvn24go/1.1.1(45) okhttp/3.11.0 AndroidTV',
        'content-type': 'application/json',
        'api-authentication': access_token,
        'api-deviceuid': device_id,
        'api-deviceinfo': 'ExtraMbebe;universal7570;Android;11;samsung;1.1.1(45);',
        'x-newrelic-id': 'VgEPV19XDBAFVlFaBAUHVg==',
    }
    params = (
        ('videoType', 'LIVE'),
        ('platform', 'ANDROID_TV'),
    )
    
    hea= '&'.join(['%s=%s' % (name, value) for (name, value) in headers2.items()])  
    url = 'https://go.tvn24.pl/api/products/%s/audios/playlist'%str(id)
    response = requests.get(url, headers=headers2, params=params,verify=False).json()

    sources = response.get("sources",None)
    if sources:

        mpdurl=sources.get("DASH",None)[0].get("src", None)
        mpdurl = 'http:' + mpdurl if mpdurl.startswith('//') else mpdurl
        mpd_url = requests.get(mpdurl, headers=headers2, verify=False).url
        
        widevineurl = response.get("drm",None).get("WIDEVINE", None).get("src",None)
        license_url=widevineurl
        
        mpd_url = mpd_url.split('&startTime')[0]

        is_helper = inputstreamhelper.Helper(PROTOCOL, drm=DRM)
        if not is_helper.check_inputstream():
            raise ValueError('To i tak się by wcześniej wywaliło !!!')
        
        
        play_item = xbmcgui.ListItem(path=mpd_url)#+'|'+hea)

        play_item.setProperty('inputstream.adaptive.license_type', 'com.widevine.alpha')

        play_item.setProperty('inputstream.adaptive.license_key', license_url+'|Content-Type=|R{SSM}|')
        
        play_item.setProperty('inputstream.adaptive.manifest_type', 'mpd')

        if sys.version_info >= (3,0,0):
            play_item.setProperty('inputstream', is_helper.inputstream_addon)
        else:
            play_item.setProperty('inputstreamaddon', is_helper.inputstream_addon)
        
        play_item.setMimeType('application/dash+xml')
        play_item.setProperty('inputstream.adaptive.manifest_update_parameter', 'full')
        play_item.setContentLookup(False)
        xbmcplugin.setResolvedUrl(addon_handle, True, listitem=play_item)        

def getAdaptiveDatas(vidplayer,ref):
    
    licensep1 = re.findall('data\-license\-wv="([^"]+)',vidplayer)[0]
    vidplaylist = re.findall('data\-video\-playlist="([^"]+)',vidplayer)[0]
    headers = {

        'User-Agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:80.0) Gecko/20100101 Firefox/80.0',
        'Accept': '*/*',
        'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',

        'Referer': ref,
    }
    part1 = re.findall('(\d+\.xml)',vidplaylist)[0]
    response = sess.get(vidplaylist, headers=headers,verify=False).content
    if sys.version_info >= (3,0,0):
        response = response.decode(encoding='utf-8', errors='strict')
    ff=re.findall('%s.+?(<detail_path>.+?)\<\/profiles>'%(part1),response)[0]

    widev = re.findall('<wv>(.+?)<\/wv>',ff)[0]
    src = re.findall('<url>(.+?)<\/url>',widev)[0]
    kid = re.findall('<kid>(.+?)<\/kid>',widev)[0]
    license = re.findall('<license>(.+?)<\/license>',widev)[0]
    
    hsh = createHash()
    licurl = license+'?key='+quote(kid)+'&hash='+hsh

    src = src.replace('r.dcs.redcdn.pl','j.dcs.redcdn.pl')
    
    headers = {

        'User-Agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:80.0) Gecko/20100101 Firefox/80.0',
        'Accept': '*/*',
        'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',

        'Referer': ref,
    }

    response = sess.get(src, headers=headers,verify=False).content
    if sys.version_info >= (3,0,0):
        response = response.decode(encoding='utf-8', errors='strict')
    src = re.findall('tURL": "(.+?)"',response)[0]
    license_url=licurl+'|user-agent='+quote(UA)+'&Referer=https://fakty.tvn24.pl/|R{SSM}|'
    
    return src, license_url

def getAdaptiveDatasNew(playlist):

    
    plist = json.loads(playlist)
    vid = plist.get('movie',None).get('video',None).get('sources',None).get('dash',None).get('url',None)
    licurl = plist.get('movie',None).get('video',None).get('protections',None).get('widevine',None).get('src',None)
    license_url=licurl+'|user-agent='+quote(UA)+'&Referer=https://fakty.tvn24.pl/|R{SSM}|'
    return vid, license_url

def PlayFakty(url):
    headers = {
    
        'User-Agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:80.0) Gecko/20100101 Firefox/80.0',
        'Accept': '*/*',
        'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',
    
    }
    
    response = sess.get(url, headers=headers,verify=False).text
    playlist=re.findall('(\{"options".*?})\,\s*{"widt',response,re.DOTALL)

    if playlist:
        if not '.mp4' in playlist[0]:
            stream,license_url = getAdaptiveDatasNew(playlist[0])
            # stream,license_url = getAdaptiveDatas(vidplayer[0],url)
    
            play_item = xbmcgui.ListItem(path=stream)
        
            play_item.setProperty('inputstream.adaptive.license_type', 'com.widevine.alpha')
            play_item.setProperty('inputstream.adaptive.license_key', license_url)
            play_item.setProperty('inputstream.adaptive.manifest_type', 'mpd')
            
            if sys.version_info >= (3,0,0):
                play_item.setProperty('inputstream', 'inputstream.adaptive')
            else:
                play_item.setProperty('inputstreamaddon', 'inputstream.adaptive')
    
            play_item.setMimeType('application/dash+xml')
            play_item.setProperty('inputstream.adaptive.manifest_update_parameter', 'full')
            play_item.setContentLookup(False)
            xbmcplugin.setResolvedUrl(addon_handle, True, listitem=play_item)
    
        else:
            srcdata = re.findall('"sources":(\{.*?}}),',response,re.DOTALL)
        
            if srcdata:
                srcdata = json.loads(srcdata[0])
        
                mp4s = srcdata.get('mp4',None)
                key, src = max(mp4s.items(), key=lambda x:x[1])
        
            else:
                src = re.findall('data-src="([^"]+)',response)
                if src:
                    src = re.sub('\=(\d+p\.mp4)', '1080p.mp4', src[0])
            play_item = xbmcgui.ListItem(path=src)
            xbmcplugin.setResolvedUrl(addon_handle, True, listitem=play_item)    

def czs(czas):

    import time
    import datetime
    try:
        format_date=datetime.datetime.strptime(czas, '%Y-%m-%dT%H:%M:%S.%fZ') 
    except TypeError:
        format_date=datetime.datetime(*(time.strptime(czas, '%Y-%m-%dT%H:%M:%S.%fZ')[0:6]))
    format_date = format_date+ datetime.timedelta(hours=2)

    pocz = format_date.strftime("%H:%M, %d.%m")

    return pocz#,koniec
    
    
    
def Najnowsze(url,pg):

    url2 = url+ str(pg)

    dd=compr2.compr2(url2)

    headers = {

        'User-Agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:80.0) Gecko/20100101 Firefox/80.0',
        'Accept': '*/*',
        'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',

        'Content-Type': 'application/json',

    }
    url2 ='https://tvn24.pl/api/%s'%dd
    response = sess.get(url2, headers=headers,verify=False).json()
    stories = response.get('data',None).get('stories',None).get('items',None)
    totoff = response.get('data',None).get('stories',None).get('total',None)
    nowoff = response.get('data',None).get('stories',None).get('offset',None)
    

    for story in stories:
        exc =''
        try:
            if story.get("updated",''):
                exc='jeden'
            #    cz = re.sub('(\:\d+Z)',':00.000Z',story.get("updated",''))
                
                publ = czs(re.sub('(\:\d+Z)',':00.000Z',story.get("updated",'')))
            #    publ = czs(story.get("updated",'').replace(':00Z',':00.000Z'))
                
            else:
                exc='dwa'
                publ = czs(re.sub('(\:\d+Z)',':00.000Z',story.get("published",'')))
            #    publ = czs(story.get("published",'').replace(':00Z',':00.000Z'))
                
        except:
            a1 = story.get("updated",'').replace(':00Z',':00.000Z')
            a2 = story.get("published",'').replace(':00Z',':00.000Z')
            zz=''
        tytul = story.get('title','')

        imag = story.get('relatedMedia',[])[0].get('content',None).get('binary','').get('href','')
        dod ='ok'
        href = story.get('href','')


        if  story.get('type','') =="ExternalContent":
            dod ='ext'
            opis = story.get("fields",None).get("leadtext",None)
            href = story.get('fields','').get('url','')

        else:
            opis = story.get("leadText",None)[0].get("fields",None)[0].get("value",None)
        opis+='[CR][COLOR yellow]%s[/COLOR]'%(publ)
        if story.get('isPremium',''):
            tytul = '[COLOR gold]'+tytul+'[/COLOR]'
        href = href +'|'+dod
        tytul = '[COLOR yellow]%s[/COLOR] '%(publ)+tytul

        add_item(href, PLchar(tytul),imag, "getVideos", folder=True, IsPlayable=False, infoLabels={'plot':PLchar(opis),'code':'[COLOR yellow]%s[/COLOR]'%(publ)})
    if nowoff+20<totoff:
        add_item(url, 'Następna strona',ikona, "tvn24najnowsze", folder=True, IsPlayable=False ,page=int(pg)+1)    
    xbmcplugin.endOfDirectory(addon_handle)
            
def PLchar(char):
    if type(char) is not str:
        char=char.encode('utf-8')
    char = char.replace('\\u0105','\xc4\x85').replace('\\u0104','\xc4\x84')
    char = char.replace('\\u0107','\xc4\x87').replace('\\u0106','\xc4\x86')
    char = char.replace('\\u0119','\xc4\x99').replace('\\u0118','\xc4\x98')
    char = char.replace('\\u0142','\xc5\x82').replace('\\u0141','\xc5\x81')
    char = char.replace('\\u0144','\xc5\x84').replace('\\u0144','\xc5\x83')
    char = char.replace('\\u00f3','\xc3\xb3').replace('\\u00d3','\xc3\x93')
    char = char.replace('\\u015b','\xc5\x9b').replace('\\u015a','\xc5\x9a')
    char = char.replace('\\u017a','\xc5\xba').replace('\\u0179','\xc5\xb9')
    char = char.replace('\\u017c','\xc5\xbc').replace('\\u017b','\xc5\xbb')
    char = char.replace('&#8217;',"'")
    char = char.replace('&#8211;',"-")    
    char = char.replace('&#8230;',"...")    
    char = char.replace('&#8222;','"').replace('&#8221;','"')    
    char = char.replace('[&hellip;]',"...")
    char = char.replace('&#038;',"&")    
    char = char.replace('&#039;',"'")
    char = char.replace('&quot;','"').replace('&oacute;','รณ').replace('&rsquo;',"'")
    char = char.replace('&nbsp;',".").replace('&amp;','&').replace('&eacute;','e')
    return char    

def router(paramstring):
    params = dict(parse_qsl(paramstring))
    
    if params:
        mode = params.get('mode', None)
        
        #if mode == 'opcje':
        #    addon.openSettings()
        #    addon.setSetting('wylog','false')
        #    xbmc.executebuiltin('Container.Refresh()')
            
            
        if mode =='tvn24main':
            Tvn24Main()
            xbmcplugin.endOfDirectory(addon_handle)
            
        elif mode =='tvn24najnowsze':
            Najnowsze(exlink,page)
            xbmcplugin.endOfDirectory(addon_handle)
            
        elif mode =='getVideos':
            getVideos(exlink)
    
        elif mode=='listfakty':
            ListFakty(page)    
    
        elif mode=="playfakty":
            PlayFakty(exlink)
            
            
        #elif mode == 'wylog':    
        #    addon.setSetting('wylog','true')
        #    xbmc.executebuiltin('Container.Refresh()')
        elif mode == 'playhqq':        
            playhqq(exlink)
            
        elif mode == 'listaudio':
            ListAudio()
            
        elif mode == 'loguj':
            Logowanie()
            
        elif mode == 'playaudio':        
            PlayAudio(exlink)
            
        elif mode == 'logout':
            yes = xbmcgui.Dialog().yesno("[COLOR orange]Uwaga[/COLOR]", 'Wylogowanie spowoduje konieczność ponownego wpisania kodu na stronie.[CR]Jesteś pewien?',yeslabel='TAK', nolabel='NIE')
            if yes:
                addon.setSetting('access_token', '')
                addon.setSetting('refresh_token', '')
                xbmc.executebuiltin('Container.Refresh()')
    
            
    else:
        home()
        xbmcplugin.endOfDirectory(addon_handle)    
if __name__ == '__main__':
    router(sys.argv[2][1:])