# -*- coding: UTF-8 -*-
import sys,re,os

import six
from six.moves import urllib_parse
import base64
import urllib3
import requests
import xbmcgui
import xbmcplugin
import xbmcaddon
import xbmc

if sys.version_info >= (3,0,0):
# for Python 3
    from resources.lib.cmf3 import parseDOM

else:
    # for Python 2
    from resources.lib.cmf2 import parseDOM

import inputstreamhelper
import json
import xbmcvfs

try:
   import StorageServer
except:
   import storageserverdummy as StorageServer

cache = StorageServer.StorageServer("tvpabon")

urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)
base_url = sys.argv[0]
addon_handle = int(sys.argv[1])
params = dict(urllib_parse.parse_qsl(sys.argv[2][1:]))

addon = xbmcaddon.Addon(id='plugin.video.tvpABON')
TIMEOUT=15
PATH            = addon.getAddonInfo('path')

try:
    DATAPATH        = xbmcvfs.translatePath(addon.getAddonInfo('profile'))
except:
    DATAPATH        = xbmc.translatePath(addon.getAddonInfo('profile')).decode('utf-8')



RESOURCES       = PATH+'/resources/'
FANART=RESOURCES+'tvpvod.jpg'
blad=PATH+'error.png'
#sys.path.append( os.path.join( RESOURCES, "lib" ) )
import resources.lib.vodTVPapi as vod
cookies = {}
exlink = params.get('url', None)
name= params.get('title', None)
page = params.get('page',[1])[0]
rys = params.get('image', None)

UA='Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:65.0) Gecko/20100101 Firefox/65.0'

s = requests.Session()

client_secret='Qao*kN$t10'

MAIN_URL='https://vod.tvp.pl'
def build_url(query):
    return base_url + '?' + urllib_parse.urlencode(query)

def add_item(url, name, image, folder, mode, fanart=FANART,infoLabels=False, contextmenu=None, itemcount=1, page=1):
    list_item = xbmcgui.ListItem(label=name)    
    if folder:
        list_item.setProperty("IsPlayable", 'false')
    else:
        list_item.setProperty("IsPlayable", 'true')
        
    if not infoLabels:
        infoLabels={'title': name,'plot':name}
    if contextmenu:
        isp=contextmenu
        list_item.addContextMenuItems(isp, replaceItems=True)
    list_item.setInfo(type="video", infoLabels=infoLabels)    
    list_item.setArt({'thumb': image, 'poster': image, 'banner': image, 'icon':image,'fanart': fanart})
    xbmcplugin.addDirectoryItem(
        handle=addon_handle,
        url = build_url({'foldername': name,'mode': mode, 'url' : url, 'page' : page,'image':image}),            
        listitem=list_item,
        isFolder=folder)

        
def getSrc(id,kuk=False):
    
    headers = {
        'accept-encoding': 'gzip',
        'authorization': 'Basic YXBpOnZvZA==',
        'connection': 'Keep-Alive',
        'content-length': '0',
        'content-type': 'application/x-www-form-urlencoded',
        'user-agent': 'okhttp/3.8.1',
    }
    if kuk:
        headers.update({'access-token': 'Bearer %s'%kuk,})
    params = (
        ('device', 'android'),
    )

    response = requests.post('https://apivod.tvp.pl/tv/v2/video/%s/default/default'%id, headers=headers, params=params, verify=False)#.json()
    ab=response.text
    src=''
    src2=''
    src3=''
    if not 'message":"Wideo nie istnieje"' in ab and not '"error":4005' in ab:
        response=response.json()
        src2=''
        src3=''
        if 'message' in response:
            src2=response['message']
            src=''
        if not src2:
    
            for v in response['data']:
                if 'proxyWidevine' in v:
                    widevine=v['proxyWidevine']
                    srcdash=v['fileDash']
                    break
            if widevine and srcdash:
                src3='%s||%s'%(srcdash,widevine)
                return src,src2,src3
            aa= response['data'][0]['formats']
            for a in aa:
                if a['mimeType']=='application/x-mpegurl':
                    src=a['url']
                    break
    else:
        import time
        
        SESS_URL2='https://vod.tvp.pl/sess/TVPlayer2/api.php?id='
        cdjs = '&@method=getTvpConfig&@callback=__tp2JSONP2477T'+str(int(time.time()))

        content = getUrlReq(SESS_URL2+id+cdjs)
        jsdata = re.findall('\(({.*?})\);',content,re.DOTALL)
        jsdata = json.loads(jsdata[0])
        files = jsdata.get('content', None). get('files', None)
        for ff in files:
            if 'hls' in ff.get('type', None):
                src = ff.get('url', None)
                break

    return src,src2,src3

def Loguj():
    sc=''
    s.cookies.clear()
    username = addon.getSetting('username')
    password = addon.getSetting('password')
    if username and password:
        headers = {
            'accept-encoding': 'gzip',
            'authorization': 'Basic dGVzdHZvZDp0ZXN0eXZvZDI5Mng=',
            'connection': 'Keep-Alive',
            'content-type': 'application/x-www-form-urlencoded',
            'user-agent': 'okhttp/3.8.1',
        }
        
        data = {
            'client_id': 'vod-api-android',
        'username': username,
        'client_secret': client_secret,
        'grant_type': 'password',
        'password': password
        }
        
        response = s.post('http://www.tvp.pl/sess/oauth/oauth/access_token.php', headers=headers, data=data).json()
        if 'access_token' in response:#response.has_key('access_token'):
            sc = response['access_token']
            addon.setSetting('token',sc)
        else:
            xbmcgui.Dialog().notification('[COLOR red][B]Błąd[/B][/COLOR]', '[COLOR red][B]Niepoprawne dane logowania.[/B][/COLOR]', xbmcgui.NOTIFICATION_INFO, 5000)    
            addon.setSetting('token','')
    return sc

def PlayTVPvod(id):

    sc = addon.getSetting('token')

    try:
        src,nxturl,playlist=getSrc(id)
    except:
        src=''
    if not src and not playlist:

        sc=Loguj()    
        if sc:
            xbmc.sleep(3000)

            src,nxturl,playlist=getSrc(id,sc)
            
    if not playlist:
        if nxturl:
            if not 'z Twojej lokalizacji' in nxturl:
                if not src:
                    xbmcgui.Dialog().notification('[COLOR red][B]Materiał płatny.[/B][/COLOR]', '[COLOR red][B]Wymaga zalogowania.[/B][/COLOR]', xbmcgui.NOTIFICATION_INFO, 5000)    
                    quit()
                else:
                    src=src#[0]
    
            else:
                xbmcgui.Dialog().notification('[COLOR red][B]Problem.[/B][/COLOR]', '[COLOR red][B]Ograniczenia Licencyjne, material jest niedostępny[/B][/COLOR]', xbmcgui.NOTIFICATION_INFO, 5000)    
                quit()
    
    else:
        src,drmwid=playlist.split('||')
        headersz = {
            'accept-encoding': 'gzip',
            'access-token': 'Bearer %s'%sc,
            'authorization': 'Basic YXBpOnZvZA==',
            'connection': 'Keep-Alive',
            'content-length': '0',
            'user-agent': 'okhttp/3.8.1',
        }
        src=requests.get(src,headers=headersz,allow_redirects=False)
        src=src.headers['Location']
    #else:
    play_item = xbmcgui.ListItem(path=src)
    if not 'mp4' in src:
        play_item.setProperty('inputstream.adaptive.manifest_type', 'hls')
        if sys.version_info >= (3,0,0):
            play_item.setProperty('inputstream', 'inputstream.adaptive')
        else:
            play_item.setProperty('inputstreamaddon', 'inputstream.adaptive')
            
        play_item.setMimeType('application/x-mpegurl')
    if '.ism' in src and not 'm3u8' in src:
        play_item.setProperty('inputstream.adaptive.license_type', 'com.widevine.alpha')
        play_item.setProperty('inputstream.adaptive.license_key', drmwid+'||R{SSM}|')#B{SSM}
        play_item.setProperty('inputstream.adaptive.manifest_type', 'mpd')
        if sys.version_info >= (3,0,0):
            play_item.setProperty('inputstream', 'inputstream.adaptive')
        else:
            play_item.setProperty('inputstreamaddon', 'inputstream.adaptive')
        play_item.setProperty('inputstream.adaptive.manifest_update_parameter', 'full')                    
        play_item.setProperty('inputstream.adaptive.license_flags', "persistent_storage")
    xbmcplugin.setResolvedUrl(addon_handle, True, listitem=play_item)

def Listabokatalog(exlink,page):
    page = int(page) if page else 1    
    links, pagin = GETabokatalog(exlink,page)    
    if pagin[0]:
        add_item(name='[COLOR blue]<< poprzednia strona <<[/COLOR]', url=exlink, mode='__page__M', image=RESOURCES+'nextpage.png', folder=True, page=pagin[0],fanart=FANART)    
    itemz=links
    items = len(links)
    for f in itemz:
        add_item(name=f.get('title'), url=f.get('href'), mode='getVideosVod', image=f.get('img'), fanart=FANART,folder=True, infoLabels={'title': f.get('title'),'code':f.get('code'),'plot':f.get('plot')}, itemcount=items)            
    if pagin[1]:
        add_item(name='[COLOR blue]>> Następna strona >>>[/COLOR]', url=exlink, mode='__page__M', image=RESOURCES+'nextpage.png', folder=True, page=pagin[1],fanart=FANART)    
    xbmcplugin.setContent(addon_handle, 'videos')    
    xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = "%R, %Y, %P")
    xbmcplugin.endOfDirectory(addon_handle)
        
def GETabokatalog(url,page):
    url = url + '?page=%d'%page
    html=getUrlReq(url)
    out=[]
    serout=[]
    prevpage=False #gr=False
    nextpage=False  # pr=False    
    lastp=re.findall('page=(\d+)"><span class="sr-only"></span></a>',html,re.DOTALL)[0]
    if int(page)<int(lastp):
        nextpage = page+1
    links = parseDOM(html, 'div', attrs={'class': "strefa-abo__item "})
    for link in links:    
        ab=re.findall('data-hover="(.+?)"',link,re.DOTALL)[0]
        c=ab.replace('&quot;','"').replace("\/","/").replace("&lt;strong&gt;","").replace("&lt;/strong&gt;","").replace("&lt;br&gt;","").replace("&lt;br/&gt;","").replace("&lt;div&gt;","").replace('false','"False"').replace('null','"Null"')
        item=json.loads(c)
        try:
            imag = parseDOM(link, 'img', ret='src')[0]
        except:
            imag=re.findall('img src="(.+?)"',link,re.DOTALL)[0]    
        imag  = 'http:'+imag  if imag .startswith('//') else imag 
        imag=re.sub('width_\d+','width_800',imag)
        imag=re.sub('height_\d+','height_400',imag)
        title = parseDOM(link, 'h3', attrs={'class': "strefa-abo__title"}) [0]
        genre = parseDOM(link, 'h4', attrs={'class': "strefa-abo__sub-title"}) [0]                            
        plot = item.get("description",'')    
        try:
            href = parseDOM(link, 'a', ret='href')[0]

        except:
            href = item.get("episodeLink",'')
    
        ftitle=ftitle='%s       [COLOR gold](%s)[/COLOR]'%(PLchar(title),PLchar(genre))
        href  = 'https://vod.tvp.pl'+href  if href .startswith('/') else href
    
        out.append({'title':ftitle,'href':href,'img':imag,'plot':PLchar(plot),'code':PLchar(genre)})
    prevpage = page-1 if page>1 else False
    return (out,(prevpage,nextpage))    
    
def ListVideosVod(exlink):
    links = GetVideosVod(exlink)        
    itemz=links
    items = len(links)
    for f in itemz:
        add_item(name=f.get('title'), url=f.get('href'), mode='playTVPstrABON', image=f.get('img'), folder=False, infoLabels={'title': f.get('title'),'code':f.get('code'),'plot':f.get('plot')}, itemcount=items)    
    xbmcplugin.setContent(addon_handle, 'videos')    
    xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_PRODUCTIONCODE, label2Mask = "%R, %Y, %P")
    xbmcplugin.endOfDirectory(addon_handle)

def GetVideosVod(url):

    html=getUrlReq(url,True)
    out=[]    
    links = parseDOM(html, 'div', attrs={'class': "strefa-abo__item "})
    for link in links:    
        ab=re.findall('data-hover="(.+?)"',link,re.DOTALL)[0]
        c=ab.replace('&quot;','"').replace("\/","/").replace('false','"False"').replace('null','"Null"')
        item=json.loads(c)

        try:
            imag = parseDOM(link, 'img', ret='src')[0]
        except:
            imag=re.findall('img src="(.+?)"',link,re.DOTALL)[0]    
        imag  = 'http:'+imag  if imag .startswith('//') else imag 
        imag=re.sub('width_\d+','width_800',imag)
        imag=re.sub('height_\d+','height_400',imag)
        title = parseDOM(link, 'h3', attrs={'class': "strefa-abo__title"}) [0]
        genre = parseDOM(link, 'h4', attrs={'class': "strefa-abo__sub-title"}) [0]                            
        plot = item.get("description",'')    
        try:
            href = parseDOM(link, 'a', ret='href')[0]

        except:
            href = item.get("episodeLink",'')    
        ftitle=PLchar(title)
        href=re.findall('(\d+)',href)[-1]
        out.append({'title':ftitle,'href':href,'img':imag,'plot':PLchar(plot),'code':PLchar(genre)})
    return out            
    
def home():
    add_item('https://vod.tvp.pl/strefa-abo/katalog,36448626', 'Strefa ABO', RESOURCES+'tvpicon.png',True, "abokatalog", fanart=FANART)    
    add_item('https://vod.tvp.pl/strefa-abo/katalog,36448626z', 'VOD', RESOURCES+'tvpicon.png', True,'vodTVProot', fanart=FANART)
    add_item('', 'Szukaj', RESOURCES+'search.png', True, 'Szukaj')    
    xbmcplugin.setContent(addon_handle, 'videos')    
    xbmcplugin.endOfDirectory(addon_handle)

def getUrlReq(url,lasturl=False):
    headers = {
        'User-Agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:65.0) Gecko/20100101 Firefox/65.0',
        'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
        'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',
        'Connection': 'keep-alive',
        'Upgrade-Insecure-Requests': '1',
        'Cache-Control': 'max-age=0',
    }
    if lasturl:
        
        url=s.get(url,headers=headers, verify=False).url
        url=url+'/video'
    content=s.get(url,headers=headers, verify=False).text    
    return content

def Szukanie(query):
    if not '+' in query:
        query=urllib_parse.quote(query)
    url='https://vod.tvp.pl/szukaj?query='+query
    links=getSzukanie(url)
    itemz=links
    items = len(links)
    for f in itemz:
        add_item(name=f.get('title'), url=f.get('href'), mode='listwyszukane', image=f.get('img'), folder=True, infoLabels=f, itemcount=items)    
    xbmcplugin.setContent(addon_handle, 'videos')    
    xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_PRODUCTIONCODE, label2Mask = "%R, %Y, %P")
    xbmcplugin.endOfDirectory(addon_handle)

def getSzukanie(url):
    html=getUrlReq(url)
    out=[]    
    
    result = parseDOM(html, 'div', attrs={'class': "row serachContent"})[0]
    links = parseDOM(result, 'div', attrs={'class': "col-xs-5ths"}) 

    for link in links:
        try:
            hover = json.loads((parseDOM(link, 'div', attrs={'data-hover': ".+?"},ret='data-hover')[0]).replace('&quot;','"').replace("\/","/").replace("&lt;strong&gt;","").replace("&lt;/strong&gt;","").replace("&lt;br&gt;","").replace("&lt;br/&gt;","").replace("&lt;div&gt;","").replace('false','"False"').replace('null','"Null"'))#.replace('&quot;','"'))#'div', ret='data-hover')#[0]
        except:
            pass
        img=hover.get('image','')
        img = 'https:'+img if img.startswith('//') else img
        img=re.sub('width_\d+','width_800',img)
        img=re.sub('height_\d+','height_480',img)
        tit=hover.get('title','')   
        plot=hover.get('description','')   
        
        href=hover.get('episodeLink','')  
        href = MAIN_URL+href if href.startswith('/') else href
        out.append({'title':PLchar(tit),'href':href,'img':img,'plot':PLchar(plot)})
    return out    

def ListNpage(url):
    
    links,npage=getListNpage(url)
    itemz=links
    items = len(links)
    for f in itemz:
        add_item(name=f.get('title'), url=f.get('href'), mode='playTVPstrABON', image=f.get('img'), folder=False, infoLabels=f, itemcount=items)    
    if npage:
        add_item(name='Następna strona', url=npage, mode='listnpage', image='', folder=True, infoLabels={})
    xbmcplugin.setContent(addon_handle, 'videos')    
    xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = "%R, %Y, %P")
    xbmcplugin.endOfDirectory(addon_handle)    
    
def getListNpage(url):

    html=getUrlReq(url)
    out=[]

    html = html.replace('\\"','"').replace('false','"False"').replace('null','"Null"').replace('true','"True"').replace('&quot;','"').replace('\\\\n','\n').replace('\n','').replace('\\\\\\/','/').replace('\\\\','\\')#.replace('\\\\u','\u')
    hovers = re.findall('data-hover="({.*?})',html,re.DOTALL)
    ab=len(hovers)
    npage=False
    nxt = re.findall('hasNext"\:"([^"]+)"',html)[0] 
    if nxt =='True':
        npage=True

        ostat = re.findall('data\-id="([^"]+)"',html,re.DOTALL)[-1]
        npage = 'https://vod.tvp.pl/player/slider/'+ostat+'/next'
    
    for hover in hovers:
        hover = json.loads(hover)
        odc=hover.get('episodeCount','')
        odc = '' if odc == 'Null' else odc
        img=hover.get('image','')
        img = 'https:'+img if img.startswith('//') else img
        img=re.sub('width_\d+','width_800',img)
        img=re.sub('height_\d+','height_480',img)
        tit=hover.get('title','')   
        plot=hover.get('description','')   
        href=hover.get('episodeLink','')  
        href=re.findall('(\d+)',href)[-1]
        out.append({'title':PLchar(tit),'href':href,'img':img,'plot':PLchar(plot),'code':PLchar(odc)})
    return out,npage
def ListWyszukane(url):
    
    links,npage=getListWyszukane(url)
    itemz=links
    items = len(links)
    for f in itemz:
        add_item(name=f.get('title'), url=f.get('href'), mode='playTVPstrABON', image=f.get('img'), folder=False, infoLabels=f, itemcount=items)    
    if npage:
        add_item(name='Następna strona', url=npage, mode='listnpage', image='', folder=True, infoLabels={})
    xbmcplugin.setContent(addon_handle, 'videos')    
    xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = "%R, %Y, %P")
    xbmcplugin.endOfDirectory(addon_handle)    

    
def getListWyszukane(url):
    html=getUrlReq(url)
    out=[]
    result = parseDOM(html, 'div', attrs={'class': "owl-container"})[0]
    hovers=parseDOM(result, 'div', attrs={'data-hover': ".+?"},ret='data-hover')
    npage=''
    nxt = re.findall('data\-hasNext="([^"]+)"',result)[0]
    if nxt =='true':
        npage=True
        ostat = re.findall('data\-id="([^"]+)"',result,re.DOTALL)[-1]
        npage = 'https://vod.tvp.pl/player/slider/'+ostat+'/next'
    for hover in hovers:
        hover = json.loads(hover.replace('&quot;','"').replace("\/","/").replace('false','"False"').replace('null','"Null"'))
        odc=hover.get('episodeCount','')
        odc = '' if odc == 'Null' else odc
        img=hover.get('image','')
        img = 'https:'+img if img.startswith('//') else img
        img=re.sub('width_\d+','width_800',img)
        img=re.sub('height_\d+','height_480',img)
        tit=hover.get('title','')   
        plot=hover.get('description','')   
        href=hover.get('episodeLink','')  
        href=re.findall('(\d+)',href)[-1]
        out.append({'title':PLchar(tit),'href':href,'img':img,'plot':PLchar(plot),'code':PLchar(odc)})
    return out,npage        

def getHistory():
    return cache.get('history').split(';')

def setHistory(entry):
    history = getHistory()
    if history == ['']:
        history = []
    history.insert(0, entry)
    cache.set('history',';'.join(history[:50]))

def remCache(entry):
    history = getHistory()
    history.remove(entry)
    if history:
        cache.set('history',';'.join(history[:50]))
    else:
        delHistory()

def delHistory():
    cache.delete('history')
    
    
    
    
def PLchar(char):

    if type(char) is not str:
        char=char.encode('utf-8')
    char = char.replace('\\u0105','\xc4\x85').replace('\\u0104','\xc4\x84')
    char = char.replace('\\u0107','\xc4\x87').replace('\\u0106','\xc4\x86') #E9
    char = char.replace('\\u00e9','\xc3\xa9').replace('\\u00C9','\xc3\x89') #E9    
    char = char.replace('\\u0119','\xc4\x99').replace('\\u0118','\xc4\x98')
    char = char.replace('\\u0142','\xc5\x82').replace('\\u0141','\xc5\x81')
    char = char.replace('\\u0144','\xc5\x84').replace('\\u0144','\xc5\x83')
    char = char.replace('\\u00f3','\xc3\xb3').replace('\\u00d3','\xc3\x93')
    char = char.replace('\\u015b','\xc5\x9b').replace('\\u015a','\xc5\x9a')
    char = char.replace('\\u017a','\xc5\xba').replace('\\u0179','\xc5\xb9')
    char = char.replace('\\u017c','\xc5\xbc').replace('\\u017b','\xc5\xbb')
    char = char.replace('&#8217;',"'")
    char = char.replace('&#8211;',"-")    
    char = char.replace('&#8230;',"...")    
    char = char.replace('&#8222;','"').replace('&#8221;','"')    
    char = char.replace('[&hellip;]',"...")
    char = char.replace('&#038;',"&")    
    char = char.replace('&nbsp;',".").replace('&amp;','&')
    return char    

if __name__ == '__main__':
    mode = params.get('mode', None)
    if not mode:
        home()
        xbmcplugin.endOfDirectory(addon_handle)        
        
    elif mode == 'playTVPstrABON':
        PlayTVPvod(exlink)    

    elif mode == "abokatalog":
        Listabokatalog(exlink,page)        

    elif mode == 'getVideosVod':
        ListVideosVod(exlink)
    
    
    elif mode == '__page__M':
        url = build_url({'mode': 'abokatalog', 'foldername': '', 'url' : exlink, 'page' : page})
        xbmc.executebuiltin('Container.Refresh(%s)'% url)
        xbmcplugin.endOfDirectory(addon_handle)
        
    elif mode =='vodTVP':

        (katalog,episodes) = vod.vodTVPapi(exlink,page)
        if episodes:
            for e in episodes:
                add_item(name=e.get('title'), url=e.get('filename'), mode='playTVPstrABON', image=e.get('img'), folder=False, infoLabels=e)
            xbmcplugin.setContent(addon_handle, 'videos')    
            xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = "%P, %D")
            xbmcplugin.endOfDirectory(addon_handle,True)            
        for one in katalog:
            add_item(name=one['title'], url=one['id'], mode='vodTVP', image=one.get('img'), page=one.get('page',1),folder=True)
        xbmcplugin.setContent(addon_handle, 'videos')        
        xbmcplugin.endOfDirectory(addon_handle,True)    
    elif mode =='vodTVProot':        
        lo = vod.vodTVP_root()
        for k in lo:
            add_item(name=k.get('title','').title().encode('utf-8'), url=str(k.get('id','')), image=k.get('img',''),mode='vodTVP',folder=True)    
        xbmcplugin.setContent(addon_handle, 'videos')    
        xbmcplugin.endOfDirectory(addon_handle,True)            

        
        
        
    elif mode == 'listwyszukane':
        ListWyszukane(exlink)            
        
    elif mode == 'searchItems':
        Szukanie(exlink)    
    
    elif mode=='listnpage':
        ListNpage(exlink)

    
    elif mode =='Szukaj':
        add_item(name='Nowe Szukanie(Film,Serial)', url='', mode='SzukajNowe', image='',folder=True)
        #addDir('[B]Nowe Szukanie(Film,Serial)[/B]','',mode='SzukajNowe')
        historia = getHistory()
        if not historia == ['']:
            for entry in historia:
                contextmenu = []
                contextmenu.append(('Usuń', 'Container.Refresh(%s)'% build_url({'mode': 'SzukajUsun', 'url' : entry})),)
                contextmenu.append(('Usuń całą historię', 'Container.Update(%s)' % build_url({'mode': 'SzukajUsunAll'})),)
                
                
                add_item(name='[COLOR yellowgreen]'+entry+'[/COLOR]', url=entry.replace(' ','+'), mode='searchItems', image='',folder=True, contextmenu=contextmenu)
                #addDir(name=entry, ex_link=entry.replace(' ','+'), mode='searchItems', fanart=None, contextmenu=contextmenu)
        xbmcplugin.endOfDirectory(addon_handle)
    elif mode =='SzukajNowe':
        d = xbmcgui.Dialog().input('Szukaj, Podaj tytuł filmu/serialu/bajki Imię aktora', type=xbmcgui.INPUT_ALPHANUM)
        if d:
            setHistory(d)
            url = build_url({'mode': 'searchItems', 'foldername': '', 'url' : d.replace(' ','+'), 'page': 1})
            xbmc.executebuiltin('Container.Refresh(%s)'% url)
            #url = build_url({'foldername': name,'mode': mode, 'url' : url, 'page' : page,'image':image}),
        else:
            quit()
        xbmcplugin.endOfDirectory(addon_handle)
    elif mode =='SzukajUsun':
        remCache(exlink)
        xbmc.executebuiltin('Container.Refresh(%s)'%  build_url({'mode': 'Szukaj'}))
        xbmcplugin.endOfDirectory(addon_handle)
    elif mode == 'SzukajUsunAll':
        delHistory()
        xbmc.executebuiltin('Container.Refresh(%s)'%  build_url({'mode': 'Szukaj'}))
        xbmcplugin.endOfDirectory(addon_handle)
        
        
        
        