# coding: UTF-8
from __future__ import division

import xbmc, xbmcgui

import sys, re
import uuid
import json
import requests, urllib3

import calendar
import iso8601
from datetime import datetime, timedelta

if sys.version_info >= (3,0,0):
# for Python 3
    to_unicode = str

    from urllib.parse import unquote, quote

else:
    # for Python 2
    to_unicode = unicode

    from urllib import unquote, quote

    
urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)

sess = requests.Session()


        
class Vectra:
    def __init__(self, plugin, fanartx, ikona ):
    
        self.plugin = plugin
        self.fanart  = fanartx
        self.ikona  = ikona
        
        self.UA ='Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:90.0) Gecko/20100101 Firefox/90.0'
        self.api_url = 'api.tvonline.vectra.pl'
        self.subscrlogin = 'subscriber/login'
        self.main_url = 'https://{}/{}?platform=BROWSER&system=tvonline'
        
        self.products_url = 'https://api.tvonline.vectra.pl/products/{}/{}?platform=BROWSER&system=tvonline'

        self.token = self.plugin.get_setting("token")
        self.device_id = self.plugin.get_setting('device_id')
        self.login = self.plugin.get_setting('login')
        self.password = self.plugin.get_setting('password')
        self.mysubscrs = self.plugin.get_setting('mysubscrs')
        self.mysubscrs = json.loads(unquote(self.mysubscrs)) if self.mysubscrs else ''

        self.headers = {
                    'Host': self.api_url,
                    'user-agent': self.UA,
                    'accept': 'application/json',
                    'accept-language': 'pl,en-US;q=0.7,en;q=0.3',
                    'content-type': 'application/json',
                    'access-control-allow-origin': '*',
                    'api-deviceuid': self.device_id,
                    'api-device': 'Firefox; 90; Windows; 7; Windows; 7;',
                    'origin': 'https://tvonline.vectra.pl',
                    'referer': 'https://tvonline.vectra.pl/',
                    'sec-fetch-dest': 'empty',
                    'sec-fetch-mode': 'cors',
                    'sec-fetch-site': 'same-site',
                    'te': 'trailers',
                    }
        self.file_name = self.plugin.get_setting('fname')
        self.path_m3u = self.plugin.get_setting('path_m3u')
        
    def home(self):
        if self.device_id == '00000000-0000-0000-0000-000000000000':
            self.createDevId()
    
        dod, logged = self.logowanie()
    
        if not logged:
            self.plugin.add_item('film', 'Zaloguj', 'DefaultUser.png', "loguj", folder=False,fanart=self.fanart)
        else:
        
            self.plugin.add_item('film', 'Zalogowany jako: '+dod, 'DefaultUser.png', "  ", folder=True, infoLabels={'plot':dod}, fanart=self.fanart)
            self.plugin.add_item('film', 'Telewizja', 'DefaultMovies.png', "listtvcat", folder=True,fanart=self.fanart)
            self.plugin.add_item('VOD_WEB', 'Filmy', 'DefaultMovies.png', "listvodcat", folder=True,fanart=self.fanart)
            self.plugin.add_item('SERIES_WEB', 'Seriale', 'DefaultMovies.png', "listvodcat", folder=True,fanart=self.fanart)
            self.plugin.add_item('KIDS_WEB', 'Dla dzieci', 'DefaultMovies.png', "listvodcat", folder=True,fanart=self.fanart)
            self.plugin.add_item('KIDS_WEB', 'Szukaj', 'DefaultMovies.png', "szukaj", folder=True,fanart=self.fanart)
            self.plugin.add_item('film', 'Opcje', 'DefaultUser.png', "opcje", folder=False,fanart=self.fanart)
            self.plugin.add_item('film', '[COLOR gold][B]Utwórz listę[/COLOR][/B]', 'DefaultUser.png', "generatem3u", folder=False,fanart=self.fanart)
        self.plugin.EOD()
        

    def createDevId(self):
        dev_id = uuid.uuid4()
        self.plugin.set_setting('device_id',str(dev_id))
        return
        
    def logowanie(self):
        ok = False
    
        if self.login and self.password:
            url = (self.main_url).format(self.api_url,self.subscrlogin)
            data = {"os":"Windows","osVersion":"7","maker":"unknown","agent":"Firefox","login":self.login,"password":self.password,"uid":self.device_id}

            jsdata = sess.post(url, headers=self.headers, json=data, verify=False).json()
            if jsdata.get("token",None):
                self.plugin.set_setting('token',str(jsdata.get("token",None)))
                if jsdata.get("status",None).get("deviceName",None):
                    self.token = self.plugin.get_setting("token")
                    self.headers.update({'authorization': 'Bearer '+self.token})

                    jsdata = sess.get('https://{}/subscriber/products/uuids?platform=BROWSER&system=tvonline'.format(self.api_url), headers=self.headers, verify=False).json()
                    mysubscrs = jsdata.get("data",None)

                    #jsdata2 = sess.get('https://{}/subscriber/products?platform=BROWSER&system=tvonline'.format(self.api_url), headers=self.headers, verify=False).json()

                    mysubscrs = quote(json.dumps(mysubscrs)) if mysubscrs else ''

                    self.plugin.set_setting('mysubscrs',mysubscrs)
                    ok = True
                else:
                    ab = jsdata.get("status",None).get("limits",None)[0]
                    tt = ab.get('message',None)
                    self.plugin.notification_dialog('[B]Uwaga[/B]', '[B]%s[/B]'%(tt),xbmcgui.NOTIFICATION_INFO, 8000,False) 
                    xbmc.sleep(500)
                    yes = self.plugin.yesno_dialog("[COLOR orange]Uwaga[/COLOR]", 'Brak miejsc na urządzenie. Zamienić je z jednym z dostępnych już na koncie?',yeslabel='YES', nolabel='NO')
                    if yes:
                        ok = self.wymiana()
                    
                pass
            else:
                tt = jsdata.get('message',None)
                self.plugin.notification_dialog('[B]Uwaga[/B]', '[B]%s[/B]'%(str(tt)),xbmcgui.NOTIFICATION_INFO, 8000,False) 

                return None,False
        if ok:
            return self.login, True
        return None,False

    def wymiana(self):
        out=[]
        url = 'https://{}/subscriber/devices/active?order[0][column]=9&order[0][dir]=desc&platform=BROWSER&system=tvonline'.format(self.api_url)
        
        self.token = self.plugin.get_setting("token")
        self.device_id = self.plugin.get_setting('device_id')

        self.headers.update({'authorization': 'Bearer '+self.token, 'api-deviceuid': self.device_id})

        jsdata = sess.get(url, headers=self.headers, verify=False).json()
        for dt in jsdata.get("data",None):
            devid = dt.get("device_id",None)
            devname = dt.get("device_name",None)
            lstlogin = dt.get("last_login_date",None)
            dd = '%s | %s'%(devname,lstlogin)
            out.append({'devid':devid,'devname':dd}) 
        label = [x.get('devname') for x in out]
        keje = [x.get('devid') for x in out]
        
        sel = self.plugin.select_dialog('Wybierz urządzenie do zastąpienia:',label)
        
        keyid = out[sel].get('devid') if sel>-1 else ''
        if keyid:
            pwd = self.plugin.input_dialog('Podaj nazwę dla urządzenia', xbmcgui.INPUT_ALPHANUM)
            
            
            pwd = pwd if pwd else 'nowex'

            url = 'https://{}/subscriber/device/toggle?platform=BROWSER&system=tvonline'.format(self.api_url)
            data = {"uidOfDeviceToDelete":keyid,"nameOfNewDevice":pwd}
            jsdata = requests.put(url, headers = self.headers, json=data, verify=False).json()
            if 'errorCode' in jsdata:
                    if jsdata.get('errorCode',None).lower() == 'subscriber_devices_changing_limit_exceeded':
                        self.plugin.set_setting('device_id',str(keyid))
                        self.logowanie()
                        return True
            self.plugin.set_setting('token',str(jsdata.get("token",None)))
            self.token = self.plugin.get_setting("token")
            self.headers.update({'authorization': 'Bearer '+self.token})

            jsdata = sess.get('https://{}/subscriber/products/uuids?platform=BROWSER&system=tvonline'.format(self.api_url), headers=self.headers, verify=False).json()
            mysubscrs = jsdata.get("data",None)
            mysubscrs = quote(json.dumps(mysubscrs)) if mysubscrs else ''

            self.plugin.set_setting('mysubscrs',mysubscrs)
            return True
        return False
        
        
    def liveChList(self):

        self.headers.update({'authorization': 'Bearer '+self.token})

        out=[]
        jsdata = sess.get('https://{}/products/channel?offset=0&limit=300&platform=BROWSER&system=tvonline'.format(self.api_url), headers=self.headers, verify=False).json()
        datas = jsdata.get("data",None)

        for dt in datas:

            avins = dt.get("available_in",None)
            jest = False
            
            for mysubscr in self.mysubscrs:
                if not jest:
                    for av in avins:
                        dod = ' [COLOR red][B] brak[/COLOR][/B]'
                        if av in mysubscr:
            
                            dod = ''
                            jest = True
                            break
                        else:
                            continue
            if dod == '':

                out.append([self.plugin.PLchar(dt.get("title",None)),dt.get("uuid",None)])
        return out
  
    def listTV(self, id, kateg = False):

        self.headers.update({'authorization': 'Bearer '+self.token})

        if not kateg:
            epgs = self.getEpgs()

            jsdata = sess.get('https://{}/products/channel?offset=0&limit=300&platform=BROWSER&system=tvonline'.format(self.api_url), headers=self.headers, verify=False).json()
            datas = jsdata.get("data",None)

            for dt in datas:
                gen = dt.get("genres",None)[0].get("slug",None)
                if id == gen:
                    title = dt.get("title",None)

                    avins = dt.get("available_in",None)
                    jest = False

                    for mysubscr in self.mysubscrs:
                        if not jest:
                            for av in avins:
                                dod = ' [COLOR red][B] brak[/COLOR][/B]'
                                if av in mysubscr:

                                    dod = ''
                                    jest = True
                                    break
                                else:
                                    continue

                    uuid = dt.get("uuid",None)
                    plot = self.getEpgPlot(uuid, epgs)
                    plot = plot if plot else title
                    img = dt.get("images",None).get("logo",None)[0].get("url",None)
                    catch_up = dt.get("context",None).get("catch_up_time",None)
                    if catch_up:
                        self.plugin.add_item(name=self.plugin.PLchar(title+dod+' [COLOR yellow](catchup)[/COLOR]'), url=uuid, mode='showcatchup', image=img, folder=True, IsPlayable=True, fanart = self.fanart, infoLabels={'plot':self.plugin.PLchar(plot)})
                    else:

                        self.plugin.add_item(name=self.plugin.PLchar(title+dod), url=uuid, mode='playtv', image=img, folder=False, IsPlayable=True, fanart = self.fanart, infoLabels={'plot':self.plugin.PLchar(plot)})
        else:

            jsdata = sess.get('https://{}/products/genres/channel?platform=BROWSER&system=tvonline'.format(self.api_url), headers=self.headers, verify=False).json()
            datas = jsdata.get("data",None) 
            for dt in datas:
                title = dt.get("name",None)
                slug = dt.get("slug",None)
                try:
                    img = dt.get("images",None).get("icon",None)[0].get("url",None)
                except:
                    img = self.ikona
                self.plugin.add_item(name=self.plugin.PLchar(title), url=slug, mode='listtv', image=img, folder=True, IsPlayable=True, fanart = self.fanart, infoLabels={'plot':self.plugin.PLchar(title)})

        if datas:
            self.plugin.EOD()
    
    
    
    def listCatchups(self, dni):
        days = eval(unquote(dni))
        for d in days:

            self.plugin.add_item(name=self.plugin.PLchar(d.get('title', None)), url=d.get('uuid', None), mode='playtv', image=d.get('ikona', None), folder=False, IsPlayable=True, fanart = self.fanart, infoLabels={'plot':self.plugin.PLchar(d.get('title', None))})
        self.plugin.EOD()
        
        
    
    def showCatchup(self, uuid, tytul, icona):
        epgs = self.getEpgs()
        plot = self.getEpgPlot(uuid, epgs)
        tytul = tytul.replace('[COLOR yellow](catchup)[/COLOR]','')
        plot = plot if plot else tytul
        self.plugin.add_item(name=self.plugin.PLchar(tytul+ '[COLOR lightgreen][B]LIVE[/COLOR][/B]'), url=uuid, mode='playtv', image=icona, folder=False, IsPlayable=True, fanart = self.fanart, infoLabels={'plot':self.plugin.PLchar(plot)})

        epgs = self.getEpgs(True)
        catchups = self.getCatchups(uuid, epgs)

        for i in sorted(catchups.keys(), reverse=True):

            self.plugin.add_item(name=self.plugin.PLchar(i), url=quote(str(catchups.get(i, None))), mode='listcatchups', image=icona, folder=True, IsPlayable=False, fanart = self.fanart, infoLabels={'plot':self.plugin.PLchar(tytul)})

        self.plugin.EOD()
    def getCatchups(self, uuid, epgs):    
        out =[]
        for channel in epgs.json():
            if uuid == channel.get('channel_uuid', None):
                programs = channel.get('programs', None)
                out2 =[]
                for program in programs:

                    czasod = self.plugin.parse_datetime(program.get('since', None) , localize=False) #parse_datetime(self, iso8601_string, localize=False)
                    
                    czasod2 = czasod.strftime('%d-%m')
                    
                    czasod = czasod.strftime('%d-%m %H:%M')
                    czasdo =self.plugin.parse_datetime(program.get('till', None) , localize=False)  # program.get('till', None)
                    czasdo = czasdo.strftime('%H:%M')
                    
                    tit = program.get('title', None)
                    tit1='[COLOR khaki]%s - %s[/COLOR] %s[CR]'%(czasod, czasdo, tit)

                    uuid = program.get('uuid', None)
                    channel_uuid = program.get('channel_uuid', None)

                    uuid2 = '%s|%s|programId'%(str(channel_uuid),str(uuid))
                    try:
                        img = program.get('images', None).get("cover", None)[0].get("url", None) 
                    except:
                        img = self.ikona
                    description_short = program.get("description_short", None)
                    plot = description_short if description_short else tit1
                    out.append({"title": tit1, 'dzien':czasod2, 'uuid':uuid2, 'ikona':img, 'plot': plot})
                break
        dni = self.podzielDni(out)

        return dni    


    def podzielDni(self, dni):
        outx={}
        days = [x.get('dzien') for x in dni]
        for s in set(days):
    
            outx[s]=[dni[i] for i, j in enumerate(days) if j == s]
        return outx

    def getEpgPlot(self, uuid, epgs):
        plot=''
        for channel in epgs.json():
            if uuid == channel.get('channel_uuid', None):
                programs = channel.get('programs', None)

                for program in programs:
                    
                    czasod = self.plugin.parse_datetime(program.get('since', None) , localize=False) 
                    czasod = czasod.strftime('%d-%m %H:%M')
                    
                    
                    czasdo =self.plugin.parse_datetime(program.get('till', None) , localize=False)  
                    czasdo = czasdo.strftime('%H:%M')
                    
                    tit = program.get('title', None)
                    plot+='[COLOR khaki]%s - %s[/COLOR] %s[CR]'%(czasod, czasdo, tit)

                break
        return plot

    def getEpgs(self, catchup = False):
        od,do = self.getOdDo(catchup)
        self.headers.update({'authorization': 'Bearer '+self.token})
        url1 = 'https://{0}/epg?startDate={1}&endDate={2}&platform=BROWSER&system=tvonline'.format(self.api_url,od,do)

        epgs = sess.get(url1, headers=self.headers, verify=False)#.json()
        return epgs
        
    def getOdDo(self,catchup=False):
        a=datetime.utcnow()
        czasteraz = a.strftime('%Y-%m-%dT%H:%M')
        czasteraz = self.plugin.parse_datetime(czasteraz, localize=True)

        do = czasteraz +timedelta(hours=4) 
        od = czasteraz +timedelta(hours=-1) 
        if catchup:
            do = czasteraz +timedelta(minutes=4) 
            od = czasteraz +timedelta(days=-3) 
        do = do .strftime('%Y%m%d%H0000')
        od = od .strftime('%Y%m%d%H0000')
        return od,do
    
    def getnpage(self, url):
        self.headers.update({'authorization': 'Bearer '+self.token})
        jsdata = sess.get(url, headers=self.headers, verify=False).json()
        datas = jsdata.get("data", None)
        return True if len(datas)>0 else False
        
    def listVOD(self, id, pg, kateg = False):

        npg = str(int(pg)+24)
        if 'query' in id:
            npg = str(int(pg)+100)
        self.headers.update({'authorization': 'Bearer '+self.token})

        if not kateg:

            url = 'https://{0}/sections/{1}/content?offset={2}&limit=24&platform=BROWSER&system=tvonline'.format(self.api_url, id, pg)
            npurl = 'https://{0}/sections/{1}/content?offset={2}&limit=24&platform=BROWSER&system=tvonline'.format(self.api_url, id, npg)
            if 'subtype' and 'genre' in id:
                idx = id.replace('genre=','').replace('subtype=','')
                
                stype,gen = idx.split('&')
                url = 'https://{0}/products/{1}?subtype={1}&genre={2}&limit=24&offset={3}&platform=BROWSER&system=tvonline'.format(self.api_url, stype, gen, pg)
                npurl = 'https://{0}/products/{1}?subtype={1}&genre={2}&limit=24&offset={3}&platform=BROWSER&system=tvonline'.format(self.api_url, stype, gen, npg)
            elif 'query' in id:
                query = id.split('|')[-1]
                
                url = 'https://{0}/products/search?q={1}&limit=100&offset={2}&platform=BROWSER&system=tvonline'.format(self.api_url, query, pg)
                npurl = 'https://{0}/products/search?q={1}&limit=100&offset={2}&platform=BROWSER&system=tvonline'.format(self.api_url, query, npg)
                    
            jsdata = sess.get(url, headers=self.headers, verify=False).json()
            datas = jsdata.get("data", None)
           
            for dt in datas:
                dod =''
                avins = dt.get("available_in",None)
                available_prices = dt.get("available_prices",None)

                uuid = dt.get("uuid", None)

                jest = False
                for mysubscr in self.mysubscrs:
                    if uuid in mysubscr:
                        jest = True
                        
                        break
                    
                
                if not jest:
                    if avins:
                        jest = False
                        for mysubscr in self.mysubscrs:
                            if not jest:
                                for av in avins:
                                    dod = ' [COLOR red][B] brak[/COLOR][/B]'
                    
                                    if av in mysubscr:
                                        dod = ''
                                        jest = True
                                        break
                                    else:
                                        continue
                    
                    elif available_prices:
                    
                        rent = dt.get("prices",None).get("rent",None)
                        price = rent.get("price", None)
                        if price:
                            price = str("%.2f PLN" % (price / 100))
                    
                            period = rent.get("period", None)
                            dod = ' (%s | %sh)'%(str(price),str(period))
                        else:
                            dod =''
                    else:
                        dod =''
                    
                        pass

                type = dt.get("type", None)
                subtype = dt.get("subtype", None)
                context = dt.get( "context", None)
                title = dt.get("title", None)
                if jest:
                    title = '[COLOR gold][B]'+title+'[/COLOR][/B]'

                titleorg = dt.get("title_org", None)
                short_desc = dt.get("short_desc", None)
                available_in = dt.get("available_in", None)
                year = dt.get("year", None)
                country = dt.get("country", None)
                year = year if year else ''
                country = country if country else ''
                if dt.get("images", None):
                    try:
                        poster = dt.get("images", None).get("poster", None)[0].get("url", None)
                    except:
                    
                        poster = dt.get("images", None).get("cover", None)[0].get("url", None) 
                else:
                    poster = self.ikona
                duration = context.get("duration", None)
                duration = duration if duration else ''
                url_mobile = context.get("url_mobile", None)
                sezony = context.get("seasons", None)

                mode = 'showvid'
                folder = True

                if url_mobile:
                    if 'subtype=' in url_mobile:
                        uuid = re.findall('(subtype=.*?)$',url_mobile)[0]
                        mode = 'listvod'
                        folder = True
                    elif '/section/' in url_mobile:

                        uuid = re.findall('(\d+)',url_mobile)[-1] 
                        mode = 'listvod'
                        folder = True
                        
                        abc =''
                        
                if sezony:
                    mode = 'listsezony'
                    folder = True
                if subtype == "program":
                    continue

                self.plugin.add_item(name=self.plugin.PLchar(title+dod), url=str(uuid), mode=mode, image=poster, folder=folder, IsPlayable=True, fanart = self.fanart, infoLabels={'plot':self.plugin.PLchar(short_desc), 'duration':duration, 'year':year,'country':self.plugin.PLchar(country),'originaltitle': self.plugin.PLchar(titleorg)})

            if self.getnpage(npurl):
                self.plugin.add_item(name='Następna strona', url=str(id), mode='listvod', image=self.ikona, folder=True, IsPlayable=False, fanart = self.fanart, infoLabels={'plot':self.plugin.PLchar('Następna strona')}, page = npg)

        else:
            url = 'https://{0}/sections/page/{1}?platform=BROWSER&system=tvonline'.format(self.api_url, id)
            datas = sess.get(url, headers=self.headers, verify=False).json()
            for dt in datas:
                cid = dt.get("id",None)
                title = dt.get("name",None)
                if title == 'Banery':

                    continue
                self.plugin.add_item(name=self.plugin.PLchar(title), url=str(cid), mode='listvod', image=self.ikona, folder=True, IsPlayable=True, fanart = self.fanart, infoLabels={'plot':self.plugin.PLchar(title)})
        if datas:
            self.plugin.setContent('videos')    
            self.plugin.EOD()

    def ListSezony(self, url, typ):
        url = self.products_url.format(typ,url)           
        self.headers.update({'authorization': 'Bearer '+self.token})

        
        
        jsdata = sess.get(url, headers=self.headers, verify=False).json()
        wer = 'seasons' if typ == 'series' else 'episodes'
        sezony = jsdata.get(wer, None)

        poster = None
        if sezony:
            try:
                if typ!= 'season':

                    poster = jsdata.get("images", None).get("poster", None)[0].get("url", None)
                    trailers = jsdata.get("trailers", None)
                    if trailers:
                        videoId = jsdata.get("videoId", None)
                        parent_uuid = jsdata.get("parent_uuid", None)
                        if parent_uuid:
                            poster = 'https://api.tvonline.vectra.pl/assets/{}/poster'.format(parent_uuid)
                        metadata = jsdata.get("metadata", None)
                        summary_long = metadata.get("summary_long", None)
                        title = metadata.get("title", None)
                        mode = 'playvid'
                        
                        self.plugin.add_item(name=self.plugin.PLchar(title), url=str(videoId), mode=mode, image=poster, folder=False, IsPlayable=True, fanart = self.fanart, infoLabels={'plot':self.plugin.PLchar(summary_long)})

                avins = jsdata.get("available_in",None)
                if avins:
                    jest = False
                    for mysubscr in self.mysubscrs:
                        if not jest:
                            for av in avins:
                                dod = ' [COLOR red][B] brak[/COLOR][/B]'

                                if av in mysubscr:

                                    dod = ''
                                    jest = True
                                    break
                                else:
                                    continue
                
            except:
                pass
            for sz in sezony:
                uuid = sz.get('uuid', None)
                if typ == 'season':
                    poster = 'https://api.tvonline.vectra.pl/assets/{}/poster'.format(uuid)
                title = sz.get('title', None)
                summary_short = sz.get('summary_short', None)
                
                number  = sz.get('number', None)
                if typ == 'series':
                    title = title + ' - sezon '+ str(number) 
                    mode = 'listepisodes'
                else:

                    mode = 'showvid'
                self.plugin.add_item(name=self.plugin.PLchar(title + dod), url=str(uuid), mode=mode, image=poster, folder=True, IsPlayable=False, fanart = self.fanart, infoLabels={'plot':self.plugin.PLchar(summary_short)})
            self.plugin.EOD()

    def showVid(self, id):

        url = 'https://{0}/products/vod/{1}?platform=BROWSER&system=tvonline'.format(self.api_url, id)
        self.headers.update({'authorization': 'Bearer '+self.token})

        jsdata = sess.get(url, headers=self.headers, verify=False).json()

        poster = jsdata.get("images", None).get("poster", None)[0].get("url", None)
        parent_uuid = jsdata.get("parent_uuid", None)
        if parent_uuid:
            poster = 'https://api.tvonline.vectra.pl/assets/{}/poster'.format(parent_uuid)
        metadata = jsdata.get("metadata", None)
        summary_long = metadata.get("summary_long", None)
        title = metadata.get("title", None)
        
        trailers = jsdata.get("trailers", None)
        if trailers:
            videoId = trailers[0].get("videoId", None)

            titlex = title + ' - [COLOR lightgreen][I][B] trailer [/I][/B][/COLOR]'
            mode = 'playvid'
            trailer_url = '%s|%s'%(str(id),str(videoId))
            self.plugin.add_item(name=self.plugin.PLchar(titlex), url=trailer_url, mode=mode, image=poster, folder=False, IsPlayable=True, fanart = self.fanart, infoLabels={'plot':self.plugin.PLchar(summary_long)})
        
        
        
        mainvid = False
        for mysubscr in self.mysubscrs:
            if id in mysubscr:
                mainvid = True

                mainvid_url = (str(id))

                self.plugin.add_item(name=self.plugin.PLchar(title), url=mainvid_url, mode=mode, image=poster, folder=False, IsPlayable=True, fanart = self.fanart, infoLabels={'plot':self.plugin.PLchar(summary_long)})
                break

        if trailers or mainvid:
            self.plugin.EOD()

            
    def generate_m3u(self):#
        if self.file_name == '' or self.path_m3u == '':
            self.plugin.notification_dialog('Vectra TV', 'Ustaw nazwe pliku oraz katalog docelowy.', xbmcgui.NOTIFICATION_ERROR, 8000,False) 
            return
        self.plugin.notification_dialog('Vectra TV', 'Generuje liste M3U.', xbmcgui.NOTIFICATION_INFO, 8000,False) 
        data = '#EXTM3U\n'
        ChList = self.liveChList()
        for item in ChList:
            channelid = item[0]
            chanUrl = item[1]
            data += '#EXTINF:0 tvg-id="%s",%s\nplugin://plugin.video.vectrapl/?mode=playm3u&url=%s\n' % (channelid,channelid,chanUrl)#zmiana z amp;
    
        f =self.plugin.FileOp(self.path_m3u + self.file_name, 'w')
        f.write(data)
        f.close()
        self.plugin.notification_dialog('Vectra TV', 'Wygenerowano listę M3U.', xbmcgui.NOTIFICATION_INFO, 8000,False)    
            
    def PlayTV(self, id, typ, broadcast=False):

        headersx = {
            'Host': 'api.tvonline.vectra.pl',
            'user-agent': self.UA,
            'accept': 'application/json',
            'accept-language': 'pl,en-US;q=0.7,en;q=0.3',
            'access-control-allow-origin': '*',
            'api-deviceuid': self.device_id,
            'api-device': 'Firefox; 90; Windows; 7; Windows; 7;',
            'authorization': 'Bearer '+self.token,
            'origin': 'https://tvonline.vectra.pl',
            'referer': 'https://tvonline.vectra.pl/',
            'sec-fetch-dest': 'empty',
            'sec-fetch-mode': 'cors',
            'sec-fetch-site': 'same-site',
            'te': 'trailers',
        }

        params = {
                'type':typ , 
                'platform': 'BROWSER',
                'system': 'tvonline'}
        
        vidid = ''
        if '|' in id:
            
            if 'programId' not in id:
                id,vidid = id.split('|')
                params.update({'videoId':vidid})
            else:
                id,programId,x = id.split('|')
                params.update({'programId':programId})

        urlk='https://api.tvonline.vectra.pl/player/product/%s/configuration'%(id)
        jsdata = requests.get('https://api.tvonline.vectra.pl/player/product/%s/configuration'%(id), headers=headersx, params=params, verify=False).json()
        if 'errorCode' in jsdata:
            msg = jsdata.get('errorCode', None)
            self.plugin.notification_dialog('[B]Błąd[/B]', '[B]%s[/B]'%(msg),xbmcgui.NOTIFICATION_INFO, 8000,False) 
            sys.exit(0)
        else:

            vsessid = jsdata.get("videoSession",None).get("videoSessionId",None)
        
            params = {
                    'type': 'channel',
                    'videoSessionId':vsessid
                    }
            
            jsdata = requests.get('https://api.tvonline.vectra.pl/player/product/%s/playlist'%(id), headers=headersx, params=params, verify=False).json()
            mpdurl = jsdata.get('sources',None).get('DASH',None)[0].get('src',None)
            mpdurl = 'https:' + mpdurl if mpdurl.startswith('//') else mpdurl
            license_url = jsdata.get('drm',None).get('WIDEVINE',None)
            sub_url = None
            az= self.plugin.get_setting("subtitles")

            if self.plugin.get_setting("subtitles"):
                try:
                    subtitles = jsdata.get("subtitles",None)[0]
                    sub_url = subtitles.get('url', None)
                except:
                    sub_url = None
            
            mpdurl=requests.get(mpdurl,allow_redirects=False,verify=False)
            mpdurl=mpdurl.headers['Location']
            
            
            PROTOCOL = 'mpd'
            DRM = 'com.widevine.alpha'
            
            lic_url = license_url+'|Content-Type=|R{SSM}|'
            
            
            
            self.plugin.PlayVid(mpdurl, lic_url, PROTOCOL, DRM, sub_url)
  
  


  
