# -*- coding: UTF-8 -*-

import sys, os

if sys.version_info >= (3,0,0):
# for Python 3
    from urllib.parse import parse_qsl
else:
    # for Python 2
    from urlparse import parse_qsl

import xbmcaddon

base_url = sys.argv[0]
addon_handle = int(sys.argv[1])

from resources.lib.itemsy import Itemsy
from resources.lib.vectra import Vectra

Items = Itemsy(
	addon=xbmcaddon.Addon('plugin.video.vectrapl'),
	addon_handle=addon_handle,
	base_url=base_url
)


params = dict(parse_qsl(sys.argv[2][1:]))
exlink = params.get('url', None)
page = params.get('page',[1])
title = params.get('title', None)
icona  = params.get('image', None)

PATH		=	Items.get_path('path')
PROFILE		=	Items.get_path('profile')

DATAPATH	=	Items.translate_path(PROFILE)

if not os.path.exists(DATAPATH):
    os.makedirs(DATAPATH)
	
RESOURCES       = PATH+'/resources/'

FANART=RESOURCES+'../fanart.jpg'
ikona = RESOURCES+'../icon.png'

Vectra = Vectra(Items, FANART, ikona)

def router(paramstring):
	args = dict(parse_qsl(paramstring))
	
	if args:
		mode = args.get('mode', None)

		if mode  == 'loguj':
			Items.open_settings()
			xbmc.executebuiltin('Container.Refresh()')
			
		elif mode  == 'listtv':
			Vectra.listTV(exlink)
			
		elif mode  == 'opcje':
			Items.open_settings()
			
		elif mode  == 'listtvcat':
			Vectra.listTV(exlink, kateg = True)
			
		elif mode  == 'listvodcat':
			Vectra.listVOD(exlink, page, kateg = True)
		
		elif mode  == 'listvod':
			Vectra.listVOD(exlink, page)
			
		elif mode == 'showvid':
			Vectra.showVid(exlink)
			
		elif mode == 'listsezony':
			Vectra.ListSezony(exlink, 'series')
			
		elif mode == 'listepisodes':
			Vectra.ListSezony(exlink, 'season')
			
		elif mode == 'playtv':
			Vectra.PlayTV(exlink, 'channel')
		
		elif mode == 'playm3u':
			Vectra.PlayTV(exlink, 'channel', True)

		
		elif mode == 'playvid':
			Vectra.PlayTV(exlink, 'vod')
        
		elif mode == 'szukaj':
			query = Items.input_dialog('Szukaj')
			if query:
				Vectra.listVOD('query|'+query, page)

		elif mode == 'showcatchup':
			Vectra.showCatchup(exlink, title, icona)
			
		elif mode == 'listcatchups':
			Vectra.listCatchups(exlink)
			
		elif mode == 'generatem3u':
			Vectra.generate_m3u()
	else:
		Vectra.home()    
if __name__ == '__main__':
    router(sys.argv[2][1:])
