# -*- coding: utf-8 -*-

import sys,re,os

import xbmc,xbmcgui,xbmcaddon,xbmcvfs
import xbmcplugin
import json

try:
    import html.entities as htmlentitydefs
    from urllib.request import Request as urllib_Request
    from urllib.request import urlopen

    from urllib.parse import urlencode, quote_plus, unquote, parse_qsl
    xrange = range 
except ImportError:
    import htmlentitydefs
    from urllib2 import Request as urllib_Request
    from urllib2 import urlopen

    from urllib import urlencode, quote_plus, unquote
    from urlparse import parse_qsl
 
import time

try:
   import StorageServer
except:
   import storageserverdummy as StorageServer
cache = StorageServer.StorageServer('viderpl')
import resources.lib.viderpl as vider

base_url = sys.argv[0]
addon_handle = int(sys.argv[1])
params = dict(parse_qsl(sys.argv[2][1:]))
exlink = params.get('url', None)
my_addon = xbmcaddon.Addon(id='plugin.video.viderpl')


PATH            = my_addon.getAddonInfo('path')
try:
    DATAPATH        = xbmcvfs.translatePath(my_addon.getAddonInfo('profile'))#.decode('utf-8')
except:
    DATAPATH        = xbmc.translatePath(my_addon.getAddonInfo('profile')).decode('utf-8')
	
RESOURCES       = PATH+'/resources/'

PY3 = sys.version_info >= (3,0,0)
ikona = RESOURCES+'../icon.png'
FANART=RESOURCES+'../fanart.jpg'

exlink = params.get('url', None)
fname = params.get('name', None)
page = params.get('page','')


if not os.path.exists(DATAPATH):
    os.makedirs(DATAPATH)

RESOURCES   = PATH+'/resources/'
FANART          = RESOURCES+'fanart.png'
FAVORITE    = os.path.join(DATAPATH,'favorites.json')

def getUrl(url,data=None):
    req = urllib_Request(url,data)
    req.add_header('User-Agent', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:90.0) Gecko/20100101 Firefox/90.0')
    response = urlopen(req)
    link = response.read()
    response.close()
    return link
	
def add_item(url, name, image, mode, contextO=['F_ADD'], folder=False, IsPlayable=False, infoLabels=False, page='0',fanart=FANART):
    list_item = xbmcgui.ListItem(label=name)

    if IsPlayable:
        list_item.setProperty("IsPlayable", 'True')
    if not infoLabels:
        infoLabels={'title': name,'plot':name}
    list_item.setInfo(type="video", infoLabels={'title':name,'plot':name})    
    list_item.setArt({'thumb': image, 'poster': image, 'banner': image, 'fanart': FANART})

    menu = []
    menu.append(('Informacja', 'Action(Info)'),)

    content=quote_plus(json.dumps(infoLabels))
    if 'F_ADD' in contextO:
        menu.append((  '[COLOR green]Dodaj do Wybranych[/COLOR]','RunPlugin(plugin://plugin.video.viderpl?mode=favoritesADD&url=%s)'%(content)))
    if 'F_REM' in contextO:
        menu.append(('[COLOR red]Usuń z Wybranych[/COLOR]',  'RunPlugin(plugin://plugin.video.viderpl?mode=favoritesREM&url=%s)'%(content)))
    if 'F_DEL' in contextO:
        menu.append(('[COLOR red]Usun Wszystko[/COLOR]', 'RunPlugin(plugin://plugin.video.viderpl?mode=favoritesREM&url=all)'))
    list_item.addContextMenuItems(menu, replaceItems=False)

    ok=xbmcplugin.addDirectoryItem(
        handle=addon_handle,
        url = build_url({'mode': mode, 'url' : url, 'page' : page,'name':name,'image':image}),            
        listitem=list_item,
        isFolder=folder)
    xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = "%R, %Y, %P")
    return ok

def build_url(query):

    return base_url + '?' + urlencode(query)

def html_entity_decode_char(m):
    ent = m.group(1)
    if ent.startswith('x'):
        return unichr(int(ent[1:],16))
    try:
        return unichr(int(ent))
    except Exception as  exception:
        if ent in htmlentitydefs.name2codepoint:
            return unichr(htmlentitydefs.name2codepoint[ent])
        else:
            return ent

def html_entity_decode(string):
    if PY3:
        string = string
    else:
        string = string.decode('UTF-8')
    s = re.compile('&.?(\\w+?);').sub(html_entity_decode_char, string)
    s=s.encode('UTF-8')

    return s
def readJSONfile(jfilename):
    content = '[]'
    if os.path.exists(jfilename):
        with open(jfilename,'r') as f:
            content = f.read()
            if not content:
                content ='[]'
    data=json.loads(html_entity_decode(content))
    return data
def ListMovies(ex_link,pg):

    dal=None
    if ex_link=='FAVORITE':
        items = readJSONfile(FAVORITE)
    elif ex_link.startswith('search'):
        items,dal=vider.search(ex_link.split('|')[-1].strip(),pg)
    	
    else:
        items = vider.scanUser(ex_link)
    contextO=['F_ADD']
    if fname=='[COLOR khaki]Wybrane[/COLOR]':
        contextO=['F_REM','F_DEL']
    if items:
        for item in items:
            if item.get('folder'):
                add_item(item.get('href'), item.get('title'),item.get('img'), 'ListMovies', folder=True, IsPlayable=False, contextO=contextO)
            else:
                add_item(item.get('href'), vider.unicodePLchar(item.get('title')),item.get('img'), 'getLinks', folder=False, IsPlayable=True, infoLabels={'href':item.get('href'), 'plot':item.get('plot'),'duration':item.get('duration'),'title':item.get('title'),'img':item.get('img') },contextO=contextO)

        if dal:
        	pgplus = str(int(pg)+1)
        	add_item(ex_link, 'Nast strona',item.get('img'), 'ListMovies', folder=True, IsPlayable=False, page=pgplus,contextO=contextO)
        xbmcplugin.endOfDirectory(addon_handle)
    else:
        xbmcgui.Dialog().notification('[B]Uwaga[/B]', 'Brak materiałów do wyświetlenia.',xbmcgui.NOTIFICATION_INFO, 8000)
def getLinks(ex_link):
    stream_url = vider.getVideoUrls(ex_link)

    if stream_url:
        xbmcplugin.setResolvedUrl(addon_handle, True, xbmcgui.ListItem(path=stream_url))
    else:
        xbmcgui.Dialog().ok('Problem','Brak źródła')
        xbmcplugin.setResolvedUrl(addon_handle, False, xbmcgui.ListItem(path=stream_url))
def HistoryLoad():
    return cache.get('history').split(';')
def HistoryAdd(entry):
    history = HistoryLoad()
    if history == ['']:
        history = []
    history.insert(0, entry)
    cache.set('history',';'.join(history[:50]))
def HistoryDel(entry):
    history = HistoryLoad()
    if history:
        cache.set('history',';'.join(history[:50]))
    else:
        HistoryClear()
def HistoryClear():
    cache.delete('history')
def home():
    try:
    	vider.getCook()
    except:
    	pass
    add_item('https://vider.info', 'Strona Główna','DefaultFolder.png', 'ListMovies', folder=True, IsPlayable=False,fanart=FANART)

    add_item('https://vider.info/ranking/month', 'Ranking Vider.pl (30dni)','DefaultFolder.png', 'ListMovies', folder=True, IsPlayable=False,fanart=FANART)
    add_item('FAVORITE', '[COLOR khaki]Wybrane[/COLOR]','DefaultFolder.png', 'ListMovies', folder=True, IsPlayable=False,fanart=FANART)
    add_item('', '[COLOR lightgreen]Szukaj[/COLOR]','DefaultFolder.png', 'Szukaj', folder=True, IsPlayable=False,fanart=FANART)
    xbmcplugin.endOfDirectory(addon_handle)	
	


def router(paramstring):
    params = dict(parse_qsl(paramstring))
    
    if params:
        mode = params.get('mode', None)
    	
        if mode == '__page__M':
            url = build_url({'mode': 'ListMovies', 'foldername': '', 'ex_link' : exlink})
            xbmc.executebuiltin('Container.Refresh(%s)'% url)
			
        elif mode == 'ListMovies':
            ListMovies(exlink,page)
        elif mode == 'ListSeriale':
            ListSeriale(exlink,page)
        elif mode == 'getLinks':
            getLinks(exlink)
        elif mode == 'GatunekRok':
            (jezyk,rok,gatunek) = l1111l1i1i11i1_vr_.l1ll1ll1i1i11i1_vr_()
            if exlink=='Typ':
                data = jezyk
            elif exlink=='Rok':
                data = rok
            elif exlink=='Kategorie':
                data = gatunek
            if data:
                label = [x[1].strip() for x in data]
                url = [x[0].strip() for x in data]
                ret = xbmcgui.Dialog().select('Wybierz: '+exlink,label)
                if ret>-1:
                    url = build_url({'mode': 'ListMovies', 'foldername': '', 'url' : l1111l1i1i11i1_vr_.BASEURL+ url[ret]})
                    xbmc.executebuiltin('Container.Refresh(%s)'% url)
        elif mode == 'Opcje':
            my_addon.openSettings()
        elif mode == 'favoritesADD':
            ab= exlink

            jdata = readJSONfile(FAVORITE)
            new_item=json.loads(exlink)
            new_item['title'] = new_item.get('title','').replace(new_item.get('label',''),'').replace(new_item.get('msg',''),'')
            dodac = [x for x in jdata if new_item['title']== x.get('title','')]
            if dodac:
                tytx = new_item.get('title','') if PY3 else new_item.get('title','').encode('utf-8')
                xbmc.executebuiltin('Notification([COLOR pink]Już jest w Wybranych[/COLOR], ' + tytx + ', 200)')
            else:
                jdata.append(new_item)
                with open(FAVORITE, 'w') as outfile:
                    json.dump(jdata, outfile, indent=2, sort_keys=True)
                    tytx = new_item.get('title','') if PY3 else new_item.get('title','').encode('utf-8')
                    xbmc.executebuiltin('Notification(Dodano Do Wybranych, ' + tytx + ', 200)')
        elif mode == 'favoritesREM':
            if exlink=='all':
                yes = xbmcgui.Dialog().yesno('??','Usuń wszystkie filmy z Wybranych?')
                if yes:
                    debug=1
            else:
                jdata = readJSONfile(FAVORITE)
                remItem=json.loads(exlink)
                to_remove=[]
                for i in xrange(len(jdata)):
                    if jdata[i].get('title') in remItem.get('title'):
                        to_remove.append(i)
                if len(to_remove)>1:
                    yes = xbmcgui.Dialog().yesno('??',remItem.get('title'),'Usuń %d pozycji z Wybranych?' % len(to_remove))
                else:
                    yes = True
                if yes:
                    for i in reversed(to_remove):
                        jdata.pop(i)
                    with open(FAVORITE, 'w') as outfile:
                        json.dump(jdata, outfile, indent=2, sort_keys=True)
            xbmc.executebuiltin('Container.Refresh')
        elif mode =='Szukaj':

            add_item('', '[COLOR green]Nowe Szukanie[/COLOR]','DefaultFolder.png', 'SzukajNowe', folder=True, IsPlayable=False,fanart=FANART)
            historia = HistoryLoad()
            if not historia == ['']:
                for entry in historia:
                    contextmenu = []
                    contextmenu.append(('Usuń', 'Container.Refresh(%s)'% build_url({'mode': 'SzukajUsun', 'url' : entry})),)
                    contextmenu.append(('Uń całą historię', 'Container.Update(%s)' % build_url({'mode': 'SzukajUsunAll'})),)
                    add_item('search|'+entry, entry,'DefaultFolder.png', 'ListMovies', folder=True, IsPlayable=False, page='0', fanart=FANART,contextO=contextmenu)

            xbmcplugin.endOfDirectory(addon_handle)
        elif mode =='SzukajNowe':
            d = xbmcgui.Dialog().input('Szukaj, Podaj tytul', type=xbmcgui.INPUT_ALPHANUM)
            if d:
                HistoryAdd(d)

                exlink2='search|'+d
                ListMovies(exlink2,page)
                
        elif mode =='SzukajUsun':
            HistoryDel(exlink)
            xbmc.executebuiltin('Container.Refresh(%s)'%  build_url({'mode': 'Szukaj'}))
        elif mode == 'SzukajUsunAll':
            HistoryClear()
            xbmc.executebuiltin('Container.Refresh(%s)'%  build_url({'mode': 'Szukaj'}))
        elif mode == 'folder':
            pass
    	
    else:
        home()
	
if __name__ == '__main__':
    router(sys.argv[2][1:])

