# -*- coding: UTF-8 -*-

import sys, re, os
import time
import io
from collections import namedtuple
from contextlib import contextmanager
from datetime import date, datetime, timedelta

if sys.version_info >= (3, 0):
	# for Python 3

	from urllib.parse import parse_qs, parse_qsl, urlencode, quote_plus, unquote_plus
	import http.cookiejar as cookielib

	# pickle is faster for Python3
	import pickle

	def save_ints(path, seq):
		with open(path, 'wb') as f:
			pickle.dump(seq, f, pickle.HIGHEST_PROTOCOL)

	def load_ints(path):
		with open(path, 'rb') as f:
			return pickle.load(f)

	basestring = str
	unicode = str
	xrange = range

else:
	# for Python 2

	from urllib import urlencode, quote_plus, unquote_plus

	import cookielib
	from urlparse import parse_qsl, parse_qs

	try:
		import urllib3
	except ImportError:
		pass
	else:
		urllib3.disable_warnings()

	# struct is faster for Python2
	import struct

	def save_ints(path, seq):
		if seq:
			with open(path, 'wb') as f:
				if seq:
					f.write(struct.pack('=%sQ' % len(seq), *seq))

	def load_ints(path):
		with open(path, 'rb') as f:
			data = f.read()
			return struct.unpack('=%sQ' % (len(data) // 8), data)


from threading import Thread
import requests
from requests.exceptions import SSLError
import urllib3  # already used by "requests"
from urllib3.exceptions import MaxRetryError, SSLError as SSLError3
from certifi import where
import xbmcgui
import xbmcplugin
import xbmcaddon
import xbmc, xbmcvfs
import json
import inputstreamhelper

from resources.lib.udata import AddonUserData
# from resources.lib.tools import U, uclean, NN, fragdict


MetaDane = namedtuple('MetaDane', 'tytul opis foto sezon epizod fanart thumb landscape poster allowed')
MetaDane.__new__.__defaults__ = 5*(None,)
MetaDane.art = property(lambda self: {k: v for k in 'fanart thumb landscape poster'.split()
									  for v in (getattr(self, k),) if v})

ExLink = namedtuple('ExLink', 'gid slug mode a1 a2')
ExLink.__new__.__defaults__ = 3*(None,)
ExLink.new = classmethod(lambda cls, exlink: cls(*exlink.split(':')[:5]))
# slug = "eurosport", mode = "schedule"
ExLink.beginTimestamp = property(lambda self: self.a1)
ExLink.endTimestamp = property(lambda self: self.a2)

ImageRule = namedtuple('ImageRule', 'width height quality')
ImageRule.ratio = property(lambda self: self.width / self.height)


class NotPlayable(Exception):
	"""Item is not playable."""
	@property
	def message(self):
		return self.args[0] if self.args else ''


#UA = 'okhttp/3.3.1 Android'
UA = 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:109.0) Gecko/20100101 Firefox/110.0'
#PF = 'ANDROID_TV'
PF = 'BROWSER'

base_url = sys.argv[0]
addon_handle = int(sys.argv[1])
params = dict(parse_qsl(sys.argv[2][1:]))
addon = xbmcaddon.Addon()

PATH = addon.getAddonInfo('path')
try:
	DATAPATH = xbmcvfs.translatePath(addon.getAddonInfo('profile'))
except:
	DATAPATH = xbmc.translatePath(addon.getAddonInfo('profile')).decode('utf-8')
CACHEPATH = os.path.join(DATAPATH, 'cache')

RESOURCES = os.path.join(PATH, 'resources')
COOKIEFILE = os.path.join(DATAPATH, 'vodpl.cookie')
SUBTITLEFILE = os.path.join(DATAPATH, 'temp.sub')
#M3UFILE = addon.getSetting('m3u_fname')
#M3UPATH = addon.getSetting('m3u_path')
MEDIA = os.path.join(RESOURCES, 'media')

ADDON_ICON = os.path.join(RESOURCES, '../icon.png')
FANART = os.path.join(RESOURCES, '../fanart.jpg')
sys.path.append(os.path.join(RESOURCES, 'lib'))

HISTORY_SIZE = 50

addon_data = AddonUserData(os.path.join(DATAPATH, 'data.json'))
kukz = ''

slug_blacklist = {
	'pobierz-i-ogladaj-offline',
}

kanalydata = []

menudata =[
	{'url': 1, 'slug': 'seriale-online', 'title': 'Seriale'},
	{'url': 2, 'slug': 'programy-online', 'title': 'Programy'},
	{'url': 3, 'slug': 'filmy-online', 'title': 'Filmy'},
	{'url': 4, 'slug': 'shorty', 'title': 'Shorty'},
]

serialemenu = {}

TIMEOUT = 15

sess = requests.Session()
sess.cookies = cookielib.LWPCookieJar(COOKIEFILE)


def get_bool(key):
	return addon.getSetting(key).lower() == 'true'


def set_bool(key, value):
	return addon.setSetting(key, 'true' if value else 'false')

#nexus = addon.getSetting(key).lower()# == 'true' get_bool('nexus')
nexus = True if addon.getSetting('nexus').lower() == 'true' else False


# URL to test: https://wrong.host.badssl.com
class GlobalOptions(object):
	"""Global options."""

	def __init__(self):
		self._session_level = 0
		self.verify_ssl = get_bool('verify_ssl')
		self.use_urllib3 = get_bool('use_urllib3')
		self.ssl_dialog_launched = get_bool('ssl_dialog_launched')

	def ssl_dialog(self, using_urllib3=False):
		if self.ssl_dialog_launched and self._session_level == 0:
			return
		using_urllib3 = bool(using_urllib3)
		options = [u'Wyłącz weryfikację SSL', u'Bez zmian']
		if using_urllib3:
			options.insert(0, u'Użyj wolniejszego połączenia (zalecane)')
		num = xbmcgui.Dialog().select(u'Problem z połączeniem SSL, co teraz?', options)
		if using_urllib3:
			# getRequests3() error
			if num == 0:  # Użyj wolniejszego połączenia
				self.use_urllib3 = False
			elif num == 1:  # Wyłącz weryfikację SSL
				self.verify_ssl = False
		else:
			# getRequests() error
			if num == 0:  # Wyłącz weryfikację SSL
				self.verify_ssl = False
		set_bool('use_urllib3', self.use_urllib3)
		set_bool('verify_ssl', self.verify_ssl)
		set_bool('ssl_dialog_launched', True)
		self.ssl_dialog_launched = True

	def __enter__(self):
		self._session_level += 1
		return self

	def __exit__(self, exc_type, exc_val, exc_tb):
		self._session_level -= 1


goptions = GlobalOptions()


def media(name, fallback=None):
	"""Returns full path to media file."""
	path = os.path.join(MEDIA, name)
	if fallback and not os.path.exists(path):
		return fallback
	return path


def build_url(query):
	query = deunicode_params(query)
	return base_url + '?' + urlencode(query)


def add_item(url, name, image, mode, folder=False, isPlayable=False, infoLabels=None, movie=True,
			 itemcount=1, page=None, fanart=None, moviescount=0, properties=None, thumb=None,
			 contextmenu=None, art=None, linkdata=None, fallback_image=ADDON_ICON,
			 label2=None):
	list_item = xbmcgui.ListItem(label=name)
	if label2 is not None:
		list_item.setLabel2(label2)
	if isPlayable:
		list_item.setProperty("isPlayable", 'true')

	if nexus:	
		def setvinfo(x,y):
			vinfo = list_item.getVideoInfoTag()
			if 'plot' == x:

				vinfo.setPlot(PLchar(y))
			if 'plotoutline' == x:
				vinfo.setPlotOutline(PLchar(y))
			if 'title' == x:
				vinfo.setTitle(PLchar(y))
		vinfo = list_item.getVideoInfoTag()
		if not infoLabels:
			vinfo.setPlot(PLchar(name))
			vinfo.setTitle(PLchar(name))
		else:
			for x,y in infoLabels.items():
				setvinfo(x,y)
				
			#eval(
	else:
		if not infoLabels:
			infoLabels = {'title': name, 'plot': name}
		list_item.setInfo(type="video", infoLabels=infoLabels)
	if not image:
		image = fallback_image
	if image and image.startswith('//'):
		image = 'https:' + image
	art = {} if art is None else dict(art)
	if fanart:
		art['fanart'] = fanart
	if thumb:
		art['thumb'] = fanart
	art.setdefault('thumb', image)
	art.setdefault('poster', image)
	art.setdefault('banner', art.get('landscape', image))
	art.setdefault('fanart', FANART)
	art.setdefault('landscape', image)
	art = {k: 'https:' + v if v and v.startswith('//') else v for k, v in art.items()}
	list_item.setArt(art)
	if properties:
		list_item.setProperties(properties)
	if contextmenu:
		list_item.addContextMenuItems(contextmenu, replaceItems=False)
	# link data used to build link,to support old one
	linkdata = {} if linkdata is None else dict(linkdata)
	if page is not None:
		linkdata['page'] = page
	linkdata['mode'] = mode
	linkdata['url'] = url
	# add item
	ok = xbmcplugin.addDirectoryItem(
		handle=addon_handle,
		url=build_url(linkdata),
		listitem=list_item,
		isFolder=folder)
	return ok


def setView(typ):
	if addon.getSetting('auto-view') == 'false':
		xbmcplugin.setContent(addon_handle, 'videos')
	else:
		xbmcplugin.setContent(addon_handle, typ)


def getmenu():
	for menu in menudata:
		mud="listcategContent"
		add_item(str(menu['url'])+':'+menu['slug'], menu['title'], ADDON_ICON, mud, folder=True)


def remove_html_tags(text, nice=True):
	"""Remove html tags from a string"""
	if nice:
		if re.match(r'^<table .*<td [^>]+$', text, re.DOTALL):
			return ''  # remove vod.pl lead fackup
		text = re.sub(r'<p\b[^>]*?>\s*</p>|<br/?>', '\n', text, 0, re.DOTALL)
	return re.sub('<.*?>', '', text, 0, re.DOTALL)


def home():
	vodpl = VOD_PL()
	vodpl.sprawdzenie1()
	getmenu()
	add_item('', '[B][COLOR khaki]Szukaj[/COLOR][/B]', ADDON_ICON, "search", folder=True)
	setView('addons')

	xbmcplugin.endOfDirectory(addon_handle)


def get_addon():
	return addon


def set_setting(key, value):
	return get_addon().setSetting(key, value)


def dialog_progress():
	return xbmcgui.DialogProgress()


def xbmc_sleep(time):
	return xbmc.sleep(time)


def deunicode_params(params):
	if sys.version_info < (3,) and isinstance(params, dict):
		def encode(s):
			return s.encode('utf-8') if isinstance(s, unicode) else s
		params = {encode(k): encode(v) for k, v in params.items()}
	return params


def _getRequests(url, data=None, headers=None, params=None):
	xbmc.log('vod.pl: getRequests(%r, data=%r, headers=%r, params=%r)'
			 % (url, data, headers, params), xbmc.LOGDEBUG)
	params = deunicode_params(params)
	if data:
		if headers.get('Content-Type', '').startswith('application/json'):
			content = sess.post(url, headers=headers, json=data, params=params, verify=goptions.verify_ssl)
		else:
			content = sess.post(url, headers=headers, data=data, params=params, verify=goptions.verify_ssl)
	else:
		content = sess.get(url, headers=headers, params=params, verify=goptions.verify_ssl)
	return content.json()


def _getRequests3(url, data=None, headers=None, params=None):
	# urllib3 seems to be faster in some cases
	xbmc.log('vod.pl: getRequests3(%r, data=%r, headers=%r, params=%r)'
			 % (url, data, headers, params), xbmc.LOGDEBUG)
	if params:
		params = deunicode_params(params)
		encoded_args = urlencode(params)
		url += '&' if '?' in url else '?'
		url += encoded_args
	pool_kwargs = {}
	if goptions.verify_ssl is False:
		pool_kwargs['cert_reqs'] = 'CERT_NONE'
	elif goptions.verify_ssl is True:
		pool_kwargs['ca_certs'] = where()
	http = urllib3.PoolManager(**pool_kwargs)
	if data:
		if headers.get('Content-Type', '').startswith('application/json'):
			data = json.dumps(data).encode('utf-8')
		resp = http.request('POST', url, headers=headers, body=data)
	else:
		resp = http.request('GET', url, headers=headers)
	text = resp.data.decode('utf-8')
	return json.loads(text)


def getRequests(url, data=None, headers=None, params=None):
	try:
		return _getRequests(url, data=data, headers=headers, params=params)
	except SSLError:
		goptions.ssl_dialog()
	return _getRequests(url, data=data, headers=headers, params=params)


def getRequests3(url, data=None, headers=None, params=None):
	if not goptions.use_urllib3:
		# force use requests
		return getRequests(url, data=data, headers=headers, params=params)
	try:
		return _getRequests3(url, data=data, headers=headers, params=params)
	except MaxRetryError as exc:
		if not isinstance(exc.reason, SSLError3):
			raise
		with goptions:
			goptions.ssl_dialog(using_urllib3=True)
			if not goptions.use_urllib3:
				return getRequests(url, data=data, headers=headers, params=params)
	return _getRequests3(url, data=data, headers=headers, params=params)


class ThreadCall(Thread):
	"""
	Async call. Create thread for func(*args, **kwargs), should be started.
	Result will be in thread.result after therad.join() call.
	"""

	def __init__(self, func, *args, **kwargs):
		super(ThreadCall, self).__init__()
		self.func = func
		self.args = args
		self.kwargs = kwargs
		self.result = None

	def run(self):
		self.result = self.func(*self.args, **self.kwargs)

	@classmethod
	def started(cls, func, *args, **kwargs):
		th = cls(func, *args, **kwargs)
		th.start()
		return th


def idle():

	if float(xbmcaddon.Addon('xbmc.addon').getAddonInfo('version')[:4]) > 17.6:
		xbmc.executebuiltin('Dialog.Close(busydialognocancel)')
	else:
		xbmc.executebuiltin('Dialog.Close(busydialog)')


def busy():

	if float(xbmcaddon.Addon('xbmc.addon').getAddonInfo('version')[:4]) > 17.6:
		xbmc.executebuiltin('ActivateWindow(busydialognocancel)')
	else:
		xbmc.executebuiltin('ActivateWindow(busydialog)')


def PLchar(*args, **kwargs):
	sep = kwargs.pop('sep', ' ')
	if kwargs:
		raise TypeError('Unexpected keywoard arguemnt(s): %s' % ' '.join(kwargs.keys()))
	out = ''
	for i, char in enumerate(args):
		if type(char) is not str:
			char = char.encode('utf-8')
		char = char.replace('\\u0105','\xc4\x85').replace('\\u0104','\xc4\x84')
		char = char.replace('\\u0107','\xc4\x87').replace('\\u0106','\xc4\x86')
		char = char.replace('\\u0119','\xc4\x99').replace('\\u0118','\xc4\x98')
		char = char.replace('\\u0142','\xc5\x82').replace('\\u0141','\xc5\x81')
		char = char.replace('\\u0144','\xc5\x84').replace('\\u0144','\xc5\x83')
		char = char.replace('\\u00f3','\xc3\xb3').replace('\\u00d3','\xc3\x93')
		char = char.replace('\\u015b','\xc5\x9b').replace('\\u015a','\xc5\x9a')
		char = char.replace('\\u017a','\xc5\xba').replace('\\u0179','\xc5\xb9')
		char = char.replace('\\u017c','\xc5\xbc').replace('\\u017b','\xc5\xbb')
		char = char.replace('&#8217;',"'")
		char = char.replace('&#8211;',"-")
		char = char.replace('&#8230;',"...")
		char = char.replace('&#8222;','"').replace('&#8221;','"')
		char = char.replace('[&hellip;]',"...")
		char = char.replace('&#038;',"&")
		char = char.replace('&#039;',"'")
		char = char.replace('&quot;','"').replace('&oacute;','ó')
		char = char.replace('&nbsp;',".").replace('&amp;','&')
		if i:
			out += sep
		out += char
	return out


def historyLoad():
	return addon_data.get('history.items', [])


def historyAdd(entry):
	if not isinstance(entry, unicode):
		entry = entry.decode('utf-8')
	history = historyLoad()
	history.insert(0, entry)
	addon_data.set('history.items', history[:HISTORY_SIZE])


def historyDel(entry):
	if not isinstance(entry, unicode):
		entry = entry.decode('utf-8')
	history = [item for item in historyLoad() if item != entry]
	addon_data.set('history.items', history[:HISTORY_SIZE])


def historyClear():
	addon_data.remove('history.items')



class VOD_PL(object):

	MaxMax = 10000

	def __init__(self):

		self._mylist = None

		self.api_base = 'https://vod.pl/playerapi/'
		self.login_api = 'https://konto.tvn.pl/oauth/'

		self.GETTOKEN = self.login_api + 'tvn-reverse-onetime-code/create'
		self.POSTTOKEN = self.login_api + 'token'
		self.SUBSCRIBER = self.api_base + 'subscriber/login/token'
		self.SUBSCRIBERDETAIL = self.api_base + 'subscriber/detail'
		self.JINFO = self.api_base + 'info'
		self.TRANSLATE = self.api_base + 'item/translate'
		self.KATEGORIE = self.api_base + 'item/category/list'
		self.GATUNKI_KATEGORII = self.api_base + 'item/category/{cid}/genre/list'

		self.PRODUCTVODLIST = self.api_base + 'product/vod/list'
		self.PRODUCTLIVELIST = self.api_base + 'product/live/list'
		self.SECTIONLIST = self.api_base + 'product/section/list'
		self.SECTION_CONTENT = self.api_base + 'product/section/{sid}'

		self.PARAMS = {'4K': 'true', 'platform': PF}

		self.DEVICE_ID = addon.getSetting('device_id')

		self.CORELATION = addon.getSetting('corelation_id')


		self.update_headers2()

		self.MYLIST_CACHE_TIMEOUT = 3 * 3600  # cache valid time for mylist: 3h
		self.skip_unaviable = get_bool('avaliable_only')
		self.auto_categories = get_bool('auto_categories')
		self.categories_without_genres = addon.getSetting('categories_without_genres').split(',')
		self.fix_api = get_bool('fix_api')
		self.remove_duplicates = get_bool('remove_duplicates')
		self.partial_size = int(addon.getSetting('partial_size') or 1000)
		# self.force_media_resize = get_bool('self.force_media_fanart')
		self.force_media_resize = True
		self.force_media_rules = {
			'smart_tv:mainUrl': ImageRule(1280, 720, 85),
			'pc:mainUrl':	   ImageRule(1280, 720, 85),
			'vertical:mainUrl': ImageRule(864, 1154, 85),
		}
		self.force_media_quality = 85
		self.logo_tags = {  # extra tag like "E1" in Eurosport taken from "pc" logo id
			2824: 'E',
			2831: 'E1',
			2838: 'E2',
		}
		self._precessed_vid_list = set()
		self.dywiz = '–'
		self.hard_separator = ' '
		#self.hide_soon = get_bool('hide_soon')
		#self.week_days = (u'poniedziałek', u'wtorek', u'środa', u'czwartek', u'piątek', u'sobota', u'niedziela')
		#self.days_ago = int(addon.getSetting('days_ago') or 31)
		#if not self.days_ago:
		#	self.days_ago = 31
		#self.days_ahead = int(addon.getSetting('days_ahead'))

		self.all_items_title = '[B]Wszystkie[/B]'

	def params(self, maxResults=False, **kwargs):
		"""
		Get default query params. Extend self.PARAMS.

		maxResults : bool or int
			False to skip, Ftrue for auto or integer
		kwargs : dict(str, any)
			Extra pamars appended to result
		"""
		params = dict(self.PARAMS)
		if maxResults or isinstance(maxResults, int):
			if maxResults is True:
				maxResults = self.MaxMax if self.skip_unaviable else self.partial_size
			params['maxResults'] = maxResults or 0
			params['firstResult'] = 0
		params.update(kwargs)
		return params

	def update_headers2(self):
		self.HEADERS2 = {
			'Host': 'vod.pl',
			'user-agent': UA,
			'accept': 'application/json, text/plain, */*',
			'accept-language': 'pl,en-US;q=0.7,en;q=0.3',
			'referer': 'https://vod.pl/',
			'api-deviceuid': self.DEVICE_ID,
			'api-correlationid': self.CORELATION,}


	def get_meta_data(self, data):
		if not data.get('active', True):
			return MetaDane('', '', '', None, None)
		tytul = data['title']
		if data.get('uhd'):
			tytul = '%s [4K]' % (tytul or '')
		opis = data.get("description")
		if not opis:
			opis = data.get("lead")
		if opis:
			opis = remove_html_tags(opis).strip()
		images = {}
		# See: https://kodi.wiki/view/Artwork_types
		# New art images must be added to MetaDane
		for prop, inames in {'foto':	  [('smart_tv', 'mainUrl'), ('pc', 'mainUrl')],
							 'fanart':	[('smart_tv', 'mainUrl'), ('pc', 'mainUrl')],
							 'thumb':	 [('smart_tv', 'miniUrl'), ('mobile', 'miniUrl'),
										   ('pc', 'miniUrl'), ('pc', 'mainUrl')],
							 'poster':	[('vertical', 'mainUrl'), ('pc', 'mainUrl')],
							 'landscape': [('smart_tv', 'mainUrl'), ('pc', 'mainUrl')],
							 }.items():
			for iname, uname in inames:
				try:
					images[prop] = data['images'][iname][0][uname]
				except (KeyError, IndexError):
					pass
				else:
					if self.force_media_resize:
						iurl, _, iparams = images[prop].partition('?')
						iparams = dict(parse_qsl(iparams))
						if iparams.get('dstw', '').isdigit() and iparams.get('dstw', '').isdigit():
							rule = self.force_media_rules.get('%s:%s' % (iname, uname))
							if not rule and iparams.get('srcw', '').isdigit() and iparams.get('srcw', '').isdigit():
								rule = ImageRule(int(iparams['srcw']), int(iparams['srch']),
												 self.force_media_quality)
							if rule:
								w, h = int(iparams['dstw']), int(iparams['dsth'])
								dst_ratio = w / h if h else 1.
								rule_ration = rule.width / rule.height if rule.height else 1.
								if w != rule.width:
									iparams['dstw'] = rule.width
									if -.1 < dst_ratio - rule_ration < .1:
										# very close to preffered ratio, use rule.height directly
										iparams['dsth'] = rule.height
									else:
										# far away from preffered ratio, count new height
										iparams['dsth'] = h * rule.width // (w or 1)
								iparams['quality'] = rule.quality
							else:
								iparams['quality'] = self.force_media_quality
							images[prop] = '%s?%s' % (iurl, urlencode(iparams))
						elif iparams.get('w', '').isdigit() and 'i.eurosport.com' in iurl:
							rule = self.force_media_rules.get('%s:%s' % (iname, uname))
							if rule:
								w = int(iparams['w'])
								if w < rule.width:
									iparams['w'] = (rule.width + 9) // 10 * 10  # MUST be / 10  (nnn0)
									images[prop] = '%s?%s' % (iurl, urlencode(iparams))
					break
			else:
				xbmc.log('vod.pl: no image %s (%s) in %r' % (prop, inames, data.get('images')), xbmc.LOGINFO)
				images[prop] = None
		try:
			logo = self.logo_tags[data['logo']['images']['pc'][0]['id']]
		except (KeyError, IndexError):
			pass
		else:
			tytul = '%s | %s' % (tytul, logo)
			opis = '[B]%s[/B] | %s' % (logo, opis or '')
		sezon = bool(data.get('showSeasonNumber')) or data.get('type') == 'SERIAL'
		epizod = bool(data.get("showEpisodeNumber"))
		allowed = self.is_allowed(data)
		return MetaDane(tytul, opis, sezon=sezon, epizod=epizod, allowed=allowed, **images)

	def createDatas(self):


		def uniq_corelation():
			import uuid
			maker_id = ''

			if addon.getSetting('corelation_id'):
				maker_id = addon.getSetting('corelation_id')
			else:
				CorrelationId = str(uuid.uuid4())
				corelation_id = str('Client_')+CorrelationId
			set_setting('corelation_id', corelation_id)
			return corelation_id

		def uniq_id():
			import uuid
			device_id = ''

			if addon.getSetting('device_id'):
				device_id = addon.getSetting('device_id')
			else:
				device_id = (uuid.uuid4()).hex
			set_setting('device_id', device_id)
			return device_id
		self.DEVICE_ID =uniq_id()
		self.CORELATION = uniq_corelation()

		return

	def sprawdzenie1(self):
   
		import json
		query = {
			"jsonrpc": "2.0",
			"method": "Application.GetProperties",
			"params": {
				"properties": ["version", "name"]
			},
			"id": 1
		}
		
		json_query = xbmc.executeJSONRPC(json.dumps(query))
		if sys.version_info[0] >= 3:
			json_query = str(json_query)
		else:
			json_query = unicode(json_query, 'utf-8', errors='ignore') 
		json_query = json.loads(json_query)
		version_installed = []
		
		if 'result' in json_query and 'version' in json_query['result']:
			version_installed = json_query['result']['version']    
			major = str(version_installed.get('major', None))
			if int(major)<20:
				set_setting('nexus', 'false')

			else:
				set_setting('nexus', 'true')

		if not self.DEVICE_ID or not self.CORELATION:# or not self.USAGENT or not self.USAGENTVER:
			self.createDatas()
		return

	def getTranslate(self,id_):
		PARAMS = {'4K': 'true', 'platform': PF, 'id': id_}
		data = getRequests(self.TRANSLATE, headers=self.HEADERS2, params=PARAMS)
		return data

	def getPlaylist(self, id_):
		data = self.getTranslate(str(id_))
		rodzaj = "LIVE" if data.get("type_", "MOVIE") == "LIVE" else "MOVIE"

		urlk = 'https://vod.pl/playerapi/product/%s/player/configuration' % id_
		data = getRequests(urlk, headers=self.HEADERS2, params=self.params(type=rodzaj))

		try:
			vidsesid = data["videoSession"]["videoSessionId"]

		except Exception:
			vidsesid = False

		PARAMS = {'type': rodzaj, 'platform': PF}
		data = getRequests(self.api_base+'item/%s/playlist' % id_, headers=self.HEADERS2, params=PARAMS)

		if not data:
			urlk = 'https://vod.pl/playerapi/item/%s/playlist' % id_
			PARAMS = {'type': rodzaj, 'platform': UA, 'videoSessionId': vidsesid}
			data = getRequests(urlk, headers=self.HEADERS2, PARAMS=PARAMS)

		xbmc.log('vod.pl: getPlaylist(%r): data: %r' % (id_, data), xbmc.LOGDEBUG)
		code = data.get('code')
		try:
			vid = data['movie']
		except KeyError:
			if code == 'ITEM_NOT_PAID':
				raise NotPlayable('Brak w pakiecie')
			raise
		outsub = []
		try:
			subs = vid['video']['subtitles']
			for lan, sub in subs.items():
				lang = sub['label']

				srcsub = sub['src']
				outsub.append({'lang': lang, 'url': srcsub})
		except Exception:
			pass

		protect = vid['video']['protections']
		if 'widevine' in protect:
			src = vid['video']['sources']['dash']['url']
			tshiftl = vid.get('video', {}).get('time_shift', {}).get('total_length', 0)
			if tshiftl > 0:
				src += '&dvr=' + str(tshiftl * 1000 + 1000)
			widev = protect['widevine']['src']
			if vidsesid:
				widev += '&videoSessionId=%s' % vidsesid
		else:
			src = vid['video']['sources']['hls']['url']
			# start = vid.get('time_shift', {}).get('start')
			src += '&dvr=86400000'  # one day, @m1992 found hte limit: 262139999
			widev = 'hls'
		return src, widev, outsub


	def playvid(self, id):
		def download_subtitles():
			if subt:
				r = requests.get(subt)
				with open(SUBTITLEFILE, 'wb') as f:
					f.write(r.content)
				play_item.setSubtitles([SUBTITLEFILE])
		
		try:
			stream_url, license_url, subtitles = self.getPlaylist(str(id))
		except NotPlayable as exc:
			xbmcgui.Dialog().notification('PlayerMB', exc.message, xbmcgui.NOTIFICATION_ERROR)
			xbmc.log('vod.pl: play error: %s' % exc.message, xbmc.LOGERROR)
			return
		subt = ''
		if subtitles:# and self.ENABLE_SUBS == 'true':
			t = [x.get('lang') for x in subtitles]
			u = [x.get('url') for x in subtitles]
			al = "subtitles"
			if len(subtitles) > 1:
				if self.SUBS_DEFAULT != '' and self.SUBS_DEFAULT in t:
					subt = next((x for x in subtitles if x.get('lang') == self.SUBS_DEFAULT), None).get('url')
				else:
					select = xbmcgui.Dialog().select(al, t)
					if select > -1:
						subt = u[select]
						addon.setSetting(id='subtitles_lang_default', value=str(t[select]))
					else:
						subt = ''
			else:
				subt = u[0]

		if license_url == 'hls':
			from inputstreamhelper import Helper
			stream_proto = license_url
			is_helper = Helper(stream_proto)
			if is_helper.check_inputstream():
				play_item = xbmcgui.ListItem(path=stream_url)
				# if stream.mime is not None:
				#	 play_item.setMimeType(stream.mime)
				play_item.setContentLookup(False)
				play_item.setProperty('inputstream', is_helper.inputstream_addon)
				play_item.setProperty("IsPlayable", "true")
				play_item.setProperty('inputstream.adaptive.manifest_type', stream_proto)
			else:
				play_item = xbmcgui.ListItem(path=stream_url)
		elif license_url:
			# DRM
			import inputstreamhelper

			PROTOCOL = 'mpd'
			DRM = 'com.widevine.alpha'

			str_url = stream_url

			HEADERSz = {
				'User-Agent': UA,
			}

			is_helper = inputstreamhelper.Helper(PROTOCOL, drm=DRM)
			if not is_helper.check_inputstream():
				xbmc.log('vod.pl: InputStream filed for %r' % license_url, xbmc.LOGWARNING)
			play_item = xbmcgui.ListItem(path=str_url)
			play_item.setContentLookup(False)
			download_subtitles()

			if sys.version_info >= (3, 0):
				play_item.setProperty('inputstream', is_helper.inputstream_addon)
			else:
				play_item.setProperty('inputstreamaddon', is_helper.inputstream_addon)
			play_item.setMimeType('application/xml+dash')
			play_item.setContentLookup(False)
			play_item.setProperty('inputstream.adaptive.manifest_type', PROTOCOL)
			play_item.setProperty('inputstream.adaptive.license_type', DRM)
			if 'dvr' in str_url:
				play_item.setProperty('inputstream.adaptive.manifest_update_parameter', 'full')
			play_item.setProperty('inputstream.adaptive.license_key', license_url+'|Content-Type=|R{SSM}|')
			play_item.setProperty('inputstream.adaptive.license_flags', "persistent_storage")
			play_item.setProperty('inputstream.adaptive.stream_headers', urlencode(HEADERSz))
		else:
			# no DRM
			play_item = xbmcgui.ListItem(path=stream_url)
			download_subtitles()
		xbmcplugin.setResolvedUrl(addon_handle, True, listitem=play_item)

	def slug_data(self, idslug, maxResults=True, plOnly=False, sort='createdAt', params=None):
		xbmc.log('vod.pl: slug %s started' % idslug, xbmc.LOGDEBUG)
		gid, slug = idslug.split(':')
		PARAMS = self.params(maxResults=maxResults)
		PARAMS['category[]'] = slug
		PARAMS['sort'] = sort
		PARAMS['order'] = 'desc'
		
		nonm = ['seriale-online', 'programy-online', 'filmy-online', 'shorty']
		
		if gid and not slug in nonm:
			PARAMS['genreId[]'] = gid

		if params:
			PARAMS.update(params)
		urlk = self.PRODUCTVODLIST
		data = getRequests3(urlk, headers=self.HEADERS2, params=PARAMS)
		xbmc.log('vod.pl: slug %s done' % idslug, xbmc.LOGDEBUG)
		return data

	def async_slug_data(self, idslug, maxResults=True, plOnly=False):
		thread = ThreadCall(self.slug_data, idslug, maxResults=maxResults, plOnly=plOnly)
		thread.start()
		return thread

	def get_mylist(self):
		xbmc.log('vod.pl: mylist started', xbmc.LOGDEBUG)
		data = getRequests3('https://vod.pl/playerapi/subscriber/product/available/list?4K=true&platform=ANDROID_TV',
							headers=self.HEADERS2, params={})
		xbmc.log('vod.pl: mylist done', xbmc.LOGDEBUG)
		return set(data)

	@property
	def mylist_cache_path(self):
		return os.path.join(CACHEPATH, 'mylist')

	def save_mylist(self, mylist=None):
		path = self.mylist_cache_path
		if mylist is None:
			mylist = self.get_mylist()
		try:
			os.makedirs(CACHEPATH)
		except OSError:
			pass  # exists
		save_ints(path, mylist)

	def load_mylist(self, auto_cache=True):
		path = self.mylist_cache_path
		try:
			if time.time() - os.stat(path).st_mtime < self.MYLIST_CACHE_TIMEOUT:
				return set(load_ints(path))
		except OSError:
			pass
		except Exception as exc:
			xbmc.log('vod.pl: Can not load mylist from %r: %r' % (path, exc), xbmc.LOGWARNING)
			self.remove_mylist()
		mylist = self.get_mylist()
		if auto_cache:
			try:
				self.save_mylist(mylist)
			except OSError:
				xbmc.log('vod.pl: Can not save mylist to %r' % path, xbmc.LOGWARNING)
		return mylist

	def remove_mylist(self):
		path = self.mylist_cache_path
		if os.path.exists(path):
			try:
				os.unlink(path)
			except Exception as exc:
				xbmc.log('vod.pl: Can not remove mylist cache %r: %r' % (path, exc),
						 xbmc.LOGWARNING)

	@property
	def mylist(self):
		if self._mylist is None:
			self._mylist = self.load_mylist()
		return self._mylist

	@mylist.deleter
	def mylist(self):
		self.remove_mylist()

	@contextmanager
	def count_subfolders(self, data, loader, **kwargs):
		"""Count subfolders (avaliable items in sections) with statement."""
		count = CountSubfolders(self, data, loader, kwargs)
		try:
			yield count
		finally:
			del count

	def is_allowed(self, vod):
		"""Check if item (video, folder) is avaliable in current pay plan."""
		return (
			# not have to pay and not on ncPlus, it's means free
			not (vod.get('payable') or vod.get('ncPlus'))
			# or it's on myslit, it's means it is in pay plan
			or vod.get('id') in self.mylist)

	def add_media_item(self, mud, vid, meta=None, prefix=None, suffix=None, folder=False, isPlayable=None,
					   vod=None, linkdata=None, label2=None, info=None):
		"""
		Add default media item to xbmc.list.
		if `isPlayable` is None (default) it's forced to `not folder`,
		because folder is not playable.
		"""
		if vid in self._precessed_vid_list:
			xbmc.log(u'vod.pl: item %s (%r) already processed' % (vid, meta.tytul), xbmc.LOGDEBUG)
			if self.remove_duplicates:
				return
		if meta is None and vod is not None:
			meta = self.get_meta_data(vod)
		if meta is None:
			meta = MetaDane('', '', '', '', '')  # tytul opis foto sezon epizod
		allowed = (meta and meta.allowed is True) or vid in self.mylist
		if allowed or not self.skip_unaviable:
			no_playable = not (mud or '').strip() or meta.sezon
			if no_playable or not allowed:
				isPlayable = False
				# folder = True
			elif isPlayable is None:
				isPlayable = not folder
			if suffix is None:
				suffix = u''
				if (no_playable and not folder) or not allowed:
					# auto suffix for non-playable video
					suffix += u' - [COLOR khaki]([I]brak w pakiecie[/I])[/COLOR]'
				sched = vod and vod.get('displaySchedules')
				if sched and sched[0].get('type') == 'SOON':
					suffix += u' [COLOR gray] [LIGHT] (od %s)[/LIGHT][/COLOR]' % sched[0]['till'][:-3]
			suffix = suffix or ''
			title = PLchar(prefix or '', meta.tytul, suffix, sep='')
			descr = PLchar(meta.opis or meta.tytul, suffix, sep='\n')
			info = {
				'title': title,
				'plot': descr,
				'plotoutline': descr,
			}
			if info:
				info.update(info)
			add_item(str(vid), title, meta.foto or ADDON_ICON, mud,
					 folder=folder, isPlayable=isPlayable, infoLabels=info, art=meta.art,
					 linkdata=linkdata, label2=label2)
			self._precessed_vid_list.add(vid)

	def process_list(self, vod_list, subitem=None):
		# WIP !!!
		"""
		Process list of VOD items.
		Check if playable or serial. Add items to Kodi list.
		"""
		for vod in vod_list:
			if subitem:
				vod = vod[subitem]
			vid = vod['id']
			meta = self.get_meta_data(vod)
			mud, fold = ' ', None
			if vod['type'] == 'SERIAL':
				mud = 'listcategSerial'
				fold = True
			elif vod['type'] == 'SECTION':
				add_item('%s:' % vid, meta.tytul, meta.foto, mode='section_list', folder=True, isPlayable=False)
				continue
			else:
				mud = 'playvid'
				fold = False
			self.add_media_item(mud, vid, meta, folder=fold, vod=vod)

	def process_vod_list(self, vod_list, subitem=None):
		"""
		Process list of VOD items.
		Check if playable or serial. Add items to Kodi list.
		"""
		for vod in vod_list:
			if subitem:
				vod = vod[subitem]
			vid = vod['id']
			meta = self.get_meta_data(vod)
			mud, fold = ' ', None

			if vod['type'] == 'SERIAL':
				mud = 'listcategSerial'
				fold = True
			elif vod['type'] == 'SECTION':
				add_item('%s:' % vid, meta.tytul, meta.foto, mode='section_list', folder=True, isPlayable=False)
				continue
			else:
				mud = 'playvid'
				fold = False
			self.add_media_item(mud, vid, meta, folder=fold, vod=vod)

	def section_list(self, exlink):
		ex = ExLink.new(exlink)
		url = self.SECTION_CONTENT.format(sid=ex.gid)
		data = getRequests(url, headers=self.HEADERS2, params=self.params())
		self.process_vod_list(data['items'])
		setView('tvshows')
		xbmcplugin.endOfDirectory(addon_handle, cacheToDisc=False)

	def listCollection(self):
		def load_subfolders(item):
			urlk = 'https://vod.pl/playerapi/product/section/%s' % item['id']
			return getRequests(urlk, headers=self.HEADERS2, params=self.params(maxResults=True))


		data = getRequests(self.SECTIONLIST,
						   headers=self.HEADERS2, params=self.params(maxResults=True, order='asc'))
		mud = "listcollectContent"
		with self.count_subfolders(data, load_subfolders) as count:
			for i, vod in enumerate(data):
				vid = vod['id']
				slug = vod['slug']
				meta = self.get_meta_data(vod)
				info = {
					'title': PLchar(meta.tytul),
					'plot': PLchar(meta.opis or meta.tytul),
				}
				name = count.title(vod, meta.tytul, info)
				add_item(str(vid)+':'+str(slug), name, meta.foto, mud, folder=True,
						 infoLabels=info, art=meta.art)
		setView('movies')
		xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_TITLE, label2Mask="%R, %Y, %P")
		xbmcplugin.endOfDirectory(addon_handle, cacheToDisc=False)

	def listSearch(self, query):

		PARAMS = self.params(keyword=query, maxResults=self.MaxMax)

		urlk = 'https://vod.pl/playerapi/product/live/search'
		lives = getRequests(urlk, headers=self.HEADERS2, params=PARAMS)
		xbmc.log('vod.pl: listSearch(%r): params=%r, #live=%r' % (query, PARAMS, len(lives.get('items', []))),
				 xbmc.LOGDEBUG)
		lives = lives['items']
		# -- commented out, it does do nothing   (rysson)
		# if len(lives)>0:
		#	 for live in lives:
		#		 ac=''
		urlk = 'https://vod.pl/playerapi/product/vod/search'
		data = getRequests(urlk, headers=self.HEADERS2, params=PARAMS)
		xbmc.log('vod.pl: listSearch(%r): params=%r, #vod=%r' % (query, PARAMS, len(data.get('items', []))),
				 xbmc.LOGDEBUG)
		self.process_vod_list(data['items'])
		# setView('tvshows')
		xbmcplugin.setContent(addon_handle, 'videos')
		xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_TITLE, label2Mask="%R, %Y, %P")
		xbmcplugin.endOfDirectory(addon_handle, cacheToDisc=False)

	def listEpizody(self, tytsezid):
		idmain, idsezon = tytsezid.split(':')


		urlk = 'https://vod.pl/playerapi/product/vod/serial/%s/season/%s/episode/list' % (idmain, idsezon)

		epizody = getRequests(urlk, headers=self.HEADERS2, params=self.PARAMS)
		for vod in epizody:
			vid = vod['id']
			meta = self.get_meta_data(vod)
			epiz = vod["episode"]
			sez = (vod["season"]["number"])
			tyt = PLchar((vod["season"]["serial"]["title"]))
			if 'fakty-' in vod.get('shareUrl', ''):
				tytul = PLchar(tyt, self.dywiz, vod['title'])
			else:
				tytul = '%s %s S%02dE%02d' % (tyt, PLchar(self.dywiz), sez, epiz)
			if vod.get('title'):
				tytul += PLchar('', self.dywiz, vod['title'].strip())
			meta = meta._replace(tytul=tytul)
			self.add_media_item('playvid', vid, meta, folder=False, vod=vod)
		setView('episodes')
		# xbmcplugin.setContent(addon_handle, 'episodes')
		xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_TITLE, label2Mask="%R, %Y, %P")
		xbmcplugin.endOfDirectory(addon_handle)

	def getSezony(self, id, tytul, opis, foto, typ):

		urlk = 'https://vod.pl/playerapi/product/vod/serial/%s/season/list' % id
		out = []
		sezony = getRequests(urlk, headers=self.HEADERS2, params=self.PARAMS)
		for sezon in sezony:
			seas = str(sezon['number'])
			urlid = '%s:%s' % (id, sezon['id'])
			title = '%s - Sezon %s' % (tytul, seas)
			if not typ:
				seas = str(sezon["display"])
				title = '%s / %s' % (tytul, seas)
			out.append({'title': PLchar(title), 'url': urlid, 'img': foto, 'plot': PLchar(opis)})
		return out

	def listCategSerial(self, id):

		urlk = 'https://vod.pl/playerapi/product/vod/serial/%s' % id
		data = getRequests(urlk, headers=self.HEADERS2, params=self.PARAMS)
		meta = self.get_meta_data(data)
		typ = True
		if meta.sezon or meta.epizod:
			if not meta.sezon:
				typ = False
			items = self.getSezony(id, meta.tytul, meta.opis, meta.foto, typ)
			for f in items:
				add_item(name=f.get('title'), url=f.get('url'), mode='listEpizody', image=f.get('img'),
						 folder=True, infoLabels=f)
		setView('seasons')
		# xbmcplugin.setContent(addon_handle, 'episodes')
		xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_TITLE, label2Mask="%R, %Y, %P")
		xbmcplugin.endOfDirectory(addon_handle)

	def listCollectContent(self, idslug):

		vid, slug = idslug.split(':')
		urlk = 'https://vod.pl/playerapi/product/section/%s' % (vid)
		data = getRequests(urlk, headers=self.HEADERS2, params=self.params(maxResults=True))
		self.process_vod_list(data['items'])
		setView('movies')
		# xbmcplugin.setContent(int(sys.argv[1]), 'movies')
		xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_TITLE,
								 label2Mask="%R, %Y, %P")
		xbmcplugin.endOfDirectory(addon_handle)

	def listCategContent(self, idslug):

		gid, slug = idslug.split(':')

		data = self.slug_data(idslug, maxResults=True if gid else self.MaxMax)
		data = data['items']
		#if self.hide_soon and slug == 'eurosport':
		#	data = self.skip_soon_vod_iter(data)
		self.process_vod_list(data)
		setView('tvshows')

		xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_TITLE, label2Mask="%R, %Y, %P")
		xbmcplugin.endOfDirectory(addon_handle)

	def listCateg(self, idslug):
		getRequests(url=self.KATEGORIE, headers=self.HEADERS2, params=self.params())
		gid, slug = idslug.split(':')
		if slug == 'live':
			data = self.getTvs()
			for f in data:
				add_item(name=f.get('title'), url=f.get('url'), mode='playvid', image=f.get('img'),
						 folder=False, isPlayable=True, infoLabels=f)
		else:
			def load_subfolders(item):
				return self.slug_data('%s:%s' % (item['id'], slug))
			try:
				data = serialemenu[gid]
			except KeyError:
				data = getRequests(url='https://vod.pl/playerapi/item/category/%s/genre/list' % gid,
								   headers=self.HEADERS2, params=self.params())
			with self.count_subfolders(data, load_subfolders) as count:
				if self.skip_unaviable:
					data.append({'id': '', 'name': self.all_items_title, '_props_': {'SpecialSort': 'top'}})
				for f in data:
					name = f['name']
					urlk = '%s:%s' % (f['id'], slug)
					count.title(f, name)
					image = media('genre/%s.png' % f['id'], fallback=ADDON_ICON)
					add_item(urlk, name, image, mode='listcategContent', folder=True, isPlayable=False,
							 properties=f.get('_props_'))

		xbmc.log('vod.pl: folder items done', xbmc.LOGWARNING)
		setView('tvshows')
		xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_TITLE,
								 label2Mask="%R, %Y, %P")
		xbmcplugin.endOfDirectory(addon_handle)
		xbmc.log('vod.pl: folder done, skip=%s' % self.skip_unaviable, xbmc.LOGWARNING)

	@property
	def category_tree(self):

		return getRequests(url=self.KATEGORIE, headers=self.HEADERS2, params=self.params())

	def root(self):
		"""Get ROOT folder (main menu)."""
		# add_item('17:live', 'TV', ADDON_ICON, 'listcateg', folder=True)
		self.category_list()

	def category_list(self, exlink=None):
		"""Get root categories (main menu)."""
		category_tree = self.category_tree
		catimages = {}
		for item in category_tree:
			image = (item.get('images', {}).get('pc') or [{}])[0].get('mainUrl')
			if image:
				catimages[item['slug']] = image
		for item in category_tree:
			if item.get('genres') and item['slug'] not in slug_blacklist:
				cid = item['id']
				slug = item['slug']
				name = item['name']
				image = catimages.get(slug)
				url = '%s:%s' % (cid, slug)
				if slug == 'eurosport':  # special case
					add_item(url, name, image=image, mode='eurosport', folder=True)
				elif slug in self.categories_without_genres:
					add_item(':%s' % slug, name, image=image, mode='listcategContent', folder=True, isPlayable=False)
				else:
					add_item(url, name, image=image, mode='category_genre_list', folder=True)


def addon_settings(name=None, **kwargs):
	xbmc.log('vod.pl: addon_settings(%r, %r)' % (name, kwargs), xbmc.LOGWARNING)
	if name == 'categories_without_genres':
		Category = namedtuple('Category', 'name slug on')
		vodpl = VOD_PL()
		categories = [Category(item['name'], item['slug'], item['slug'] in vodpl.categories_without_genres)
					  for item in vodpl.category_tree
					  if item.get('genres') and item['slug'] not in slug_blacklist]
		dialog = xbmcgui.Dialog()
		ret = dialog.multiselect("Kategorie bez podziału na gatunki",
								 [c.name for c in categories],
								 preselect=[i for i, c in enumerate(categories) if c.on])
		if ret is not None:
			addon.setSetting('categories_without_genres', ','.join(c.slug for i, c in enumerate(categories)
																   if i in ret))


if __name__ == '__main__':

	exlink = params.get('url')
	mode = params.get('mode')
	name = params.get('name')
	xbmc.log('vod.pl: ENTER: mode=%r, name=%r, exlink=%r' % (mode, name, exlink),
			 xbmc.LOGWARNING)

	if not mode:
		home()

	elif mode == "content":
		VOD_PL().content()

	elif mode == "listproduct":
		VOD_PL().listProduct(exlink)
		
	elif mode == "listcateg":
		VOD_PL().listCateg(exlink)

	elif mode == "listcategContent":
		VOD_PL().listCategContent(exlink)

	elif mode == "listcategSerial":
		VOD_PL().listCategSerial(exlink)

	elif mode == "listEpizody":
		VOD_PL().listEpizody(exlink)

	elif mode == 'search.it':
		if exlink:
			VOD_PL().listSearch(exlink)

	elif mode == 'search':
		add_item('', '[COLOR khaki][B]Nowe szukanie[/B][/COLOR]', image=None, mode='search.new',
				 folder=True)
		for entry in historyLoad():
			if entry:
				contextmenu = [
					(u'Usuń', 'Container.Update(%s)'
					 % build_url({'mode': 'search.remove', 'url': entry})),
					(u'Usuń całą historię', 'Container.Update(%s)'
					 % build_url({'mode': 'search.remove_all'})),
				]
				add_item(entry, entry, image=None, mode='search.it', contextmenu=contextmenu,
						 folder=True)
		xbmcplugin.endOfDirectory(addon_handle, succeeded=True, cacheToDisc=False)

	elif mode == 'search.new':
		query = xbmcgui.Dialog().input(u'Szukaj, podaj tytuł filmu', type=xbmcgui.INPUT_ALPHANUM)
		if query:
			historyAdd(query)
			try:
				VOD_PL().listSearch(query)
			except Exception:
				addon_data.save(indent=2)  # save new search even if exception raised
				raise
	elif mode == 'search.remove':
		historyDel(exlink)
		xbmc.executebuiltin('Container.Refresh(%s)' % build_url({'mode': 'search'}))
		xbmcplugin.endOfDirectory(addon_handle, succeeded=True, cacheToDisc=False)

	elif mode == 'search.remove_all':
		historyClear()
		xbmc.executebuiltin('Container.Refresh(%s)' % build_url({'mode': 'search'}))
		xbmcplugin.endOfDirectory(addon_handle, succeeded=True, cacheToDisc=False)

	elif mode == "listcollectContent":
		VOD_PL().listCollectContent(exlink)

	elif mode == 'playvid':
		VOD_PL().playvid(exlink)

	elif mode == 'opcje':
		addon.openSettings()
		xbmc.executebuiltin('Container.Refresh()')

	else:
		# auto bind
		vodpl = VOD_PL()
		if hasattr(vodpl, mode):
			getattr(vodpl, mode)(exlink)

addon_data.save(indent=2)
