# -*- coding: UTF-8 -*-
import sys,re,os
from urlparse import parse_qsl, urlparse

import requests
import xbmcgui
import xbmcplugin
import xbmcaddon
import xbmc
from resources.lib.cmf2 import parseDOM

import resolveurl

from urllib import urlencode, quote_plus, quote, unquote


base_url = sys.argv[0]
addon_handle = int(sys.argv[1])
params = dict(parse_qsl(sys.argv[2][1:]))
addon = xbmcaddon.Addon(id='plugin.video.watchserieshdtv')

skatv = addon.getSetting('skatV')
if not skatv:
	addon.setSetting('skatV','&genre=all')
skatn = addon.getSetting('skatN') if skatv else 'all'
srokv = addon.getSetting('srokV')
if not srokv:
	addon.setSetting('srokV','&year=all')
srokn = addon.getSetting('srokN') if srokv else 'all'
addon.setSetting('fdata',skatv+srokv)
fdata = addon.getSetting('fdata')

PATH            = addon.getAddonInfo('path')
DATAPATH        = xbmc.translatePath(addon.getAddonInfo('profile')).decode('utf-8')
RESOURCES       = PATH+'/resources/'
FANART=RESOURCES+'../fanart.jpg'
ikona =RESOURCES+'../icon.png'


exlink = params.get('url', None)
nazwa= params.get('title', None)
rys = params.get('image', None)

page = params.get('page',[1])


UA= 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:83.0) Gecko/20100101 Firefox/83.0'

hd = {'User-Agent': UA,
    'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
    'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',}
	
sess = requests.Session()
baseurl = 'https://www4.watchserieshd.tv'

def build_url(query):
    return base_url + '?' + urlencode(query)

def add_item(url, name, image, mode, itemcount=1, page=1,fanart=FANART, infoLabels=False,contextmenu=None,IsPlayable=False, folder=False):
	list_item = xbmcgui.ListItem(label=name)
	if IsPlayable:
		list_item.setProperty("IsPlayable", 'True')	
	if not infoLabels:
		infoLabels={'title': name}	
	list_item.setInfo(type="video", infoLabels=infoLabels)	
	list_item.setArt({'thumb': image, 'poster': image, 'banner': image, 'fanart': fanart})
	
	if contextmenu:
		out=contextmenu
		list_item.addContextMenuItems(out, replaceItems=True)
	else:
		out = []
		out.append(('Informacja', 'XBMC.Action(Info)'),)
		list_item.addContextMenuItems(out, replaceItems=False)

	xbmcplugin.addDirectoryItem(
		handle=addon_handle,
		url = build_url({'mode': mode, 'url' : url, 'page' : page, 'title':name,'image':image}),			
		listitem=list_item,
		isFolder=folder)
	xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = "%R, %Y, %P")
	
def home():
	add_item('https://subsmovies.club/', 'Series', ikona, "menu:series",fanart=FANART, folder=True)
	add_item('https://www4.watchserieshd.tv/movies', 'Movies', ikona, "listcontent",fanart=FANART, folder=True)
	add_item('https://www4.watchserieshd.tv/drama', 'Drama', ikona, "listcontent",fanart=FANART, folder=True)
	add_item('https://www4.watchserieshd.tv/anime', 'Anime', ikona, "listcontent",fanart=FANART, folder=True)
	add_item('', '[COLOR lightblue]Search[/COLOR]', 'DefaultAddonsSearch.png', "search", folder=True)	

def menuSeries():
	add_item('', '[COLOR gold][B]<=>=<=> SERIES <=>=<=>[/COLOR][/B] ',ikona, " ",fanart=FANART, folder=False)
	add_item('', 'Popular TV series',ikona, "menu:seriespop",fanart=FANART, folder=True)
	add_item('', 'All TV series',ikona, "menu:seriesall",fanart=FANART, folder=True)
	xbmcplugin.endOfDirectory(addon_handle)

def menuSeriesPop():
	add_item('https://www4.watchserieshd.tv/popular'+fdata, 'List popular',ikona, "listcontent",fanart=FANART, folder=True)
	add_item('https://subsmovies.club/', '[COLOR blue]- genre:[/COLOR] [B]'+skatn+'[/B]', 'DefaultGenre.png', "filtr:skat",fanart=FANART, folder=False)
	add_item('https://subsmovies.club/', '[COLOR blue]- year:[/COLOR] [B]'+srokn+'[/B]', 'DefaultYear.png', "filtr:srok",fanart=FANART, folder=False)
	xbmcplugin.endOfDirectory(addon_handle)
	
def menuSeriesAll():
	add_item(baseurl+"/letters/0-9","0-9" ,ikona, "listcontent",fanart=FANART, folder=True)
	add_item(baseurl+"/letters/A","A"     ,ikona, "listcontent",fanart=FANART, folder=True)
	add_item(baseurl+"/letters/B","B"     ,ikona, "listcontent",fanart=FANART, folder=True)
	add_item(baseurl+"/letters/C","C"     ,ikona, "listcontent",fanart=FANART, folder=True)
	add_item(baseurl+"/letters/D","D"     ,ikona, "listcontent",fanart=FANART, folder=True)
	add_item(baseurl+"/letters/E","E"     ,ikona, "listcontent",fanart=FANART, folder=True)
	add_item(baseurl+"/letters/F","F"     ,ikona, "listcontent",fanart=FANART, folder=True)
	add_item(baseurl+"/letters/G","G"     ,ikona, "listcontent",fanart=FANART, folder=True)
	add_item(baseurl+"/letters/H","H"     ,ikona, "listcontent",fanart=FANART, folder=True)
	add_item(baseurl+"/letters/I","I"     ,ikona, "listcontent",fanart=FANART, folder=True)
	add_item(baseurl+"/letters/J","J"     ,ikona, "listcontent",fanart=FANART, folder=True)
	add_item(baseurl+"/letters/K","K"     ,ikona, "listcontent",fanart=FANART, folder=True)
	add_item(baseurl+"/letters/L","L"     ,ikona, "listcontent",fanart=FANART, folder=True)
	add_item(baseurl+"/letters/M","M"     ,ikona, "listcontent",fanart=FANART, folder=True)
	add_item(baseurl+"/letters/N","N"     ,ikona, "listcontent",fanart=FANART, folder=True)
	add_item(baseurl+"/letters/O","O"     ,ikona, "listcontent",fanart=FANART, folder=True)
	add_item(baseurl+"/letters/P","P"     ,ikona, "listcontent",fanart=FANART, folder=True)
	add_item(baseurl+"/letters/Q","Q"     ,ikona, "listcontent",fanart=FANART, folder=True)
	add_item(baseurl+"/letters/R","R"     ,ikona, "listcontent",fanart=FANART, folder=True)
	add_item(baseurl+"/letters/S","S"     ,ikona, "listcontent",fanart=FANART, folder=True)
	add_item(baseurl+"/letters/T","T"     ,ikona, "listcontent",fanart=FANART, folder=True)
	add_item(baseurl+"/letters/U","U"     ,ikona, "listcontent",fanart=FANART, folder=True)
	add_item(baseurl+"/letters/V","V"     ,ikona, "listcontent",fanart=FANART, folder=True)
	add_item(baseurl+"/letters/W","W"     ,ikona, "listcontent",fanart=FANART, folder=True)
	add_item(baseurl+"/letters/X","X"     ,ikona, "listcontent",fanart=FANART, folder=True)
	add_item(baseurl+"/letters/Y","Y"     ,ikona, "listcontent",fanart=FANART, folder=True)
	add_item(baseurl+"/letters/Z","Z"     ,ikona, "listcontent",fanart=FANART, folder=True)
	xbmcplugin.endOfDirectory(addon_handle)

def ListContent(exlink,page):
	page = int(page) if page else 1	
	if '/letters/' in exlink:
		itemsk,pagination=getContent2(exlink,page)
	else:
		itemsk,pagination=getContent(exlink,page)

	items = len(itemsk)
	if items>0:
		for f in itemsk:

			modemy='getLinks'
			isplay=False
			fold=True
			if 'series' in f.get('rodz'): 
	
				modemy='listepisodes'
				isplay=False
				fold=True
	
				tyt = re.sub('(\(\d+\.\d+\))\s*','',f.get('title')) 
			else:
				tyt = f.get('title')
			add_item(name=tyt, url=f.get('href'), mode=modemy, image=f.get('img'), infoLabels={'code':f.get('code'),'plot':f.get('plot'),'genre':f.get('genre')}, itemcount=items,folder=fold, IsPlayable=isplay)	
		
		if pagination:
			add_item(name='[COLOR blue]>> next page >>[/COLOR]', url=exlink, mode="listcontent", image=RESOURCES+'right.png', page=pagination,fanart=FANART, folder=True)		

		xbmcplugin.endOfDirectory(addon_handle)
	else:
		xbmcgui.Dialog().notification('[COLOR red][B]Info[/B][/COLOR]', "[COLOR red][B]No results.[/B][/COLOR]", xbmcgui.NOTIFICATION_INFO, 5000)
def getContent(url,pg):
	
	out=[]
	npage=[]
	if not '/popular' in url and not 'search.html?' in url:
		if '?page=' in url:

			url = re.sub('\?page=\\d+','?page=%d'%int(page),url)
		else:

			url = url + '?page=%d' %int(page)
		nturl = '?page=%d' %(int(page)+1) 
	else:
		if '&page=' in url:

			url = re.sub('\?page=\\d+','?page=%d'%int(page),url)
		else:

			url = url + '&page=%d' %int(page)
		nturl = '&page=%d' %(int(page)+1) 

	html = sess.get(url,headers=hd,verify=False).content
	items = parseDOM(html,'li', attrs={'class': "video-block"}) 
	for link in items:

		href = parseDOM(link,'a', ret="href")[0]
		typ= 'series' if '-season-' in href and not 'episode-' in href else ''
		tyt = parseDOM(link,'div', attrs={'class': "home_video_title"})
		if tyt:
			tyt = re.sub("<[^>]*>","",tyt[0]) if tyt else ''
		else:
			tyt = parseDOM(link,'a', ret="title")[0]
		qual = parseDOM(link,'div', attrs={'class': "home_video_info"})

		imag = parseDOM(link,'img', ret="src")[0]
		href = baseurl + href if href.startswith('/') else href
		imag = baseurl + imag if imag.startswith('/') else imag
		qual = re.sub("<[^>]*>","",qual[0]) if qual else ''
		genre = parseDOM(link,'span', attrs={'class': "genre"})
		genre = genre[0] if genre else ''
		year = parseDOM(link,'span', attrs={'class': "hd hdy"})

		year = year[0] if year else ''

		ftitle=tyt.strip()+' [COLOR orange][B]('+qual+')[/COLOR][/B]' if qual else tyt.strip()
		plot=PLchar(ftitle)
		out.append({'title':PLchar(ftitle),'href':href,'img':imag,'year':year,'plot':plot,'genre':genre,'code':qual,'rodz':typ})

	nextpage=False  
	ktora=False

	if html.find(nturl)>1:
		nextpage=int(page)+1

	return out,nextpage
	
def getContent2(url,pg):
	out=[]
	npage=[]

	if '?page=' in url:
	
		url = re.sub('\?page=\\d+','?page=%d'%int(page),url)
	else:
	
		url = url + '?page=%d' %int(page)

	nturl = '?page=%d' %(int(page)+1) 	

	html = sess.get(url,headers=hd,verify=False).content

	result = parseDOM(html,'tbody')[0]
	items = parseDOM(result,'tr')
	for link in items:

		href = parseDOM(link,'a', ret="href")[0]
		tyt = parseDOM(link,'a', ret="title")[0]
		typ= 'series' if '-season-' in href and not 'episode-' in href else ''

		quals1= re.findall('<\/a>(.+?)$',link,re.DOTALL)[0]
		quals = parseDOM(quals1,'td')
		qual = ', '.join([(x.strip()).lower() for x in quals]) if quals else ''

		href = baseurl + href if href.startswith('/') else href

		genre = parseDOM(link,'span', attrs={'class': "genre"})
		genre = genre[0] if genre else ''
		year = parseDOM(link,'span', attrs={'class': "hd hdy"})

		year = year[0] if year else ''

		ftitle=tyt.strip()+' [COLOR orange][B]('+qual+')[/COLOR][/B]' if qual else tyt.strip()
		plot=PLchar(ftitle)
		out.append({'title':PLchar(ftitle),'href':href,'img':ikona,'year':year,'plot':plot,'genre':genre,'code':qual,'rodz':typ})

	nextpage=False  
	ktora=False

	if html.find(nturl)>1:
		nextpage=int(page)+1

	return out,nextpage
	

def ListLinks(exlink):
	pagination=None
	links=getLinks(exlink)
	
	itemz=links
	items = len(links)
	if items>0:
		for f in itemz:
			modemy='playLink'
			isplay=True
			fold=False
			add_item(name=f.get('title'), url=f.get('href'), mode=modemy, image=f.get('img'), infoLabels={'code':f.get('code'),'plot':f.get('plot'),'genre':f.get('genre')}, itemcount=items,folder=fold, IsPlayable=isplay)	
		
		if pagination:
			add_item(name='[COLOR blue]>> next page >>[/COLOR]', url=exlink, mode='listsubsmov', image=RESOURCES+'right.png', page=pagination,fanart=FANART, folder=True)		

		xbmcplugin.addSortMethod(addon_handle, sortMethod=xbmcplugin.SORT_METHOD_NONE, label2Mask = "%R, %Y, %P")
		xbmcplugin.endOfDirectory(addon_handle)
	else:
		xbmcgui.Dialog().notification('[COLOR red][B]Info[/B][/COLOR]', "[COLOR red][B]No links for this video.[/B][/COLOR]", xbmcgui.NOTIFICATION_INFO, 5000)

def getLinks(url):
	out=[]

	htmlx = sess.get(url, headers=hd,verify=False).content
	
	plot = parseDOM(htmlx,'div', attrs={'class': "video-page-desc"})
	plot = plot[0] if plot else ''

	video_player = parseDOM(htmlx,'div', attrs={'class': "video_player default"}) 
	if video_player:

		mainurl = parseDOM(video_player[0],'a', ret = 'href')[0]
		mainurl = baseurl + mainurl if mainurl.startswith('/') else mainurl
		htmlx = sess.get(mainurl, headers=hd,verify=False).content
	mainvid = parseDOM(htmlx,'a', ret = 'data-video')
	if mainvid:
		hd.update({'Referer': url})

		mainvid = 'https:' + mainvid[0] if mainvid[0].startswith('//') else mainvid[0]
		parsed_url = urlparse(mainvid)
		domain = parsed_url.netloc
		html = sess.get(mainvid , headers=hd,verify=False).content

		result = parseDOM(html,'ul', attrs={'class': "list-server-items"})[0]
		vids = re.findall('data\-video=(".+?>.+?<)',result)

		for vid in vids:
			if 'main server' in vid.lower() or 'standard server' in vid.lower() or 'vidstreaming' in vid.lower() :
				cd = re.findall('(\?id.+?)$',mainvid)[0]
				href = 'https://%s/ajax.php'%(domain) + cd
				tyt = nazwa+' - [I]Main Server[/I]'

			else:
				href,host = re.findall('"(.+?)">(.+?)<',vid)[0]
				href = 'https:' + href if href.startswith('//') else href
				tyt = nazwa+' - [I]'+host+'[/I]'

			out.append({'title':tyt,'href':href,'img':rys,'year':'','plot':plot,'genre':'','code':''})
	return out

def PlayLink(url):

	parsed_url = urlparse(url)
	domain = parsed_url.netloc

	link=''
	if 'vidnext' in url or 'k-vid.net' in url or 'kshows.to' in url or 'gogo-play.net' in url:

		hd2 = {'Host': domain,
				'user-agent': UA,
				'accept': 'application/json, text/javascript, */*; q=0.01',
				'accept-language': 'pl,en-US;q=0.7,en;q=0.3',
				'referer': 'https://%s/'%domain,
				'x-requested-with': 'XMLHttpRequest',
				'dnt': '1',
				'te': 'trailers',}
		response = sess.get(url, headers=hd2,verify=False)

		if 'ajax.' in url:
			html = response.json()
			link = html['source'][0]['file']

		else:

			ab=response.content
			
			srcs = re.findall('sources\:\s*(\[.*?\])',ab,re.DOTALL)#[0]
			if srcs:
				link = re.findall("""file:\s*['"](.+?)['"]""",srcs[0])[0]
		link = link + '|User-Agent='+UA
	elif 'streamsb.' in url:
		link = getStreamssb(url)
	elif 'movcloud.' in url:
		link = getMovcloud(url)

	else:
		
		try:
			link = resolveurl.resolve(url)
		except Exception as e:
			link =''
			xbmcgui.Dialog().notification('[COLOR red][B]Error[/B][/COLOR]', "[COLOR red][B]This video is not working.[/B][/COLOR]", xbmcgui.NOTIFICATION_INFO, 5000)
	if link:
		play_item = xbmcgui.ListItem(path=link)

		xbmcplugin.setResolvedUrl(addon_handle, True, listitem=play_item)

def getStreamssb(url):

	import resources.lib.jsunpack as jsunpack

	html = sess.get(url , headers=hd,verify=False).content	
	sc=''.join(['%s=%s;'%(c.name, c.value) for c in sess.cookies])	
	r = re.search(r"text/javascript'>(eval.*?)\s*</script>", html, re.DOTALL)
	if r:
		html = jsunpack.unpack(r.group(1))

	link = re.findall("""file:\s*['"](.+?)['"]""",html)
	#xbmc.log('@#@linklinklinklinklink: %s' % str(link), xbmc.LOGNOTICE)
	
	link = link[0]+ '|User-Agent='+UA+'&Referer=https://streamsb.net/' if link else '' 
	return link
	

def getMovcloud(url):

	url = url.replace('movcloud.net/embed/','api.movcloud.net/stream/')

	html = sess.get(url , headers=hd,verify=False).content	

	link = re.findall("""file['"]:\s*['"](.+?)['"]""",html)#[0]	
	#xbmc.log('@#@linklinklinklinklink: %s' % str(link), xbmc.LOGNOTICE)
	
	link = link[0]+ '|User-Agent='+UA+'&Referer=https://movcloud.net' if link else '' #&Cookie='+sc if link else '' #https://streamsb.net/
	return link	

def ListSeasons(exlink,org_tit):

	seasons =  getSeasons(exlink)
	itemz=seasons
	items = len(seasons)
	for f in seasons:
		mud='listepisodes' if f.get('typ')=='ok' else 'getLinks'
		add_item(name=f.get('title'), url=f.get('href'), mode=mud, image=f.get('img'), infoLabels={'code':f.get('code'),'plot':f.get('plot'),'genre':f.get('genre')}, itemcount=items,folder=True, IsPlayable=False)	
	xbmcplugin.endOfDirectory(addon_handle)


def ListEpisodes(exlink,pg):
	episodes,pagination = getEpisodes(exlink,pg)
	itemz=episodes
	items = len(episodes)
	for f in itemz:
		add_item(name=f.get('title'), url=f.get('href'), mode='getLinks', image=f.get('img'), folder=True, infoLabels={'title':f.get('title'),'plot':f.get('title')}, itemcount=items, IsPlayable=False)		

	if pagination:
		add_item(name='[COLOR blue]>> next page >>[/COLOR]', url=exlink, mode='listepisodes', image=RESOURCES+'right.png', page=pagination,fanart=FANART, folder=True)		

	xbmcplugin.endOfDirectory(addon_handle)
	
def getEpisodes(url,pg):

	url=url+'/season'
	html = sess.get(url, headers=hd).content

	episodes = parseDOM(html,'li', attrs={'class': "li\-\d+"})

	out=[]
	npage=False
	for epis in episodes:
		vidinfo = parseDOM(epis,'div', attrs={'class': "vid_info"})[0] # <div class="vid_info">
		href = parseDOM(vidinfo,'a', ret="href")[0]

		tyt = parseDOM(vidinfo,'a', ret="title")[0]
		imag = re.findall('image\: url\((.+?)\)',epis)[0]

		href = baseurl + href if href.startswith('/') else href
		imag = baseurl + imag if imag.startswith('/') else imag

		out.append({'title':tyt,'href':href,'img':imag,'plot':'','genre':'', 'season' : '','episode' : '',})

	return out,npage	

def PLchar(char):
	if type(char) is not str:
		char=char.encode('utf-8')
	char = char.replace('\\u0105','\xc4\x85').replace('\\u0104','\xc4\x84')
	char = char.replace('\\u0107','\xc4\x87').replace('\\u0106','\xc4\x86')
	char = char.replace('\\u0119','\xc4\x99').replace('\\u0118','\xc4\x98')
	char = char.replace('\\u0142','\xc5\x82').replace('\\u0141','\xc5\x81')
	char = char.replace('\\u0144','\xc5\x84').replace('\\u0144','\xc5\x83')
	char = char.replace('\\u00f3','\xc3\xb3').replace('\\u00d3','\xc3\x93')
	char = char.replace('\\u015b','\xc5\x9b').replace('\\u015a','\xc5\x9a')
	char = char.replace('\\u017a','\xc5\xba').replace('\\u0179','\xc5\xb9')
	char = char.replace('\\u017c','\xc5\xbc').replace('\\u017b','\xc5\xbb')
	char = char.replace('&#8217;',"'")
	char = char.replace('&#8211;',"-")	
	char = char.replace('&#8230;',"...")	
	char = char.replace('&#8222;','"').replace('&#8221;','"')	
	char = char.replace('[&hellip;]',"...")
	char = char.replace('&#038;',"&")	
	char = char.replace('&#039;',"'")
	char = char.replace('&quot;','"').replace('&oacute;','ó').replace('&rsquo;',"'")
	char = char.replace('&nbsp;',".").replace('&amp;','&').replace('&eacute;','e')
	return char	
def PLcharx(char):
	char=char.replace("\xb9","ą").replace("\xa5","Ą").replace("\xe6","ć").replace("\xc6","Ć")
	char=char.replace("\xea","ę").replace("\xca","Ę").replace("\xb3","ł").replace("\xa3","Ł")
	char=char.replace("\xf3","ó").replace("\xd3","Ó").replace("\x9c","ś").replace("\x8c","Ś")
	char=char.replace("\x9f","ź").replace("\xaf","Ż").replace("\xbf","ż").replace("\xac","Ź")
	char=char.replace("\xf1","ń").replace("\xd1","Ń").replace("\x8f","Ź");
	return char	
	
def router(paramstring):
	params = dict(parse_qsl(paramstring))
	if params:	

		mode = params.get('mode', None)

		if 'menu' in mode:
			mode2 = mode.split(':')[-1]
			
			if mode2 == 'series':
				menuSeries()
			elif mode2 == 'seriespop':
				menuSeriesPop()
			elif mode2 == 'seriesall':
				menuSeriesAll()
		

		elif 'filtr' in mode:
			sst = mode.split(':')[-1]
			
			
			if 'skat' in sst:
				dd='genre:'
				
				value=["?genre=all","?genre=action","?genre=adventure","?genre=animation","?genre=biography","?genre=comedy","?genre=costume","?genre=crime","?genre=documentary","?genre=drama","?genre=family","?genre=fantasy","?genre=history","?genre=horror","?genre=kungfu","?genre=musical","?genre=mystery","?genre=mythological","?genre=psychological","?genre=romance","?genre=sci-fi","?genre=sitcom","?genre=sport","?genre=thriller","?genre=tv-show","?genre=war","?genre=western","?genre=xmas"]
				label=["all","action","adventure","animation","biography","comedy","costume","crime","documentary","drama","family","fantasy","history","horror","kungfu","musical","mystery","mythological","psychological","romance","sci-fi","sitcom","sport","thriller","tv show","war","western","xmas"]

			elif 'srok' in sst:
				dd='year:'
				value=["&year=all","&year=2020","&year=2019","&year=2018","&year=2017","&year=2016","&year=2015","&year=2014","&year=2013","&year=2012","&year=2011","&year=2010","&year=2009","&year=2008","&year=2007","&year=2006","&year=2005","&year=2004","&year=2003","&year=2002","&year=2001","&year=2000"]
				label=["all","2020","2019","2018","2017","2016","2015","2014","2013","2012","2011","2010","2009","2008","2007","2006","2005","2004","2003","2002","2001","2000"]

			s = xbmcgui.Dialog().select('Select '+dd,label)
			
			if s<=-1: quit()

			s = s if s>-1 else quit()
			v = value[s]
			n = label[s]
			
			addon.setSetting(sst+'V',v)
			addon.setSetting(sst+'N',n)
			
			skatv = addon.getSetting('skatV')
			srokv = addon.getSetting('srok')
			
			addon.setSetting('fdata',skatv+srokv)

			xbmc.executebuiltin('XBMC.Container.Refresh')

		elif mode =="listcontent":
			ListContent(exlink,page)

		elif mode == 'playLink':
			PlayLink(exlink)

		elif mode == 'getLinks':
			ListLinks(exlink)

		elif mode == 'listepisodes':
			ListEpisodes(exlink,page)	
			
		elif mode=='search':
			query = xbmcgui.Dialog().input(u'Search...', type=xbmcgui.INPUT_ALPHANUM)
			if query:  	
				query=query.replace(' ','+')
				url = 'https://www4.watchserieshd.tv/search.html?keyword='+query
				ListContent(url,1)

			else:
				pass
	else:
		home()
		xbmcplugin.endOfDirectory(addon_handle)	
if __name__ == '__main__':
    router(sys.argv[2][1:])