# coding: UTF-8
import xbmc, xbmcgui

import sys, re
import json
import requests
import urllib3

from resources.lib.brotlipython import brotlidec


if sys.version_info >= (3,0,0):
# for Python 3
    to_unicode = str

    from urllib.parse import unquote, quote

else:
    # for Python 2
    to_unicode = unicode

    from urllib import unquote, quote


def resp_text(resp):
    """Return decoded response text."""
    if resp and resp.headers.get('content-encoding') == 'br':
        out = []
        # terrible implementation but it's pure Python
        return brotlidec(resp.content, out).decode('utf-8')
    return resp.text


urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)


def debug_write(name, text):
    if 0:
        with open('/tmp/%s' % name, 'wb') as f:
            f.write(text.encode('utf-8'))


class Wfdif:
    def __init__(self, plugin, fanartx, ikona ):

    
        self.plugin = plugin
        self.fanart  = fanartx
        self.ikona  = ikona
        self.datapath = self.plugin.translate_path(self.plugin.get_path('profile'))
        try:
            self.kukis = self.plugin.load_file(self.datapath+'kukis', isJSON=True)
        except:
            self.kukis = {}

        self.UA ='Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:93.0) Gecko/20100101 Firefox/93.0'

        self.headers = {
            'User-Agent': self.UA,
            'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,*/*;q=0.8',
            'Accept-Language': 'pl,en-US;q=0.7,en;q=0.3',
            'Accept-Encoding': 'gzip, deflate, br',

        }

        self.login = self.plugin.get_setting('login')
        self.password = self.plugin.get_setting('password')
        self._sess = None
        self.kuk = {}

    @property
    def sess(self):
        if self._sess is None:
            self._sess = requests.Session()
            if self.kukis:
                self._sess.cookies.update(self.kukis)
                
                
                self._sess.cookies.update(self.kuk)

        return self._sess

    def home(self):
        user = self.logowanie()
        if user is None:
            self.plugin.add_item('film', 'Zaloguj', self.ikona, "loguj", folder=False, fanart=self.fanart)
        else:
            self.plugin.add_item('film', 'Zalogowany jako: %s' % user, self.ikona, "  ", folder=True, infoLabels={'plot': user}, fanart=self.fanart)
            self.plugin.add_item('strefa', 'Strefa VOD', self.ikona, "menu", folder=True, fanart=self.fanart)
            self.plugin.add_item('edukacja', 'Edukacja', self.ikona, "menu", folder=True, fanart=self.fanart)
            self.plugin.add_item('edukacja', 'Szukaj', self.ikona, "szukaj", folder=True, fanart=self.fanart)
            
        self.plugin.EOD()
        
    def Menu(self,typ):
        if typ == 'strefa':
        
            self.plugin.add_item('35827', 'Dokument', self.ikona, "listcontent", folder=True, fanart=self.fanart)
            self.plugin.add_item('35828', 'Fabuła', self.ikona, "listcontent", folder=True, fanart=self.fanart)
            self.plugin.add_item('35829', 'Animacja', self.ikona, "listcontent", folder=True, fanart=self.fanart)
            self.plugin.add_item('35830', 'Kroniki', self.ikona, "listcontent", folder=True, fanart=self.fanart)
        else:
            self.plugin.add_item('receiver:1', 'Nauczyciel', self.ikona, "listcontent", folder=True, fanart=self.fanart)
            self.plugin.add_item('receiver:2', 'Uczeń', self.ikona, "listcontent", folder=True, fanart=self.fanart)
            self.plugin.add_item('receiver:3', 'Student', self.ikona, "listcontent", folder=True, fanart=self.fanart)
        self.plugin.EOD()
            
    def Szukaj(self):
        query = self.plugin.input_dialog('Szukaj: ')
        if query:
            query=query.replace(' ','%20')
            url1 ='https://wfdif.online/vowosadmin/surface/ChildViewSurface/GetPage/?p={}&parentNodeId=1192&filter='+query+'&sort=ds&t=3&e=&k=&All=false'
            self.ListContent(url1)
    def ListContent(self,url):
        self.kuk={}
        if 'receiver' in url:
            dod = url.split(':')[-1]
            self.kuk = {}
            self.kuk = {'receiver': dod, 'Welcome':'true'}
            hdrs = {
                'Host': 'wfdif.online',

                'user-agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:98.0) Gecko/20100101 Firefox/98.0',
                'accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,*/*;q=0.8',
                'accept-language': 'pl,en-US;q=0.7,en;q=0.3',
                'dnt': '1',
                'referer': 'https://wfdif.online/',
                'upgrade-insecure-requests': '1',
                'sec-fetch-dest': 'document',
                'sec-fetch-mode': 'navigate',
                'sec-fetch-site': 'same-origin',
                'sec-fetch-user': '?1',

            }

            urlk = 'https://wfdif.online/vowosadmin/surface/ChildViewSurface/GetPage/?p=1&parentNodeId=43405&filter=&sort=ds&t=0&e=&k=&All=true'
            urlk2 = 'https://wfdif.online/vowosadmin/surface/ChildViewSurface/GetPage/?p=2&parentNodeId=43405&filter=&sort=ds&t=0&e=&k=&All=true'#&_=1648630228308'

            html = self.request_sess(urlk, 'get', headers=hdrs)
            html += self.request_sess(urlk2, 'get', headers=hdrs)

        elif 'vowosadmin' in url:
            urlk = url.format('1')
            urlk2 = url.format('2')
            html = self.request_sess(urlk, 'get', headers=self.headers)
            html += self.request_sess(urlk2, 'get', headers=self.headers)
        else:

            urlk='https://wfdif.online/vowosadmin/surface/ChildViewSurface/GetPage/?p=1&parentNodeId='+url+'&filter=&sort=ds&t=0&e=&k=&All=false'
            urlk2='https://wfdif.online/vowosadmin/surface/ChildViewSurface/GetPage/?p=2&parentNodeId='+url+'&filter=&sort=ds&t=0&e=&k=&All=false'
            html = self.request_sess(urlk, 'get', headers=self.headers)
            html += self.request_sess(urlk2, 'get', headers=self.headers)

        ids = [(a.start(), a.end()) for a in re.finditer('<li style="background', html)]
        ids.append( (-1,-1) )
        out=[]
        byl = False
        for i in range(len(ids[:-1])):
            result = html[ ids[i][1]:ids[i+1][0] ]

            poster = re.findall("url\('(.*?)\?",result,re.DOTALL)
            if poster:
                try:
                    poster = 'https://wfdif.online'+quote(poster[0])
                except:
                    poster = 'https://wfdif.online'+poster[0]
            else:
                poster = ikona

            href = re.findall('ovlay-play" href="([^"]+)',result,re.DOTALL)
            
            href = href[0] if href else 'nic'
            name = re.findall('data\-title="([^"]+)',result,re.DOTALL)
            name = name[0] if name else 'nic'
            opisy = re.findall('<div class="(?:title|desc|title-top)" title="([^"]+)',result,re.DOTALL+re.I)
            director = ''
            genre = ''
            country = 'Polska'
            year = '1'
            duration =int('0')
            for op in opisy:
                try:
                    if 'seria' in op:
                        director  = re.findall('\:\s+(.*?)$',op,re.DOTALL)[0]
                    else:
                        cd = re.findall('(\\bmin\\b)',op,re.DOTALL)
                        if cd and '/' in op:
                            sp = op.split('/')
                            country = sp[0]
                            year = sp[1].strip(' ')
                            year = year if year else '0'
                            duration = int(re.findall('(\d+)',op, re.DOTALL)[-1])*60
                        else:
                            if op!=name:
                                genre = op.lower()
                except:
                    pass

            plot = re.findall('data-lead="(.+?)">',result,re.DOTALL)
            plot = plot[0] if plot else 'nic'
            self.plugin.add_item(name=self.plugin.PLchar(name), url=self.plugin.PLchar(href), mode='playvid', image=self.plugin.PLchar(poster), folder=False, IsPlayable=True, fanart = self.fanart, infoLabels={'plot':self.plugin.PLchar(plot), 'year':year, 'genre':self.plugin.PLchar(genre), 'director':self.plugin.PLchar(director), 'duration':duration})
            byl = True

        if byl:
            self.plugin.setContent('videos')
            self.plugin.EOD()
        else:
            self.plugin.notification_dialog('[B]Uwaga[/B]', '[B]Brak wyników do wyświetlenia[/B]', xbmcgui.NOTIFICATION_INFO, 8000, False)

    def request_sess(self, url, method='get', headers={}, data='', cookies={}, result=True, json=False, allow=True , multipart = False):
        if method == 'get':
            resp = self.sess.get(url, headers=headers, cookies=cookies, timeout=15, verify=False, allow_redirects=allow)
        elif method == 'post':
            if multipart:
                resp = self.sess.post(url, headers=headers, files=data, cookies=cookies, timeout=15, verify=False, allow_redirects=allow)
            else:
                resp = self.sess.post(url, headers=headers, data=data, cookies=cookies, timeout=15, verify=False, allow_redirects=allow)
        elif method == 'delete':
            resp = self.sess.delete(url, headers=headers, cookies=cookies, timeout=15, verify=False, allow_redirects=allow)
        if result:
            return resp.json() if json else resp_text(resp)
        else:
            return resp

    def logowanie(self):

        if self.login and self.password:
            if self.kukis and 'yourAuthCookie' in self.kukis:
                # check if loged - try to get profile (small page)
                html = self.request_sess('https://wfdif.online/users/profile/', 'get', headers=self.headers)
                if 'ASP.NET_SessionId' in self.kukis:
                    del (self.kukis)['ASP.NET_SessionId']
                    self.plugin.save_file(file=self.datapath+'kukis', data=self.kukis, isJSON=True)

                if 'Wyloguj' in html:
                    return self.login

            url = 'https://wfdif.online/users/login/?returnurl=https://wfdif.online/'
            html = self.request_sess(url, 'get', headers=self.headers)
            upfrt = re.findall("input name='.*?'\s*type='hidden'\s*value='([^']+)",html,re.DOTALL)
            if upfrt:
                
                
                multipart_form_data = {
                    'username': self.login, 'password':self.password, 'CurrentPage':'/users/login/?returnurl=https://wfdif.online/', 'ufprt': upfrt[0]
                }        
                html = self.request_sess('https://wfdif.online/users/login/?returnurl=https://wfdif.online/', 'post', headers=self.headers, data=multipart_form_data)

                if 'yourAuthCookie' in self.sess.cookies.get_dict():
                    if 'ASP.NET_SessionId' in self.sess.cookies.get_dict():
                        del (self.sess.cookies.get_dict())['ASP.NET_SessionId']
                    self.plugin.save_file(file=self.datapath+'kukis', data=self.sess.cookies.get_dict(), isJSON=True)
                    return self.login

            self.plugin.notification_dialog('[B]Uwaga[/B]', '[B]Błąd logowania[/B]', xbmcgui.NOTIFICATION_INFO, 8000, False)
        else:
            self.plugin.notification_dialog('[B]Uwaga[/B]', '[B]Brak danych logowania[/B]', xbmcgui.NOTIFICATION_INFO, 8000, False)


    def PlayVid(self, url):
        url = 'https://wfdif.online'+url if url.startswith('/') else url
        html = self.request_sess(url, 'get', headers=self.headers, cookies=self.kukis)

        html = html.replace("\'",'"')

        dash = re.findall('dash\:\s*"([^"]+)"', html,re.DOTALL)
        if dash:
            dash = dash[0]
            dash = 'https:'+dash if dash.startswith('//') else dash
            widevine = re.findall('widevine\:\s*"([^"]+)"', html,re.DOTALL)[0]

            if widevine:
                lic_url = widevine+'|Content-Type=|R{SSM}|'
                drm = 'com.widevine.alpha'
                protocol = 'mpd'


            self.plugin.PlayVid(dash, lic_url=lic_url, PROTOCOL=protocol, DRM=drm)
        else:
            self.plugin.notification_dialog('[B]Uwaga[/B]', '[B]Nie można ostworzyć tego materiału[/B]', xbmcgui.NOTIFICATION_INFO, 8000, False)
