/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.wholeprograminference;

import annotations.el.AClass;
import annotations.el.AField;
import annotations.el.AMethod;
import annotations.util.JVMNames;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.common.wholeprograminference.WholeProgramInference;
import org.checkerframework.common.wholeprograminference.WholeProgramInferenceScenesHelper;
import org.checkerframework.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.dataflow.cfg.node.ImplicitThisLiteralNode;
import org.checkerframework.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.ObjectCreationNode;
import org.checkerframework.dataflow.cfg.node.ReturnNode;
import org.checkerframework.framework.qual.IgnoreInWholeProgramInference;
import org.checkerframework.framework.qual.TypeUseLocation;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.InternalUtils;

public class WholeProgramInferenceScenes
implements WholeProgramInference {
    private final WholeProgramInferenceScenesHelper helper;

    public WholeProgramInferenceScenes(boolean ignoreNullAssignments) {
        this.helper = new WholeProgramInferenceScenesHelper(ignoreNullAssignments);
    }

    @Override
    public void updateInferredConstructorParameterTypes(ObjectCreationNode objectCreationNode, ExecutableElement constructorElt, AnnotatedTypeFactory atf) {
        Symbol.ClassSymbol classSymbol = this.getEnclosingClassSymbol(objectCreationNode.getTree());
        if (classSymbol == null) {
            return;
        }
        String className = classSymbol.flatname.toString();
        String jaifPath = this.helper.getJaifPath(className);
        AClass clazz = this.helper.getAClass(className, jaifPath);
        String methodName = JVMNames.getJVMMethodName((ExecutableElement)constructorElt);
        AMethod method = (AMethod)clazz.methods.vivify((Object)methodName);
        List<Node> arguments = objectCreationNode.getArguments();
        this.updateInferredExecutableParameterTypes(constructorElt, atf, jaifPath, method, arguments);
    }

    @Override
    public void updateInferredMethodParameterTypes(MethodTree methodTree, ExecutableElement methodElt, AnnotatedTypeMirror.AnnotatedExecutableType overriddenMethod, AnnotatedTypeFactory atf) {
        Symbol.ClassSymbol classSymbol = this.getEnclosingClassSymbol(methodTree);
        String className = classSymbol.flatname.toString();
        String jaifPath = this.helper.getJaifPath(className);
        AClass clazz = this.helper.getAClass(className, jaifPath);
        String methodName = JVMNames.getJVMMethodName((ExecutableElement)methodElt);
        AMethod method = (AMethod)clazz.methods.vivify((Object)methodName);
        for (int i = 0; i < overriddenMethod.getParameterTypes().size(); ++i) {
            VariableElement ve = methodElt.getParameters().get(i);
            AnnotatedTypeMirror paramATM = atf.getAnnotatedType(ve);
            AnnotatedTypeMirror argATM = overriddenMethod.getParameterTypes().get(i);
            AField param = (AField)method.parameters.vivify((Object)i);
            this.helper.updateAnnotationSetInScene(param.type, atf, jaifPath, argATM, paramATM, TypeUseLocation.PARAMETER);
        }
    }

    @Override
    public void updateInferredMethodParameterTypes(MethodInvocationNode methodInvNode, Tree receiverTree, ExecutableElement methodElt, AnnotatedTypeFactory atf) {
        if (receiverTree == null) {
            return;
        }
        Symbol.ClassSymbol classSymbol = this.getEnclosingClassSymbol(receiverTree);
        if (classSymbol == null) {
            return;
        }
        if (!classSymbol.getEnclosedElements().contains(methodElt)) {
            return;
        }
        String className = classSymbol.flatname.toString();
        String jaifPath = this.helper.getJaifPath(className);
        AClass clazz = this.helper.getAClass(className, jaifPath);
        String methodName = JVMNames.getJVMMethodName((ExecutableElement)methodElt);
        AMethod method = (AMethod)clazz.methods.vivify((Object)methodName);
        List<Node> arguments = methodInvNode.getArguments();
        this.updateInferredExecutableParameterTypes(methodElt, atf, jaifPath, method, arguments);
    }

    private void updateInferredExecutableParameterTypes(ExecutableElement methodElt, AnnotatedTypeFactory atf, String jaifPath, AMethod method, List<Node> arguments) {
        for (int i = 0; i < arguments.size(); ++i) {
            VariableElement ve = methodElt.getParameters().get(i);
            AnnotatedTypeMirror paramATM = atf.getAnnotatedType(ve);
            Node arg = arguments.get(i);
            Tree treeNode = arg.getTree();
            if (treeNode == null) continue;
            AnnotatedTypeMirror argATM = atf.getAnnotatedType(treeNode);
            AField param = (AField)method.parameters.vivify((Object)i);
            this.helper.updateAnnotationSetInScene(param.type, atf, jaifPath, argATM, paramATM, TypeUseLocation.PARAMETER);
        }
    }

    @Override
    public void updateInferredParameterType(LocalVariableNode lhs, Node rhs, ClassTree classTree, MethodTree methodTree, AnnotatedTypeFactory atf) {
        Symbol.ClassSymbol classSymbol = this.getEnclosingClassSymbol(classTree, lhs);
        if (classSymbol == null) {
            return;
        }
        String className = classSymbol.flatname.toString();
        String jaifPath = this.helper.getJaifPath(className);
        AClass clazz = this.helper.getAClass(className, jaifPath);
        String methodName = JVMNames.getJVMMethodName((MethodTree)methodTree);
        AMethod method = (AMethod)clazz.methods.vivify((Object)methodName);
        List<? extends VariableTree> params = methodTree.getParameters();
        for (int i = 0; i < params.size(); ++i) {
            Tree treeNode;
            VariableTree vt = params.get(i);
            if (!vt.getName().toString().equals(lhs.getName()) || (treeNode = rhs.getTree()) == null) continue;
            AnnotatedTypeMirror paramATM = atf.getAnnotatedType(vt);
            AnnotatedTypeMirror argATM = atf.getAnnotatedType(treeNode);
            AField param = (AField)method.parameters.vivify((Object)i);
            this.helper.updateAnnotationSetInScene(param.type, atf, jaifPath, argATM, paramATM, TypeUseLocation.PARAMETER);
            break;
        }
    }

    @Override
    public void updateInferredMethodReceiverType(MethodTree methodTree, ExecutableElement methodElt, AnnotatedTypeMirror.AnnotatedExecutableType overriddenMethod, AnnotatedTypeFactory atf) {
        AnnotatedTypeMirror.AnnotatedDeclaredType paramATM;
        Symbol.ClassSymbol classSymbol = this.getEnclosingClassSymbol(methodTree);
        String className = classSymbol.flatname.toString();
        String jaifPath = this.helper.getJaifPath(className);
        AClass clazz = this.helper.getAClass(className, jaifPath);
        String methodName = JVMNames.getJVMMethodName((ExecutableElement)methodElt);
        AMethod method = (AMethod)clazz.methods.vivify((Object)methodName);
        AnnotatedTypeMirror.AnnotatedDeclaredType argADT = overriddenMethod.getReceiverType();
        if (argADT != null && (paramATM = atf.getAnnotatedType(methodTree).getReceiverType()) != null) {
            AField receiver = method.receiver;
            this.helper.updateAnnotationSetInScene(receiver.type, atf, jaifPath, argADT, paramATM, TypeUseLocation.RECEIVER);
        }
    }

    @Override
    public void updateInferredFieldType(FieldAccessNode lhs, Node rhs, ClassTree classTree, AnnotatedTypeFactory atf) {
        Symbol.ClassSymbol classSymbol = this.getEnclosingClassSymbol(classTree, lhs);
        if (classSymbol == null) {
            return;
        }
        if (!classSymbol.getEnclosedElements().contains(lhs.getElement())) {
            return;
        }
        for (AnnotationMirror declAnno : atf.getDeclAnnotations(InternalUtils.symbol(lhs.getTree()))) {
            Element elt = declAnno.getAnnotationType().asElement();
            if (elt.getAnnotation(IgnoreInWholeProgramInference.class) == null) continue;
            return;
        }
        String className = classSymbol.flatname.toString();
        String jaifPath = this.helper.getJaifPath(className);
        AClass clazz = this.helper.getAClass(className, jaifPath);
        AField field = (AField)clazz.fields.vivify((Object)lhs.getFieldName());
        AnnotatedTypeMirror lhsATM = atf.getAnnotatedType(lhs.getTree());
        AnnotatedTypeMirror rhsATM = atf.getAnnotatedType(rhs.getTree());
        this.helper.updateAnnotationSetInScene(field.type, atf, jaifPath, rhsATM, lhsATM, TypeUseLocation.FIELD);
    }

    @Override
    public void updateInferredMethodReturnType(ReturnNode retNode, Symbol.ClassSymbol classSymbol, MethodTree methodTree, AnnotatedTypeFactory atf) {
        if (classSymbol == null) {
            return;
        }
        String className = classSymbol.flatname.toString();
        String jaifPath = this.helper.getJaifPath(className);
        AClass clazz = this.helper.getAClass(className, jaifPath);
        AMethod method = (AMethod)clazz.methods.vivify((Object)JVMNames.getJVMMethodName((MethodTree)methodTree));
        AnnotatedTypeMirror lhsATM = atf.getAnnotatedType(methodTree).getReturnType();
        AnnotatedTypeMirror rhsATM = atf.getAnnotatedType(retNode.getTree().getExpression());
        this.helper.updateAnnotationSetInScene(method.returnType, atf, jaifPath, rhsATM, lhsATM, TypeUseLocation.RETURN);
    }

    @Override
    public void saveResults() {
        this.helper.writeScenesToJaif();
    }

    private Symbol.ClassSymbol getEnclosingClassSymbol(ClassTree classTree, Node field) {
        Node receiverNode = null;
        if (field instanceof FieldAccessNode) {
            receiverNode = ((FieldAccessNode)field).getReceiver();
        } else if (field instanceof LocalVariableNode) {
            receiverNode = ((LocalVariableNode)field).getReceiver();
        } else {
            ErrorReporter.errorAbort("Unexpected type: " + field.getClass());
        }
        if ((receiverNode == null || receiverNode instanceof ImplicitThisLiteralNode) && classTree != null) {
            return (Symbol.ClassSymbol)InternalUtils.symbol(classTree);
        }
        TypeMirror type = receiverNode.getType();
        if (type instanceof Type.ClassType) {
            Element tsym = ((Type.ClassType)type).asElement();
            return ((Symbol)tsym).enclClass();
        }
        return this.getEnclosingClassSymbol(receiverNode.getTree());
    }

    private Symbol.ClassSymbol getEnclosingClassSymbol(Tree tree) {
        Element symbol = InternalUtils.symbol(tree);
        if (symbol instanceof Symbol.ClassSymbol) {
            return (Symbol.ClassSymbol)symbol;
        }
        if (symbol instanceof Symbol.VarSymbol) {
            return ((Type)((Symbol.VarSymbol)symbol).asType()).asElement().enclClass();
        }
        if (symbol instanceof Symbol.MethodSymbol) {
            return ((Symbol.MethodSymbol)symbol).enclClass();
        }
        return null;
    }
}

