/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.flow.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Types;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.TypeHierarchy;
import org.checkerframework.framework.type.visitor.AnnotatedTypeMerger;
import org.checkerframework.framework.util.AnnotatedTypes;

public class LubTypeVariableAnnotator {
    public static List<AnnotatedTypeMirror.AnnotatedTypeVariable> getSubtypesAsTypevars(AnnotatedTypeMirror.AnnotatedTypeVariable lub, List<? extends AnnotatedTypeMirror> subtypes) {
        ArrayList<AnnotatedTypeMirror.AnnotatedTypeVariable> typeVars = new ArrayList<AnnotatedTypeMirror.AnnotatedTypeVariable>();
        for (AnnotatedTypeMirror annotatedTypeMirror : subtypes) {
            AnnotatedTypeMirror.AnnotatedTypeVariable typeVar;
            if (annotatedTypeMirror.getKind() == TypeKind.TYPEVAR) {
                typeVar = (AnnotatedTypeMirror.AnnotatedTypeVariable)annotatedTypeMirror;
            } else if (annotatedTypeMirror.getKind() == TypeKind.NULL) {
                typeVar = lub.deepCopy();
                typeVar.replaceAnnotations(annotatedTypeMirror.getAnnotations());
            } else {
                return null;
            }
            typeVars.add(typeVar);
        }
        return typeVars;
    }

    public static void annotateTypeVarAsLub(AnnotatedTypeMirror.AnnotatedTypeVariable lub, List<AnnotatedTypeMirror.AnnotatedTypeVariable> subtypes, AnnotatedTypeFactory typeFactory) {
        Types types = typeFactory.getProcessingEnv().getTypeUtils();
        QualifierHierarchy qualHierarchy = typeFactory.getQualifierHierarchy();
        Iterator<AnnotatedTypeMirror.AnnotatedTypeVariable> subtypesIter = subtypes.iterator();
        AnnotatedTypeMirror.AnnotatedTypeVariable headSubtype = subtypesIter.next();
        LubTypeVariableAnnotator.annotateEmptyLub(lub, headSubtype, qualHierarchy, types);
        while (subtypesIter.hasNext()) {
            LubTypeVariableAnnotator.annotateLub(lub, subtypesIter.next(), typeFactory, qualHierarchy, types);
        }
    }

    private static void annotateEmptyLub(AnnotatedTypeMirror.AnnotatedTypeVariable lub, AnnotatedTypeMirror.AnnotatedTypeVariable headSubtype, QualifierHierarchy qualHierarchy, Types types) {
        for (AnnotationMirror annotationMirror : qualHierarchy.getTopAnnotations()) {
            AnnotatedTypeMirror.AnnotatedTypeVariable src = LubTypeVariableAnnotator.asLubType(headSubtype, lub, annotationMirror, types);
            AnnotatedTypeMerger.merge(src, lub);
        }
    }

    private static void annotateLub(AnnotatedTypeMirror.AnnotatedTypeVariable lub, AnnotatedTypeMirror.AnnotatedTypeVariable subtype, AnnotatedTypeFactory typeFactory, QualifierHierarchy qualHierarchy, Types types) {
        for (AnnotationMirror annotationMirror : qualHierarchy.getTopAnnotations()) {
            AnnotatedTypeMirror.AnnotatedTypeVariable subAsLub = LubTypeVariableAnnotator.asLubType(subtype, lub, annotationMirror, types);
            AnnotationMirror lubPrimary = lub.getAnnotationInHierarchy(annotationMirror);
            AnnotationMirror subPrimary = subtype.getAnnotationInHierarchy(annotationMirror);
            if (lubPrimary == null && subPrimary == null) continue;
            if (lubPrimary != null && subPrimary != null) {
                lub.replaceAnnotation(qualHierarchy.leastUpperBound(lubPrimary, subPrimary));
                continue;
            }
            TypeHierarchy typeHierarchy = typeFactory.getTypeHierarchy();
            if (typeHierarchy.isSubtype(subAsLub, lub, annotationMirror)) continue;
            if (typeHierarchy.isSubtype(lub, subAsLub, annotationMirror)) {
                if (lubPrimary != null) {
                    lub.removeAnnotation(lubPrimary);
                    lub.getUpperBound().replaceAnnotation(subAsLub.getUpperBound().getAnnotationInHierarchy(annotationMirror));
                    lub.getLowerBound().replaceAnnotation(subAsLub.getLowerBound().getAnnotationInHierarchy(annotationMirror));
                    continue;
                }
                lub.replaceAnnotation(subPrimary);
                continue;
            }
            AnnotationMirror lubAnno = lubPrimary != null ? lubPrimary : AnnotatedTypes.findEffectiveAnnotationInHierarchy(qualHierarchy, lub, annotationMirror);
            AnnotationMirror subAnno = subPrimary != null ? subPrimary : AnnotatedTypes.findEffectiveAnnotationInHierarchy(qualHierarchy, subAsLub, annotationMirror);
            lub.replaceAnnotation(qualHierarchy.leastUpperBound(lubAnno, subAnno));
        }
    }

    private static AnnotatedTypeMirror.AnnotatedTypeVariable asLubType(AnnotatedTypeMirror.AnnotatedTypeVariable type, AnnotatedTypeMirror.AnnotatedTypeVariable lub, AnnotationMirror top, Types types) {
        AnnotatedTypeMirror typeUpperBound = type;
        AnnotationMirror anno = typeUpperBound.getAnnotationInHierarchy(top);
        while (typeUpperBound.getKind() == TypeKind.TYPEVAR && !AnnotatedTypes.haveSameDeclaration(types, (AnnotatedTypeMirror.AnnotatedTypeVariable)typeUpperBound, lub)) {
            typeUpperBound = ((AnnotatedTypeMirror.AnnotatedTypeVariable)typeUpperBound).getUpperBound();
            if (anno != null) continue;
            anno = typeUpperBound.getAnnotationInHierarchy(top);
        }
        if (typeUpperBound.getKind() != TypeKind.TYPEVAR) {
            return type;
        }
        if (anno != null) {
            typeUpperBound = typeUpperBound.deepCopy();
            typeUpperBound.addAnnotation(anno);
        }
        return typeUpperBound;
    }
}

