/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.stub;

import annotations.Annotation;
import annotations.Annotations;
import annotations.el.ABlock;
import annotations.el.AClass;
import annotations.el.ADeclaration;
import annotations.el.AElement;
import annotations.el.AExpression;
import annotations.el.AField;
import annotations.el.AMethod;
import annotations.el.AScene;
import annotations.el.ATypeElement;
import annotations.el.ATypeElementWithType;
import annotations.el.AnnotationDef;
import annotations.el.DefException;
import annotations.el.ElementVisitor;
import annotations.field.ArrayAFT;
import annotations.field.BasicAFT;
import annotations.field.ScalarAFT;
import annotations.io.IndexFileParser;
import annotations.io.IndexFileWriter;
import annotations.io.ParseException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.checkerframework.framework.qual.AnnotatedFor;

public class AddAnnotatedFor {
    private static AnnotationDef adAnnotatedFor;
    private static ElementVisitor<Void, Set<String>> annotatedForVisitor;

    public static void main(String[] args) throws IOException, DefException, ParseException {
        AScene scene = new AScene();
        InputStreamReader r = args.length > 0 ? new FileReader(args[0]) : new InputStreamReader(System.in);
        IndexFileParser.parse((LineNumberReader)new LineNumberReader(r), (AScene)scene);
        scene.prune();
        AddAnnotatedFor.addAnnotatedFor(scene);
        IndexFileWriter.write((AScene)scene, (Writer)new PrintWriter(System.out, true));
    }

    public static void addAnnotatedFor(AScene scene) {
        for (AClass clazz : new HashSet(scene.classes.values())) {
            HashSet annotatedFor = new HashSet();
            clazz.accept(annotatedForVisitor, annotatedFor);
            if (annotatedFor.isEmpty()) continue;
            ArrayList annotatedForList = new ArrayList(annotatedFor);
            clazz.tlAnnotationsHere.add(new Annotation(adAnnotatedFor, Annotations.valueFieldOnly(annotatedForList)));
        }
    }

    static {
        Class<AnnotatedFor> annotatedFor = AnnotatedFor.class;
        HashSet<Annotation> annotatedForMetaAnnotations = new HashSet<Annotation>();
        annotatedForMetaAnnotations.add(Annotations.aRetentionSource);
        annotatedForMetaAnnotations.add(Annotations.createValueAnnotation((AnnotationDef)Annotations.adTarget, Arrays.asList("TYPE", "METHOD", "CONSTRUCTOR", "PACKAGE")));
        adAnnotatedFor = new AnnotationDef(annotatedFor.getCanonicalName(), annotatedForMetaAnnotations, Collections.singletonMap("value", new ArrayAFT((ScalarAFT)BasicAFT.forType(String.class))));
        annotatedForVisitor = new ElementVisitor<Void, Set<String>>(){

            public Void visitAnnotationDef(AnnotationDef el, Set<String> annotatedFor) {
                return null;
            }

            public Void visitBlock(ABlock el, Set<String> annotatedFor) {
                for (AField e : el.locals.values()) {
                    e.accept((ElementVisitor)this, annotatedFor);
                }
                return this.visitExpression((AExpression)el, annotatedFor);
            }

            public Void visitClass(AClass el, Set<String> annotatedFor) {
                for (ATypeElement e : el.bounds.values()) {
                    e.accept((ElementVisitor)this, annotatedFor);
                }
                for (ATypeElement e : el.extendsImplements.values()) {
                    e.accept((ElementVisitor)this, annotatedFor);
                }
                for (ATypeElement e : el.fieldInits.values()) {
                    e.accept((ElementVisitor)this, annotatedFor);
                }
                for (ATypeElement e : el.fields.values()) {
                    e.accept((ElementVisitor)this, annotatedFor);
                }
                for (ATypeElement e : el.instanceInits.values()) {
                    e.accept((ElementVisitor)this, annotatedFor);
                }
                for (ATypeElement e : el.methods.values()) {
                    e.accept((ElementVisitor)this, annotatedFor);
                }
                for (ATypeElement e : el.staticInits.values()) {
                    e.accept((ElementVisitor)this, annotatedFor);
                }
                return this.visitDeclaration((ADeclaration)el, annotatedFor);
            }

            public Void visitDeclaration(ADeclaration el, Set<String> annotatedFor) {
                for (ATypeElement e : el.insertAnnotations.values()) {
                    e.accept((ElementVisitor)this, annotatedFor);
                }
                for (ATypeElement e : el.insertTypecasts.values()) {
                    e.accept((ElementVisitor)this, annotatedFor);
                }
                return this.visitElement((AElement)el, annotatedFor);
            }

            public Void visitExpression(AExpression el, Set<String> annotatedFor) {
                for (ATypeElement e : el.calls.values()) {
                    e.accept((ElementVisitor)this, annotatedFor);
                }
                for (ATypeElement e : el.funs.values()) {
                    e.accept((ElementVisitor)this, annotatedFor);
                }
                for (ATypeElement e : el.instanceofs.values()) {
                    e.accept((ElementVisitor)this, annotatedFor);
                }
                for (ATypeElement e : el.news.values()) {
                    e.accept((ElementVisitor)this, annotatedFor);
                }
                for (ATypeElement e : el.refs.values()) {
                    e.accept((ElementVisitor)this, annotatedFor);
                }
                for (ATypeElement e : el.typecasts.values()) {
                    e.accept((ElementVisitor)this, annotatedFor);
                }
                return this.visitElement((AElement)el, annotatedFor);
            }

            public Void visitField(AField el, Set<String> annotatedFor) {
                if (el.init != null) {
                    el.init.accept((ElementVisitor)this, annotatedFor);
                }
                return this.visitDeclaration((ADeclaration)el, annotatedFor);
            }

            public Void visitMethod(AMethod el, Set<String> annotatedFor) {
                if (el.body != null) {
                    el.body.accept((ElementVisitor)this, annotatedFor);
                }
                if (el.receiver != null) {
                    el.receiver.accept((ElementVisitor)this, annotatedFor);
                }
                if (el.returnType != null) {
                    el.returnType.accept((ElementVisitor)this, annotatedFor);
                }
                for (ATypeElement e : el.bounds.values()) {
                    e.accept((ElementVisitor)this, annotatedFor);
                }
                for (ATypeElement e : el.parameters.values()) {
                    e.accept((ElementVisitor)this, annotatedFor);
                }
                for (ATypeElement e : el.throwsException.values()) {
                    e.accept((ElementVisitor)this, annotatedFor);
                }
                return this.visitDeclaration((ADeclaration)el, annotatedFor);
            }

            public Void visitTypeElement(ATypeElement el, Set<String> annotatedFor) {
                for (ATypeElement e : el.innerTypes.values()) {
                    e.accept((ElementVisitor)this, annotatedFor);
                }
                return this.visitElement((AElement)el, annotatedFor);
            }

            public Void visitTypeElementWithType(ATypeElementWithType el, Set<String> annotatedFor) {
                return this.visitTypeElement((ATypeElement)el, annotatedFor);
            }

            public Void visitElement(AElement el, Set<String> annotatedFor) {
                for (Annotation a : el.tlAnnotationsHere) {
                    int i;
                    String s = a.def().name;
                    int j = s.indexOf(".qual.");
                    if (j <= 0 || (i = s.lastIndexOf(46, j - 1)) <= 0 || j - i <= 1) continue;
                    annotatedFor.add(s.substring(i + 1, j));
                }
                if (el.type != null) {
                    el.type.accept((ElementVisitor)this, annotatedFor);
                }
                return null;
            }
        };
    }
}

