/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.Target;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.tools.Diagnostic;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.framework.util.AnnotationBuilder;
import org.checkerframework.javacutil.ErrorReporter;

public class AnnotationClassLoader {
    private final BaseTypeChecker checker;
    private final String packageName;
    private final String packageNameWithSlashes;
    private final List<String> fullyQualifiedPackageNameSegments;
    private static final String QUAL_PACKAGE_SUFFIX = ".qual";
    private static final String JAR_SUFFIX = ".jar";
    private static final String CLASS_SUFFIX = ".class";
    private static final String JAVA_SUFFIX = ".java";
    private static final char DOT = '.';
    private static final char SLASH = '/';
    protected final ProcessingEnvironment processingEnv;
    private final URL resourceURL;
    private Set<Class<? extends Annotation>> loadedAnnotations;

    public AnnotationClassLoader(BaseTypeChecker checker) {
        this.checker = checker;
        this.processingEnv = checker.getProcessingEnvironment();
        this.packageName = checker.getClass().getPackage().getName() + QUAL_PACKAGE_SUFFIX;
        this.packageNameWithSlashes = this.packageName.replace('.', '/');
        this.fullyQualifiedPackageNameSegments = new ArrayList<String>();
        this.fullyQualifiedPackageNameSegments.addAll(Arrays.asList(Pattern.compile(Character.toString('.'), 16).split(this.packageName)));
        this.loadedAnnotations = null;
        ClassLoader applicationClassloader = this.getAppClassLoader();
        this.resourceURL = applicationClassloader != null ? applicationClassloader.getResource(this.packageNameWithSlashes) : this.getURLFromClasspaths();
    }

    private final URL getURLFromClasspaths() {
        URL url = null;
        Set<String> paths = this.getClasspaths();
        for (String path : paths) {
            if (path.endsWith(JAR_SUFFIX)) {
                url = this.getJarURL(path);
                if (url == null || !this.containsPackage(url)) continue;
                return url;
            }
            url = this.getDirectoryURL(path);
            if (url == null || !this.containsPackage(url)) continue;
            if (!path.endsWith(Character.toString('/'))) {
                path = path + '/';
            }
            url = this.getDirectoryURL(path + this.packageNameWithSlashes);
            return url;
        }
        return null;
    }

    private final boolean containsPackage(URL url) {
        if (url.getProtocol().equals("jar")) {
            try {
                JarURLConnection connection = (JarURLConnection)url.openConnection();
                JarFile jarFile = connection.getJarFile();
                return this.checkJarForPackage(jarFile);
            }
            catch (IOException connection) {}
        } else if (url.getProtocol().equals("file")) {
            File rootDir = new File(url.getFile());
            return this.checkDirForPackage(rootDir, this.fullyQualifiedPackageNameSegments.iterator());
        }
        return false;
    }

    private final boolean checkJarForPackage(JarFile jar) {
        Enumeration<JarEntry> jarEntries = jar.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry je = jarEntries.nextElement();
            String entryName = je.getName();
            if (!entryName.startsWith(this.packageNameWithSlashes)) continue;
            return true;
        }
        return false;
    }

    private final boolean checkDirForPackage(File currentDir, Iterator<String> pkgNames) {
        if (!pkgNames.hasNext()) {
            return true;
        }
        if (currentDir == null || !currentDir.isDirectory()) {
            return false;
        }
        String currentPackageDirName = pkgNames.next();
        for (File file : currentDir.listFiles()) {
            if (!file.isDirectory() || !file.getName().equals(currentPackageDirName)) continue;
            return this.checkDirForPackage(file, pkgNames);
        }
        return false;
    }

    private final URL getDirectoryURL(String absolutePathToDirectory) {
        URL directoryURL = null;
        try {
            directoryURL = new File(absolutePathToDirectory).toURI().toURL();
        }
        catch (MalformedURLException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Directory URL " + absolutePathToDirectory + " is malformed");
        }
        return directoryURL;
    }

    private final URL getJarURL(String absolutePathToJarFile) {
        URL jarURL = null;
        try {
            jarURL = new URL("jar:file:" + absolutePathToJarFile + "!/");
        }
        catch (MalformedURLException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Jar URL " + absolutePathToJarFile + " is malformed");
        }
        return jarURL;
    }

    private final Set<String> getClasspaths() {
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        paths.addAll(Arrays.asList(System.getProperty("java.ext.dirs").split(":")));
        paths.addAll(Arrays.asList(System.getProperty("java.class.path").split(":")));
        ClassLoader applicationClassloader = this.getAppClassLoader();
        if (applicationClassloader != null) {
            URL[] urls = ((URLClassLoader)applicationClassloader).getURLs();
            for (int i = 0; i < urls.length; ++i) {
                paths.add(urls[i].getFile().toString());
            }
        }
        return Collections.unmodifiableSet(paths);
    }

    private final ClassLoader getAppClassLoader() {
        ClassLoader applicationClassLoader = this.checker.getClass().getClassLoader();
        if (applicationClassLoader == null) {
            applicationClassLoader = ClassLoader.getSystemClassLoader();
        }
        return applicationClassLoader;
    }

    private final void printPaths() {
        String[] bootclassPaths = System.getProperty("sun.boot.class.path").split(":");
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "bootclass path:");
        for (String path : bootclassPaths) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "\t" + path);
        }
        String[] extensionDirs = System.getProperty("java.ext.dirs").split(":");
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "extension dirs:");
        for (String path : extensionDirs) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "\t" + path);
        }
        String[] javaclassPaths = System.getProperty("java.class.path").split(":");
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "java classpaths:");
        for (String path : javaclassPaths) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "\t" + path);
        }
        ClassLoader applicationClassLoader = this.getAppClassLoader();
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "classloader examined paths:");
        if (applicationClassLoader != null) {
            URL[] urls = ((URLClassLoader)applicationClassLoader).getURLs();
            for (int i = 0; i < urls.length; ++i) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "\t" + urls[i].getFile());
            }
        } else {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "classloader unavailable");
        }
    }

    public final Set<Class<? extends Annotation>> getLoadedAnnotationClasses() {
        if (this.loadedAnnotations == null) {
            this.loadedAnnotations = new LinkedHashSet<Class<? extends Annotation>>();
            if (this.resourceURL == null) {
                return this.loadedAnnotations;
            }
            Set<String> annotationNames = null;
            if (this.resourceURL.getProtocol().equals("jar")) {
                try {
                    JarURLConnection connection = (JarURLConnection)this.resourceURL.openConnection();
                    JarFile jarFile = connection.getJarFile();
                    annotationNames = this.getBundledAnnotationNamesFromJar(jarFile);
                }
                catch (IOException e) {
                    ErrorReporter.errorAbort("AnnotatedTypeLoader: cannot open the Jar file " + this.resourceURL.getFile());
                }
            } else if (this.resourceURL.getProtocol().equals("file")) {
                File packageDir = new File(this.resourceURL.getFile());
                annotationNames = this.getAnnotationNamesFromDirectory(this.packageName + '.', this.resourceURL.getFile(), packageDir, CLASS_SUFFIX);
            }
            this.loadedAnnotations.addAll(this.loadAnnotationClasses(annotationNames));
        }
        return this.loadedAnnotations;
    }

    private final Set<String> getBundledAnnotationNamesFromJar(JarFile jar) {
        LinkedHashSet<String> annos = new LinkedHashSet<String>();
        Enumeration<JarEntry> jarEntries = jar.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry je = jarEntries.nextElement();
            if (je.isDirectory() || !je.getName().endsWith(CLASS_SUFFIX)) continue;
            String className = je.getName().substring(0, je.getName().lastIndexOf(46));
            if (!(className = className.replace('/', '.')).startsWith(this.packageName)) continue;
            annos.add(className);
        }
        return annos;
    }

    public final Class<? extends Annotation> loadExternalAnnotationClass(String annoName) {
        try {
            Class<Annotation> annoClass = Class.forName(annoName).asSubclass(Annotation.class);
            return annoClass;
        }
        catch (ClassNotFoundException e) {
            this.checker.userErrorAbort(this.checker.getClass().getSimpleName() + ": could not load class for annotation: " + annoName + "; ensure that your classpath is correct");
        }
        catch (ClassCastException e) {
            this.checker.userErrorAbort(this.checker.getClass().getSimpleName() + ": class " + annoName + " is not an annotation");
        }
        return null;
    }

    public final Set<Class<? extends Annotation>> loadExternalAnnotationClassesFromDirectory(String dirName) {
        File rootDirectory = new File(dirName);
        Set<String> annoNames = this.getAnnotationNamesFromDirectory("", dirName, rootDirectory, JAVA_SUFFIX);
        return this.loadAnnotationClasses(annoNames);
    }

    private final Set<String> getAnnotationNamesFromDirectory(String packageName, String rootDirectory, File currentDirectory, String fileExtension) {
        LinkedHashSet<String> results = new LinkedHashSet<String>();
        File[] directoryContents = currentDirectory.listFiles();
        Arrays.sort(directoryContents, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (File file : directoryContents) {
            if (file.isFile()) {
                String fullFileName = file.getAbsolutePath();
                String fileName = fullFileName.substring(fullFileName.lastIndexOf(File.separator) + 1, fullFileName.length());
                String filePath = fullFileName.substring(0, fullFileName.lastIndexOf(File.separator));
                String qualPackageName = "";
                if (!filePath.equals(rootDirectory)) {
                    qualPackageName = filePath.substring(rootDirectory.length() + 1, filePath.length()).replace('/', '.') + '.';
                }
                String annotationName = fileName;
                if (fileName.lastIndexOf(46) != -1) {
                    annotationName = fileName.substring(0, fileName.lastIndexOf(46));
                }
                String fullyQualifiedAnnoName = packageName + qualPackageName + annotationName;
                if (!fileName.endsWith(fileExtension)) continue;
                results.add(fullyQualifiedAnnoName);
                continue;
            }
            if (!file.isDirectory()) continue;
            results.addAll(this.getAnnotationNamesFromDirectory(packageName, rootDirectory, file, fileExtension));
        }
        return results;
    }

    private final Class<? extends Annotation> loadAnnotationClass(String fullyQualifiedClassName) {
        Class<Annotation> annoClass;
        Class<?> cls = null;
        try {
            cls = Class.forName(fullyQualifiedClassName, true, this.getAppClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (cls != null && cls.isAnnotation() && cls.getAnnotation(Target.class) != null && AnnotatedTypes.hasTypeQualifierElementTypes(cls.getAnnotation(Target.class).value(), cls) && this.isSupportedAnnotationClass(annoClass = cls.asSubclass(Annotation.class))) {
            return annoClass;
        }
        return null;
    }

    private final Set<Class<? extends Annotation>> loadAnnotationClasses(Set<String> fullyQualifiedAnnoNames) {
        LinkedHashSet<Class<? extends Annotation>> loadedClasses = new LinkedHashSet<Class<? extends Annotation>>();
        if (fullyQualifiedAnnoNames != null && !fullyQualifiedAnnoNames.isEmpty()) {
            for (String fullyQualifiedAnnoName : fullyQualifiedAnnoNames) {
                Class<? extends Annotation> annoClass = this.loadAnnotationClass(fullyQualifiedAnnoName);
                if (annoClass == null) continue;
                loadedClasses.add(annoClass);
            }
        }
        return loadedClasses;
    }

    protected boolean isSupportedAnnotationClass(Class<? extends Annotation> annoClass) {
        if (this.getLoadedAnnotationClasses().contains(annoClass)) {
            return true;
        }
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, annoClass);
        AnnotationMirror annoMirroResult = builder.build();
        return annoMirroResult != null;
    }
}

