/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Types;
import org.checkerframework.framework.type.AnnotatedTypeCopier;
import org.checkerframework.framework.type.AnnotatedTypeMirror;

public class TypeVariableSubstitutor {
    public AnnotatedTypeMirror substitute(Map<TypeVariable, AnnotatedTypeMirror> typeParamToArg, AnnotatedTypeMirror typeMirror) {
        return new Visitor(typeParamToArg).visit(typeMirror);
    }

    protected AnnotatedTypeMirror substituteTypeVariable(AnnotatedTypeMirror argument, AnnotatedTypeMirror.AnnotatedTypeVariable use) {
        AnnotatedTypeMirror substitute = argument.shallowCopy(false);
        substitute.addAnnotations(argument.getAnnotationsField());
        if (!use.getAnnotationsField().isEmpty()) {
            substitute.replaceAnnotations(use.getAnnotations());
        }
        return substitute;
    }

    protected class Visitor
    extends AnnotatedTypeCopier {
        private final Map<TypeParameterElement, AnnotatedTypeMirror> elementToArgMap = new HashMap<TypeParameterElement, AnnotatedTypeMirror>();

        public Visitor(Map<TypeVariable, AnnotatedTypeMirror> typeParamToArg) {
            for (Map.Entry<TypeVariable, AnnotatedTypeMirror> paramToArg : typeParamToArg.entrySet()) {
                this.elementToArgMap.put((TypeParameterElement)paramToArg.getKey().asElement(), paramToArg.getValue());
            }
        }

        @Override
        public AnnotatedTypeMirror visitArray(AnnotatedTypeMirror.AnnotatedArrayType original, IdentityHashMap<AnnotatedTypeMirror, AnnotatedTypeMirror> originalToCopy) {
            AnnotatedTypeMirror.AnnotatedArrayType correctedCopy;
            if (originalToCopy.containsKey(original)) {
                return originalToCopy.get(original);
            }
            AnnotatedTypeMirror.AnnotatedArrayType copy = (AnnotatedTypeMirror.AnnotatedArrayType)AnnotatedTypeMirror.createType(original.getUnderlyingType(), original.atypeFactory, original.isDeclaration());
            this.maybeCopyPrimaryAnnotations(original, copy);
            originalToCopy.put(original, copy);
            AnnotatedTypeMirror componentType = this.visit(original.getComponentType(), originalToCopy);
            Types types = componentType.atypeFactory.types;
            if (!types.isSameType(componentType.getUnderlyingType(), copy.getUnderlyingType()) && componentType.getKind() != TypeKind.WILDCARD) {
                ArrayType underlyingType = types.getArrayType(componentType.getUnderlyingType());
                correctedCopy = (AnnotatedTypeMirror.AnnotatedArrayType)AnnotatedTypeMirror.createType(underlyingType, copy.atypeFactory, false);
                correctedCopy.addAnnotations(copy.getAnnotations());
            } else {
                correctedCopy = copy;
            }
            correctedCopy.setComponentType(componentType);
            return correctedCopy;
        }

        @Override
        public AnnotatedTypeMirror visitTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable original, IdentityHashMap<AnnotatedTypeMirror, AnnotatedTypeMirror> originalToCopy) {
            if (this.visitingExecutableTypeParam) {
                this.visitingExecutableTypeParam = false;
                return super.visitTypeVariable(original, originalToCopy);
            }
            Element typeVarElem = original.getUnderlyingType().asElement();
            if (this.elementToArgMap.containsKey(typeVarElem)) {
                AnnotatedTypeMirror argument = this.elementToArgMap.get(typeVarElem);
                return TypeVariableSubstitutor.this.substituteTypeVariable(argument, original);
            }
            return super.visitTypeVariable(original, originalToCopy);
        }
    }
}

