/*
 * Decompiled with CFR 0.152.
 */
package afu.com.trilead.ssh2.crypto;

import afu.com.trilead.ssh2.crypto.digest.HashForSSH2Types;
import java.math.BigInteger;

public class KeyMaterial {
    public byte[] initial_iv_client_to_server;
    public byte[] initial_iv_server_to_client;
    public byte[] enc_key_client_to_server;
    public byte[] enc_key_server_to_client;
    public byte[] integrity_key_client_to_server;
    public byte[] integrity_key_server_to_client;

    private static byte[] calculateKey(HashForSSH2Types sh, BigInteger K2, byte[] H, byte type, byte[] SessionID, int keyLength) {
        byte[] res = new byte[keyLength];
        int dglen = sh.getDigestLength();
        int numRounds = (keyLength + dglen - 1) / dglen;
        byte[][] tmp = new byte[numRounds][];
        sh.reset();
        sh.updateBigInt(K2);
        sh.updateBytes(H);
        sh.updateByte(type);
        sh.updateBytes(SessionID);
        tmp[0] = sh.getDigest();
        int off = 0;
        int produced = Math.min(dglen, keyLength);
        System.arraycopy(tmp[0], 0, res, off, produced);
        keyLength -= produced;
        off += produced;
        for (int i = 1; i < numRounds; ++i) {
            sh.updateBigInt(K2);
            sh.updateBytes(H);
            for (int j = 0; j < i; ++j) {
                sh.updateBytes(tmp[j]);
            }
            tmp[i] = sh.getDigest();
            produced = Math.min(dglen, keyLength);
            System.arraycopy(tmp[i], 0, res, off, produced);
            keyLength -= produced;
            off += produced;
        }
        return res;
    }

    public static KeyMaterial create(String hashType, byte[] H, BigInteger K2, byte[] SessionID, int keyLengthCS, int blockSizeCS, int macLengthCS, int keyLengthSC, int blockSizeSC, int macLengthSC) throws IllegalArgumentException {
        KeyMaterial km3 = new KeyMaterial();
        HashForSSH2Types sh = new HashForSSH2Types(hashType);
        km3.initial_iv_client_to_server = KeyMaterial.calculateKey(sh, K2, H, (byte)65, SessionID, blockSizeCS);
        km3.initial_iv_server_to_client = KeyMaterial.calculateKey(sh, K2, H, (byte)66, SessionID, blockSizeSC);
        km3.enc_key_client_to_server = KeyMaterial.calculateKey(sh, K2, H, (byte)67, SessionID, keyLengthCS);
        km3.enc_key_server_to_client = KeyMaterial.calculateKey(sh, K2, H, (byte)68, SessionID, keyLengthSC);
        km3.integrity_key_client_to_server = KeyMaterial.calculateKey(sh, K2, H, (byte)69, SessionID, macLengthCS);
        km3.integrity_key_server_to_client = KeyMaterial.calculateKey(sh, K2, H, (byte)70, SessionID, macLengthSC);
        return km3;
    }
}

