/*
 * Decompiled with CFR 0.152.
 */
package afu.de.regnis.q.sequence.media;

import afu.de.regnis.q.sequence.core.QSequenceAssert;
import afu.de.regnis.q.sequence.media.QSequenceDiscardingMediaConfusionDetector;
import afu.de.regnis.q.sequence.media.QSequenceIntMedia;

public abstract class QSequenceDiscardingMediaBlock {
    private final QSequenceIntMedia media;
    private final int[] undiscardedSymbols;
    private final int[] undiscardedIndices;
    private int undiscardedSymbolCount;

    protected abstract int[] getAllSymbols(QSequenceIntMedia var1);

    protected QSequenceDiscardingMediaBlock(QSequenceIntMedia media) {
        this.media = media;
        this.undiscardedSymbols = new int[this.getAllSymbols(media).length];
        this.undiscardedIndices = new int[this.getAllSymbols(media).length];
        this.undiscardedSymbolCount = 0;
    }

    public int getUndiscardedSymbolCount() {
        return this.undiscardedSymbolCount;
    }

    public int[] getUndiscardedSymbols() {
        return this.undiscardedSymbols;
    }

    public int getMediaIndex(int index) {
        return this.undiscardedIndices[index];
    }

    public void init(QSequenceDiscardingMediaBlock thatBlock, QSequenceDiscardingMediaConfusionDetector confusionDetector) {
        QSequenceAssert.assertNotNull(confusionDetector);
        int[] thisAllSymbols = this.getAllSymbols(this.media);
        int[] thatAllSymbols = thatBlock.getAllSymbols(this.media);
        int[] otherEquivalences = QSequenceDiscardingMediaBlock.createEquivalences(thatAllSymbols, this.media);
        byte[] discardableMarkers = QSequenceDiscardingMediaBlock.createDiscardableMarkers(thisAllSymbols, otherEquivalences, confusionDetector);
        for (int index = 0; index < thisAllSymbols.length; ++index) {
            if (discardableMarkers[index] == 1) continue;
            this.undiscardedSymbols[this.undiscardedSymbolCount] = thisAllSymbols[index];
            this.undiscardedIndices[this.undiscardedSymbolCount] = index;
            ++this.undiscardedSymbolCount;
        }
    }

    private static int[] createEquivalences(int[] symbols, QSequenceIntMedia media) {
        int[] equivalences = new int[media.getSymbolCount()];
        for (int index = 0; index < symbols.length; ++index) {
            int n = symbols[index];
            equivalences[n] = equivalences[n] + 1;
        }
        return equivalences;
    }

    private static byte[] createDiscardableMarkers(int[] symbols, int[] otherEquivalences, QSequenceDiscardingMediaConfusionDetector confusionDetector) {
        byte[] discardableMarkers = new byte[symbols.length];
        confusionDetector.init(symbols.length);
        for (int index = 0; index < symbols.length; ++index) {
            int occurences = otherEquivalences[symbols[index]];
            if (confusionDetector.isAbsolute(occurences)) {
                discardableMarkers[index] = 1;
                continue;
            }
            if (!confusionDetector.isProvisional(occurences)) continue;
            discardableMarkers[index] = 2;
        }
        return discardableMarkers;
    }
}

