/*
 * Decompiled with CFR 0.152.
 */
package afu.nu.xom;

import afu.nu.xom.Element;
import afu.nu.xom.IllegalNameException;
import afu.nu.xom.NamespaceConflictException;
import afu.nu.xom.Node;
import afu.nu.xom.Verifier;

public final class Namespace
extends Node {
    private final String prefix;
    private final String uri;
    public static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";

    public Namespace(String string, String string2, Element element) {
        if (string == null) {
            string = "";
        } else {
            if ("xmlns".equals(string)) {
                throw new IllegalNameException("The xmlns prefix may not be bound to a URI.");
            }
            if ("xml".equals(string) && !XML_NAMESPACE.equals(string2)) {
                throw new NamespaceConflictException("The prefix xml can only be bound to the URI http://www.w3.org/XML/1998/namespace");
            }
        }
        if (string.length() != 0) {
            Verifier.checkNCName(string);
        }
        if (string2 == null) {
            string2 = "";
        } else if (string2.equals(XML_NAMESPACE) && !"xml".equals(string)) {
            throw new NamespaceConflictException("The URI http://www.w3.org/XML/1998/namespace can only be bound to the prefix xml");
        }
        if (string2.length() == 0) {
            if (string.length() != 0) {
                throw new NamespaceConflictException("Prefixed elements must have namespace URIs.");
            }
        } else {
            Verifier.checkAbsoluteURIReference(string2);
        }
        this.prefix = string;
        this.uri = string2;
        super.setParent(element);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getValue() {
        return this.uri;
    }

    public Node getChild(int n) {
        throw new IndexOutOfBoundsException("Namespaces do not have children");
    }

    public int getChildCount() {
        return 0;
    }

    public Node copy() {
        return new Namespace(this.prefix, this.uri, null);
    }

    public void detach() {
        super.setParent(null);
    }

    public String toXML() {
        String string = this.prefix.equals("") ? "" : ":";
        return "xmlns" + string + this.prefix + "=\"" + this.uri + "\"";
    }

    public String toString() {
        return "[Namespace: " + this.toXML() + "]";
    }
}

