/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.classfile;

import afu.org.apache.commons.bcel6.classfile.Annotations;
import afu.org.apache.commons.bcel6.classfile.Attribute;
import afu.org.apache.commons.bcel6.classfile.ConstantPool;
import afu.org.apache.commons.bcel6.classfile.ConstantUtf8;
import afu.org.apache.commons.bcel6.classfile.ElementValue;
import afu.org.apache.commons.bcel6.classfile.ElementValuePair;
import afu.org.apache.commons.bcel6.classfile.Node;
import afu.org.apache.commons.bcel6.classfile.Visitor;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AnnotationEntry
implements Node {
    private final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int type_index;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool;
    private final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean isRuntimeVisible;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ElementValuePair> element_value_pairs;

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString AnnotationEntry read(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataInput input, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean isRuntimeVisible) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        AnnotationEntry annotationEntry = new AnnotationEntry(input.readUnsignedShort(), constant_pool, isRuntimeVisible);
        int num_element_value_pairs = input.readUnsignedShort();
        annotationEntry.element_value_pairs = new ArrayList<ElementValuePair>();
        for (int i = 0; i < num_element_value_pairs; ++i) {
            annotationEntry.element_value_pairs.add(new ElementValuePair(input.readUnsignedShort(), ElementValue.readElementValue(input, constant_pool), constant_pool));
        }
        return annotationEntry;
    }

    public AnnotationEntry(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int type_index, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean isRuntimeVisible) {
        this.type_index = type_index;
        this.constant_pool = constant_pool;
        this.isRuntimeVisible = isRuntimeVisible;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getTypeIndex() {
        return this.type_index;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean isRuntimeVisible() {
        return this.isRuntimeVisible;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Visitor v) {
        v.visitAnnotationEntry(this);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getAnnotationType() {
        ConstantUtf8 c = (ConstantUtf8)this.constant_pool.getConstant(this.type_index, (byte)1);
        return c.getBytes();
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getAnnotationTypeIndex() {
        return this.type_index;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getNumElementValuePairs() {
        return this.element_value_pairs.size();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ElementValuePair @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getElementValuePairs() {
        return this.element_value_pairs.toArray(new ElementValuePair[this.element_value_pairs.size()]);
    }

    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream dos) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        dos.writeShort(this.type_index);
        dos.writeShort(this.element_value_pairs.size());
        for (ElementValuePair envp : this.element_value_pairs) {
            envp.dump(dos);
        }
    }

    public void addElementNameValuePair(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ElementValuePair elementNameValuePair) {
        this.element_value_pairs.add(elementNameValuePair);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toShortString() {
        StringBuilder result = new StringBuilder();
        result.append("@");
        result.append(this.getAnnotationType());
        ElementValuePair[] evPairs = this.getElementValuePairs();
        if (evPairs.length > 0) {
            result.append("(");
            for (ElementValuePair element : evPairs) {
                result.append(element.toShortString());
            }
            result.append(")");
        }
        return result.toString();
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString() {
        return this.toShortString();
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString AnnotationEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] createAnnotationEntries(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Attribute @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] attrs) {
        ArrayList accumulatedAnnotations = new ArrayList(attrs.length);
        for (Attribute attribute : attrs) {
            if (!(attribute instanceof Annotations)) continue;
            Annotations runtimeAnnotations = (Annotations)attribute;
            Collections.addAll(accumulatedAnnotations, runtimeAnnotations.getAnnotationEntries());
        }
        return accumulatedAnnotations.toArray(new AnnotationEntry[accumulatedAnnotations.size()]);
    }
}

