/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.classfile;

import afu.org.apache.commons.bcel6.classfile.Constant;
import afu.org.apache.commons.bcel6.classfile.ConstantObject;
import afu.org.apache.commons.bcel6.classfile.ConstantPool;
import afu.org.apache.commons.bcel6.classfile.ConstantUtf8;
import afu.org.apache.commons.bcel6.classfile.Visitor;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantClass
extends Constant
implements ConstantObject {
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int name_index;

    public ConstantClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantClass c) {
        this(c.getNameIndex());
    }

    ConstantClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataInput file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        this(file.readUnsignedShort());
    }

    public ConstantClass(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int name_index) {
        super((byte)7);
        this.name_index = name_index;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Visitor v) {
        v.visitConstantClass(this);
    }

    @Override
    public final void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        file.writeByte(super.getTag());
        file.writeShort(this.name_index);
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getNameIndex() {
        return this.name_index;
    }

    public final void setNameIndex(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int name_index) {
        this.name_index = name_index;
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object getConstantValue(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool cp) {
        Constant c = cp.getConstant(this.name_index, (byte)1);
        return ((ConstantUtf8)c).getBytes();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getBytes(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool cp) {
        return (String)this.getConstantValue(cp);
    }

    @Override
    @SideEffectFree
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString() {
        return super.toString() + "(name_index = " + this.name_index + ")";
    }
}

