/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.classfile;

import afu.org.apache.commons.bcel6.classfile.AnnotationElementValue;
import afu.org.apache.commons.bcel6.classfile.AnnotationEntry;
import afu.org.apache.commons.bcel6.classfile.ArrayElementValue;
import afu.org.apache.commons.bcel6.classfile.ClassElementValue;
import afu.org.apache.commons.bcel6.classfile.ConstantPool;
import afu.org.apache.commons.bcel6.classfile.EnumElementValue;
import afu.org.apache.commons.bcel6.classfile.SimpleElementValue;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class ElementValue {
    @Deprecated
    protected @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int type;
    @Deprecated
    protected @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool cpool;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte STRING = 115;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte ENUM_CONSTANT = 101;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte CLASS = 99;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte ANNOTATION = 64;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte ARRAY = 91;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte PRIMITIVE_INT = 73;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte PRIMITIVE_BYTE = 66;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte PRIMITIVE_CHAR = 67;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte PRIMITIVE_DOUBLE = 68;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte PRIMITIVE_FLOAT = 70;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte PRIMITIVE_LONG = 74;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte PRIMITIVE_SHORT = 83;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte PRIMITIVE_BOOLEAN = 90;

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString() {
        return this.stringifyValue();
    }

    protected ElementValue(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int type, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool cpool) {
        this.type = type;
        this.cpool = cpool;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getElementValueType() {
        return this.type;
    }

    public abstract @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String stringifyValue();

    public abstract void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream var1) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException;

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ElementValue readElementValue(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataInput input, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool cpool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        byte type = input.readByte();
        switch (type) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                return new SimpleElementValue(type, input.readUnsignedShort(), cpool);
            }
            case 101: {
                return new EnumElementValue(101, input.readUnsignedShort(), input.readUnsignedShort(), cpool);
            }
            case 99: {
                return new ClassElementValue(99, input.readUnsignedShort(), cpool);
            }
            case 64: {
                return new AnnotationElementValue(64, AnnotationEntry.read(input, cpool, false), cpool);
            }
            case 91: {
                int numArrayVals = input.readUnsignedShort();
                ElementValue[] evalues = new ElementValue[numArrayVals];
                for (int j = 0; j < numArrayVals; ++j) {
                    evalues[j] = ElementValue.readElementValue(input, cpool);
                }
                return new ArrayElementValue(91, evalues, cpool);
            }
        }
        throw new RuntimeException("Unexpected element value kind in annotation: " + type);
    }

    final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool getConstantPool() {
        return this.cpool;
    }

    final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getType() {
        return this.type;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toShortString() {
        return this.stringifyValue();
    }
}

