/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.classfile;

import afu.org.apache.commons.bcel6.classfile.ConstantPool;
import afu.org.apache.commons.bcel6.classfile.ConstantUtf8;
import afu.org.apache.commons.bcel6.classfile.ElementValue;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import java.io.DataOutputStream;
import java.io.IOException;

public class EnumElementValue
extends ElementValue {
    private final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int typeIdx;
    private final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int valueIdx;

    public EnumElementValue(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int type, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int typeIdx, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int valueIdx, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool cpool) {
        super(type, cpool);
        if (type != 101) {
            throw new RuntimeException("Only element values of type enum can be built with this ctor - type specified: " + type);
        }
        this.typeIdx = typeIdx;
        this.valueIdx = valueIdx;
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream dos) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        dos.writeByte(super.getType());
        dos.writeShort(this.typeIdx);
        dos.writeShort(this.valueIdx);
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String stringifyValue() {
        ConstantUtf8 cu8 = (ConstantUtf8)super.getConstantPool().getConstant(this.valueIdx, (byte)1);
        return cu8.getBytes();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getEnumTypeString() {
        ConstantUtf8 cu8 = (ConstantUtf8)super.getConstantPool().getConstant(this.typeIdx, (byte)1);
        return cu8.getBytes();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getEnumValueString() {
        ConstantUtf8 cu8 = (ConstantUtf8)super.getConstantPool().getConstant(this.valueIdx, (byte)1);
        return cu8.getBytes();
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getValueIndex() {
        return this.valueIdx;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getTypeIndex() {
        return this.typeIdx;
    }
}

