/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.classfile;

import afu.org.apache.commons.bcel6.classfile.Attribute;
import afu.org.apache.commons.bcel6.classfile.ClassFormatException;
import afu.org.apache.commons.bcel6.classfile.ConstantPool;
import afu.org.apache.commons.bcel6.classfile.ConstantValue;
import afu.org.apache.commons.bcel6.classfile.FieldOrMethod;
import afu.org.apache.commons.bcel6.classfile.Utility;
import afu.org.apache.commons.bcel6.classfile.Visitor;
import afu.org.apache.commons.bcel6.generic.Type;
import afu.org.apache.commons.bcel6.util.BCELComparator;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.Pure;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.DataInput;
import java.io.IOException;

public final class Field
extends FieldOrMethod {
    private static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString BCELComparator _cmp = new BCELComparator(){

        @Override
        public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean equals(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object o1, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object o2) {
            Field THIS = (Field)o1;
            Field THAT = (Field)o2;
            return THIS.getName().equals(THAT.getName()) && THIS.getSignature().equals(THAT.getSignature());
        }

        @Override
        public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int hashCode(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object o) {
            Field THIS = (Field)o;
            return THIS.getSignature().hashCode() ^ THIS.getName().hashCode();
        }
    };

    public Field(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Field c) {
        super(c);
    }

    Field(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataInput file, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassFormatException {
        super(file, constant_pool);
    }

    public Field(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int access_flags, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int signature_index, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Attribute @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] attributes, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool) {
        super(access_flags, name_index, signature_index, attributes, constant_pool);
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Visitor v) {
        v.visitField(this);
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantValue getConstantValue() {
        for (Attribute attribute : super.getAttributes()) {
            if (attribute.getTag() != 1) continue;
            return (ConstantValue)attribute;
        }
        return null;
    }

    @SideEffectFree
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString() {
        String access = Utility.accessToString(super.getAccessFlags());
        access = access.equals("") ? "" : access + " ";
        String signature = Utility.signatureToString(this.getSignature());
        String name = this.getName();
        StringBuilder buf = new StringBuilder(64);
        buf.append(access).append(signature).append(" ").append(name);
        ConstantValue cv = this.getConstantValue();
        if (cv != null) {
            buf.append(" = ").append(cv);
        }
        for (Attribute attribute : super.getAttributes()) {
            if (attribute instanceof ConstantValue) continue;
            buf.append(" [").append(attribute).append("]");
        }
        return buf.toString();
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Field copy(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool _constant_pool) {
        return (Field)this.copy_(_constant_pool);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type getType() {
        return Type.getReturnType(this.getSignature());
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString BCELComparator getComparator() {
        return _cmp;
    }

    public static void setComparator(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString BCELComparator comparator) {
        _cmp = comparator;
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean equals(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object obj) {
        return _cmp.equals(this, obj);
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int hashCode() {
        return _cmp.hashCode(this);
    }
}

