/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.classfile;

import afu.org.apache.commons.bcel6.classfile.ConstantPool;
import afu.org.apache.commons.bcel6.classfile.ConstantUtf8;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public class MethodParameter
implements Cloneable {
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int name_index;
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int access_flags;

    public MethodParameter() {
    }

    MethodParameter(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataInput input) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        this.name_index = input.readUnsignedShort();
        this.access_flags = input.readUnsignedShort();
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getNameIndex() {
        return this.name_index;
    }

    public void setNameIndex(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int name_index) {
        this.name_index = name_index;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getParameterName(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool) {
        if (this.name_index == 0) {
            return null;
        }
        return ((ConstantUtf8)constant_pool.getConstant(this.name_index, (byte)1)).getBytes();
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getAccessFlags() {
        return this.access_flags;
    }

    public void setAccessFlags(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int access_flags) {
        this.access_flags = access_flags;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean isFinal() {
        return (this.access_flags & 0x10) != 0;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean isSynthetic() {
        return (this.access_flags & 0x1000) != 0;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean isMandated() {
        return (this.access_flags & Short.MIN_VALUE) != 0;
    }

    public final void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        file.writeShort(this.name_index);
        file.writeShort(this.access_flags);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString MethodParameter copy() {
        try {
            return (MethodParameter)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

