/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.classfile;

import afu.org.apache.commons.bcel6.classfile.Attribute;
import afu.org.apache.commons.bcel6.classfile.ConstantPool;
import afu.org.apache.commons.bcel6.classfile.StackMapEntry;
import afu.org.apache.commons.bcel6.classfile.Visitor;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class StackMap
extends Attribute {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString StackMapEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] map;

    public StackMap(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString StackMapEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] map, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool) {
        super((byte)11, name_index, length, constant_pool);
        this.map = map;
    }

    StackMap(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataInput input, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        this(name_index, length, (StackMapEntry[])null, constant_pool);
        int map_length = input.readUnsignedShort();
        this.map = new StackMapEntry[map_length];
        for (int i = 0; i < map_length; ++i) {
            this.map[i] = new StackMapEntry(input, constant_pool);
        }
    }

    @Override
    public final void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        super.dump(file);
        file.writeShort(this.map.length);
        for (StackMapEntry entry : this.map) {
            entry.dump(file);
        }
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString StackMapEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getStackMap() {
        return this.map;
    }

    public final void setStackMap(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString StackMapEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] map) {
        this.map = map;
        int len = 2;
        for (int i = 0; i < map.length; ++i) {
            len += map[i].getMapEntrySize();
        }
        this.setLength(len);
    }

    @Override
    @SideEffectFree
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString() {
        StringBuilder buf = new StringBuilder("StackMap(");
        for (int i = 0; i < this.map.length; ++i) {
            buf.append(this.map[i]);
            if (i >= this.map.length - 1) continue;
            buf.append(", ");
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Attribute copy(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool _constant_pool) {
        StackMap c = (StackMap)this.clone();
        c.map = new StackMapEntry[this.map.length];
        for (int i = 0; i < this.map.length; ++i) {
            c.map[i] = this.map[i].copy();
        }
        c.setConstantPool(_constant_pool);
        return c;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Visitor v) {
        v.visitStackMap(this);
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getMapLength() {
        return this.map == null ? 0 : this.map.length;
    }
}

