/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.generic;

import afu.org.apache.commons.bcel6.generic.ClassGenException;
import afu.org.apache.commons.bcel6.generic.Instruction;
import afu.org.apache.commons.bcel6.generic.InstructionHandle;
import afu.org.apache.commons.bcel6.generic.InstructionTargeter;
import afu.org.apache.commons.bcel6.util.ByteSequence;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class BranchInstruction
extends Instruction
implements InstructionTargeter {
    @Deprecated
    protected @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int index;
    @Deprecated
    protected @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle target;
    @Deprecated
    protected @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int position;

    BranchInstruction() {
    }

    protected BranchInstruction(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString short opcode, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle target) {
        super(opcode, (short)3);
        this.setTarget(target);
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream out) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        out.writeByte(super.getOpcode());
        this.index = this.getTargetOffset();
        if (!BranchInstruction.isValidShort(this.index)) {
            throw new ClassGenException("Branch target offset too large for short: " + this.index);
        }
        out.writeShort(this.index);
    }

    protected @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getTargetOffset(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle _target) {
        if (_target == null) {
            throw new ClassGenException("Target of " + super.toString(true) + " is invalid null handle");
        }
        int t = _target.getPosition();
        if (t < 0) {
            throw new ClassGenException("Invalid branch target position offset for " + super.toString(true) + ":" + t + ":" + _target);
        }
        return t - this.position;
    }

    protected @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getTargetOffset() {
        return this.getTargetOffset(this.target);
    }

    protected @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int updatePosition(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int offset, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int max_offset) {
        this.position += offset;
        return 0;
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean verbose) {
        String s2 = super.toString(verbose);
        String t = "null";
        if (verbose) {
            if (this.target != null) {
                t = this.target.getInstruction() == this ? "<points to itself>" : (this.target.getInstruction() == null ? "<null instruction!!!?>" : "" + this.target.getPosition());
            }
        } else if (this.target != null) {
            this.index = this.target.getPosition();
            t = "" + this.index;
        }
        return s2 + " -> " + t;
    }

    @Override
    protected void initFromFile(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ByteSequence bytes, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean wide) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        super.setLength(3);
        this.index = bytes.readShort();
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getIndex() {
        return this.index;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle getTarget() {
        return this.target;
    }

    public void setTarget(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle target) {
        BranchInstruction.notifyTarget(this.target, target, this);
        this.target = target;
    }

    static void notifyTarget(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle old_ih, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle new_ih, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionTargeter t) {
        if (old_ih != null) {
            old_ih.removeTargeter(t);
        }
        if (new_ih != null) {
            new_ih.addTargeter(t);
        }
    }

    @Override
    public void updateTarget(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle old_ih, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle new_ih) {
        if (this.target != old_ih) {
            throw new ClassGenException("Not targeting " + old_ih + ", but " + this.target);
        }
        this.setTarget(new_ih);
    }

    @Override
    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean containsTarget(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle ih) {
        return this.target == ih;
    }

    @Override
    void dispose() {
        this.setTarget(null);
        this.index = -1;
        this.position = -1;
    }

    protected @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getPosition() {
        return this.position;
    }

    protected void setPosition(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int position) {
        this.position = position;
    }

    protected void setIndex(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int index) {
        this.index = index;
    }
}

