/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.generic;

import afu.org.apache.commons.bcel6.generic.ClassGenException;
import afu.org.apache.commons.bcel6.generic.ConstantPoolGen;
import afu.org.apache.commons.bcel6.generic.LocalVariableInstruction;
import afu.org.apache.commons.bcel6.generic.Type;
import afu.org.apache.commons.bcel6.generic.Visitor;
import afu.org.apache.commons.bcel6.util.ByteSequence;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import java.io.DataOutputStream;
import java.io.IOException;

public class IINC
extends LocalVariableInstruction {
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean wide;
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int c;

    IINC() {
    }

    public IINC(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int n, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int c) {
        super.setOpcode((short)132);
        super.setLength(3);
        this.setIndex(n);
        this.setIncrement(c);
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream out) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        if (this.wide) {
            out.writeByte(196);
        }
        out.writeByte(super.getOpcode());
        if (this.wide) {
            out.writeShort(super.getIndex());
            out.writeShort(this.c);
        } else {
            out.writeByte(super.getIndex());
            out.writeByte(this.c);
        }
    }

    private void setWide() {
        boolean bl = this.wide = super.getIndex() > 255 || Math.abs(this.c) > 127;
        if (this.wide) {
            super.setLength(6);
        } else {
            super.setLength(3);
        }
    }

    @Override
    protected void initFromFile(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ByteSequence bytes, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean wide) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        this.wide = wide;
        if (wide) {
            super.setLength(6);
            super.setIndexOnly(bytes.readUnsignedShort());
            this.c = bytes.readShort();
        } else {
            super.setLength(3);
            super.setIndexOnly(bytes.readUnsignedByte());
            this.c = bytes.readByte();
        }
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean verbose) {
        return super.toString(verbose) + " " + this.c;
    }

    @Override
    public final void setIndex(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int n) {
        if (n < 0) {
            throw new ClassGenException("Negative index value: " + n);
        }
        super.setIndexOnly(n);
        this.setWide();
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getIncrement() {
        return this.c;
    }

    public final void setIncrement(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int c) {
        this.c = c;
        this.setWide();
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type getType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cp) {
        return Type.INT;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Visitor v) {
        v.visitLocalVariableInstruction(this);
        v.visitIINC(this);
    }
}

