/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.generic;

import afu.org.apache.commons.bcel6.classfile.LocalVariable;
import afu.org.apache.commons.bcel6.generic.BranchInstruction;
import afu.org.apache.commons.bcel6.generic.ClassGenException;
import afu.org.apache.commons.bcel6.generic.ConstantPoolGen;
import afu.org.apache.commons.bcel6.generic.InstructionHandle;
import afu.org.apache.commons.bcel6.generic.InstructionTargeter;
import afu.org.apache.commons.bcel6.generic.NamedAndTyped;
import afu.org.apache.commons.bcel6.generic.Type;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.Pure;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;

public class LocalVariableGen
implements InstructionTargeter,
NamedAndTyped,
Cloneable {
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int index;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String name;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type type;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle start;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle end;

    public LocalVariableGen(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int index, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type type, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle start, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle end) {
        if (index < 0 || index > 65535) {
            throw new ClassGenException("Invalid index index: " + index);
        }
        this.name = name;
        this.type = type;
        this.index = index;
        this.setStart(start);
        this.setEnd(end);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LocalVariable getLocalVariable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cp) {
        int start_pc = 0;
        int length = 0;
        if (this.start != null && this.end != null) {
            start_pc = this.start.getPosition();
            length = this.end.getPosition() - start_pc;
            if (this.end.getNext() == null) {
                length += this.end.getInstruction().getLength();
            }
        }
        int name_index = cp.addUtf8(this.name);
        int signature_index = cp.addUtf8(this.type.getSignature());
        return new LocalVariable(start_pc, length, name_index, signature_index, this.index, cp.getConstantPool());
    }

    public void setIndex(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int index) {
        this.index = index;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getIndex() {
        return this.index;
    }

    @Override
    public void setName(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String name) {
        this.name = name;
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getName() {
        return this.name;
    }

    @Override
    public void setType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type type) {
        this.type = type;
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type getType() {
        return this.type;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle getStart() {
        return this.start;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle getEnd() {
        return this.end;
    }

    public void setStart(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle start) {
        BranchInstruction.notifyTarget(this.start, start, this);
        this.start = start;
    }

    public void setEnd(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle end) {
        BranchInstruction.notifyTarget(this.end, end, this);
        this.end = end;
    }

    @Override
    public void updateTarget(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle old_ih, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle new_ih) {
        boolean targeted = false;
        if (this.start == old_ih) {
            targeted = true;
            this.setStart(new_ih);
        }
        if (this.end == old_ih) {
            targeted = true;
            this.setEnd(new_ih);
        }
        if (!targeted) {
            throw new ClassGenException("Not targeting " + old_ih + ", but {" + this.start + ", " + this.end + "}");
        }
    }

    void dispose() {
        this.setStart(null);
        this.setEnd(null);
    }

    @Override
    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean containsTarget(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle ih) {
        return this.start == ih || this.end == ih;
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int hashCode() {
        return this.name.hashCode() ^ this.type.hashCode();
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean equals(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object o) {
        if (!(o instanceof LocalVariableGen)) {
            return false;
        }
        LocalVariableGen l = (LocalVariableGen)o;
        return l.index == this.index && l.start == this.start && l.end == this.end;
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString() {
        return "LocalVariableGen(" + this.name + ", " + this.type + ", " + this.start + ", " + this.end + ")";
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Clone Not Supported");
        }
    }
}

