/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.generic;

import afu.org.apache.commons.bcel6.generic.BranchInstruction;
import afu.org.apache.commons.bcel6.generic.ClassGenException;
import afu.org.apache.commons.bcel6.generic.InstructionHandle;
import afu.org.apache.commons.bcel6.generic.StackConsumer;
import afu.org.apache.commons.bcel6.generic.StackProducer;
import afu.org.apache.commons.bcel6.generic.VariableLengthInstruction;
import afu.org.apache.commons.bcel6.util.ByteSequence;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class Select
extends BranchInstruction
implements VariableLengthInstruction,
StackConsumer,
StackProducer {
    @Deprecated
    protected @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] match;
    @Deprecated
    protected @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] indices;
    @Deprecated
    protected @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] targets;
    @Deprecated
    protected @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int fixed_length;
    @Deprecated
    protected @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int match_length;
    @Deprecated
    protected @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int padding = 0;

    Select() {
    }

    Select(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString short opcode, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] match, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] targets, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle defaultTarget) {
        super(opcode, null);
        this.match = match;
        this.targets = targets;
        this.setTarget(defaultTarget);
        for (InstructionHandle target2 : targets) {
            Select.notifyTarget(null, target2, this);
        }
        this.match_length = match.length;
        if (this.match_length != targets.length) {
            throw new ClassGenException("Match and target array have not the same length: Match length: " + match.length + " Target length: " + targets.length);
        }
        this.indices = new int[this.match_length];
    }

    @Override
    protected @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int updatePosition(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int offset, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int max_offset) {
        this.setPosition(this.getPosition() + offset);
        short old_length = (short)super.getLength();
        this.padding = (4 - (this.getPosition() + 1) % 4) % 4;
        super.setLength((short)(this.fixed_length + this.padding));
        return super.getLength() - old_length;
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream out) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        out.writeByte(super.getOpcode());
        for (int i = 0; i < this.padding; ++i) {
            out.writeByte(0);
        }
        super.setIndex(this.getTargetOffset());
        out.writeInt(super.getIndex());
    }

    @Override
    protected void initFromFile(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ByteSequence bytes, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean wide) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        this.padding = (4 - bytes.getIndex() % 4) % 4;
        for (int i = 0; i < this.padding; ++i) {
            bytes.readByte();
        }
        super.setIndex(bytes.readInt());
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean verbose) {
        StringBuilder buf = new StringBuilder(super.toString(verbose));
        if (verbose) {
            for (int i = 0; i < this.match_length; ++i) {
                String s2 = "null";
                if (this.targets[i] != null) {
                    s2 = this.targets[i].getInstruction().toString();
                }
                buf.append("(").append(this.match[i]).append(", ").append(s2).append(" = {").append(this.indices[i]).append("})");
            }
        } else {
            buf.append(" ...");
        }
        return buf.toString();
    }

    public void setTarget(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int i, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle target) {
        Select.notifyTarget(this.targets[i], target, this);
        this.targets[i] = target;
    }

    @Override
    public void updateTarget(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle old_ih, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle new_ih) {
        boolean targeted = false;
        if (super.getTarget() == old_ih) {
            targeted = true;
            this.setTarget(new_ih);
        }
        for (int i = 0; i < this.targets.length; ++i) {
            if (this.targets[i] != old_ih) continue;
            targeted = true;
            this.setTarget(i, new_ih);
        }
        if (!targeted) {
            throw new ClassGenException("Not targeting " + old_ih);
        }
    }

    @Override
    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean containsTarget(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle ih) {
        if (super.getTarget() == ih) {
            return true;
        }
        for (InstructionHandle target2 : this.targets) {
            if (target2 != ih) continue;
            return true;
        }
        return false;
    }

    @SideEffectFree
    protected @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object clone() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString CloneNotSupportedException {
        Select copy = (Select)super.clone();
        copy.match = (int[])this.match.clone();
        copy.indices = (int[])this.indices.clone();
        copy.targets = (InstructionHandle[])this.targets.clone();
        return copy;
    }

    @Override
    void dispose() {
        super.dispose();
        for (InstructionHandle target2 : this.targets) {
            target2.removeTargeter(this);
        }
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getMatchs() {
        return this.match;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getIndices() {
        return this.indices;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getTargets() {
        return this.targets;
    }

    final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getMatch(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int index) {
        return this.match[index];
    }

    final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getIndices(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int index) {
        return this.indices[index];
    }

    final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle getTarget(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int index) {
        return this.targets[index];
    }

    final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getFixed_length() {
        return this.fixed_length;
    }

    final void setFixed_length(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int fixed_length) {
        this.fixed_length = fixed_length;
    }

    final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getMatch_length() {
        return this.match_length;
    }

    final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int setMatch_length(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int match_length) {
        this.match_length = match_length;
        return match_length;
    }

    final void setMatch(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int index, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int value) {
        this.match[index] = value;
    }

    final void setIndices(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] array) {
        this.indices = array;
    }

    final void setMatches(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] array) {
        this.match = array;
    }

    final void setTargets(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] array) {
        this.targets = array;
    }

    final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getPadding() {
        return this.padding;
    }

    final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int setIndices(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int i, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int value) {
        this.indices[i] = value;
        return value;
    }
}

